/* 
 * (c) Copyright 1989, 1990, 1991, 1992 OPEN SOFTWARE FOUNDATION, INC. 
 * ALL RIGHTS RESERVED 
*/ 
/* 
 * Motif Release 1.2
*/ 
#ifdef REV_INFO
#ifndef lint
static char rcsid[] = "$RCSfile: MAllWidgets.c,v $ $Revision: 1.5.2.3 $ $Date: 1992/04/07 13:41:30 $"
#endif
#endif
#include "Mmemory.h"
#include <testlib.h>

#define	LOOPCNT	5
#define	MAXARGS	20
#define	ITEMS	10
#define	VISIBLE	5

Widget RowCol, label, menubar, menu,  bulletin, weegee;

char *items[] = { "one", "two", "three", "four", "five",
			     "six", "seven", "eight", "nine", "ten"	};

#ifdef _NO_PROTO
static void CB1(w, client_data, call_data)
Widget  w;
caddr_t client_data;
caddr_t call_data;
#else
static void CB1(Widget w, caddr_t client_data, caddr_t call_data)
#endif
{
  printf("In Callback1\n");
}

#ifdef _NO_PROTO
static void CB2(w, client_data, call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
#else
static void CB2(Widget w, caddr_t client_data, caddr_t call_data)
#endif
{
  printf("In Callback2\n");
}

#ifdef _NO_PROTO
static void CB3(w, client_data, call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
#else
static void CB3(Widget w, caddr_t client_data, caddr_t call_data)
#endif
{
  printf("In Callback3\n");
}

#ifdef _NO_PROTO
void main(argc, argv)
int argc;
char **argv;
#else
void main(int argc, char **argv)
#endif
{
  XmString fss, List1[ITEMS], str1, str2, str3;
  Arg args[MAXARGS];
  Cardinal n;
  int i;
  int total_memory, memory_leaked;

  /* Initialize toolkit */
  CommonTestInit(argc, argv);

  n = 0;
  XtSetArg(args[n], XmNwidth, 250);                   n++;
  XtSetArg(args[n], XmNheight, 200);                  n++;
  XtSetValues(Shell1, args, n);

  for (n=0; n < ITEMS; n++)
    List1[n] = XmStringCreateLtoR(items[n], XmSTRING_DEFAULT_CHARSET);

  XtRealizeWidget(Shell1);

  MallocDisable();

  /*****  BEGIN MEMORY TESTS  ********/
  fprintf(stderr,"Starting Widget memory tests\n\n\n");

  for (i = 0; i < LOOPCNT; i++)				{
    MallocEnable();
    n = 0;
    XtSetArg(args[n], XmNresizePolicy, XmRESIZE_NONE);	n++;
    XtSetArg(args[n], XmNmarginWidth, 25);		n++;
    XtSetArg(args[n], XmNwidth, 250);			n++;
    XtSetArg(args[n], XmNheight, 200);			n++;
    bulletin = XmCreateBulletinBoard(Shell1, "Adult", args, n);
    XtManageChild(bulletin);

    n = 0;
    XtSetArg(args[n], XmNinitialResourcesPersistent, False); n++;
    weegee = XmCreateArrowButton(bulletin, "Name", args, n);
    XtManageChild(weegee);

    XtDestroyWidget(weegee);
    XtDestroyWidget(bulletin);

    MallocLeakInfo(&total_memory, &memory_leaked);
    printf("Total memory allocated = %d, Memory Leftover = %d\n",
	   total_memory, memory_leaked);
    MallocDisable();
  }
  fflush(stdout);
  fprintf(stderr,"End of report for ArrowButton\n\n");


  for (i = 0; i < LOOPCNT; i++)				{
    MallocEnable();
    n = 0;
    XtSetArg(args[n], XmNresizePolicy, XmRESIZE_NONE);	n++;
    XtSetArg(args[n], XmNmarginWidth, 25);		n++;
    XtSetArg(args[n], XmNwidth, 250);			n++;
    XtSetArg(args[n], XmNheight, 200);			n++;
    bulletin = XmCreateBulletinBoard(Shell1, "Adult", args, n);
    XtManageChild(bulletin);

    n = 0;
    XtSetArg(args[n], XmNinitialResourcesPersistent, False); n++;
    weegee = XmCreateArrowButtonGadget(bulletin, "Name", args, n);
    XtManageChild(weegee);

    XtDestroyWidget(weegee);
    XtDestroyWidget(bulletin);

    MallocLeakInfo(&total_memory, &memory_leaked);
    printf("Total memory allocated = %d, Memory Leftover = %d\n",
	   total_memory, memory_leaked);
    MallocDisable();
  }
  fflush(stdout);
  fprintf(stderr,"End of report for ArrowButtonGadget\n\n");


  for (i = 0; i < LOOPCNT; i++)				{
    MallocEnable();
    n = 0;
    XtSetArg(args[n], XmNresizePolicy, XmRESIZE_NONE);	n++;
    XtSetArg(args[n], XmNmarginWidth, 25);		n++;
    XtSetArg(args[n], XmNwidth, 250);			n++;
    XtSetArg(args[n], XmNheight, 200);			n++;
    bulletin = XmCreateBulletinBoard(Shell1, "Adult", args, n);
    XtManageChild(bulletin);

    n = 0;
    XtSetArg(args[n], XmNinitialResourcesPersistent, False); n++;
    weegee = XmCreateBulletinBoard(bulletin, "Name", args, n);
    XtManageChild(weegee);

    XtDestroyWidget(weegee);
    XtDestroyWidget(bulletin);

    MallocLeakInfo(&total_memory, &memory_leaked);
    printf("Total memory allocated = %d, Memory Leftover = %d\n",
	   total_memory, memory_leaked);
    MallocDisable();
  }
  fflush(stdout);
  fprintf(stderr,"End of report for BulletinBoard\n\n");
  

  for (i = 0; i < LOOPCNT; i++)				{
    MallocEnable();
    n = 0;
    XtSetArg(args[n], XmNpacking, XmPACK_COLUMN);               n++;
    XtSetArg(args[n], XmNnumColumns, 2);                        n++;
    RowCol = XmCreateRowColumn(Shell1, "RC1", args, n);
    XtManageChild(RowCol);

    n = 0;
    XtSetArg(args[n], XmNinitialResourcesPersistent, False); n++;
    weegee = XmCreateCascadeButton(RowCol, "Name", args, n);
    XtManageChild(weegee);

    XtDestroyWidget(weegee);
    XtDestroyWidget(RowCol);

    MallocLeakInfo(&total_memory, &memory_leaked);
    printf("Total memory allocated = %d, Memory Leftover = %d\n",
	   total_memory, memory_leaked);
    MallocDisable();
  }
  fflush(stdout);
  fprintf(stderr,"End of report for CascadeButton\n\n");


  for (i = 0; i < LOOPCNT; i++)				{
    MallocEnable();

    menubar = XmCreateMenuBar(Shell1, "menubar", NULL, 0);
    XtManageChild(menubar);

    menu = XmCreatePopupMenu(menubar, "MENU", NULL, 0);

    n = 0;
    XtSetArg(args[n], XmNinitialResourcesPersistent, False); n++;
    weegee = XmCreateCascadeButtonGadget(menu, "Name", args, n);
    XtManageChild(weegee);

    XtDestroyWidget(weegee);
    XtDestroyWidget(menu);
    XtDestroyWidget(menubar);

    MallocLeakInfo(&total_memory, &memory_leaked);
    printf("Total memory allocated = %d, Memory Leftover = %d\n",
	   total_memory, memory_leaked);
    MallocDisable();
  }
  fflush(stdout);
  fprintf(stderr,"End of report for CascadeButtonGadget\n\n");


  for (i = 0; i < LOOPCNT; i++)				{
    MallocEnable();
    n = 0;
    XtSetArg(args[n], XmNresizePolicy, XmRESIZE_NONE);	n++;
    XtSetArg(args[n], XmNmarginWidth, 25);		n++;
    XtSetArg(args[n], XmNwidth, 250);			n++;
    XtSetArg(args[n], XmNheight, 200);			n++;
    bulletin = XmCreateBulletinBoard(Shell1, "Adult", args, n);
    XtManageChild(bulletin);

    n = 0;
    XtSetArg(args[n], XmNinitialResourcesPersistent, False); n++;
    weegee = XmCreateCommand(bulletin, "Name", args, n);
    XtManageChild(weegee);

    XtDestroyWidget(weegee);
    XtDestroyWidget(bulletin);

    MallocLeakInfo(&total_memory, &memory_leaked);
    printf("Total memory allocated = %d, Memory Leftover = %d\n",
	   total_memory, memory_leaked);
    MallocDisable();
  }
  fflush(stdout);
  fprintf(stderr,"End of report for Command\n\n");


  for (i = 0; i < LOOPCNT; i++)	{
    MallocEnable();
    n = 0;
    XtSetArg(args[n], XmNresizePolicy, XmRESIZE_NONE);	n++;
    XtSetArg(args[n], XmNmarginWidth, 25);		n++;
    XtSetArg(args[n], XmNwidth, 250);			n++;
    XtSetArg(args[n], XmNheight, 200);			n++;
    bulletin = XmCreateBulletinBoard(Shell1, "Adult", args, n);
    XtManageChild(bulletin);

    n=0;
    XtSetArg (args[n], XmNwidth, 100); n++;
    XtSetArg (args[n], XmNheight, 100); n++;
    XtSetArg(args[n], XmNinitialResourcesPersistent, False); n++;
    weegee = XmCreateForm(Shell1, "Name", args, n);
    XtManageChild(weegee);

    XtDestroyWidget(weegee);
    XtDestroyWidget(bulletin);

    MallocLeakInfo(&total_memory, &memory_leaked);
    printf("Total memory allocated = %d, Memory Leftover = %d\n",
	   total_memory, memory_leaked);
    MallocDisable();
  }
  fflush(stdout);
  fprintf(stderr,"End of report for Form\n\n");


  for (i = 0; i < LOOPCNT; i++)				{
    MallocEnable();
    n = 0;
    XtSetArg(args[n], XmNresizePolicy, XmRESIZE_NONE);	n++;
    XtSetArg(args[n], XmNmarginWidth, 25);		n++;
    XtSetArg(args[n], XmNwidth, 250);			n++;
    XtSetArg(args[n], XmNheight, 200);			n++;
    bulletin = XmCreateBulletinBoard(Shell1, "Adult", args, n);
    XtManageChild(bulletin);

    n = 0;
    XtSetArg(args[n], XmNinitialResourcesPersistent, False); n++;
    weegee = XmCreateFrame(bulletin, "Name", args, n);
    XtManageChild(weegee);

    XtDestroyWidget(weegee);
    XtDestroyWidget(bulletin);

    MallocLeakInfo(&total_memory, &memory_leaked);
    printf("Total memory allocated = %d, Memory Leftover = %d\n",
	   total_memory, memory_leaked);
    MallocDisable();
  }
  fflush(stdout);
  fprintf(stderr,"End of report for Frame\n\n");


  for (i = 0; i < LOOPCNT; i++)				{
    MallocEnable();
    n = 0;
    XtSetArg(args[n], XmNresizePolicy, XmRESIZE_NONE);	n++;
    XtSetArg(args[n], XmNmarginWidth, 25);		n++;
    XtSetArg(args[n], XmNwidth, 250);			n++;
    XtSetArg(args[n], XmNheight, 200);			n++;
    bulletin = XmCreateBulletinBoard(Shell1, "Adult", args, n);
    XtManageChild(bulletin);

    n = 0;
    XtSetArg(args[n], XmNinitialResourcesPersistent, False); n++;
    weegee = XmCreateLabel(bulletin, "Name", args, n);
    XtManageChild(weegee);

    XtDestroyWidget(weegee);
    XtDestroyWidget(bulletin);

    MallocLeakInfo(&total_memory, &memory_leaked);
    printf("Total memory allocated = %d, Memory Leftover = %d\n",
	   total_memory, memory_leaked);
    MallocDisable();
  }
  fflush(stdout);
  fprintf(stderr,"End of report for Label\n\n");


  for (i = 0; i < LOOPCNT; i++)				{
    MallocEnable();
    n = 0;
    XtSetArg(args[n], XmNresizePolicy, XmRESIZE_NONE);	n++;
    XtSetArg(args[n], XmNmarginWidth, 25);		n++;
    XtSetArg(args[n], XmNwidth, 250);			n++;
    XtSetArg(args[n], XmNheight, 200);			n++;
    bulletin = XmCreateBulletinBoard(Shell1, "Adult", args, n);
    XtManageChild(bulletin);

    n = 0;
    XtSetArg(args[n], XmNinitialResourcesPersistent, False); n++;
    weegee = XmCreateLabelGadget(bulletin, "Name", args, n);
    XtManageChild(weegee);

    XtDestroyWidget(weegee);
    XtDestroyWidget(bulletin);

    MallocLeakInfo(&total_memory, &memory_leaked);
    printf("Total memory allocated = %d, Memory Leftover = %d\n",
	   total_memory, memory_leaked);
    MallocDisable();
  }
  fflush(stdout);
  fprintf(stderr,"End of report for LabelGadget\n\n");


  for (i = 0; i < LOOPCNT; i++)				{
    MallocEnable();
    n = 0;
    XtSetArg(args[n], XmNresizePolicy, XmRESIZE_NONE);	n++;
    XtSetArg(args[n], XmNmarginWidth, 25);		n++;
    XtSetArg(args[n], XmNwidth, 250);			n++;
    XtSetArg(args[n], XmNheight, 200);			n++;
    bulletin = XmCreateBulletinBoard(Shell1, "Adult", args, n);
    XtManageChild(bulletin);

    n = 0;
    XtSetArg(args[n], XmNinitialResourcesPersistent, False); n++;
    XtSetArg(args[n], XmNwidth, 100);				n++;
    XtSetArg(args[n], XmNheight, 250);				n++;
    XtSetArg(args[n], XmNitems, List1);				n++;
    XtSetArg(args[n], XmNitemCount, ITEMS);			n++;
    XtSetArg(args[n], XmNvisibleItemCount, VISIBLE);		n++;
    weegee = XmCreateList(bulletin, "Name", args, n);
    XtManageChild(weegee);

    XtDestroyWidget(weegee);
    XtDestroyWidget(bulletin);

    MallocLeakInfo(&total_memory, &memory_leaked);
    printf("Total memory allocated = %d, Memory Leftover = %d\n",
	   total_memory, memory_leaked);
    MallocDisable();
  }
  fflush(stdout);
  fprintf(stderr,"End of report for List\n\n");


  for (i = 0; i < LOOPCNT; i++)                               {
    MallocEnable();
    n = 0;
    XtSetArg(args[n], XmNresizePolicy, XmRESIZE_NONE);	n++;
    XtSetArg(args[n], XmNmarginWidth, 25);		n++;
    XtSetArg(args[n], XmNwidth, 250);			n++;
    XtSetArg(args[n], XmNheight, 200);			n++;
    bulletin = XmCreateBulletinBoard(Shell1, "Adult", args, n);
    XtManageChild(bulletin);

    n = 0;
    XtSetArg(args[n], XmNinitialResourcesPersistent, False); n++;
    XtSetArg(args[n], XmNunitType, Xm1000TH_INCHES);  n++;
    XtSetArg(args[n], XmNmainWindowMarginHeight, 200);  n++;
    XtSetArg(args[n], XmNmainWindowMarginWidth, 200);  n++;
    XtSetArg(args[n], XmNshowSeparator, True);  n++;    
    weegee = XmCreateMainWindow(bulletin, "Name", args, n);
    XtManageChild(weegee);

    XtDestroyWidget(weegee);
    XtDestroyWidget(bulletin);

    MallocLeakInfo(&total_memory, &memory_leaked);
    printf("Total memory allocated = %d, Memory Leftover = %d\n",
	   total_memory, memory_leaked);
    MallocDisable();
  }
  fflush(stdout);
  fprintf(stderr,"End of report for MainWindow\n\n");


  for (i = 0; i < LOOPCNT; i++)                               {
    MallocEnable();
    n = 0;
    XtSetArg(args[n], XmNresizePolicy, XmRESIZE_NONE);	n++;
    XtSetArg(args[n], XmNmarginWidth, 25);		n++;
    XtSetArg(args[n], XmNwidth, 250);			n++;
    XtSetArg(args[n], XmNheight, 200);			n++;
    bulletin = XmCreateBulletinBoard(Shell1, "Adult", args, n);
    XtManageChild(bulletin);

    n = 0;
    XtSetArg(args[n], XmNinitialResourcesPersistent, False); n++;
    weegee = XmCreateMenuBar(bulletin, "Name", args, n);
    XtManageChild(weegee);

    XtDestroyWidget(weegee);
    XtDestroyWidget(bulletin);

    MallocLeakInfo(&total_memory, &memory_leaked);
    printf("Total memory allocated = %d, Memory Leftover = %d\n",
	   total_memory, memory_leaked);
    MallocDisable();
  }
  fflush(stdout);
  fprintf(stderr,"End of report for MenuBar\n\n");


  for (i = 0; i < LOOPCNT; i++)                               {
    MallocEnable();
    n = 0;
    XtSetArg(args[n], XmNresizePolicy, XmRESIZE_NONE);	n++;
    XtSetArg(args[n], XmNmarginWidth, 25);		n++;
    XtSetArg(args[n], XmNwidth, 250);			n++;
    XtSetArg(args[n], XmNheight, 200);			n++;
    bulletin = XmCreateBulletinBoard(Shell1, "Adult", args, n);
    XtManageChild(bulletin);

    n = 0;
    XtSetArg(args[n], XmNinitialResourcesPersistent, False); n++;
    weegee = XmCreateOptionMenu(bulletin, "Name", args, n);
    XtManageChild(weegee);

    XtDestroyWidget(weegee);
    XtDestroyWidget(bulletin);

    MallocLeakInfo(&total_memory, &memory_leaked);
    printf("Total memory allocated = %d, Memory Leftover = %d\n",
	   total_memory, memory_leaked);
    MallocDisable();
    }
	fflush(stdout);
  fprintf(stderr,"End of report for OptionMenu\n\n");


  for (i = 0; i < LOOPCNT; i++)                               {
    MallocEnable();
    n = 0;
    XtSetArg(args[n], XmNresizePolicy, XmRESIZE_NONE);	n++;
    XtSetArg(args[n], XmNmarginWidth, 25);		n++;
    XtSetArg(args[n], XmNwidth, 250);			n++;
    XtSetArg(args[n], XmNheight, 200);			n++;
    bulletin = XmCreateBulletinBoard(Shell1, "Adult", args, n);
    XtManageChild(bulletin);

    n = 0;
    XtSetArg(args[n], XmNinitialResourcesPersistent, False); n++;
    weegee = XmCreatePanedWindow(bulletin, "Name", args, n);
    XtManageChild(weegee);

    XtDestroyWidget(weegee);
    XtDestroyWidget(bulletin);

    MallocLeakInfo(&total_memory, &memory_leaked);
    printf("Total memory allocated = %d, Memory Leftover = %d\n",
	   total_memory, memory_leaked);
    MallocDisable();
  }
  fflush(stdout);
  fprintf(stderr,"End of report for PanedWindow\n\n");


  label = XmCreateLabel(Shell1, "top_label", args, n);
  XtManageChild(label);
  for (i = 0; i < LOOPCNT; i++)                               {
    MallocEnable();
    n = 0;
    XtSetArg(args[n], XmNresizePolicy, XmRESIZE_NONE);	n++;
    XtSetArg(args[n], XmNmarginWidth, 25);		n++;
    XtSetArg(args[n], XmNwidth, 250);			n++;
    XtSetArg(args[n], XmNheight, 200);			n++;
    bulletin = XmCreateBulletinBoard(Shell1, "Adult", args, n);
    XtManageChild(bulletin);

    n = 0;
    XtSetArg(args[n], XmNinitialResourcesPersistent, False); n++;
    XtSetArg(args[n], XmNorientation, XmVERTICAL); n++;
    XtSetArg(args[n], XmNwhichButton, 2); n++;
    weegee = XmCreatePopupMenu(bulletin, "Name", args, n);
    XtManageChild(weegee);

    XtDestroyWidget(weegee);
    XtDestroyWidget(bulletin);

    MallocLeakInfo(&total_memory, &memory_leaked);
    printf("Total memory allocated = %d, Memory Leftover = %d\n",
	   total_memory, memory_leaked);
    MallocDisable();
  }
  fflush(stdout);
  fprintf(stderr,"End of report for PopupMenu\n\n");


  for (i = 0; i < LOOPCNT; i++)                               {
    MallocEnable();
    n = 0;
    XtSetArg(args[n], XmNresizePolicy, XmRESIZE_NONE);	n++;
    XtSetArg(args[n], XmNmarginWidth, 25);		n++;
    XtSetArg(args[n], XmNwidth, 250);			n++;
    XtSetArg(args[n], XmNheight, 200);			n++;
    bulletin = XmCreateBulletinBoard(Shell1, "Adult", args, n);
    XtManageChild(bulletin);

    n = 0;
    XtSetArg(args[n], XmNinitialResourcesPersistent, False); n++;
    weegee = XmCreatePulldownMenu(bulletin, "Name", args, n);

    XtDestroyWidget(weegee);
    XtDestroyWidget(bulletin);

    MallocLeakInfo(&total_memory, &memory_leaked);
    printf("Total memory allocated = %d, Memory Leftover = %d\n",
	   total_memory, memory_leaked);
    MallocDisable();
  }
  fflush(stdout);
  fprintf(stderr,"End of report for PulldownMenu\n\n");


  n = 0;
  XtSetArg(args[n], XmNinitialResourcesPersistent, False); n++;
  for (i = 0; i < LOOPCNT; i++)                               {
    MallocEnable();
    n = 0;
    XtSetArg(args[n], XmNresizePolicy, XmRESIZE_NONE);	n++;
    XtSetArg(args[n], XmNmarginWidth, 25);		n++;
    XtSetArg(args[n], XmNwidth, 250);			n++;
    XtSetArg(args[n], XmNheight, 200);			n++;
    bulletin = XmCreateBulletinBoard(Shell1, "Adult", args, n);
    XtManageChild(bulletin);

    weegee = XmCreatePushButton(bulletin, "Name", args, n);

    XtDestroyWidget(weegee);
    XtDestroyWidget(bulletin);

    MallocLeakInfo(&total_memory, &memory_leaked);
    printf("Total memory allocated = %d, Memory Leftover = %d\n",
	   total_memory, memory_leaked);
    MallocDisable();
  }
  fflush(stdout);
  fprintf(stderr,"End of report for PushButton\n\n");	


  for (i = 0; i < LOOPCNT; i++)                               {
    MallocEnable();
    n = 0;
    XtSetArg(args[n], XmNresizePolicy, XmRESIZE_NONE);	n++;
    XtSetArg(args[n], XmNmarginWidth, 25);		n++;
    XtSetArg(args[n], XmNwidth, 250);			n++;
    XtSetArg(args[n], XmNheight, 200);			n++;
    bulletin = XmCreateBulletinBoard(Shell1, "Adult", args, n);
    XtManageChild(bulletin);

    n = 0;
    XtSetArg(args[n], XmNinitialResourcesPersistent, False); n++;
    weegee = XmCreatePushButtonGadget(bulletin, "Name", args, n);

    XtDestroyWidget(weegee);
    XtDestroyWidget(bulletin);

    MallocLeakInfo(&total_memory, &memory_leaked);
    printf("Total memory allocated = %d, Memory Leftover = %d\n",
	   total_memory, memory_leaked);
    MallocDisable();
  }
  fflush(stdout);
  fprintf(stderr,"End of report for PushButtonGadget\n\n");


  for (i = 0; i < LOOPCNT; i++)                               {
    MallocEnable();
    n = 0;
    XtSetArg(args[n], XmNresizePolicy, XmRESIZE_NONE);	n++;
    XtSetArg(args[n], XmNmarginWidth, 25);		n++;
    XtSetArg(args[n], XmNwidth, 250);			n++;
    XtSetArg(args[n], XmNheight, 200);			n++;
    bulletin = XmCreateBulletinBoard(Shell1, "Adult", args, n);
    XtManageChild(bulletin);

    n = 0;
    XtSetArg(args[n], XmNinitialResourcesPersistent, False); n++;
    weegee = XmCreateRadioBox(bulletin, "Name", args, n);

    XtDestroyWidget(weegee);
    XtDestroyWidget(bulletin);

    MallocLeakInfo(&total_memory, &memory_leaked);
    printf("Total memory allocated = %d, Memory Leftover = %d\n",
	   total_memory, memory_leaked);
    MallocDisable();
  }
  fflush(stdout);
  fprintf(stderr,"End of report for RadioBox\n\n");


  for (i = 0; i < LOOPCNT; i++)                               {
    MallocEnable();
    n = 0;
    XtSetArg(args[n], XmNresizePolicy, XmRESIZE_NONE);	n++;
    XtSetArg(args[n], XmNmarginWidth, 25);		n++;
    XtSetArg(args[n], XmNwidth, 250);			n++;
    XtSetArg(args[n], XmNheight, 200);			n++;
    bulletin = XmCreateBulletinBoard(Shell1, "Adult", args, n);
    XtManageChild(bulletin);

    n = 0;
    XtSetArg(args[n], XmNinitialResourcesPersistent, False); n++;
    weegee = XmCreateRowColumn(bulletin, "Name", args, n);

    XtDestroyWidget(weegee);
    XtDestroyWidget(bulletin);

    MallocLeakInfo(&total_memory, &memory_leaked);
    printf("Total memory allocated = %d, Memory Leftover = %d\n",
	   total_memory, memory_leaked);
    MallocDisable();
  }
  fflush(stdout);
  fprintf(stderr,"End of report for RowColumn\n\n");


  for (i = 0; i < LOOPCNT; i++)                               {
    MallocEnable(); 
    n = 0;
    XtSetArg(args[n], XmNresizePolicy, XmRESIZE_NONE);	n++;
    XtSetArg(args[n], XmNmarginWidth, 25);		n++;
    XtSetArg(args[n], XmNwidth, 250);			n++;
    XtSetArg(args[n], XmNheight, 200);			n++;
    bulletin = XmCreateBulletinBoard(Shell1, "Adult", args, n);
    XtManageChild(bulletin);

    n = 0;
    XtSetArg(args[n], XmNinitialResourcesPersistent, False); n++;
    weegee = XmCreateScale(bulletin, "Name", args, n);

    XtDestroyWidget(weegee);
    XtDestroyWidget(bulletin);

    MallocLeakInfo(&total_memory, &memory_leaked);
    printf("Total memory allocated = %d, Memory Leftover = %d\n",
	   total_memory, memory_leaked);
    MallocDisable();
  }
  fflush(stdout);
  fprintf(stderr,"End of report for Scale\n\n");


  for (i = 0; i < LOOPCNT; i++)                               {
    MallocEnable();
    n = 0;
    XtSetArg(args[n], XmNresizePolicy, XmRESIZE_NONE);	n++;
    XtSetArg(args[n], XmNmarginWidth, 25);		n++;
    XtSetArg(args[n], XmNwidth, 250);			n++;
    XtSetArg(args[n], XmNheight, 200);			n++;
    bulletin = XmCreateBulletinBoard(Shell1, "Adult", args, n);
    XtManageChild(bulletin);

    n = 0;
    XtSetArg(args[n], XmNinitialResourcesPersistent, False); n++;
    weegee = XmCreateScrollBar(bulletin, "Name", args, n);

    XtDestroyWidget(weegee);
    XtDestroyWidget(bulletin);

    MallocLeakInfo(&total_memory, &memory_leaked);
    printf("Total memory allocated = %d, Memory Leftover = %d\n",
	   total_memory, memory_leaked);
    MallocDisable();
  }
  fflush(stdout);
  fprintf(stderr,"End of report for ScrollBar\n\n");


  for (i = 0; i < LOOPCNT; i++)                               {
    MallocEnable();
    n = 0;
    XtSetArg(args[n], XmNresizePolicy, XmRESIZE_NONE);	n++;
    XtSetArg(args[n], XmNmarginWidth, 25);		n++;
    XtSetArg(args[n], XmNwidth, 250);			n++;
    XtSetArg(args[n], XmNheight, 200);			n++;
    bulletin = XmCreateBulletinBoard(Shell1, "Adult", args, n);
    XtManageChild(bulletin);

    n = 0;
    XtSetArg(args[n], XmNwidth, 100);                           n++;
    XtSetArg(args[n], XmNheight, 250);                          n++;
    XtSetArg(args[n], XmNitems, List1);                         n++;
    XtSetArg(args[n], XmNitemCount, ITEMS);                     n++;
    XtSetArg(args[n], XmNvisibleItemCount, VISIBLE);            n++;
    XtSetArg(args[n], XmNinitialResourcesPersistent, False); n++;
    weegee = XmCreateScrolledList(bulletin, "Name", args, n);

    XtDestroyWidget(weegee);
    XtDestroyWidget(bulletin);

    MallocLeakInfo(&total_memory, &memory_leaked);
    printf("Total memory allocated = %d, Memory Leftover = %d\n",
	   total_memory, memory_leaked);
    MallocDisable();
  }
  fflush(stdout);
  fprintf(stderr,"End of report for ScrolledList\n\n");

  
  for (i = 0; i < LOOPCNT; i++)                               {
    MallocEnable();
    n = 0;
    XtSetArg(args[n], XmNresizePolicy, XmRESIZE_NONE);	n++;
    XtSetArg(args[n], XmNmarginWidth, 25);		n++;
    XtSetArg(args[n], XmNwidth, 250);			n++;
    XtSetArg(args[n], XmNheight, 200);			n++;
    bulletin = XmCreateBulletinBoard(Shell1, "Adult", args, n);
    XtManageChild(bulletin);

    n = 0;
    XtSetArg(args[n], XmNrows, 2);				n++;
    XtSetArg(args[n], XmNscrollVertical, True);			n++;
    XtSetArg(args[n], XmNscrollHorizontal, True);		n++;
    XtSetArg(args[n], XmNinitialResourcesPersistent, False); n++;
    weegee = XmCreateScrolledText(bulletin, "Name", args, n);

    XtDestroyWidget(weegee);
    XtDestroyWidget(bulletin);

    MallocLeakInfo(&total_memory, &memory_leaked);
    printf("Total memory allocated = %d, Memory Leftover = %d\n",
	   total_memory, memory_leaked);
    MallocDisable();
  }
  fflush(stdout);
  fprintf(stderr,"End of report for ScrolledText\n\n");


  for (i = 0; i < LOOPCNT; i++)                               {
    MallocEnable();
    n = 0;
    XtSetArg(args[n], XmNresizePolicy, XmRESIZE_NONE);	n++;
    XtSetArg(args[n], XmNmarginWidth, 25);		n++;
    XtSetArg(args[n], XmNwidth, 250);			n++;
    XtSetArg(args[n], XmNheight, 200);			n++;
    bulletin = XmCreateBulletinBoard(Shell1, "Adult", args, n);
    XtManageChild(bulletin);

    XtSetArg(args[n], XmNwidth, 250);				n++;
    XtSetArg(args[n], XmNheight, 200);				n++;
    XtSetArg(args[n], XmNx, "-0");                               n++;
    XtSetArg(args[n], XmNy, "+0");                               n++;
    XtSetArg(args[n], XmNinitialResourcesPersistent, False); n++;
    weegee = XmCreateScrolledWindow(bulletin, "Name", args, n);

    XtDestroyWidget(weegee);
    XtDestroyWidget(bulletin);

    MallocLeakInfo(&total_memory, &memory_leaked);
    printf("Total memory allocated = %d, Memory Leftover = %d\n",
	   total_memory, memory_leaked);
    MallocDisable();
  }
  fflush(stdout);
  fprintf(stderr,"End of report for ScrolledWindow\n\n");


  for (i = 0; i < LOOPCNT; i++)                               {
    MallocEnable();
    n = 0;
    XtSetArg(args[n], XmNresizePolicy, XmRESIZE_NONE);	n++;
    XtSetArg(args[n], XmNmarginWidth, 25);		n++;
    XtSetArg(args[n], XmNwidth, 250);			n++;
    XtSetArg(args[n], XmNheight, 200);			n++;
    bulletin = XmCreateBulletinBoard(Shell1, "Adult", args, n);
    XtManageChild(bulletin);

    n = 0;
    XtSetArg(args[n], XmNinitialResourcesPersistent, False); n++;
    weegee = XmCreateSeparator(bulletin, "Name", args, n);

    XtDestroyWidget(weegee);
    XtDestroyWidget(bulletin);

    MallocLeakInfo(&total_memory, &memory_leaked);
    printf("Total memory allocated = %d, Memory Leftover = %d\n",
	   total_memory, memory_leaked);
    MallocDisable();
  }
  fflush(stdout);
  fprintf(stderr,"End of report for Separator\n\n");


  for (i = 0; i < LOOPCNT; i++)                               {
    MallocEnable();
    n = 0;
    XtSetArg(args[n], XmNresizePolicy, XmRESIZE_NONE);	n++;
    XtSetArg(args[n], XmNmarginWidth, 25);		n++;
    XtSetArg(args[n], XmNwidth, 250);			n++;
    XtSetArg(args[n], XmNheight, 200);			n++;
    bulletin = XmCreateBulletinBoard(Shell1, "Adult", args, n);
    XtManageChild(bulletin);

    n = 0;
    XtSetArg(args[n], XmNinitialResourcesPersistent, False); n++;
    weegee = XmCreateSeparatorGadget(bulletin, "Name", args, n);

    XtDestroyWidget(weegee);
    XtDestroyWidget(bulletin);

    MallocLeakInfo(&total_memory, &memory_leaked);
    printf("Total memory allocated = %d, Memory Leftover = %d\n",
	   total_memory, memory_leaked);
    MallocDisable();
  }
  fflush(stdout);
  fprintf(stderr,"End of report for SeparatorGadget\n\n");

  for (i = 0; i < LOOPCNT; i++)                               {
    MallocEnable();
    n = 0;
    XtSetArg(args[n], XmNresizePolicy, XmRESIZE_NONE);	n++;
    XtSetArg(args[n], XmNmarginWidth, 25);		n++;
    XtSetArg(args[n], XmNwidth, 250);			n++;
    XtSetArg(args[n], XmNheight, 200);			n++;
    bulletin = XmCreateBulletinBoard(Shell1, "Adult", args, n);
    XtManageChild(bulletin);

    n = 0;
    XtSetArg(args[n], XmNrows, 2);				n++;
    XtSetArg(args[n], XmNscrollVertical, True);			n++;
    XtSetArg(args[n], XmNscrollHorizontal, True);		n++;
    XtSetArg(args[n], XmNinitialResourcesPersistent, False); n++;
    weegee = XmCreateText(bulletin, "Name", args, n);

    XtDestroyWidget(weegee);
    XtDestroyWidget(bulletin);

    MallocLeakInfo(&total_memory, &memory_leaked);
    printf("Total memory allocated = %d, Memory Leftover = %d\n",
	   total_memory, memory_leaked);
    MallocDisable();
  }
  fflush(stdout);
  fprintf(stderr,"End of report for Text\n\n");


  for (i = 0; i < LOOPCNT; i++)                               {
    MallocEnable();
    n = 0;
    XtSetArg(args[n], XmNresizePolicy, XmRESIZE_NONE);	n++;
    XtSetArg(args[n], XmNmarginWidth, 25);		n++;
    XtSetArg(args[n], XmNwidth, 250);			n++;
    XtSetArg(args[n], XmNheight, 200);			n++;
    bulletin = XmCreateBulletinBoard(Shell1, "Adult", args, n);
    XtManageChild(bulletin);

    n = 0;
    XtSetArg(args[n], XmNrows, 2);				n++;
    XtSetArg(args[n], XmNscrollVertical, True);			n++;
    XtSetArg(args[n], XmNscrollHorizontal, True);		n++;
    XtSetArg(args[n], XmNinitialResourcesPersistent, False); n++;
    weegee = XmCreateTextField(bulletin, "Name", args, n);

    XtDestroyWidget(weegee);
    XtDestroyWidget(bulletin);

    MallocLeakInfo(&total_memory, &memory_leaked);
    printf("Total memory allocated = %d, Memory Leftover = %d\n",
	   total_memory, memory_leaked);
    MallocDisable();
  }
  fflush(stdout);
  fprintf(stderr,"End of report for TextField\n\n");


  for (i = 0; i < LOOPCNT; i++)                               {
    MallocEnable();
    n = 0;
    XtSetArg(args[n], XmNresizePolicy, XmRESIZE_NONE);	n++;
    XtSetArg(args[n], XmNmarginWidth, 25);		n++;
    XtSetArg(args[n], XmNwidth, 250);			n++;
    XtSetArg(args[n], XmNheight, 200);			n++;
    bulletin = XmCreateBulletinBoard(Shell1, "Adult", args, n);
    XtManageChild(bulletin);

    n = 0;
    XtSetArg(args[n], XmNinitialResourcesPersistent, False); n++;
    weegee = XmCreateToggleButton(bulletin, "Name", args, n);

    XtDestroyWidget(weegee);
    XtDestroyWidget(bulletin);

    MallocLeakInfo(&total_memory, &memory_leaked);
    printf("Total memory allocated = %d, Memory Leftover = %d\n",
	   total_memory, memory_leaked);
    MallocDisable();
  }
  fflush(stdout);
  fprintf(stderr,"End of report for ToggleButton\n\n");


  for (i = 0; i < LOOPCNT; i++)                               {
    MallocEnable();
    n = 0;
    XtSetArg(args[n], XmNresizePolicy, XmRESIZE_NONE);	n++;
    XtSetArg(args[n], XmNmarginWidth, 25);		n++;
    XtSetArg(args[n], XmNwidth, 250);			n++;
    XtSetArg(args[n], XmNheight, 200);			n++;
    bulletin = XmCreateBulletinBoard(Shell1, "Adult", args, n);
    XtManageChild(bulletin);

    n = 0;
    XtSetArg(args[n], XmNinitialResourcesPersistent, False); n++;
    weegee = XmCreateToggleButtonGadget(bulletin, "Name", args, n);

    XtDestroyWidget(weegee);
    XtDestroyWidget(bulletin);

    MallocLeakInfo(&total_memory, &memory_leaked);
    printf("Total memory allocated = %d, Memory Leftover = %d\n",
	   total_memory, memory_leaked);
    MallocDisable();
  }
  fflush(stdout);
  fprintf(stderr,"End of report for ToggleButtonGadget\n\n");


  for (i = 0; i < LOOPCNT; i++)                               {
    MallocEnable();
    n = 0;
    XtSetArg(args[n], XmNresizePolicy, XmRESIZE_NONE);	n++;
    XtSetArg(args[n], XmNmarginWidth, 25);		n++;
    XtSetArg(args[n], XmNwidth, 250);			n++;
    XtSetArg(args[n], XmNheight, 200);			n++;
    bulletin = XmCreateBulletinBoard(Shell1, "Adult", args, n);
    XtManageChild(bulletin);

    n = 0;
    XtSetArg(args[n], XmNinitialResourcesPersistent, False); n++;
    weegee = XmCreateSelectionBox(Shell1, "Name", args, n);

    XtDestroyWidget(weegee);
    XtDestroyWidget(bulletin);

    MallocLeakInfo(&total_memory, &memory_leaked);
    printf("Total memory allocated = %d, Memory Leftover = %d\n",
	   total_memory, memory_leaked);
    MallocDisable();
  }
  fflush(stdout);
  fprintf(stderr,"End of report for SelectionBox\n\n");


  for (i = 0; i < LOOPCNT; i++)                               {
    MallocEnable();
    n = 0;
    XtSetArg(args[n], XmNresizePolicy, XmRESIZE_NONE);	n++;
    XtSetArg(args[n], XmNmarginWidth, 25);		n++;
    XtSetArg(args[n], XmNwidth, 250);			n++;
    XtSetArg(args[n], XmNheight, 200);			n++;
    bulletin = XmCreateBulletinBoard(Shell1, "Adult", args, n);
    XtManageChild(bulletin);

    n = 0;
    XtSetArg(args[n], XmNwidth, 5); n++;
    XtSetArg(args[n], XmNheight, 5); n++;
    XtSetArg(args[n], XmNinitialResourcesPersistent, False); n++;
    weegee = XmCreateMenuShell(bulletin, "Name", args, n);
    XtManageChild(weegee);

    XtDestroyWidget(weegee);
    XtDestroyWidget(bulletin);

    MallocLeakInfo(&total_memory, &memory_leaked);
    printf("Total memory allocated = %d, Memory Leftover = %d\n",
	   total_memory, memory_leaked);
    MallocDisable();
  }
  fflush(stdout);
  fprintf(stderr,"End of report for MenuShell\n\n");


  n = 0;
  XtSetArg(args[n], XmNinitialResourcesPersistent, False); n++;
  for (i = 0; i < LOOPCNT; i++)                               {
    MallocEnable();
    n = 0;
    XtSetArg(args[n], XmNresizePolicy, XmRESIZE_NONE);	n++;
    XtSetArg(args[n], XmNmarginWidth, 25);		n++;
    XtSetArg(args[n], XmNwidth, 250);			n++;
    XtSetArg(args[n], XmNheight, 200);			n++;
    bulletin = XmCreateBulletinBoard(Shell1, "Adult", args, n);
    XtManageChild(bulletin);

    weegee = XmCreateMessageBox(bulletin, "Name", args, n);
    XtManageChild(weegee);

    XtDestroyWidget(weegee);
    XtDestroyWidget(bulletin);

    MallocLeakInfo(&total_memory, &memory_leaked);
    printf("Total memory allocated = %d, Memory Leftover = %d\n",
	   total_memory, memory_leaked);
    MallocDisable();
  }
  fflush(stdout);
  fprintf(stderr,"End of report for MessageBox\n\n");


  for (i = 0; i < LOOPCNT; i++)				{
    MallocEnable();
    n = 0;
    XtSetArg(args[n], XmNresizePolicy, XmRESIZE_NONE);	n++;
    XtSetArg(args[n], XmNmarginWidth, 25);		n++;
    XtSetArg(args[n], XmNwidth, 250);			n++;
    XtSetArg(args[n], XmNheight, 200);			n++;
    bulletin = XmCreateBulletinBoard(Shell1, "Adult", args, n);
    XtManageChild(bulletin);

    n = 0;
    XtSetArg(args[n], XmNinitialResourcesPersistent, False); n++;
    weegee = XmCreateDrawnButton(bulletin, "Name", args, n); 
    XtManageChild(weegee);

    XtDestroyWidget(weegee);
    XtDestroyWidget(bulletin);

    MallocLeakInfo(&total_memory, &memory_leaked);
    printf("Total memory allocated = %d, Memory Leftover = %d\n",
	   total_memory, memory_leaked);
    MallocDisable();
  }
  fflush(stdout);
  fprintf(stderr,"End of report for DrawnButton\n\n");


  for (i = 0; i < LOOPCNT; i++)				{
    MallocEnable();
    n = 0;
    XtSetArg(args[n], XmNresizePolicy, XmRESIZE_NONE);	n++;
    XtSetArg(args[n], XmNmarginWidth, 25);		n++;
    XtSetArg(args[n], XmNwidth, 250);			n++;
    XtSetArg(args[n], XmNheight, 200);			n++;
    bulletin = XmCreateBulletinBoard(Shell1, "Adult", args, n);
    XtManageChild(bulletin);

    n = 0;
    XtSetArg(args[n], XmNinitialResourcesPersistent, False); n++;
    weegee = XmCreateDrawingArea(bulletin, "Name", args, n);
    XtManageChild(weegee);
    
    XtDestroyWidget(weegee);
    XtDestroyWidget(bulletin);

    MallocLeakInfo(&total_memory, &memory_leaked);
    printf("Total memory allocated = %d, Memory Leftover = %d\n",
	   total_memory, memory_leaked);
    MallocDisable();
  }
  fflush(stdout);
  fprintf(stderr,"End of report for Drawing Area\n\n");


  for (i = 0; i < LOOPCNT; i++)				{
    MallocEnable();
    n = 0;
    XtSetArg(args[n], XmNresizePolicy, XmRESIZE_NONE);	n++;
    XtSetArg(args[n], XmNmarginWidth, 25);		n++;
    XtSetArg(args[n], XmNwidth, 250);			n++;
    XtSetArg(args[n], XmNheight, 200);			n++;
    bulletin = XmCreateBulletinBoard(Shell1, "Adult", args, n);
    XtManageChild(bulletin);

    n = 0;
    XtSetArg(args[n], XmNinitialResourcesPersistent, False); n++;
    weegee = XmCreateInformationDialog(bulletin, "Name", args, n);
    XtManageChild(weegee);

    XtDestroyWidget(weegee);
    XtDestroyWidget(bulletin);

    MallocLeakInfo(&total_memory, &memory_leaked);
    printf("Total memory allocated = %d, Memory Leftover = %d\n",
	   total_memory, memory_leaked);
    MallocDisable();
  }
  fflush(stdout);
  fprintf(stderr,"End of report for InformationDialog\n\n");


  for (i = 0; i < LOOPCNT; i++)                               {
    MallocEnable();
    n = 0;
    XtSetArg(args[n], XmNresizePolicy, XmRESIZE_NONE);	n++;
    XtSetArg(args[n], XmNmarginWidth, 25);		n++;
    XtSetArg(args[n], XmNwidth, 250);			n++;
    XtSetArg(args[n], XmNheight, 200);			n++;
    bulletin = XmCreateBulletinBoard(Shell1, "Adult", args, n);
    XtManageChild(bulletin);

    n = 0;
    XtSetArg(args[n], XmNinitialResourcesPersistent, False); n++;
    weegee = XmCreateMessageDialog(bulletin, "Name", args, n);
    XtManageChild(weegee);

    XtDestroyWidget(weegee);
    XtDestroyWidget(bulletin);

    MallocLeakInfo(&total_memory, &memory_leaked);
    printf("Total memory allocated = %d, Memory Leftover = %d\n",
	   total_memory, memory_leaked);
    MallocDisable();
  }
  fflush(stdout);
  fprintf(stderr,"End of report for MessageDialog\n\n");


  str1 = XmStringCreate ("Warning",  XmSTRING_DEFAULT_CHARSET);
  str2 = XmStringCreate ("Working",  XmSTRING_DEFAULT_CHARSET);
  str3 = XmStringCreate ("Information", XmSTRING_DEFAULT_CHARSET);

  for (i = 0; i < LOOPCNT; i++)                               {
    MallocEnable();
    n = 0;
    XtSetArg(args[n], XmNresizePolicy, XmRESIZE_NONE);	n++;
    XtSetArg(args[n], XmNmarginWidth, 25);		n++;
    XtSetArg(args[n], XmNwidth, 250);			n++;
    XtSetArg(args[n], XmNheight, 200);			n++;
    bulletin = XmCreateBulletinBoard(Shell1, "Adult", args, n);
    XtManageChild(bulletin);

    n = 0;
    XtSetArg(args[n], XmNinitialResourcesPersistent, False); n++;
    XtSetArg (args[n], XmNokLabelString, str1);		     n++;
    XtSetArg (args[n], XmNcancelLabelString, str2);	     n++;
    XtSetArg (args[n], XmNhelpLabelString, str3);	     n++;
    weegee = XmCreateQuestionDialog(bulletin, "Name", args, n);

    XtDestroyWidget(weegee);
    XtDestroyWidget(bulletin);

    MallocLeakInfo(&total_memory, &memory_leaked);
    printf("Total memory allocated = %d, Memory Leftover = %d\n",
	   total_memory, memory_leaked);
    MallocDisable();
  }
  fflush(stdout);
  fprintf(stderr,"End of report for QuestionDialog\n\n");


  for (i = 0; i < LOOPCNT; i++)                               {
    MallocEnable();
    n = 0;
    XtSetArg(args[n], XmNresizePolicy, XmRESIZE_NONE);	n++;
    XtSetArg(args[n], XmNmarginWidth, 25);		n++;
    XtSetArg(args[n], XmNwidth, 250);			n++;
    XtSetArg(args[n], XmNheight, 200);			n++;
    bulletin = XmCreateBulletinBoard(Shell1, "Adult", args, n);
    XtManageChild(bulletin);

    n = 0;
    XtSetArg(args[n], XmNinitialResourcesPersistent, False); n++;
    weegee = XmCreateSelectionDialog(Shell1, "Name", args, n);

    XtDestroyWidget(weegee);
    XtDestroyWidget(bulletin);

    MallocLeakInfo(&total_memory, &memory_leaked);
    printf("Total memory allocated = %d, Memory Leftover = %d\n",
	   total_memory, memory_leaked);
    MallocDisable();
  }
  fflush(stdout);
  fprintf(stderr,"End of report for SelectionDialog\n\n");


  for (i = 0; i < LOOPCNT; i++)                               {
    MallocEnable();
    n = 0;
    XtSetArg(args[n], XmNresizePolicy, XmRESIZE_NONE);	n++;
    XtSetArg(args[n], XmNmarginWidth, 25);		n++;
    XtSetArg(args[n], XmNwidth, 250);			n++;
    XtSetArg(args[n], XmNheight, 200);			n++;
    bulletin = XmCreateBulletinBoard(Shell1, "Adult", args, n);
    XtManageChild(bulletin);

    n = 0;
    XtSetArg(args[n], XmNinitialResourcesPersistent, False); n++;
    weegee = XmCreateWarningDialog(bulletin, "Name", args,n);

    XtDestroyWidget(weegee);
    XtDestroyWidget(bulletin);

    MallocLeakInfo(&total_memory, &memory_leaked);
    printf("Total memory allocated = %d, Memory Leftover = %d\n",
	   total_memory, memory_leaked);
    MallocDisable();
  }
  fflush(stdout);
  fprintf(stderr,"End of report for WarningDialog\n\n");


  for (i = 0; i < LOOPCNT; i++)                               {
    MallocEnable();
    n = 0;
    XtSetArg(args[n], XmNresizePolicy, XmRESIZE_NONE);	n++;
    XtSetArg(args[n], XmNmarginWidth, 25);		n++;
    XtSetArg(args[n], XmNwidth, 250);			n++;
    XtSetArg(args[n], XmNheight, 200);			n++;
    bulletin = XmCreateBulletinBoard(Shell1, "Adult", args, n);
    XtManageChild(bulletin);

    n = 0;
    XtSetArg(args[n], XmNinitialResourcesPersistent, False); n++;
    weegee = XmCreateWorkingDialog(bulletin, "Name", args, n);

    XtDestroyWidget(weegee);
    XtDestroyWidget(bulletin);

    MallocLeakInfo(&total_memory, &memory_leaked);
    printf("Total memory allocated = %d, Memory Leftover = %d\n",
	   total_memory, memory_leaked);
    MallocDisable();
  }
  fflush(stdout);
  fprintf(stderr,"End of report for WorkingDialog\n\n");


  for (i = 0; i < LOOPCNT; i++)				{
    MallocEnable();
    n = 0;
    XtSetArg(args[n], XmNresizePolicy, XmRESIZE_NONE);	n++;
    XtSetArg(args[n], XmNmarginWidth, 25);		n++;
    XtSetArg(args[n], XmNwidth, 250);			n++;
    XtSetArg(args[n], XmNheight, 200);			n++;
    bulletin = XmCreateBulletinBoard(Shell1, "Adult", args, n);
    XtManageChild(bulletin);

    n = 0;
    XtSetArg(args[n], XmNinitialResourcesPersistent, False); n++;
    weegee = XmCreateDialogShell(bulletin, "Name", args, n);
    XtManageChild(weegee);

    XtDestroyWidget(weegee);
    XtDestroyWidget(bulletin);

    MallocLeakInfo(&total_memory, &memory_leaked);
    printf("Total memory allocated = %d, Memory Leftover = %d\n",
	   total_memory, memory_leaked);
    MallocDisable();
  }
  fflush(stdout);
  fprintf(stderr,"End of report for DialogShell\n\n");


  for (i = 0; i < LOOPCNT; i++)				{
    MallocEnable();
    n = 0;
    XtSetArg(args[n], XmNresizePolicy, XmRESIZE_NONE);	n++;
    XtSetArg(args[n], XmNmarginWidth, 25);		n++;
    XtSetArg(args[n], XmNwidth, 250);			n++;
    XtSetArg(args[n], XmNheight, 200);			n++;
    bulletin = XmCreateBulletinBoard(Shell1, "Adult", args, n);
    XtManageChild(bulletin);

    n = 0;
    XtSetArg(args[n], XmNinitialResourcesPersistent, False); n++;
    weegee = XmCreateErrorDialog(bulletin, "Name", args, n);
    XtManageChild(weegee);

    XtDestroyWidget(weegee);
    XtDestroyWidget(bulletin);

    MallocLeakInfo(&total_memory, &memory_leaked);
    printf("Total memory allocated = %d, Memory Leftover = %d\n",
	   total_memory, memory_leaked);
    MallocDisable();
  }
  fflush(stdout);
  fprintf(stderr,"End of report for ErrorDialog\n\n");


  fss = XmStringLtoRCreate( "/tmp/FS/nullbox/", XmSTRING_DEFAULT_CHARSET);
  for (i = 0; i < LOOPCNT; i++)				{
    MallocEnable();
    n = 0;
    XtSetArg(args[n], XmNresizePolicy, XmRESIZE_NONE);	n++;
    XtSetArg(args[n], XmNmarginWidth, 25);		n++;
    XtSetArg(args[n], XmNwidth, 250);			n++;
    XtSetArg(args[n], XmNheight, 200);			n++;
    bulletin = XmCreateBulletinBoard(Shell1, "Adult", args, n);
    XtManageChild(bulletin);

    n = 0;
    XtSetArg(args[n], XmNinitialResourcesPersistent, False); n++;
    XtSetArg(args[n], XmNdirMask, fss);  n++;
    XtSetArg(args[n], XmNdirSpec, NULL); n++;
    weegee = XmCreateFileSelectionBox(bulletin, "Name", args, n);
    XtManageChild(weegee);

    XtDestroyWidget(weegee);
    XtDestroyWidget(bulletin);

    MallocLeakInfo(&total_memory, &memory_leaked);
    printf("Total memory allocated = %d, Memory Leftover = %d\n",
	   total_memory, memory_leaked);
    MallocDisable();
  }
  fflush(stdout);
  fprintf(stderr,"End of report for FileSelectionBox\n\n");


  for (i = 0; i < LOOPCNT; i++)				{
    MallocEnable();
    n = 0;
    XtSetArg(args[n], XmNresizePolicy, XmRESIZE_NONE);	n++;
    XtSetArg(args[n], XmNmarginWidth, 25);		n++;
    XtSetArg(args[n], XmNwidth, 250);			n++;
    XtSetArg(args[n], XmNheight, 200);			n++;
    bulletin = XmCreateBulletinBoard(Shell1, "Adult", args, n);
    XtManageChild(bulletin);

    n=0;
    XtSetArg (args[n], XmNwidth, 100);                  n++;
    XtSetArg (args[n], XmNheight, 100);                 n++;
    XtSetArg(args[n], XmNinitialResourcesPersistent, False); n++;
    weegee = XmCreateFormDialog(Shell1, "Name", args, n);
    XtManageChild(weegee);

    XtDestroyWidget(weegee);
    XtDestroyWidget(bulletin);

    MallocLeakInfo(&total_memory, &memory_leaked);
    printf("Total memory allocated = %d, Memory Leftover = %d\n",
	   total_memory, memory_leaked);
    MallocDisable();
  }
  fflush(stdout);
  fprintf(stderr,"End of report for FormDialog\n\n");
  fprintf(stderr,"\n\n\n");
}
