/*
 * (c) Copyright 1989, 1990, 1991, 1992 OPEN SOFTWARE FOUNDATION, INC. 
 * ALL RIGHTS RESERVED 
 */
/*
 * Motif Release 1.2
 */
#include <stdio.h>
#include <Xm/XmP.h>
#include <Xm/DrawingA.h>
#include <testlib.h>

GC gc;
XmFontList fontlist;
XFontStruct   *font;

main(argc, argv)
int   argc;
char  *argv[];
{
        Widget bboard, testingArea;
	Arg args[10];
	int n;
	XGCValues  gcv;
	XmFontContext font_context;
	XmStringCharSet charset;
	XmString	title;
	
	void PostString();

	CommonTestInit(argc, argv);

	title = XmStringCreateLocalized("Push Button Here");
	
	n = 0;
	XtSetArg(args[n], XmNdialogTitle, title); n++;
	bboard = XmCreateBulletinBoard(Shell1, "bboard", args, n);
	XtManageChild (bboard);

	XmStringFree(title);

	n = 0;
	XtSetArg(args[n], XmNwidth, 300); n++;
	XtSetArg(args[n], XmNheight, 300); n++;
	XtSetArg(args[n], XmNbackground, 0); n++;
	testingArea = XmCreateDrawingArea(bboard, "DrawingArea", args, n);
	XtManageChild(testingArea);

	XtAddEventHandler(testingArea, ButtonPressMask, FALSE,
		PostString, NULL);

	fontlist = _XmGetDefaultFontList(testingArea, XmTEXT_FONTLIST);
	XmFontListInitFontContext(&font_context, fontlist);
	XmFontListGetNextFont(font_context, &charset, &font);
	XtFree(charset);
	XmFontListFreeFontContext(font_context);

	XtRealizeWidget (Shell1);

	n = 0;
	XtSetArg(args[n], XmNforeground, &gcv.foreground); n++;
	XtSetArg(args[n], XmNbackground, &gcv.background); n++;
	XtGetValues(testingArea, args, n);

	gcv.font = font->fid;

	gc = XCreateGC(XtDisplay(testingArea), XtWindow(testingArea),
		(GCFont | GCForeground | GCBackground), &gcv);

	XtAppMainLoop (app_context);
}

void PostString(w, popup, event)
Widget  w;
char * popup;
XEvent *event;
{
	XmString st1, st2;
	static Dimension       x = 50, y = 50;
	Dimension       height;
	Dimension       width;
	XRectangle ClipRect;
	XCharStruct char_return;
	int dir, asc, dsc;
	char *s1, *s2;


	printf("PostString\n");
	/* Use X and Z to show the problems */
	s1 = "X is an Example of Z";
	s2 = "X is an Example of Z\nZ is an Example of X\nX is an Example of Z";
	
	st1 = XmStringCreateLocalized(s1);
	st2 = XmStringCreateLtoR(s2, XmFONTLIST_DEFAULT_TAG);
	XmStringExtent(fontlist, st1, &width, &height);
	printf("Expected bounding box (%d, %d)\n", width, height);
	XTextExtents(font, s1, strlen(s1), &dir, &asc, &dsc, &char_return);
	printf("Real bounding box (%d, %d), width %d\nRight %d, Left %d\n",
		char_return.rbearing - char_return.lbearing,
		asc+dsc, char_return.width, char_return.rbearing,
	       char_return.lbearing);

	ClipRect.x = x + char_return.lbearing - 1;
	ClipRect.y = y;
	ClipRect.width = width;
	ClipRect.height = height;
	XmStringDrawImage (XtDisplay (w), XtWindow (w),
                          fontlist,
                          st1,
                          gc,
                          x, y, width,
                          XmALIGNMENT_BEGINNING,
                          XmSTRING_DIRECTION_L_TO_R,
                          NULL);
	y += (height + 3);
	XDrawRectangles(XtDisplay (w), XtWindow (w),
			gc,
			&ClipRect,
			1);
}
