/* 
 * (c) Copyright 1989, 1990, 1991, 1992 OPEN SOFTWARE FOUNDATION, INC. 
 * ALL RIGHTS RESERVED 
*/ 
/* 
 * Motif Release 1.2
*/ 
#ifdef REV_INFO
#ifndef lint
static char rcsid[] = "$RCSfile: TextField3.c,v $ $Revision: 1.4.2.2 $ $Date: 1992/04/06 14:20:58 $"
#endif
#endif
/*
*  (c) Copyright 1987, 1988, 1989 HEWLETT-PACKARD COMPANY */

#include <testlib.h>

Arg args[MAX_ARGS];

#ifdef _NO_PROTO
static void ModifyVerifyCB(w, client_data, call_data)
	Widget w;
	XtPointer client_data;
	XtPointer call_data;
#else   /* _NO_PROTO */
static void ModifyVerifyCB(Widget w, XtPointer client_data,
	XtPointer call_data)
#endif  /* _NO_PROTO */
{
	XmTextVerifyCallbackStruct  *modify_verify;
	static char c = 'A';
	static int position = 12;

	modify_verify = (XmTextVerifyCallbackStruct *)call_data;

	if (modify_verify->event == NULL)
		printf("Null event in ModifyVerify callback\n");

	if (modify_verify->text->ptr != NULL) 
	{  /* Make sure that it is not a BS */
		modify_verify->startPos = position++;
		modify_verify->endPos = modify_verify->startPos;
		modify_verify->text->ptr[0] = c;
		modify_verify->text->length = 1;
	}

	c += 1;
	if (c > 'Z')
		c = 'A';
}

#ifdef _NO_PROTO
static void ChangeString(w, client_data, call_data)
	Widget w;
	XtPointer client_data;
	XtPointer call_data;
#else   /* _NO_PROTO */
static void ChangeString(Widget w, XtPointer client_data,
	XtPointer call_data)
#endif  /* _NO_PROTO */
{
	int n = 0;
	char *value;

	value = XmTextFieldGetString(w);
	XmTextFieldSetCursorPosition(w, strlen(value));
	XtFree(value);

	XtSetArg(args[n], XmNfontList, CommonGetFontList("8x13bold"));  n++;
	XtSetArg(args[n], XmNmarginWidth, 10);  n++;
	XtSetArg(args[n], XmNmarginHeight, 10);  n++;
	XtSetArg(args[n], XmNforeground, CommonGetColor("navy"));  n++;
	XtSetArg(args[n], XmNvalue, XServerVendor(XtDisplay(w))); n++;
	XtSetValues(w, args, n);
}

/* test case for PIR 2492
 *   Type in a string as per bug report;
 *   hit return;
 *   note that the new string is drawn properly (not off-screen).
 *   On even activates, change string with set string; on odd, use setvalues
 */

#ifdef _NO_PROTO
static void ChangeString2(w, client_data, call_data)
	Widget w;
	XtPointer client_data;
	XtPointer call_data;
#else   /* _NO_PROTO */
static void ChangeString2(Widget w, XtPointer client_data,
	XtPointer call_data)
#endif  /* _NO_PROTO */
{
	static Boolean toggle = False;
	int n = 0;
	
	if (!toggle)
	{
		XmTextFieldSetString((Widget)client_data,
		"This is a much longer string which overflows the display");
	}
	else
	{
		n = 0;
		XtSetArg(args[0],XmNvalue,"Now is the time");  n++;
		XtSetValues((Widget)client_data, args, n);
	}
	toggle = !toggle;
}

void main (argc, argv)
int argc;
char **argv;
{
	Widget Text1 = NULL;
	int n = 0;
	
	/*  initialize toolkit  */
	CommonTestInit(argc, argv);
	
	/* test case for PIR 4031 */
	n = 0;
	XtSetArg(args[n], XmNwidth, 10); n++;
	XtSetArg(args[n], XmNheight, 10); n++;
	XtSetValues(Shell1, args, n);
	XtRealizeWidget(Shell1);
	/* end of test case for PIR 4031 */
	
	n = 0;
	XtSetArg(args[n], XmNfontList, CommonGetFontList("fixed"));  n++;
	XtSetArg(args[n], XmNcursorPosition, 12);  n++;
	XtSetArg(args[n], XmNvalue, "Sample Text ");  n++;
	XtSetArg(args[n], XmNforeground, CommonGetColor("Red"));  n++;
	XtSetArg(args[n], XmNbackground, CommonGetColor("White"));  n++;
	Text1 = XmCreateTextField(Shell1, "Text1", args, n);
	
	XtManageChild(Text1);
	XtRealizeWidget(Shell1);
	
	n = 0;
	XtSetArg(args[n], XmNresizeWidth, False);  n++;
	XtSetArg(args[n], XmNcolumns, 40);  n++;
	XtSetValues(Text1, args, n);
	
	CommonPause();
	
	/* Begin test for PIR 2959 */
	XtAddCallback(Text1, XmNmodifyVerifyCallback, ModifyVerifyCB, NULL);
	
	CommonPause();
	/* End test for PIR 2959 *
	
	/* Begin Test for PIR 2663 */
	XtRemoveAllCallbacks (Text1, XmNmodifyVerifyCallback);
	XtAddCallback(Text1, XmNactivateCallback, ChangeString, NULL);
	CommonPause();
	/* End Test for PIR 2663 */
	
	/* Begin Test for PIR 2942, 4077 */
	XtRemoveAllCallbacks(Text1, XmNactivateCallback);
	XtAddCallback(Text1, XmNactivateCallback, ChangeString2, Text1);
	CommonPause();
	/* End Test for PIR 2942, 4077 */
	
	XtAppMainLoop(app_context);
}
