/* 
 * (c) Copyright 1989, 1990, 1991, 1992 OPEN SOFTWARE FOUNDATION, INC. 
 * ALL RIGHTS RESERVED 
*/ 
/* 
 * Motif Release 1.2
*/ 
#ifdef REV_INFO
#ifndef lint
static char rcsid[] = "$RCSfile: TextFWcs2.c,v $ $Revision: 1.3.2.3 $ $Date: 1992/04/21 14:11:24 $"
#endif
#endif
/*
*  (c) Copyright 1987, 1988, 1989 HEWLETT-PACKARD COMPANY */

#include <testlib.h>

#ifdef	MOTIF1_2

Arg args[MAX_ARGS];
static char starting_string[] = "Sample Text ";

#ifdef _NO_PROTO
static void ModifyVerifyCB (w, client_data, call_data)
	Widget w;
	XtPointer client_data;
	XtPointer call_data;
#else	/* _NO_PROTO */
static void ModifyVerifyCB (Widget w, XtPointer client_data,
	XtPointer call_data)
#endif	/* _NO_PROTO */
{
	XmTextVerifyCallbackStructWcs  *modify_verify;
	static char c = 'A';
	static wchar_t wc;
	static int position = 12;
	static int nbytes;

	modify_verify = (XmTextVerifyCallbackStructWcs *)call_data;

	if (modify_verify->event == NULL)
		printf("Null event in ModifyVerify callback\n");

	if (modify_verify->text->wcsptr != NULL) 
	{
		/* Make sure that it is not a BS */
		nbytes = mbtowc(&wc, &c, 1);
		modify_verify->startPos = position++;
		modify_verify->endPos = modify_verify->startPos;
		modify_verify->text->wcsptr[0] = wc;
		modify_verify->text->length = nbytes;
	}

	c += 1;
	if (c > 'Z')
		c = 'A';
}

#endif	/* MOTIF1_2 */

void main (argc, argv)
int argc;
char **argv;
{
	Widget Text1 = NULL;
	int n = 0;
	wchar_t	*starting_wchar;
	int	num_chars;

#ifdef	MOTIF1_2

	/*  initialize toolkit  */
	CommonTestInit(argc, argv);

	n = 0;
	XtSetArg(args[n], XmNwidth, 10); n++;
	XtSetArg(args[n], XmNheight, 10); n++;
	XtSetValues(Shell1, args, n);
	XtRealizeWidget(Shell1);

	num_chars = strlen(starting_string);
	starting_wchar =
		(wchar_t *)XtMalloc((unsigned)
			(num_chars + 1) * sizeof(wchar_t));
	mbstowcs(starting_wchar, starting_string, num_chars + 1);

	n = 0;
	XtSetArg(args[n], XmNfontList, CommonGetFontList("fixed"));  n++;
	XtSetArg(args[n], XmNcursorPosition, 12);  n++;
	XtSetArg(args[n], XmNvalueWcs, starting_wchar);  n++;
	XtSetArg(args[n], XmNforeground, CommonGetColor("Red"));  n++;
	XtSetArg(args[n], XmNbackground, CommonGetColor("White"));  n++;
	Text1 = XmCreateTextField(Shell1, "Text1", args, n);

	XtManageChild(Text1);
	XtRealizeWidget(Shell1);

	n = 0;
	XtSetArg(args[n], XmNresizeWidth, False);  n++;
	XtSetArg(args[n], XmNcolumns, 40);  n++;
	XtSetValues(Text1, args, n);

	XtAddCallback(Text1, XmNmodifyVerifyCallbackWcs, ModifyVerifyCB, NULL);

	CommonPause();
	
	XtAppMainLoop(app_context);

#else	/* MOTIF1_2 */

	printf("This is a Motif 1.2 test only.\n");
	exit(0);

#endif	/* MOTIF1_2 */
}
