/* 
 * (c) Copyright 1989, 1990, 1991, 1992 OPEN SOFTWARE FOUNDATION, INC. 
 * ALL RIGHTS RESERVED 
*/ 
/* 
 * Motif Release 1.2
*/ 
#ifdef REV_INFO
#ifndef lint
static char rcsid[] = "$RCSfile: DiaShell1.c,v $ $Revision: 1.4.2.2 $ $Date: 1992/03/24 19:25:37 $"
#endif
#endif
/*
*  (c) Copyright 1987, 1988, 1989 HEWLETT-PACKARD COMPANY */


#include <testlib.h>
#include "warn.bmp"


/*  Global Variables  */
Pixmap	warnmap;
Widget 	MessageBox1;
Widget 	MessageBox2;
Widget 	MessageBox3;
Widget 	Dialog1, BulletinBoard, fontLabel1, fontLabel2, fontLabel3;

Widget  FormDialog1 = NULL;
Widget  FormDialog2 = NULL;


static void
#ifdef _NO_PROTO
PostSecondFormDialog(w, client_data, call_data)
Widget       w;
XtPointer    client_data;
XtPointer    call_data;
#else /* _NO_PROTO */
PostSecondFormDialog(Widget w, XtPointer client_data, XtPointer call_data)
#endif /* _NO_PROTO */
{

    Widget      parent;
    Cardinal 	n;
    Arg 		args[10];

	if (FormDialog2 != NULL) {

		if (XtIsManaged(FormDialog2))
			fprintf(stderr, "FormDialog2 already managed\n");
		else
			fprintf(stderr, "FormDialog2 being managed\n");
		XtManageChild(FormDialog2);
		return;

	}

    parent = (Widget) client_data;

   	n = 0;
	XtSetArg(args[n], XmNwidth, 100); n++;
	XtSetArg(args[n], XmNheight, 100); n++;
   	FormDialog2 = XmCreateFormDialog(FormDialog1, "FormDialog2", args, n);
	XtManageChild(FormDialog2);

}


static void
#ifdef _NO_PROTO
CreateFirstFormDialog(w, client_data, call_data)
Widget       w;
XtPointer    client_data;
XtPointer    call_data;
#else /* _NO_PROTO */
CreateFirstFormDialog(Widget w, XtPointer client_data, XtPointer call_data)
#endif /* _NO_PROTO */
{

    Widget		parent, SecondForm;
    Cardinal	n;
    Arg 		args[MAX_ARGS];


	if (FormDialog1 != NULL)
		return;

    parent = (Widget) client_data;

    n = 0;
	XtSetArg(args[n], XmNautoUnmanage, False); n++;
    FormDialog1 = XmCreateFormDialog(parent, "FormDialog1", args, n);

	n = 0;
   	SecondForm = XmCreatePushButton(FormDialog1, "Post_FormDialog2", args, n);
	XtManageChild(SecondForm);
   	XtAddCallback (SecondForm, XmNactivateCallback, PostSecondFormDialog,
			   	   FormDialog1);

}


static void
#ifdef _NO_PROTO
ManageFormDialog(w, client_data, call_data)
Widget       w;
XtPointer    client_data;
XtPointer    call_data;
#else /* _NO_PROTO */
ManageFormDialog(Widget w, XtPointer client_data, XtPointer call_data)
#endif /* _NO_PROTO */
{

	if (FormDialog1 != NULL)
    	XtManageChild(FormDialog1);

}


static void
#ifdef _NO_PROTO
UnmanageFormDialog(w, client_data, call_data)
Widget       w;
XtPointer    client_data;
XtPointer    call_data;
#else /* _NO_PROTO */
UnmanageFormDialog(Widget w, XtPointer client_data, XtPointer call_data)
#endif /* _NO_PROTO */
{

	if (FormDialog1 != NULL)
    	XtUnmanageChild(FormDialog1);

}


static void
#ifdef _NO_PROTO
UnmanageSystemDialog(w, client_data, call_data)
Widget       w;
XtPointer    client_data;
XtPointer    call_data;
#else /* _NO_PROTO */
UnmanageSystemDialog(Widget w, XtPointer client_data, XtPointer call_data)
#endif /* _NO_PROTO */
{

    XtUnmanageChild(w);

}


static void
#ifdef _NO_PROTO
HelpCB(w, client_data, call_data)
Widget       w;
XtPointer    client_data;
XtPointer    call_data;
#else /* _NO_PROTO */
HelpCB(Widget w, XtPointer client_data, XtPointer call_data)
#endif /* _NO_PROTO */
{
  printf("If you want to overwrite the file click on OK\n");
  printf("If you DON'T want to overwrite it click CANCEL\n");
}


void
#ifdef _NO_PROTO
main(argc, argv)
unsigned int argc;
char 		 **argv;
#else
main(unsigned int argc, char **argv)
#endif /* _NO_PROTO */
{

	XmString        tcs, tcs2;
#ifdef MOTIF1_1
    XmFontList		font0, font1, font2;
#else
    XmFontListEntry	font0, font1, font2;
#endif
    Cardinal    	n;
    Arg         	args[MAX_ARGS];
    Widget      	BB1;
    Widget      	SystemDia1;			/* PIR4340 */
    Widget      	CreateForm;
    Widget      	ManageForm;
    Widget      	UnmanageForm;


    CommonTestInit(argc, argv);
    
    /*  Load some fonts */


    font0 = CommonGetFontList("fixed");
    font1 = CommonGetFontList("6x10");
    font2 = CommonGetFontList("8x13bold");

    n = 0;
    XtSetArg(args[n], XmNwidth,  100);  n++;
    XtSetArg(args[n], XmNheight, 100);  n++;
    XtSetValues(Shell1, args, n);

#ifdef MOTIF1_1
    tcs = XmStringCreateLtoR("DialogStyle Unmanaged Test", 
							 XmSTRING_DEFAULT_CHARSET);
	tcs2 = XmStringCreateLtoR("UnManage", XmSTRING_DEFAULT_CHARSET);
#else
    tcs = XmStringCreateLtoR("DialogStyle Unmanaged Test", 
							 XmFONTLIST_DEFAULT_TAG);
	tcs2 = XmStringCreateLtoR("UnManage", XmFONTLIST_DEFAULT_TAG);
#endif

												/* Begin PIR4340 */
    n = 0;
    XtSetArg (args[n], XmNdialogStyle, XmDIALOG_SYSTEM_MODAL);    n++;
    XtSetArg (args[n], XmNmessageString, tcs);            n++;
    XtSetArg (args[n], XmNokLabelString, tcs2);           n++;
    XtSetArg (args[n], XmNautoUnmanage, False);                   n++;
    XtSetArg (args[n], XmNminimizeButtons, False);                n++;
    SystemDia1 = XmCreateMessageDialog (Shell1, "SystemDia1", args, n);
    XtManageChild (SystemDia1);
    XmStringFree(tcs);
    XmStringFree(tcs2);

	XtAddCallback(SystemDia1, XmNokCallback, UnmanageSystemDialog, NULL);

												/* End PIR4340 */

    XtRealizeWidget(Shell1);

	CommonPause();								/* PIR4340 */


    /* build the pixmap */
    warnmap = XCreatePixmapFromBitmapData(display, rootWindow,
		       warn_bits,warn_width,warn_height,
		       CommonGetColor("white"),
		       CommonGetColor("black"),
		       DefaultDepth(display,
				    DefaultScreen(display)));

    n = 0;
#ifdef MOTIF1_1
    tcs = XmStringCreateLtoR("Warning!! File Exists! OK to OverWrite?",
       						 XmSTRING_DEFAULT_CHARSET);
#else
    tcs = XmStringCreateLtoR("Warning!! File Exists! OK to OverWrite?",
       						 XmFONTLIST_DEFAULT_TAG);
#endif
    XtSetArg(args[n], XmNmessageString, tcs );  n++;
    XtSetArg(args[n], XmNsymbolPixmap, warnmap);  n++;
    XtSetArg(args[n], XmNwidth, 370); n++;
    XtSetArg(args[n], XmNheight, 120); n++;
    MessageBox1 = XmCreateWarningDialog(Shell1, "MessageBox1", args, n);
    XtManageChild(MessageBox1);
    XmStringFree(tcs);

    /* add callbacks, change label */
    XtAddCallback(MessageBox1,XmNhelpCallback, HelpCB, NULL);
    n = 0;
#ifdef MOTIF1_1
    tcs = XmStringCreateLtoR("No Overwrite", XmSTRING_DEFAULT_CHARSET);
#else
    tcs = XmStringCreateLtoR("No Overwrite", XmFONTLIST_DEFAULT_TAG);
#endif
    XtSetArg(args[n], XmNcancelLabelString, tcs); n++;
    XtSetValues(MessageBox1,args,n);
        
    n = 0;
#ifdef MOTIF1_1
    tcs = XmStringCreateLtoR("Error!! File Exists!", XmSTRING_DEFAULT_CHARSET);
#else
    tcs = XmStringCreateLtoR("Error!! File Exists!", XmFONTLIST_DEFAULT_TAG);
#endif
    XtSetArg(args[n], XmNmessageString, tcs );  n++;
    XtSetArg(args[n], XmNwidth, 270); n++;
    XtSetArg(args[n], XmNheight, 120); n++;
    MessageBox2 = XmCreateErrorDialog(Shell1, "MessageBox2", args, n);
    XtManageChild(MessageBox2);
    XmStringFree(tcs);

    /* add callbacks, change label */
    XtAddCallback(MessageBox2,XmNhelpCallback, HelpCB, NULL);
    n = 0;
#ifdef MOTIF1_1
    tcs = XmStringCreateLtoR("Giveup", XmSTRING_DEFAULT_CHARSET);
#else
    tcs = XmStringCreateLtoR("Giveup", XmFONTLIST_DEFAULT_TAG);
#endif
    XtSetArg(args[n], XmNcancelLabelString, tcs); n++;
    XtSetValues(MessageBox2,args,n);
    
    n = 0;
#ifdef MOTIF1_1
    tcs = XmStringCreateLtoR("Do you want to go on?", 
							 XmSTRING_DEFAULT_CHARSET);
#else
    tcs = XmStringCreateLtoR("Do you want to go on?", 
							 XmFONTLIST_DEFAULT_TAG);
#endif
    XtSetArg(args[n], XmNmessageString, tcs );  n++;
    XtSetArg(args[n], XmNwidth, 270); n++;
    XtSetArg(args[n], XmNheight, 120); n++;
    MessageBox3 = XmCreateQuestionDialog(Shell1, "MessageBox3", args, n);
    XtManageChild(MessageBox3);
    XmStringFree(tcs);

    /* add callbacks, change label */
    XtAddCallback(MessageBox3,XmNhelpCallback, HelpCB, NULL);
    n = 0;
#ifdef MOTIF1_1
    tcs = XmStringCreateLtoR("No", XmSTRING_DEFAULT_CHARSET);
#else
    tcs = XmStringCreateLtoR("No", XmFONTLIST_DEFAULT_TAG);
#endif
    XtSetArg(args[n], XmNcancelLabelString, tcs); n++;
    XtSetValues(MessageBox2,args,n);

    CommonPause();

    CommonPause();

    CommonPause();

											/* Begin PIR3228 */
    n = 0;
    Dialog1 = XmCreateDialogShell(Shell1, "Dialog1", args, n); 
    BulletinBoard = XmCreateBulletinBoard(Dialog1, "BulletinBoard", args, n); 

    n = 0;
#ifdef MOTIF1_1
    tcs = XmStringCreateLtoR("fixed", XmSTRING_DEFAULT_CHARSET);
#else
    tcs = XmStringCreateLtoR("fixed", XmFONTLIST_DEFAULT_TAG);
#endif
    XtSetArg(args[n], XmNx, 10); n++;
    XtSetArg(args[n], XmNy, 10); n++;
    XtSetArg(args[n], XmNfontList, font0);      n++;
    XtSetArg(args[n], XmNlabelString, tcs);	n++;
    fontLabel1 = XmCreateLabel (BulletinBoard, "fontLabel1", args, n);
    XtManageChild(fontLabel1);
    XmStringFree(tcs);

    n = 0;
#ifdef MOTIF1_1
    tcs = XmStringCreateLtoR("6x10", XmSTRING_DEFAULT_CHARSET);
#else
    tcs = XmStringCreateLtoR("6x10", XmFONTLIST_DEFAULT_TAG);
#endif
    XtSetArg(args[n], XmNx, 60); n++;
    XtSetArg(args[n], XmNy, 10); n++;
    XtSetArg(args[n], XmNfontList, font1);      n++;
    XtSetArg(args[n], XmNlabelString, tcs);	n++;
    fontLabel2 = XmCreateLabel (BulletinBoard, "fontLabel2", args, n);
    XtManageChild(fontLabel2);
    XmStringFree(tcs);

    n = 0;
#ifdef MOTIF1_1
    tcs = XmStringCreateLtoR("8x13bold", XmFONTLIST_DEFAULT_TAG);
#else
    tcs = XmStringCreateLtoR("8x13bold", XmSTRING_DEFAULT_CHARSET);
#endif
    XtSetArg(args[n], XmNx, 110); n++;
    XtSetArg(args[n], XmNy, 10); n++;
    XtSetArg(args[n], XmNfontList, font2);      n++;
    XtSetArg(args[n], XmNlabelString, tcs);	n++;
    fontLabel3 = XmCreateLabel(BulletinBoard, "fontLabel3", args, n);
    XtManageChild(fontLabel3);
    XmStringFree(tcs);

    XtManageChild(BulletinBoard);
    XtManageChild(Dialog1); 
											/* End PIR3228 */

    CommonPause();

	XtDestroyWidget(fontLabel1);
	XtDestroyWidget(fontLabel2);
	XtDestroyWidget(fontLabel3);
	XtDestroyWidget(BulletinBoard);
	XtDestroyWidget(Dialog1);

											/* Begin PIR3006 */
    n = 0;
    BB1 = XmCreateBulletinBoard (Shell1, "BB1", args, n);
    XtManageChild (BB1);

    n = 0;
    XtSetArg (args[n], XmNx, 10); n++;
    XtSetArg (args[n], XmNy, 100); n++;
    XtSetArg (args[n], XmNlabelString,
          	  XmStringCreateSimple ("Create FormDialog1")); n++;
    CreateForm = XmCreatePushButton (BB1, "CreateForm", args, n);
    XtManageChild (CreateForm);
    XtAddCallback (CreateForm, XmNactivateCallback, CreateFirstFormDialog,
                   Shell1);

    n = 0;
    XtSetArg (args[n], XmNx, 10); n++;
    XtSetArg (args[n], XmNy, 150); n++;
    XtSetArg (args[n], XmNlabelString,
          	  XmStringCreateSimple ("Manage FormDialog1")); n++;
    ManageForm = XmCreatePushButton (BB1, "ManageForm", args, n);
    XtManageChild (ManageForm);
    XtAddCallback (ManageForm, XmNactivateCallback, ManageFormDialog, NULL);

    n = 0;
    XtSetArg (args[n], XmNx, 10); n++;
    XtSetArg (args[n], XmNy, 200); n++;
    XtSetArg (args[n], XmNlabelString,
          	  XmStringCreateSimple ("Unmanage FormDialog1")); n++;
    UnmanageForm = XmCreatePushButton (BB1, "UnmanageForm", args, n);
    XtManageChild (UnmanageForm);
    XtAddCallback (UnmanageForm, XmNactivateCallback, UnmanageFormDialog, NULL);

    CommonPause();

    CommonPause();

    CommonPause();
											/* End PIR3006 */

    CommonPause();

    XtAppMainLoop(app_context);

}
