/* 
 * (c) Copyright 1989, 1990, 1991, 1992 OPEN SOFTWARE FOUNDATION, INC. 
 * ALL RIGHTS RESERVED 
*/ 
/* 
 * Motif Release 1.2
*/ 
#ifdef REV_INFO
#ifndef lint
static char rcsid[] = "$RCSfile: Label5.c,v $ $Revision: 1.4 $ $Date: 92/03/13 17:33:43 $"
#endif
#endif
/*
*  (c) Copyright 1987, 1988, 1989 HEWLETT-PACKARD COMPANY */
/*
 *  Read a set of images using _XmGetImageFromFile, store them in
 *  pixmaps, then create a drawing area with a set of labels containing
 *  the pixmaps.
 */

#include <X11/StringDefs.h>
#include <Xm/XmP.h>

#include <testlib.h>

extern XImage * _XmGetImageFromFile();
char automatic = 0;
Boolean trace = 0;

static char *bitmapNames[8] = {
	"../bitmaps/tie_fighter",
	"../bitmaps/gnu.bmp",
	"../bitmaps/warning",
	"../bitmaps/mtn.bmp",
	"../bitmaps/smiley.bmp",
	"../bitmaps/dp.bmp",
	"../bitmaps/circles1.bmp",
	""
};

static void flushEvents();

void main (argc, argv)
unsigned int argc;
char **argv;

{
  Widget drawarea;
  Widget separator;
  static char *label_names[15] = {"label1","label2","label3","label4",
		            "label5","label6","label7","label8",
		            "label9","label10","label11","label12",
		            "label13","label14","label15"};
  static Widget labels[15] = 
    {NULL, NULL,NULL, NULL,NULL, NULL,NULL, NULL,NULL, NULL,
       NULL, NULL,NULL, NULL,NULL};
  Pixmap pixmap1;
  XImage * image1;
  GC gc;
  Arg args[10];
  int j = 0, n;
  XmString tcs;

  CommonTestInit(argc, argv);

  /*  The drawing area creation.  Contained in an outer frame.  */

  n = 0;
  XtSetArg (args[n], XmNmarginWidth, 10);	n++;
  XtSetArg (args[n], XmNmarginHeight, 10); 	n++;
  drawarea = XmCreateRowColumn (Shell1, "drawarea", args, n);
  XtManageChild (drawarea);
  XtRealizeWidget (Shell1);

  while (bitmapNames[j][0]) {

    n = 0;
    tcs = XmStringLtoRCreate("Oops! error", XmSTRING_DEFAULT_CHARSET);
    XtSetArg (args[n], XmNlabelString, tcs);	n++;
    labels[j] = XmCreateLabel (drawarea, label_names[j], args, n);
    XtManageChild (labels[j]);
    
    gc = XCreateGC (XtDisplay (Shell1), XtWindow (Shell1), 0, 0);
    printf ("Reading image %s\n", bitmapNames[j]);

    if ((image1 = _XmGetImageFromFile (bitmapNames[j])) == NULL)
      {
	printf ("No image returned from _XmGetImageFromFile.\n");
	j++;
	continue;
      }
   
    pixmap1 = XCreatePixmap (XtDisplay (Shell1), XtWindow (Shell1),
			     image1->width, image1->height, 
			     DefaultDepthOfScreen (XtScreen (Shell1)));

    XPutImage (XtDisplay (Shell1), pixmap1, gc, image1, 
	       0, 0, 0, 0, image1->width, image1->height);

    XFreeGC (XtDisplay (Shell1), gc);

    n = 0;
    XtSetArg (args[n], XmNx, j * 20 + 5);	n++;
    XtSetArg (args[n], XmNlabelType, XmPIXMAP);	n++;
    XtSetArg (args[n], XmNlabelPixmap, pixmap1);	n++;
    XtSetValues (labels[j], args, n);
    XtManageChild (labels[j]);

    n = 0;
    XtSetArg (args[n], XmNseparatorType, XmSHADOW_ETCHED_OUT);	n++;
    separator = XmCreateSeparatorGadget (drawarea, "separator", args, n);
    XtManageChild (separator);

    if (!automatic)
      CommonPause();

    j++; 
  }

  j = 0;

  while (labels[j] != NULL)
    {
      XtDestroyWidget(labels[j]);
      j++;
    }
  CommonPause();

  XtAppMainLoop(app_context);
}

static void flushEvents(display, delay)
Display * display;
int delay;
{
  XEvent event;
  while (XPending(display)) {
    XNextEvent(display, &event);
    XtDispatchEvent(&event);
  }
  sleep(delay);
}

