/* 
 * (c) Copyright 1989, 1990, 1991, 1992 OPEN SOFTWARE FOUNDATION, INC. 
 * ALL RIGHTS RESERVED 
*/ 
/* 
 * Motif Release 1.2
*/ 
#ifdef REV_INFO
#ifndef lint
static char rcsid[] = "$RCSfile: OptionMenu5.c,v $ $Revision: 1.4.2.2 $ $Date: 1992/04/07 17:32:30 $"
#endif
#endif
/*
*  (c) Copyright 1987, 1988, 1989 HEWLETT-PACKARD COMPANY */

#include <testlib.h>

#include <X11/bitmaps/star>
#include <X11/bitmaps/opendot>
#include <X11/bitmaps/black>
#include <X11/bitmaps/boxes>
#include <X11/bitmaps/icon>
#include <X11/bitmaps/xlogo16>
#include <X11/bitmaps/xlogo32>
#include <X11/bitmaps/wide_weave>
#include <X11/bitmaps/target>

#define NUM_CHILDREN 6

Pixmap
#ifdef _NO_PROTO
makepixmap(toplevel,bits,width,height)
Widget toplevel;
char bits[];
int width, height;
#else
makepixmap(Widget toplevel, char bits[], int width, int height)
#endif
{
  return (Pixmap)XCreatePixmapFromBitmapData(XtDisplay(toplevel),
			   DefaultRootWindow(XtDisplay(toplevel)),
                           bits,
                           width,
                           height,
                           BlackPixelOfScreen(XtScreen(toplevel)),
                           WhitePixelOfScreen(XtScreen(toplevel)),
                           DefaultDepthOfScreen(XtScreen(toplevel)));
}

/*
** change the labelString and labelPixmap for the object by cycling through
** a pre-prepared set of values
*/
/*ARGSUSED*/

#ifdef _NO_PROTO
void cycle_values (w, client_data, call_data)
Widget w;
XtPointer client_data;	/* which widget to affect*/
XtPointer call_data;	
#else
void cycle_values (Widget w, XtPointer client_data, XtPointer call_data)
#endif
{
  Widget entry = (Widget) client_data;
#define NUM_VALUES 8
  static char *orig_strings[NUM_VALUES] = {
    "1",
    "second in series",
    "third in series",
    "fourth in series",
    "fifth in series",
    "sixth in series",
    "the seventh in the series",
    "last in series"
    };

  static struct bitmap_data {
    char *bits;
    int width;
    int height;
  } orig_pixmap[] = 
    {
      {(char *) star_bits, star_width, star_height},
      {(char *) opendot_bits, opendot_width, opendot_height},
      {(char *) black_bits, black_width, black_height},
      {(char *) boxes_bits, boxes_width, boxes_height},
      {(char *) icon_bits, icon_width, icon_height},
      {(char *) xlogo16_bits, xlogo16_width, xlogo16_height},
      {(char *) xlogo32_bits, xlogo32_width, xlogo32_height},
      {(char *) wide_weave_bits, wide_weave_width, wide_weave_height},
    };

  static XmString strings[NUM_VALUES];
  static Pixmap pixmaps[NUM_VALUES];
  Arg args[5];
  int n;
  int i;
  static Boolean values_set = False;
  static int which_one = 0;
  if (!values_set)
    {
      values_set = True;
      for (i=0; i < NUM_VALUES; i++)
	{
	  strings[i]=XmStringCreateSimple(orig_strings[i]);
	  pixmaps[i]=makepixmap(w,orig_pixmap[i].bits,
				orig_pixmap[i].width,orig_pixmap[i].height);
	}
      /* gosh; remember to destroy these ! */
    }
  n=0;
  XtSetArg (args[n], XmNlabelString, strings[which_one]); n++;
  XtSetArg (args[n], XmNlabelPixmap, pixmaps[which_one]); n++;
  XtSetValues (entry, args, n);
  which_one++;
  which_one %= NUM_VALUES;
}

/*ARGSUSED*/
#ifdef _NO_PROTO
void change_sensitive (w, client_data, call_data)
Widget w;
XtPointer client_data;	/* option menu */
XtPointer call_data;	/* from Toggle */
#else
void change_sensitive (Widget w, XtPointer client_data, XtPointer call_data)
#endif
{
  Widget option = (Widget) client_data;
  XmToggleButtonCallbackStruct *info = 
    (XmToggleButtonCallbackStruct *)call_data;
  Arg args[1];
  XtSetArg (args[0], XmNsensitive, info->set);
  XtSetValues (option, args, 1);
}

/*ARGSUSED*/
#ifdef _NO_PROTO
void change_labelType (w, client_data, call_data)
Widget w;
XtPointer client_data;	/* widgets */
XtPointer call_data;	/* from Toggle */
#else
void change_labelType(Widget w, XtPointer client_data, XtPointer call_data)
#endif
{
  Widget *entries = (Widget *)client_data;
  unsigned char labelType;
  int i;
  Arg args[2];
  /* find the value from the first, change it in all the others */
  XtSetArg(args[0], XmNlabelType, &labelType); 
  XtGetValues(entries[0], args, 1);
  if (XmSTRING == labelType) 
    XtSetArg(args[0], XmNlabelType, XmPIXMAP); 
  else	
    XtSetArg(args[0], XmNlabelType, XmSTRING); 
  for (i=0; i < NUM_CHILDREN; i++)
    XtSetValues(entries[i], args, 1);
}


main(argc, argv)
     int argc;
     char *argv[];
{  
  Widget form, rc, option, buttons[NUM_CHILDREN], entries[NUM_CHILDREN], 		toggles;
  Widget sensitive, labelType;
  Widget pulldown, bb;
  Arg args[10]; 
  int n;
  int i;
  XmString dummy;

  /* initialize toolkit; classname is XMcommon; sets global Shell1  */

  CommonTestInit(argc, argv);
  
  form = XmCreateForm (Shell1, "form", NULL, 0);

  toggles = XmCreateForm (form, "toggles", NULL, 0);
  XtVaSetValues (toggles,
	XmNleftAttachment, XmATTACH_FORM,
	XmNrightAttachment, XmATTACH_NONE,
	XmNtopAttachment, XmATTACH_POSITION,
	XmNtopPosition, 1,
	XmNbottomAttachment, XmATTACH_POSITION,
	XmNbottomPosition, 23,
	XmNfractionBase, 100,
	NULL);

  rc = XmCreateForm (form, "rc", NULL, 0);
  XtVaSetValues (rc, 
	XmNleftAttachment, XmATTACH_FORM,
	XmNrightAttachment, XmATTACH_NONE,
	XmNtopAttachment, XmATTACH_POSITION,
	XmNtopPosition, 24,
	XmNbottomAttachment, XmATTACH_POSITION,
	XmNbottomPosition, 64,
	XmNfractionBase, 100,
	NULL);

  n=0;
  XtSetArg(args[n], XmNset, True); n++;
  XtSetArg(args[n], XmNlabelString, 
	dummy=XmStringCreateSimple("Option's XmNsensitive=True")); n++;
  XtManageChild(sensitive=XmCreateToggleButton(toggles,"sensitivity",args,n));
  XmStringFree(dummy);
  XtVaSetValues (sensitive, 
	XmNleftAttachment, XmATTACH_FORM,
	XmNrightAttachment, XmATTACH_FORM,
	XmNtopAttachment, XmATTACH_FORM,
	XmNbottomAttachment, XmATTACH_POSITION,
	XmNbottomPosition, 50,
	NULL);
  n=0;
  XtSetArg(args[n], XmNset, True); n++;
  XtSetArg(args[n], XmNlabelString, 
	dummy=XmStringCreateSimple("Menu items' XmNlabelType=XmSTRING")); n++;
  XtManageChild(labelType=XmCreateToggleButton(toggles, "labelType", args, n));
  XmStringFree(dummy);
  XtVaSetValues (labelType, 
	XmNleftAttachment, XmATTACH_FORM,
	XmNrightAttachment, XmATTACH_FORM,
	XmNtopPosition, 50,
	XmNtopAttachment, XmATTACH_POSITION,
	XmNbottomAttachment, XmATTACH_FORM,
	NULL);

  n=0;
  XtManageChild(bb = XmCreateBulletinBoard(form, "bb", args, n));
  XtVaSetValues (bb,
	XmNleftAttachment, XmATTACH_FORM,
	XmNrightAttachment, XmATTACH_NONE,
	XmNtopAttachment, XmATTACH_POSITION,
	XmNtopPosition, 65,
	XmNbottomAttachment, XmATTACH_POSITION,
	XmNbottomPosition, 99,
	NULL);
  pulldown = XmCreatePulldownMenu(bb, "pulldown", NULL, 0);
  n=0;
  XtSetArg(args[n],XmNsubMenuId, pulldown);n++;
  XtSetArg(args[n], XmNlabelString, 
	dummy=XmStringCreateSimple("Label/LabelG Menu Items")); n++;
  option=XmCreateOptionMenu(bb, "option_menu", args, n);
  XmStringFree(dummy);

  XtAddCallback(sensitive, XmNvalueChangedCallback, change_sensitive,
	(Widget)option);
  XtAddCallback(labelType, XmNvalueChangedCallback, change_labelType,
	(Widget *)entries);

  /* enumerate interesting subclasses of Label and LabelGadget */
  entries[0] = XmCreateLabelGadget(pulldown, "lg", NULL, 0);
  entries[1] = XmCreateLabel (pulldown, "l", NULL, 0);
  entries[2] = XmCreatePushButtonGadget (pulldown, "pbg",NULL,0);
  entries[3] = XmCreatePushButton (pulldown, "pb", NULL, 0);
  entries[4] = XmCreateToggleButtonGadget (pulldown, "tbg",
		NULL, 0);
  entries[5] = XmCreateToggleButton (pulldown, "tb", NULL, 0);

  {
	/* give an initial harmless XmNlabelPixmap */
  int i;
  Pixmap target = makepixmap(Shell1,target_bits,
			target_width,target_height);
  XtSetArg(args[0], XmNlabelPixmap, target);
  for (i=0; i< NUM_CHILDREN; i++)
	XtSetValues(entries[i], args,1);
  }

  /* if the option appears as the name then the 
  ** updating of the label is busted 
  */
  for (i=0; i < NUM_CHILDREN; i++)
	{
	char buffer[100];
	char lab[50];
	sprintf(buffer, "Change pulldown entry #%d", i);
	sprintf(lab, "entry%d", i);
	dummy = XmStringCreateSimple(buffer);
	XtSetArg(args[0], XmNlabelString, dummy);
	buttons[i]= XmCreatePushButton(rc, lab, args, 1);
  	XmStringFree(dummy);
	XtAddCallback(buttons[i], XmNactivateCallback, cycle_values, 
		entries[i]);
  	XtVaSetValues (buttons[i], 
		XmNleftAttachment, XmATTACH_FORM,
		XmNrightAttachment, XmATTACH_FORM,
		XmNtopAttachment, XmATTACH_POSITION,
		XmNtopPosition, i*100/NUM_CHILDREN,	/* fractionBase */
		NULL);
	}

  XtManageChildren(buttons, NUM_CHILDREN);
  XtManageChildren(entries, NUM_CHILDREN);

  XtManageChild(rc);
  XtManageChild(toggles);
  XtManageChild(form);
  XtManageChild(option);


  /* if we realize after setting the labels, there is no problem; it works.
  ** The sequence of realizing is important only because the option menu
  ** sets the cascade label at realize time, so we set afterwards so that if
  ** the name as the label shows we know it's wrong.  
  */
#ifdef DONT_SHOW_INITIAL_BUG
  XtRealizeWidget(Shell1);
#endif

  {
/* confirm that we can change the labels programmatically and have the
** labels appear correctly in the XmOptionButtonGadget before the menu has
** been popped up by the user . So we set them here to what they should 
** appear as. We should see "Label Gadget" echoed.
** Optimally, we will also see correct geometry for the CBG.
*/
  static char *strings[NUM_VALUES]=
	{
	  "Label Gadget", 
	  "Label",
	  "Push Button Gadget",
	  "Push Button",
	  "Toggle Button Gadget",
	  "Toggle Button"
	};
  int i;
  XmString dummy;
  for (i=0; i< NUM_CHILDREN; i++)
	{
	dummy=XmStringCreateSimple(strings[i]);
	XtSetArg (args[0], XmNlabelString, dummy);
	XtSetValues(entries[i], args, 1);
	XmStringFree(dummy);
	}   
  }

#ifndef DONT_SHOW_INITIAL_BUG
  XtRealizeWidget(Shell1);
#endif

/* one of these for each Continue: C), if any, plus last screen: E)*/
  CommonPause();
  CommonPause();
  CommonPause();
  CommonPause();
  CommonPause();
  CommonPause();

/* declared elsewhere */
  XtAppMainLoop(app_context);
}
