/* 
 * (c) Copyright 1989, 1990, 1991, 1992 OPEN SOFTWARE FOUNDATION, INC. 
 * ALL RIGHTS RESERVED 
*/ 
/* 
 * Motif Release 1.2
*/ 
#ifdef REV_INFO
#ifndef lint
static char rcsid[] = "$RCSfile: Cutpaste4b.c,v $ $Revision: 1.4.2.2 $ $Date: 1992/04/06 19:04:09 $"
#endif
#endif
/*
*  (c) Copyright 1989, HEWLETT-PACKARD COMPANY */
#include <X11/Xatom.h>
#include <testlib.h>

Arg	args[20];
Atom	target;

static void GetCBSelection();

#define XA_TIMESTAMP ( XmInternAtom( display, "TIMESTAMP", False ))
#define XA_TARGETS ( XmInternAtom( display, "TARGETS", False ))
#define XA_CLIPBOARD ( XInternAtom( display, "CLIPBOARD", False ))

/*
 * This function is called when the selection value is returned by the
 * Toolkit.  It will try to use the cut buffer if no X selection is found.
 */

static void PasteCallBack(w, closure, selection, type, value, length, format)
     Widget	w;
     caddr_t	closure;
     Atom	*selection,
     		*type;
     caddr_t	value;
     int	*length,
     		*format;
{
    Widget	text = (Widget) closure;
    char	string[20];

    if (*type == XA_STRING)
    {
	char *text_string;
	char *text_value = (char *)value;

	text_string = (char *) XtMalloc (strlen(text_value) + 12);
	sprintf(text_string, "%s", text_value);
	XmTextSetString(text, text_string);
    }
    else   if (*type == None)
    {
	fprintf(stdout, "Retrieve Failed, No Clipboard selection.\n");
    }
    else
    {
	fprintf(stdout, "Incorrect selection type\n");
    }
} 


static void GetCBSelection (button, client_data, call_data)
     Widget	button;
     XtPointer	client_data,
     		call_data;
{
    Widget 		text = (Widget) client_data;
    XmAnyCallbackStruct	*cb = (XmAnyCallbackStruct *)call_data;

    XtGetSelectionValue(text, XA_CLIPBOARD, XA_STRING, PasteCallBack,
			text, cb->event->xbutton.time);
}


void main (argc, argv)
int argc;
char **argv;
{
    Widget	PanedWindow,
    		PushButton1,
    		Label,
    		Text;
    int		n;

    CommonTestInit(argc, argv);

/*
 * Paned window to hold pushbutton, labels and text widgets
 */

    n = 0;
    PanedWindow = XmCreatePanedWindow(Shell1, "PanedWindow", args, n);
    XtManageChild(PanedWindow);

    n = 0;
    XtSetArg(args[n], XmNlabelString,
	     XmStringCreateLtoR("Get Values", XmSTRING_DEFAULT_CHARSET)); n++;
    PushButton1 = XmCreatePushButton(PanedWindow, "PushButton1", args, n);
    XtManageChild(PushButton1);

    n = 0;
    XtSetArg(args[n], XmNlabelString,
	     XmStringCreateLtoR("String", XmSTRING_DEFAULT_CHARSET)); n++;
    Label = XmCreateLabel(PanedWindow, "Label", args, n);
    XtManageChild(Label);

    n = 0;
    XtSetArg(args[n], XmNresizeWidth, False);  n++;
    XtSetArg(args[n], XmNresizeHeight, False);  n++;
    XtSetArg(args[n], XmNrows, 1);  n++;
    XtSetArg(args[n], XmNcolumns, 15);  n++;
    XtSetArg(args[n], XmNfontList, CommonGetFontList("6x10"));  n++;

    Text = XmCreateText(PanedWindow, "Text", args, n);
    XtManageChild(Text);

    XtAddCallback (PushButton1, XmNactivateCallback, GetCBSelection, 
		   (XtPointer) Text);

    XtRealizeWidget(Shell1);

    XtSetSelectionTimeout(20000); 

    XtAppMainLoop(app_context);
}
