/* 
 * (c) Copyright 1989, 1990, 1991, 1992 OPEN SOFTWARE FOUNDATION, INC. 
 * ALL RIGHTS RESERVED 
*/ 
/* 
 * Motif Release 1.2
*/ 
#ifdef REV_INFO
#ifndef lint
static char rcsid[] = "$RCSfile: Form8.c,v $ $Revision: 1.5.2.2 $ $Date: 1992/05/05 17:59:55 $"
#endif
#endif
/*
*  (c) Copyright 1987, 1988, 1989 HEWLETT-PACKARD COMPANY */

/*
 *  Create two scrollbars in a form.  The first being attached to the right
 *  and top sides of the form.  The second being attached to the left
 *  and bottom of the form and the left edge of the form.
 *  Set the form's unit type to inches and offset the scrollbars 
 *  from the form's edge.  Offset the first at init time, the second at
 *  setvalues.  GetValues on the resolution independent data to ensure
 *  correctness.
 */


#include <signal.h>
#include <X11/Xlib.h>
#include <X11/StringDefs.h>

#include <testlib.h>

/*  Forward declarations  */

extern void FormCallback();

/*  main  */

void main (argc, argv)
unsigned int argc;
char **argv;
{
   Widget frame;
   Widget form;
   Widget scrollbar1;
   Widget scrollbar2;
   Arg args[10];
   int n;

   /*  initialize toolkit  */
   CommonTestInit(argc, argv);

   if (UserData == NULL) {
	printf ("Usage: %s -u [early middle late]\n", argv[1]);
	printf ("Assuming late realize.\n");
   }
    
   frame = XmCreateFrame(Shell1, "frame", NULL, 0);
   XtManageChild(frame);

   if (UserData && (strcmp (UserData, "early") == 0)) {
	printf ("Early realize.\n");
	fflush (stdout);
	XtRealizeWidget (Shell1);
   }

   /*  The form creation.  Contained in an outer frame.  */

   n = 0;
   XtSetArg (args[n], XmNwidth, 4000);			n++;
   XtSetArg (args[n], XmNheight, 3000);			n++;
   XtSetArg (args[n], XmNunitType, Xm1000TH_INCHES);	n++;
   form = XmCreateForm (frame, "form", args, n);
   XtManageChild (form);
   XtAddCallback (form, XmNhelpCallback, FormCallback, NULL);

   if (UserData && (strcmp (UserData, "middle") == 0)) {
	printf ("Middle realize.\n");
	fflush (stdout);
	XtRealizeWidget (Shell1);
   }

   /*  Arguments to the first scrollbar.  */

   n = 0;
   XtSetArg (args[n], XmNheight, 750);				n++;
   XtSetArg (args[n], XmNorientation, XmVERTICAL);		n++;
   XtSetArg (args[n], XmNrightAttachment, XmATTACH_FORM);	n++;
   XtSetArg (args[n], XmNrightOffset, 500);			n++;
   XtSetArg (args[n], XmNunitType, Xm1000TH_INCHES);		n++;
   XtSetArg (args[n], XmNtopAttachment, XmATTACH_FORM);		n++;
   scrollbar1 = XmCreateScrollBar (form, "scrollbar1", args, n);
   XtManageChild (scrollbar1);

   /*  Arguments to the second scrollbar.  */

   n = 0;
   XtSetArg (args[n], XmNorientation, XmHORIZONTAL);		n++;
   XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM);	n++;
   XtSetArg (args[n], XmNbottomAttachment, XmATTACH_FORM);	n++;
   XtSetArg (args[n], XmNrightAttachment, XmATTACH_WIDGET);	n++;
   XtSetArg (args[n], XmNunitType, Xm1000TH_INCHES);		n++;
   XtSetArg (args[n], XmNrightWidget, scrollbar1);		n++;
   scrollbar2 = XmCreateScrollBar (form, "scrollbar2", args, n);
   XtManageChild (scrollbar2);

   /*  Set the bottom offset for scrollbar2 to 1/2 inch  */

   n = 0;
   XtSetArg (args[n], XmNbottomOffset, 500);	n++;
   XtSetValues (scrollbar2, args, n);


   if (!UserData || (strcmp (UserData, "late") == 0)) {
	printf ("Late realize.\n");
	fflush (stdout);
	XtRealizeWidget (Shell1);
   }

   /*  Get Values out of the form and scrollbars and print the results.  */

   printf ("Width\tHeight\tOffset1\tOffset2\tMode\n");

   n = 0;
   XtSetArg (args[n], XmNwidth, NULL);	n++;
   XtSetArg (args[n], XmNheight, NULL);	n++;
   XtGetValues (form, args, n);
   printf ("%d\t%d\t", args[0].value, args[1].value);

   n = 0;
   XtSetArg (args[n], XmNrightOffset, NULL);	n++;
   XtGetValues (scrollbar1, args, n);
   printf ("%d\t", args[0].value);

   n = 0;
   XtSetArg (args[n], XmNbottomOffset, NULL);	n++;
   XtGetValues (scrollbar2, args, n);
   printf ("%d\t", args[0].value);

   printf ("%s\n", (UserData ? UserData : "late"));


   CommonPause();

   XtAppMainLoop(app_context);
}

void FormCallback (fw, closure, call_data)
XmFormWidget fw;
caddr_t closure;
caddr_t call_data;
{
   int reason;

   XmAnyCallbackStruct * call_value = (XmAnyCallbackStruct *) call_data;

   reason = call_value -> reason;

   switch (reason)
   {
      case XmCR_HELP:
         printf ("Reason = XmCR_HELP\n");
      break;

      default:
         printf ("Hit the default, incorrect reason sent!!\n");
      break;
   }
}












