/* 
 * (c) Copyright 1989, 1990, 1991, 1992 OPEN SOFTWARE FOUNDATION, INC. 
 * ALL RIGHTS RESERVED 
*/ 
/* 
 * Motif Release 1.2
*/ 
#ifdef REV_INFO
#ifndef lint
static char rcsid[] = "$RCSfile: RegisterC.c,v $ $Revision: 1.5.2.2 $ $Date: 1992/04/08 15:53:40 $"
#endif
#endif

#include <MrmTest.h>

#include "Browse.h"

/*
 * Callbacks for Browse widget
 */

void		browse_help_proc();
void		browse_quit_proc();

/*
 * Convenience routine
 */

extern void	nyi_proc();

/*
 * Names to register with MrmRegisterNames
 */

static MrmRegisterArg reglist[] = 
{
    "browse_help_proc",		(caddr_t) browse_help_proc,
    "browse_quit_proc",		(caddr_t) browse_quit_proc,
};

static int reglist_num =
(sizeof(reglist) / sizeof(reglist[0]));

/*
 * Data for summary
 */

#define NUM_TESTS		2
#define TEST_DESCRIP_LENGTH	49

struct TestInfo RegisterClassInfo[NUM_TESTS] = 
{
    {"Register valid Motif widget class                ", MrmSUCCESS, NULL},
    {"Fetch user-defined Motif widget (of valid class) ", MrmSUCCESS, NULL},
};

/*
 * External declarations
 */

extern MrmHierarchy	s_MrmHierarchy;
extern MrmType		class;

extern Widget		toplevel,
			widgetmain;

extern String		summary();

/*
 * Local declarations
 */

#define VALID_TEST1	1
#define FINISH		2

int		iteration = 1;

Widget		test_top = NULL,
		browse = NULL;

Display		*dsp;
Screen		*screen;
Colormap	cmap;

Pixmap		images[5];
int		num_images = 5;

    
Pixel		image_background,
		image_foreground;

void continue_proc(w, tag, reason)
     Widget		w;
     int		*tag;
     unsigned long	*reason;
{ 	

    String	msg_valid_tst1 = "There should now be a Motif Browse widget in the second\nwindow.  This widget consists of four pushbutton widgets\nand a label widget displaying an image.  There are five\nsuch images, and they can be seen by using the Next and\nPrev buttons.  Note that pressing Next while viewing the\nlast image will have no effect.  This is also true for\npressing Prev while viewing the first image.\n\nPress the continue button to continue the test.";

    Arg		args[2];
    int		nargs;

    XmString	message;

    String	summary_msg;

    if(iteration == VALID_TEST1)
    {
	iteration++;

/*
 * Create top level shell widget as parent for test_box widget
 */

	nargs = 0;
	XtSetArg(args[nargs], XtNallowShellResize, TRUE); nargs++;

	test_top = XtAppCreateShell("test_top",
				    "TEST_TOP",
				    topLevelShellWidgetClass,
				    XtDisplay(widgetmain),
				    args, nargs);

/*
 * Register valid Browse widget class
 */
	RegisterClassInfo[0].actual_return =
	MrmRegisterClass(URMwcUnknown,
			 "Browse",
			 "XmCreateBrowse",
			 XmCreateBrowse,
			 browseWidgetClass);

/*
 * Register the names of the Browse widget callback routines with Mrm
 */
    
	if(MrmRegisterNames(reglist,		/* list of names	*/
			    reglist_num)	/* number of names	*/
	   != MrmSUCCESS)
	{
	    error_proc("Can't register Browse widget callbacks\n");
	}
    
/*
 * Get display, screen, colormap
 */

	dsp = XtDisplay(toplevel);
	
	screen = DefaultScreenOfDisplay(dsp);

	cmap = DefaultColormap(dsp, DefaultScreen(dsp));

/*
 * Fetch background and foreground colors for images
 */

	if(MrmFetchColorLiteral(s_MrmHierarchy,
				"yellow",
				dsp,
				cmap,
				&image_foreground) != MrmSUCCESS)
	{
	    error_proc("can't fetch the color yellow");
	}
    
	if(MrmFetchColorLiteral(s_MrmHierarchy,
				"red",
				dsp,
				cmap,
				&image_background) != MrmSUCCESS)
	{
	    error_proc("can't fetch the color red");
	}
    
/*
 * Fetch images (pixmaps)
 */
	
	if(MrmFetchIconLiteral(s_MrmHierarchy,
			       "blank_icon",
			       screen,
			       dsp,
			       image_foreground,
			       image_background,
			       &images[0]) != MrmSUCCESS)
	{
	    error_proc("can't fetch blank_icon");
	}
    
	if(MrmFetchIconLiteral(s_MrmHierarchy,
			       "test1_btn1_icon",
			       screen,
			       dsp,
			       image_foreground,
			       image_background,
			       &images[1]) != MrmSUCCESS)
	{
	    error_proc("can't fetch test1_btn1_icon");
	}
	
	if(MrmFetchIconLiteral(s_MrmHierarchy,
			       "test1_btn2_icon",
			       screen,
			       dsp,
			       image_foreground,
			       image_background,
			       &images[2]) != MrmSUCCESS)
	{
	    error_proc("can't fetch test1_btn2_icon");
	}
	
	if(MrmFetchIconLiteral(s_MrmHierarchy,
			       "test2_btn1_icon",
			       screen,
			       dsp,
			       image_foreground,
			       image_background,
			       &images[3]) != MrmSUCCESS)
	{
	    error_proc("can't fetch test2_btn1_icon");
	}
	
	if(MrmFetchIconLiteral(s_MrmHierarchy,
			       "test2_btn2_icon",
			       screen,
			       dsp,
			       image_foreground,
			       image_background,
			       &images[4]) != MrmSUCCESS)
	{
	    error_proc("can't fetch test2_btn2_icon");
	}
	
/*
 * Try to fetch Browse widget
 */

	RegisterClassInfo[1].actual_return = MrmFetchWidget(s_MrmHierarchy,
							    "browse",
							    test_top,
							    &browse,
							    &class);

/*
 * Pass images to widget
 */

	nargs = 0;
	XtSetArg(args[nargs], XmNimages, images); nargs++;
	XtSetArg(args[nargs], XmNnumImages, num_images); nargs++;
	XtSetValues(browse, args, nargs);

/*
 * Manage Browse widget
 */

	XtManageChild(browse);
    
/*
 * Realize top level shell widget
 */

	XtRealizeWidget(test_top);

/*
 * Replace the instruction message with "valid test 1" message
 */

	message = XmStringCreateLtoR(msg_valid_tst1, XmSTRING_DEFAULT_CHARSET);
	
	nargs = 0;
	XtSetArg(args[nargs], XmNmessageString, message); nargs++;
	XtSetValues(widgetmain, args, nargs);
    }
    else if(iteration == FINISH)
    {
	iteration++;

	summary_msg = summary(NUM_TESTS,
			      TEST_DESCRIP_LENGTH,
			      RegisterClassInfo);
    
	fprintf (stdout, summary_msg); 

	message = XmStringCreateLtoR(summary_msg, XmSTRING_DEFAULT_CHARSET);
	
	nargs = 0;
	XtSetArg(args[nargs], XmNmessageString, message); nargs++;
	XtSetValues(widgetmain, args, nargs);
    }
}

/*
 * Browse Help procedure
 */

void browse_help_proc(w, tag, reason)
     Widget		w;
     int		*tag;
     unsigned long	*reason;
{
    nyi_proc(w, "Browse Help", NULL);
}

/*
 * Browse Exit procedure
 */

void browse_quit_proc(w, tag, reason)
     Widget		w;
     int		*tag;
     unsigned long	*reason;
{
    nyi_proc(w, "Browse Quit", NULL);
}
