/* 
 * (c) Copyright 1989, 1990, 1991, 1992 OPEN SOFTWARE FOUNDATION, INC. 
 * ALL RIGHTS RESERVED 
*/ 
/* 
 * Motif Release 1.2
*/ 
#ifdef REV_INFO
#ifndef lint
static char rcsid[] = "$RCSfile: Conversion.c,v $ $Revision: 1.3 $ $Date: 92/03/13 18:32:06 $"
#endif
#endif
#include "testlib.h"

/*************************************************************************
*									 *
*	Name:		CommonCsToRs()					 *
*									 *
*	Function:	This function will receive as input a Compound   *
*			string and return to the user a Regular string   *
*			representation.					 *
*									 *
*	Returns:	A Regular string corresponding to the inputs     *
*			Compound String. Will return NULL if inputted    *
*			string is NULL					 *
*									 *
*************************************************************************/

#ifdef _NO_PROTO
char *CommonCsToRs(cs)
XmString cs;
#else /* _NO_PROTO */
char *CommonCsToRs(XmString cs)
#endif /* _NO_PROTO */

{
    XmStringContext 	context;
    XmStringCharSet 	charset;
    XmStringDirection 	direction;
    Boolean 		separator;
    char 		*primitive_string;

    /* Don't do conversion if string is NULL */

    if (cs == NULL)
	return (NULL);

    XmStringInitContext(&context,cs);
    XmStringGetNextSegment(context,&primitive_string,
           &charset,&direction,&separator);
    XmStringFreeContext(context);
    return(primitive_string);
}
