/* 
 * (c) Copyright 1989, 1990, 1991, 1992 OPEN SOFTWARE FOUNDATION, INC. 
 * ALL RIGHTS RESERVED 
*/ 
/* 
 * Motif Release 1.2
*/ 
#ifdef REV_INFO
#ifndef lint
static char rcsid[] = "$RCSfile: Callbacks.c,v $ $Revision: 1.4 $ $Date: 92/03/13 18:31:53 $"
#endif
#endif
#include "testlib.h"

char *REASONS[50] = {
	"XmCR_NONE",
	"XmCR_HELP",
	"XmCR_VALUE_CHANGED",
	"XmCR_INCREMENT",
	"XmCR_DECREMENT",
	"XmCR_PAGE_INCREMENT",
	"XmCR_PAGE_DECREMENT",
	"XmCR_TO_TOP",
	"XmCR_TO_BOTTOM",
	"XmCR_DRAG",
	"XmCR_ACTIVATE",
	"XmCR_ARM",
	"XmCR_DISARM",
	"NO_REASON",
	"NO_REASON",
	"NO_REASON",
	"XmCR_MAP",
	"XmCR_UNMAP",
	"XmCR_FOCUS",
	"XmCR_LOSING_FOCUS",
	"XmCR_MODIFYING_TEXT_VALUE",
	"XmCR_MOVING_INSERT_CURSOR",
	"XmCR_EXECUTE",
	"XmCR_SINGLE_SELECT",
	"XmCR_MULTIPLE_SELECT",
	"XmCR_EXTENDED_SELECT",
	"XmCR_BROWSE_SELECT",
	"XmCR_DEFAULT_ACTION",
	"XmCR_CLIPBOARD_DATA_REQUEST",
	"XmCR_CLIPBOARD_DATA_DELETE",
	"XmCR_CASCADING",
	"XmCR_OK",
	"XmCR_CANCEL",
	"NO_REASON",
	"XmCR_APPLY",
	"XmCR_NO_MATCH",
	"XmCR_COMMAND_ENTERED ",
	"XmCR_COMMAND_CHANGED",
	"XmCR_EXPOSE",
	"XmCR_RESIZE",
	"XmCR_INPUT",
	"XmCR_GAIN_PRIMARY",
	"XmCR_LOSE_PRIMARY",
};

/*************************************************************************
*									 *
*	Name:		CommonGenericCB()				 *
*									 *
*	Purpose:	This is a generic callback routine that will     *
*			simply fprintf out a message that a callback has *
*		    	been called and what the reason was for the      *
*			callback. 					 *
*									 *
*	Returns:	Nothing						 *
*									 *
*************************************************************************/

#ifdef _NO_PROTO
void CommonGenericCB(w, client_data, call_data)
Widget    w;
XtPointer client_data;
XtPointer call_data;
#else /* _NO_PROTO */
void CommonGenericCB(Widget w, XtPointer client_data,
		     XtPointer call_data)
#endif /* _NO_PROTO */

{
    char *reason;
    int  index;

    index = ((XmAnyCallbackStruct *)call_data)->reason;
    reason = REASONS[index];
    fprintf(stdout, "Generic Callback called:  Reason - %s\n", reason);
    if (client_data)
	fprintf(stdout, "    Client Data:  %s\n", (char *)client_data);
}
