/* 
 * (c) Copyright 1989, 1990, 1991, 1992 OPEN SOFTWARE FOUNDATION, INC. 
 * ALL RIGHTS RESERVED 
*/ 
/* 
 * Motif Release 1.2
*/ 
#ifdef REV_INFO
#ifndef lint
static char rcsid[] = "$RCSfile: MallocOut.c,v $ $Revision: 1.3 $ $Date: 92/03/13 18:31:07 $"
#endif
#endif
/*
 * FILE: MallocOut.c
 *  Based on Conor Cahill's Malloc library - (see copyright statement)
 *  This module contains routines to support output from the malloc
 *  library.
 *
 *  Condensed 910218, Susan Thompson
 */

/*
 * (c) Copyright 1990 Conor P. Cahill (uunet!virtech!cpcahil).  
 * You may copy, distribute, and use this software as long as this
 * copyright statement is not removed.
 */

#include <stdio.h>
#include "Malloc.h"

/*
 * Function:    malloc_msg
 *
 * Purpose:     To format malloc output.  Formats message with
 *		sprintf.  Allows up to 5 parameters.
 *
 * Arguments:   msg_type - the type of message
 *		numparams - the number of parameters actually to use
 *		msg  - the sprintf message string
 *		par1 - parameter 1
 *		par2    "  2
 *		par3	"  3
 *		par4    "  4
 * 		par5    "  5
 *
 * Returns:     No value
 *  
 * Info:  For AUTOMATION, malloc_msg prints out a generic message depending
 * 		on the type of message.  AUTOMATION output requires that
 *              no output be dependent on the particular run, therefore we
 *	        cannot print out specific addresses, etc.  Also, AUTOMATION
 *		output does not contain malloc statistics.
 */

#ifdef _NO_PROTO
void malloc_msg(msg_type, numparams, msg, par1, par2, par3, par4, par5)
int msg_type;
int numparams;
char *msg;
int par1;
char *par2;
int par3;
char *par4;
char *par5;
#else  /* _NO_PROTO */
void malloc_msg(int msg_type, int numparams, char *msg, int par1, char *par2, 
		int par3, char *par4, char *par5)
#endif 
{
  static char strbuf[100];
  static int strsize = 0;

#ifdef AUTOMATION

  switch (msg_type)
    {
    case MALLOC_STAT:
      /* Statistic, no message occurs during automation */
      return;

    case MALLOC_WRITE_ERROR:
      sprintf(strbuf, 
         "Warning: Malloc detected write beyond end of allocated memory.\n");
      break;

    case MALLOC_INVALID_FREE:
      sprintf(strbuf,
	 "Warning: Malloc detected free on memory not currently allocated.\n");
      break;

    case MALLOC_REALLOC_ERROR:
      sprintf(strbuf,
	 "Warning: Malloc trying to allocated memory already allocated.\n");
      break;

    case MALLOC_EMPTY_TREE:
      sprintf(strbuf,
	 "Warning: Malloc operation detected on empty tree.\n");
      break;

    case MALLOC_INTERNAL_ERROR:
      sprintf(strbuf,
	 "Warning: Malloc allocation request failed.  Internal error.\n");
      break;
    } /* switch (msg_type) */

  strsize = strlen(strbuf);
  write(malloc_outfd, strbuf, strsize);

#else
  switch (numparams) 
    {
    case 0:
      sprintf(strbuf, msg);
      break;
      
    case 1:
      sprintf(strbuf, msg, par1);
      break;

    case 2:
      sprintf(strbuf, msg, par1, par2);
      break;

    case 3:
      sprintf(strbuf, msg, par1, par2, par3);
      break;

    case 4:
      sprintf(strbuf, msg, par1, par2, par3, par4);
      break;

    case 5:
      sprintf(strbuf, msg, par1, par2, par3, par4, par5);
      break;

    default:
	return;  /* error, can only handle 0, 1, 2, 3, 4, or 5 parameters */
    } /* switch (numparams) */

  strsize = strlen(strbuf);
  write(malloc_outfd, strbuf, strsize);

#endif /* if AUTOMATION */

}

/*
 * Function:	MallocDump()
 *
 * Purpose:	to dump a printed copy of the malloc tree data structure
 *		and the associated data elements
 *
 * Arguments:   None
 *
 * Returns:	Void, no value
 *
 */

#ifdef _NO_PROTO 
void MallocDump()
#else  /* _NO_PROTO */
void MallocDump()
#endif /* _NO_PROTO */
{
  /*
   *  Traverse the malloc tree and dump out what's left.  This only 
   *   occurs when we're not running with AUTOMATION.
   */

#ifndef AUTOMATION
  malloc_msg(MALLOC_STAT,0,"\n",0,NULL,0,NULL,NULL);
  malloc_msg(MALLOC_STAT,0,
	     "*****************  DUMPING LEFTOVER DATA  **********\n",
	     0,NULL,0,NULL,NULL);
  malloc_msg(MALLOC_STAT,
	     0,"\n",0,NULL,0,NULL,NULL);

  if (malloc_root == NULL)
    malloc_msg(MALLOC_STAT, 0, 
       "Malloc root pointer is NULL, no data in tree\n",0, NULL, 0,NULL, NULL);
  else
    malloc_dump_tree(malloc_root);

  malloc_msg(MALLOC_STAT, 0,"\n",0,NULL,0,NULL,NULL);
  malloc_msg(MALLOC_STAT, 0,
	     "*****************   MALLOC DATA COUNTS  **********\n",
	     0,NULL,0,NULL,NULL);
  malloc_msg(MALLOC_STAT, 0,"\n",0,NULL,0,NULL,NULL);

  malloc_msg(MALLOC_STAT, 1,"Total bytes left over = %u\n", bytes_in_use,
	     NULL,0,NULL,NULL);
  malloc_msg(MALLOC_STAT, 1,
	     "Total malloc ptrs left over = %u\n", alloc_requests_in_use,
	     NULL,0,NULL,NULL);
  malloc_msg(MALLOC_STAT, 1,
	     "Total Memory allocation = %u\n", total_bytes_allocated,NULL,
	     0, NULL, NULL);
  malloc_msg(MALLOC_STAT,1,
	     "Total Pointers allocated = %u\n", total_alloc_requests, NULL,
	     0, NULL, NULL);
  malloc_msg(MALLOC_STAT, 0,"\n",0,NULL,0,NULL,NULL);

#endif /* not defined AUTOMATION */
  return;

} /* MallocDump(... */



/*
 * Function:	MallocLeakInfo()
 *
 * Purpose:	to provide information about the total memory allocated so far
 *			and the total memory leaked.
 *
 * Arguments:   
 *		      total_memory - Returned value of total memory allocated
 *		      memory_leaked - Returned value of total memory leaked
 *
 * Returns:	Void, no value
 *
 */

#ifdef _NO_PROTO 
void MallocLeakInfo(total_memory, memory_leaked)
int	*total_memory;
int	*memory_leaked;
#else  /* _NO_PROTO */
void MallocLeakInfo(int *total_memory, int *memory_leaked)
#endif /* _NO_PROTO */
{

	*total_memory = total_bytes_allocated;
	*memory_leaked = bytes_in_use;

	return;

} /* MallocLeakInfo(... */
