/* 
 * (c) Copyright 1989, 1990, 1991, 1992 OPEN SOFTWARE FOUNDATION, INC. 
 * ALL RIGHTS RESERVED 
*/ 
/* 
 * Motif Release 1.2
*/ 
#ifdef REV_INFO
#ifndef lint
static char rcsid[] = "$RCSfile: MallocCheck.c,v $ $Revision: 1.3 $ $Date: 92/03/13 18:30:58 $"
#endif
#endif
/*
 * FILE: MallocCheck.c
 * Based on: 
 *       Conor Cahill's Malloc Library - (see copyright statement)
 * Condensed 910214, SMT
 */

/*
 * (c) Copyright 1990 Conor P. Cahill (uunet!virtech!cpcahil).  
 * You may copy, distribute, and use this software as long as this
 * copyright statement is not removed.
 */

#include <stdio.h>
#include "Malloc.h"

/*
 * Function:	malloc_in_arena()
 *
 * Purpose:	to verify address is within malloc arena.
 *
 * Arguments:	ptr	- pointer to verify
 *
 * Returns:	TRUE	- if pointer is within malloc area
 *		FALSE	- otherwise
 *
 * Narrative:
 *   IF pointer is >= malloc area start AND <= malloc area end
 *      return TRUE
 *   ELSE
 *      return FALSE
 *
 */

#ifdef _NO_PROTO
int malloc_in_arena(ptr)
char *ptr;
#else  /* _NO_PROTO */
int malloc_in_arena(char *ptr)
#endif /* _NO_PROTO */
{
  int rtn = 0;

  if (malloc_root == NULL) return 0;

  if ((ptr <= malloc_great_value(malloc_root)) && 
       (ptr >= malloc_least_value(malloc_root)))
    {
      rtn = 1;
    }
  return(rtn);
}

/*
 * Function:	malloc_check_str()
 *
 * Arguments:	func	- name of function calling this routine
 *		str	- pointer to area to check
 *
 * Purpose:	to verify that if str is within the malloc arena, the data 
 *		it points to does not extend beyond the applicable region.
 *
 * Returns:	Nothing of any use (function is void).
 *
 * Narrative:
 *   IF pointer is within malloc arena
 *      determin length of string
 *      call malloc_verify() to verify data is withing applicable region
 *   return 
 *
 */
#ifdef _NO_PROTO
void malloc_check_str(func,str)
char *func;
char *str;
#else  /* _NO_PROTO */
void malloc_check_str(char *func, char *str)
#endif /* _NO_PROTO */
{
  static int layers;
  register char	*s;

  if (malloc_root == NULL) return;

  if ((layers++ == 0) && malloc_in_arena(str))
    {
      for (s=str; *s; s++){}
		
      malloc_verify(func,str,s-str+1);
    }
  layers--;
}

/*
 * Function:	malloc_check_data()
 *
 * Arguments:	func	- name of function calling this routine
 *		ptr	- pointer to area to check
 *		len 	- length to verify
 *
 * Purpose:	to verify that if ptr is within the malloc arena, the data 
 *		it points to does not extend beyond the applicable region.
 *
 * Returns:	Nothing of any use (function is void).
 *
 * Narrative:
 *   IF pointer is within malloc arena
 *      call malloc_verify() to verify data is withing applicable region
 *   return 
 *
 */
#ifdef _NO_PROTO
void malloc_check_data(func,ptr,len)
char *func;
char *ptr;
int len;
#else  /* _NO_PROTO */
void malloc_check_data(char *func, char *ptr, int len)
#endif /* _NO_PROTO */

{
  static int layers;

  if (malloc_root == NULL) return;

  if (layers++ == 0)
    {
      if (malloc_in_arena(ptr))
	{
	  malloc_verify(func,ptr,len);
	}
    }

  layers--;
}

/*
 * Function:	malloc_verify()
 *
 * Arguments:	func	- name of function calling the malloc check routines
 *		ptr	- pointer to area to check
 *		len 	- length to verify
 *
 * Purpose:	to verify that the data ptr points to does not extend beyond
 *		the applicable malloc region.  This function is only called 
 *		if it has been determined that ptr points into the malloc arena.
 *
 * Returns:	Nothing of any use (function is void).
 *
 * Narrative:
 *
 */

#ifdef _NO_PROTO
void malloc_verify(func,ptr,len)
char *func;
char *ptr;
int len;
#else  /* _NO_PROTO */
void malloc_verify(char *func, char *ptr, int len)
#endif /* _NO_PROTO */
{
  struct mnode *m_ptr;

  /*
   * Find the malloc block that includes this pointer
   */

  m_ptr = malloc_find_addr(ptr, malloc_root);

  /*
   * if ptr was not in a malloc block, it must be part of
   *    some direct sbrk() stuff, so just return.
   */

  if (!m_ptr)
    {
      return;
    }
	
  /*
   * Now we have a valid malloc block that contains the indicated
   * pointer.  We must verify that it is within the requested block
   * size (as opposed to the real block size which is rounded up to
   * allow for correct alignment).
   */

  if ((ptr < m_ptr->m_address) || 
      ((ptr+len) > (m_ptr->m_address + m_ptr->m_size - m_ptr->d_size)))
    {
      malloc_msg(MALLOC_WRITE_ERROR, 4, 
		 "Warning!  Attempted write of %u bytes at 0x%08x extends\n     beyond allocated %u bytes at the same address! Called from: %s\n",
		 len, ptr, m_ptr->m_size, func, NULL);
    }

  return;
}








