/* 
 * (c) Copyright 1989, 1990, 1991, 1992 OPEN SOFTWARE FOUNDATION, INC. 
 * ALL RIGHTS RESERVED 
*/ 
/* 
 * Motif Release 1.2
*/ 
/*   $RCSfile: Malloc.h,v $ $Revision: 1.4.2.3 $ $Date: 1992/03/27 18:33:13 $ */
/*
 * FILE: Malloc.h
 * (Based on Conor Cahill's Malloc Library - see copyright statement)
 */

/*
 * (c) Copyright 1990 Conor P. Cahill (uunet!virtech!cpcahil).  
 * You may copy, distribute, and use this software as long as this
 * copyright statement is not removed.
 */

#ifndef MOTIF1_1

#ifndef _NO_PROTO
#if    !defined(__STDC__) && !defined(__cplusplus) && !defined(c_plusplus) \
    && !defined(FUNCPROTO) && !defined(XTFUNCPROTO) && !defined(XMFUNCPROTO)
#define _NO_PROTO
#endif /* __STDC__ */
#endif /* _NO_PROTO */

#endif /* MOTIF1_1 */

/*
 * Mallopt commands and defaults
 */

#define MALLOC_ALLOC_CHAR 1	    /* Pattern to write when alloc          */
#define MALLOC_FREE_CHAR 2          /* Pattern to write when free           */
#define MALLOC_OUT_FILE	3	    /* Specify malloc output file	    */
#define MALLOC_END_DUMP	4	    /* Whether dump should occur at the end */
#define MALLOC_LOG_INFO 5           /* Log it as it occurs                  */
#define MALLOC_CHECK_STRING 6       /* check strings in string.c, memory.c  */

#define MALLOC_ALLOC_FILL 0x01      /* Default alloc character	            */
#define MALLOC_FREE_FILL 0x03 	    /* Default free character               */
#define MALLOC_CLEAR_FILL 0x00	    /* Clear character */
#define MALLOC_MALLOC 0
#define MALLOC_REALLOC 1
#define MALLOC_FREE 2
#define MALLOC_CALLOC 3

/* Malloc output codes */

#define MALLOC_WRITE_ERROR 0
#define MALLOC_STAT 1
#define MALLOC_INVALID_FREE 2
#define MALLOC_REALLOC_ERROR 3
#define MALLOC_EMPTY_TREE 4
#define MALLOC_INTERNAL_ERROR 5


#define True 1
#define False 0

#ifndef Bool
#define Bool int
#endif

#include <sys/types.h>

/* define size_t, in case it's not there */

#ifdef size_t
#define szt size_t
#else
#define szt unsigned int
#endif

/*
 * Malloc package functions
 */

#ifdef _NO_PROTO

extern void malloc_memset();
extern void MallocExit();
extern void MallocInit();
extern void MallocDump();
extern void MallocEnable();
extern void MallocDisable();
extern void MallocLeakInfo();
extern void malloc_msg();
extern struct mnode *malloc_find_node();
extern struct mnode *malloc_find_addr();
extern struct mnode *malloc_add_node();
extern void malloc_delete_node();
extern void malloc_delete_tree();
extern void malloc_dump_tree();
extern char *malloc_least_value();
extern char *malloc_great_value();
extern void malloc_verify();
/* extern char *XtMalloc();
   extern char *XtRealloc();
   extern char *XtCalloc();
   extern void XtFree();
*/


#else /* PROTOTYPING */

extern void malloc_memset(char *ptr, char fill_char, int len);
extern void MallocExit();		/* No arguments */
extern void MallocInit(); 		/* No arguments */
extern void MallocDump(); 		/* No arguments */
extern void MallocEnable();          	/* No arguments */
extern void MallocDisable();		/* No arguments */
extern void MallocLeakInfo(int *total_memory, int *memory_leaked);
extern void malloc_msg(int msg_type, int numparams, char *msg, int par1, 
		       char *par2, int par3, char *par4, char *par5);
extern struct mnode *malloc_find_node(char *data, struct mnode *m_ptr);
extern struct mnode *malloc_find_addr(char *data, struct mnode *m_ptr);
extern struct mnode *malloc_add_node(char *data_ptr, unsigned int data_size,
			            unsigned int delta_size,
			            struct mnode *m_ptr, struct mnode *parent);
extern void malloc_delete_node(struct mnode *m_node);
extern void malloc_delete_tree(struct mnode *m_node);
extern void malloc_dump_tree(struct mnode *m_node);
extern char *malloc_least_value(struct mnode *m_ptr);
extern char *malloc_great_value(struct mnode *m_ptr);
extern void malloc_verify(char *func, char *ptr, int len);

/* extern char *XtMalloc(unsigned int size);
   extern char *XtRealloc(char *ptr, unsigned int size);
   extern char *XtCalloc(unsigned int numelem, unsigned int elsize);
   extern void XtFree(char *ptr);
*/

#endif

/*
 * variables
 */

extern struct mnode *malloc_root;  /* Pointer to the root */
extern Bool malloc_inited;         /* Whether malloc's been initialized   */
extern int bytes_in_use;           /* Outstanding # of bytes allocated    */
extern int alloc_requests_in_use;  /* Outstanding # of blocks allocated   */
extern unsigned int total_bytes_allocated;/* Total bytes allocated ever */
extern unsigned int total_alloc_requests; /* # of malloc/calloc/rea requests */
extern FILE *malloc_outfp;      /* File pointer to output file         */
extern int malloc_outfd;        /* File descriptor of output file      */
extern char m_alloc_char;   	/* Fill character for allocating       */
extern char m_free_char;  	/* Fill character for freeing          */
extern char m_clear_char;	/* fill with blanks		       */
extern Bool m_end_dump;         /* Whether to call dump when exiting   */
extern Bool m_log_info;        	/* Whether to log information          */
extern Bool m_check_string;    	/* Whether to check string.c, memory.c */
extern Bool malloc_checking;

/*
 * Malloc tree data structure 
 */

struct mnode
{
  char *m_address;		/* address of malloced data 	  */
  struct mnode *parent;		/* back pointer                   */
  unsigned int m_size;		/* size of malloced data    	  */
  unsigned int d_size;		/* delta betw/ requested & actual */
  struct mnode *left_child;     /* left child 		    	  */
  struct mnode *right_child;    /* right child 	 	    	  */


};


