/*
 *  Copyright (c) 1990,1991, OPEN SOFTWARE FOUNDATION, INC.
 *  ALL RIGHTS RESERVED
 */
#ifndef lint
static char *RCSid =
 "$Header: /project/docsrc/src/sml/RCS/sml_util.c,v 1.4 91/04/10 08:42:03 bowe Exp $";
#endif

#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include "sml_def.h"
#include "sml_str.h"
#include "sml_glob.h"
#include "sml_proto.h"

#ifdef ANSI
void	ReadOld(char* file_name) 	/* Read old syntax description file 	*/
				/* and make a list of old macros 	*/
#else
void	ReadOld(file_name) 
char* file_name;
#endif
{
int i;
FILE*	file;
/*
	OldMacroNumb = -1;
*/
	file=NULL;
	if ( strcmp(file_name,"") == 0 ) return;
	while ( file == NULL ) {
		file = fopen(file_name,"r");
		if ( file == NULL ) {
			printf("Can not open file - [%s]\n",file_name);
			printf(
			"Name for translations description file, please ( or 'q' to skip ) - ");
			gets(file_name);
			if ( !strcmp(file_name,"q") ) return;
		}
	}
	if ( Debug ) printf("ReadOld begin !\n");
	if ( file == NULL ) return;
	while ( fgets(Line,L_SIZE,file) != NULL ) {
		strcpy(LineTail,"");
		if ( strlen(Line) > 3 ) 
		strcpy(LineTail,&Line[3]);
		strshF(LineTail);
		if ( ( strncmp(Line,".dn ",4) == 0 ) || 
			(strncmp(Line,".dn\t",4) == 0 ) ) {
			OldMacroNumb++;
			strcpy(Old_macro_desc[OldMacroNumb].old_macro_name,
			LineTail);
			if ( OldMacroNumb == 0 )
			Old_macro_desc[OldMacroNumb].trans_end_in_list = 0;
			else
			Old_macro_desc[OldMacroNumb].trans_end_in_list =
			Old_macro_desc[OldMacroNumb-1].trans_end_in_list ;
		}
		if ( ( strncmp(Line,".dt ",4) == 0 ) || 
			(strncmp(Line,".dt\t",4) == 0 ) ) {
			if ( OldMacroNumb == -1 ) {
				PrintEr(112,"");
				return;
			}
			strcat(Trans_total_list,LineTail);
			i = strlen(Trans_total_list);
			Old_macro_desc[OldMacroNumb].trans_end_in_list = i;
			if ( i > MACRO_TEXT_SIZE - L_SIZE ) { 
				PrintEr(113,"");
				return;
			}
		}
	}
}
yyerror(s) char *s;
{
        fprintf(stderr,"%s\n",s);
        ErKey = 1;
	sprintf(ForDouble,"Error in macros description in %s %s\n\
Line number %d\n\
%s%s\n",MacroName,TypeName,LineNumb,Line,UnderLine(SymbNumb));
		DoublePrint();
/*	exit(1);	/* 	??????????	*/
}
void	SaveMacro()
{
int i;
char record[DESC_RECORD_SIZE];

	for ( i =0; i < MacroNumb; i++ ) {
		if ( strcmp(Macro_desc[i].macro_name,MacroName) == 0 ) {
			sprintf(ForDouble,"Redefinition macro %s\n",MacroName);
			DoublePrint();
		}
	}
	if ( CheckMacro(MacroName) ) {
		yyerror("Syntax error");
		return;
	}
	strcpy(Macro_desc[MacroNumb].macro_name,MacroName);
	strcpy(Macro_desc[MacroNumb].macro_long_name,LongName);
	strcpy(Macro_desc[MacroNumb].arg_list,ArgList);
	Macro_desc[MacroNumb].line = DefLineNumb;

/*	Don't need to save in file !!!
	if ( MacroNumb == 0 ) {
		sprintf(f_name,"%s.mac",DesFileName);
		if ( (MacFile = fopen(f_name,"w")) == NULL ) {
			printf("Can not open output file - %s\n",
				DesFileName);
			GentleExit();
		}
	}
*/

	sprintf(record,"%3i %4s %30s %20s %4i\n",
		MacroNumb,Macro_desc[MacroNumb].macro_name,
		Macro_desc[MacroNumb].macro_long_name,
		Macro_desc[MacroNumb].arg_list,
		Macro_desc[MacroNumb].line);
/*
	fprintf(MacFile,"%s",record);	
*/
	MacroNumb++;
}
void PrintRez()
{
char record1[DESC_RECORD_SIZE];
char* record;
char*	check;
FILE*	w_file;
int i_size;
char	f_name[P_LENGTH+1];
	i_size = DESC_RECORD_SIZE;
	sprintf(ForDouble,"Report\n");
	DoublePrint();
	record = record1;
	sprintf(f_name,"%s.mac",DesFileName);
	w_file = fopen(f_name,"r");
	if ( w_file == NULL ) {
		sprintf(ForDouble,"\nNo macros !!!\n\n");
		DoublePrint();
	}
	else {
		check = fgets(record,i_size,w_file);
		while ( check != NULL ) {
			sprintf(ForDouble,"%s\n",record);
			DoublePrint();
			check = fgets(record,i_size,w_file);
		}
	}
}
/*	Find end of substring in string	*/
#ifdef ANSI
char* strsubenD(char* str1, char* str2)
#else
char* strsubenD(str1, str2)
char* str1;
char* str2;
#endif
{
int i, j, l;
char* adres;
        adres = NULL;
        l = strlen(str2);
        i =0; j =strlen(str1) - l;
        while ( i <= j ) {
                if ( strncmp(str2,&str1[i],l) == 0 ) {
                        adres = &str1[i+strlen(str2)];
                        break;
		}
                i++;
        }
        if ( strlen(str1) == 0 ) adres = NULL;
        return( adres);
}
/*	Find begin of substring in string	*/
#ifdef ANSI
char* strsubbeG(char* str1, char* str2)
#else
char* strsubbeG(str1, str2)
char* str1;
char* str2;
#endif
{
int i, j, l;
char* adres;
        adres = NULL;
        l = strlen(str2);
        i =0; j =strlen(str1) - l;
        while ( i <= j ) {
                if ( strncmp(str2,&str1[i],l) == 0 ) {
                        adres = &str1[i];
                        break;
		}
                i++;
        }
        if ( strlen(str1) == 0 ) adres = NULL;
        return( adres);
}
void SaveList()
{
	strcpy(List_desc[ListNumb].list_name,ListName);
	strcpy(List_desc[ListNumb].list,List);
	ListNumb++;
}
void CheckArg()
{
int i,j,c;	/* number, index, character	*/
int status, er;
	status =0;
	er =0;
	j = 0;
	i = 0;
	while ( er == 0 ) {
		c=Word[i];
		switch(c) {
		case '[' :
			status++;
		break;
		case ']' :
			status--;
			if ( status < 0 ) er=1;
		break;
		case 'c':
		case 'C':
			j++;
			if ( j > MAX_ARG_NUMB ) er = 4;
			Word[i] = '2';
		break;
		case 'd':
		case 'D':
			j++;
			if ( j > MAX_ARG_NUMB ) er = 4;
			Word[i] = '1';
		break;
		case 'a':
		case 'A':
			j++;
			if ( j > MAX_ARG_NUMB ) er = 4;
			Word[i] = '3';
		break;
		case '\0':
			if ( status ) er =2;
			else er = -1;
		break;
		default :
			er =3;
		break;
		}
		i++;
	}
	if ( er == -1 ) strcpy(ArgList,Word);
	else {
		sprintf(ForDouble,"Error #%d in argument description %s\n",er,Word);
		DoublePrint();
		sprintf(ForDouble,"In line #%d %s\n",LineNumb,Line);
		DoublePrint();
		strcpy(ArgList,"");
	}
}
#ifdef ANSI
char* UnderLine( int length ) 
#else
char* UnderLine( length ) 
int length;
#endif
{
int i;
char line[L_SIZE+2];
	strcpy(line,"");
	if ( length > L_SIZE ) length = L_SIZE ;
	for ( i=0; i < length; i++ ) {
		strcat(line,"-");
	}
	strcat(line,"^");
	return(line);
}
void AddRelName()
{
int list_numb;
	list_numb = CheckList( Name );
	if ( list_numb == -1 ) {
		AddRel1(Name);
	}
	else {
		strcpy(List,List_desc[list_numb].list);
		Work_name = strchr(List,' ');
		while( Work_name != NULL ) {
			*Work_name = '\0';
			AddRel1(List);
			strcpy(List,&Work_name[1]);
			Work_name = (char*) strchr(List,' ');
		}
	}
}
#ifdef ANSI
int CheckList( char*  l_name ) /* If list exists return it's number, or -1 */
#else
int CheckList( l_name)
char* l_name;
#endif
{
int i;
int list_numb;
	list_numb = -1;
	for ( i =0; i < ListNumb; i++ ) {
		if ( strcmp(List_desc[i].list_name,l_name) == 0 ) {
			list_numb =i;
			break;
		}
	}
	return( list_numb);
}
#ifdef ANSI
void AddRel1( char* w_name)
#else
void AddRel1( w_name)
char* w_name;
#endif
{
int status;
	status =0;
	if ( *w_name == '-' ) {
		status = -1;
		w_name = &w_name[1];
	}
	if ( *w_name == '+' ) {
		status = 1;
		w_name = &w_name[1];
	}
	if ( *w_name == '=' ) {
		status = 2;
		w_name = &w_name[1];
	}
	if ( ( CheckMacro(MacroName))  || ( CheckMacro(w_name) ) ) {
		yyerror("Syntax error");
		return;
	}
	strcpy(Mac_rel[MacroRelNumb].m_name,MacroName);
	strcpy(Mac_rel[MacroRelNumb].rel_name,w_name);
	Mac_rel[MacroRelNumb].new_status = status;
	MacroRelNumb++;
	if ( MacroRelNumb >= MAX_MACRO_REL_NUMB ) {
		printf("Not enough MAX_MACRO_REL_NUMB (%d)!\n Exiting",
		MAX_MACRO_REL_NUMB);
		exit(1);
	}

/*	Don't need to save in file !!!!!!!!
	if ( MacroRelNumb == 1) {
		sprintf(f_name,"%s.rel",DesFileName);
		RelFile = fopen(f_name,"w");
		if ( RelFile == NULL ) {
			printf("Can not open file %s for output\n",
				f_name);
			GentleExit();
		}
	}
	fprintf(RelFile,"%5s %5s %1d\n",MacroName,w_name,status);
*/
}
void GentleExit()
{
	printf("Exiting ...\n");
	if ( MdFile != NULL ) fclose ( MdFile);
/*
	if ( MacFile != NULL ) fclose ( MacFile);
	if ( RelFile != NULL ) fclose ( RelFile);
*/
	exit(1);
}
#ifdef ANSI
int CheckMacro( char* mac_name)
#else
int CheckMacro( mac_name)
char* mac_name;
#endif
{
int i;
	i = strlen(mac_name) ;
	if ( ( i < 1 ) || ( i > MACRO_NAME_SIZE ) ) {
		sprintf(ForDouble,"Unacceptable size for Macro name ->%s<-\n",
		mac_name);
		DoublePrint();
		return(1);
	}
	else return(0);
}
#ifdef ANSI
int CheckCurMacArg(char* pattern,char* target1)
#else
int CheckCurMacArg(pattern, target1)
char* pattern;
char* target1;
#endif
{
int i;
char c;
char w_type[L_SIZE+1];
char target[L_SIZE+1];
int status, esc;
char word[L_SIZE+1];
	if ( target1 != NULL ) strcpy(target,target1);
	else strcpy(target,"");
	strcpy(w_type,"");
	strcpy(word,"");
	status =0;
	i = 0;
	esc =0;
        c = target[0];
        while ( ( c != '\n' ) && ( c!= '\0' ) ) {
                c = target[i] ;
                switch (status) {
                case 0:         /* out of word  */
			switch ( c ) {
			case ' ':
			case '\t':
			case '\n':
			case '\0':
				if ( c == '\t' ) PrintEr(9,"");
			break;
			case '"':
			        status = 1;     /* in quotas */
				strcpy(word,"");
			break;
			default:
			        status =2;      /* in regular word      */
				strcpy(word,"");
				strcatC(word,c);
			break;
			}
		break;
		case 1:		/* in quotas				*/
			switch(c) {
			case '\\' :
				esc =1;
			break;
			case '"' :
				if ( !esc ) {
					status = 0;
					if ( strisD(word) ) strcatC(w_type,'1');
					else strcatC(w_type,'2');
					esc =0;
				}
			break;
			default:
				esc =0;
				strcatC(word,c);
			break;
			}
		break;
		case 2:		/* in regular word			*/
			switch ( c ) {
			case '\\' :
				esc =1;
			break;
			case ' ' :
			case '\t':
			case '\n':
				if ( esc ) {
					esc =0;
					break;
				}
				if ( c == '\t' ) PrintEr(9,"");
			case '\0':
				status =0;
				if ( strisD(word) ) strcatC(w_type,'1');
				else strcatC(w_type,'2');
			break;
			default:
				if ( esc == 0 ) strcatC(word,c);
				esc =0;
			break;
			}
		break;
		default:
		sprintf(ForDouble,"Internal error: Unexpected status %i for \
string %s while checking arguments\n",
		status,target);
		DoublePrint();
		break;
		}
		i++;
	}
	if ( !strsaT(pattern,w_type) ) {
		if ( strlen(pattern) == 0 ) {
			return(1);
		}
		else {
			strcpy(word,pattern);
			return(2);
		}
	}
	return(0);
}
#ifdef ANSI
int NextStatus(char* m_name ) 
#else
int NextStatus( m_name ) 
char* m_name;
#endif
{
int i;
int n_stat;
	n_stat = -2;
	for ( i = 0; ((i < MacroRelNumb) && ( n_stat == -2)); i++ ) {
		if ( ( strcmp(CurMacName,Mac_rel[i].m_name) == 0 ) &&
			( strcmp(m_name,Mac_rel[i].rel_name) == 0 ))
		n_stat = Mac_rel[i].new_status;
	}
	return(n_stat);
}
void PrStat() /* Print statistic	*/
{
	sprintf(ForDouble,
	"\nInput file - %s, %d lines\n",TextFileName,LineNumb);
	DoublePrint();
	sprintf(ForDouble,
	"Summary:\nErrors - %d\tWarnings - %d\t\n",ErNumb,WarNumb);
	DoublePrint();
	if ( ! ErNumb ) {
		if ( ! WarNumb ) {
			sprintf(ForDouble,"All OK !\n");
		}
		else sprintf(ForDouble,"Only warnings. Check them !\n");
	}
	else {
		Work_int = LineNumb / ErNumb ;
		if ( Work_int >= 1000 ) sprintf(ForDouble,"Not so bad");
		else {
			if ( Work_int > 100 ) sprintf(ForDouble,"Not so good");
			else  sprintf(ForDouble,"That's bad");
		}
		DoublePrint();
		sprintf(ForDouble," for %d lines of source text file.\n\n",
		LineNumb);
	}
	DoublePrint();
}
#ifdef ANSI
char*	SelWord(char* text,int numb)
#else
char*	SelWord(text, numb)
char* text;
int numb;
#endif
{
int i, i1, j;
char	string[L_SIZE+1];
	i1 =0;
	for ( i =0; i < numb; i++ ) {
		j = strspn(&text[i1]," \t") ;
		i1 = i1 + j;
		j = strcspn(&text[i1]," \t");
		i1 = i1+j;
	}
	j = strspn(&text[i1]," \t");
	i1 = i1 + j;
	j = strcspn(&text[i1]," \t");
	if ( j > L_SIZE ) j = L_SIZE;
	strncpy(string,&text[i1],j);
	string[j+1] = '\0';
	return(string);
}
void	Recovery()
{
	SerError++;
	if ( SerError > 3 ) {
		SerError = 0;
		strcpy(CurMacName,Macro_desc[0].macro_name);
		CurMacroNumb= 0;
		sprintf(ForDouble,"Too many errors. Attempt to recovery.\n");
		DoublePrint();
	}
	return;
}
/*************************************************************************/
/*	strsaT: string satisfy - does target in form aaaaaa,
/*		satisfy pattern in form [a[aa]aa[aa]]aa
/*		a - 1, 2 or 3
/*	return: 0 - no, 1 -yes
/*************************************************************************/
#ifdef ANSI
int	strsaT(char* pattern1, char* target1) 
#else
int	strsaT( pattern1, target1) 
char* pattern1;
char* target1;
#endif
{
int rez,l_pat, l_tar, end_p, end_t;
char	pattern[L_SIZE+1];
char	target[L_SIZE+1];
char*	ptr_p;
char*	ptr_t;
int level;
int end_in, i_in;
	strcpy(pattern,pattern1);
	ptr_p = pattern;
	strcpy(target,target1);
	ptr_t = target;
	rez = 1;
	while ( ( strcmp(pattern,"") != NULL ) && ( rez == 1) ) {
/*
printf("StrsaT:pat=%s,tar=%s,rez=%d\n",pattern,target,rez);
*/
		switch ( pattern[0] ) {
		case '3' :
			return(1);
		break;
		case '2' :	/* word		*/
			if ((target[0] != '1') && (target[0] != '2')) rez = 0;
			else {
				ptr_p = &pattern[1];
				ptr_t = &target[1];
			}
		break;
		case '1' :	/* number	*/
			if ( target[0] != '1' ) rez = 0;
			else {
				ptr_p = &pattern[1];
				ptr_t = &target[1];
			}
		break;
		case '[' :
			l_pat = strlen(pattern);
			l_tar = strlen(target);
			end_p = '\0'; end_t = '\0';
			if ( l_pat > 0 ) end_p = pattern[l_pat-1];
			if ( l_tar > 0 ) end_t = target[l_tar-1];
			switch ( end_p ) {
			case ']' :
				if ( strcmp(target,"") == 0 ) rez = 2;
				level =0;
				end_in =0;
				for ( i_in =0; !end_in ; i_in++ ) {
					switch ( pattern[i_in] ) {
						case '[' :
							level++;
						break;
						case ']' :
							level--;
							if ( level == 0 ) {
								strcpy(&pattern[i_in],&pattern[i_in+1]);
								strcpy(pattern,&pattern[1]);
								end_in = 1;
							}
						break;
						case '\0':
							end_in =1;
							printf("Internal error in check of satisfaction: pattern =%s, working pattern =%s\n",
							pattern1,pattern);
						break;
						default :
						break;
					}
				}
/*
				pattern[l_pat -1] = '\0';
				ptr_p = &pattern[1];
*/
			break;
			case '2' :
				if ( ( end_t != '1' ) && ( end_t != '2' ) )
				rez =0;
				else {
					strcuT(pattern);
					strcuT(target);
				}
			break;
			case '1' :
				if ( end_t != '1' ) 
				rez =0;
				else {
					strcuT(pattern);
					strcuT(target);
				}
			break;
			case '3' :
				return(1);
			break;
			default:
				rez =0;
			break;
			}
		break;
		default:
			sprintf(ForDouble,
			"Internal error in argument description \n\
pattern -%s, target -%s\n",
			pattern1,target1);
			DoublePrint();
			return(0);
		break;
		}
		strcpy(pattern,ptr_p);
		strcpy(target,ptr_t);
	}
	if ( strcmp(target,"") != 0 ) rez =0;
	if ( rez == 2 ) rez =1;
	return(rez);
}
#ifdef ANSI
int	strisD(char* word)	/* String is digit			*/
#else
int	strisD( word)	/* String is digit			*/
char*	word;
#endif
{			/* allow sign, point and tabs before and after	*/
int i;
int rez;
int c;
int status, sign, point;

	i = 0;
	rez= 1;
	status =0; sign = 0; point =0;
	while ( ( word[i] !='\0' ) && ( rez ) ) {
		c = word[i];
		i++;
		switch ( status ) {
		case 0 :
			switch ( c ) {
			case '+':
			case '-':
				if ( sign ) rez = 0;
				sign =1;
				status = 1;
			break;
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
				status = 1; /* in number	*/
			break;
			case '.':
				if ( point ) rez = 0;
				point =1;
				status = 1;
			break;
			case ' ':
			case '\t':
			case '\n':
			break;
			default:
				rez =0;
			break;
			}
		break;
		case 1 :
			switch ( c ) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			break;
			case '.':
				if ( point ) rez = 0;
				point =1;
			break;
			case ' ':
			case '\t':
			case '\n':
				status =2;
			break;
			default:
				rez =0;
			break;
			}
		break;
		case 2 :
			switch ( c ) {
			case ' ':
			case '\t':
			case '\n':
			break;
			default:
				rez =0;
			break;
			}
		break;
		default:
			printf("Internal error in strisD - for[%s]\n",word);
			rez =0;
		break;
		}
	}
	return(rez);
}
#ifdef ANSI
char* strcatC(char* string, int c) 
#else
char* strcatC( string, c) 
char* string;
int c;
#endif
{
int l;
	l = strlen(string);
	string[l] = c;
	string[l+1] = '\0';
	return(string);
}
#ifdef ANSI
char* strcuT( char* string)
#else
char* strcuT( string)
char* string;
#endif
{
int i;
	if ( ( i = strlen(string)) > 0 ) 
		string[i-1] = '\0';
	return(string);
}
/*	Compress spaces at the end of the string	*/
#ifdef ANSI
char* strprS( char* string)
#else
char* strprS( string)
char* string;
#endif
{
int i, j, c;
	i = strlen(string);
	if ( !i ) return(string);
	for ( j = i-1; j > 0; j-- ) {
		c = string[j];
		switch( c ) {
		case '\n':
		case '\t':
		case ' ' :
			string[j] = '\0';
		break;
		default:
			j =0;
		break;
		}
	}
	return(string);
}
/*	Compress spaces at the begining of the string	*/
#ifdef ANSI
char* strshF( char* string)
#else
char* strshF( string)
char* string;
#endif
{
int i;
	i = strspn(string," \t\n");
	strcpy(string,&string[i]);
	return(string);
}
void DoublePrint()
{
	printf("%s",ForDouble);
	fprintf(LogFile,"%s",ForDouble);
}

/*	Make name for macro				*/
#ifdef ANSI
void	MakeName(char* name,char* line)
#else
void	MakeName(name,line)
char* name;
char* line;
#endif
{
char temp_line[L_SIZE * 5];
	strcpy(temp_line,line);
	strshF(temp_line);
	strncpy(name,temp_line,MACRO_NAME_SIZE);
	name[MACRO_NAME_SIZE] ='\0';
	strprS(name);
}
/* SelLongWord - select word from the line according to order 	*/
/* order "$n", if n == '$' - return all line			*/
/*	if n == '#' - return word's number ( as string )	*/
/*	in n - number - return word with given number		*/
#ifdef ANSI
char* SelLongWord(char* line,char* order)
#else
char* SelLongWord(line,order)
char* line;
char* order;
#endif
{
static char	select[L_SIZE];
int i;
	if ( order[0] != '$' ) return ( order );
	if ( order[1] == '$' ) return ( line ) ;
	if ( order[1] == '#' ) {
		i = WordNumb(line);
		sprintf(select,"%d",i);
		return(select);
	}
	i = order[1] - '0' ;
	strcpy(select,strworD(line,i));
	return( select);
}
#ifdef ANSI
int WordNumb(char* string) 
#else
int WordNumb(string) 
char* string;
#endif
{
int i, c, end, numb, status;
	numb =0;
	end =0;
	status =0;
	i =0;
	while ( !end ) {
		c = string[i];
		switch ( status ) {
		case 0 :
	/* Out of word	*/
			switch ( c ) {
			case ' ':
			case '\t':
			break;
			case '\0':
				end =1;
			break;
			case '\"':
				status =2;
				numb++;
			break;
			default:
				status =1;
				numb++;
			break;
			}
		break;
		case 1 :
	/* In regular word	*/
			switch ( c ) {
			case ' ':
			case '\t':
				status = 0;
			break;
			case '\"':
				status =2;
			break;
			case '\0':
				end = 1;
			break;
			default:
			break;
			}
		break;
		case 2 :
	/* In double quotas		*/
			switch ( c ) {
			case '\"':
				status=1;
			break;
			case '\0':
				end =1;
			break;
			default:
			break;
			}
		break;
		}
		i++;
	}
	return(numb);
}

/*	Select word from string	*/

#ifdef ANSI
char* strworD(char* string,int numb_asked) 
#else
char* strworD(string,numb_asked) 
char* string;
int	numb_asked;
#endif
{
static char word[L_SIZE];
int i, c, end, numb, status;
	numb =0;
	end =0;
	status =0;
	i =0;
	strcpy(word,"");
	while ( !end ) {
		c = string[i];
		switch( status ) {
		case 0:
	/* Out of word	*/
			switch ( c ) {
			case ' ':
			case '\t':
			break;
			case '\0':
				end =1;
			break;
			case '\"':
				status =2;
				numb++;
			break;
			default:
				status =1;
				numb++;
				if ( numb == numb_asked )
				strcatC(word,c);
			break;
			}
		break;
		case 1:
	/* In regular word	*/
			switch ( c ) {
			case ' ':
			case '\t':
				status = 0;
			break;
			case '\"':
				status =2;
			break;
			case '\0':
				end = 1;
			break;
			default:
				if ( numb == numb_asked )
				strcatC(word,c);
			break;
			}
		break;
		case 2:
	/* In double quotas		*/
			switch ( c ) {
			case '\"':
				status=1;
			break;
			case '\0':
				end =1;
			break;
			default:
				if ( numb == numb_asked )
				strcatC(word,c);
			break;
			}
		break;
		}
		i++;
	}
	return(word);
}
#ifdef ANSI
char*	MakeSynopsis(char* text)
#else
char*	MakeSynopsis(text)
char* text;
#endif
{
char	out[L_SIZE+1];
int i, c;
	strcpy(out,"");
	for ( i =0; i < strlen(text); i++ ) {
		c = text[i];
		switch ( c ) {
		case '[' :
			strcat(out," [");
		break;
		case ']' :
			strcat(out,"] ");
		break;
		case '1' :
			strcat(out," <#>");
		break;
		case '2' :
			strcat(out," <word>");
		break;
		case '3' :
			strcat(out," <anything>");
		break;
		default:
		break;
		}
	}
	return(out);
}
#ifdef ANSI
int TakeTrans(char* translation,int number) 
#else
int TakeTrans(translation,number) 
char* translation;
int number;
#endif
{
int length;
int begin, end;
	strcpy(translation,"");
	if ( number > OldMacroNumb ) {
		PrintEr(112,"");
		return(1);
	}
	end = Old_macro_desc[number].trans_end_in_list;                        
	begin =0;
	if ( number > 0 )
	begin = Old_macro_desc[number-1].trans_end_in_list;
	length = end - begin;
	if ( length > TRANS_SIZE ) {
		PrintEr(111,"");
		return(1);
	}
	else {
		strncpy(translation,&Trans_total_list[begin],length);
		translation[length] = '\0';
	}
	return(0);
}
