/*
 *  Copyright (c) 1990,1991, OPEN SOFTWARE FOUNDATION, INC.
 *  ALL RIGHTS RESERVED
 */
#ifndef lint
static char *RCSid =
 "$Header: /project/docsrc/src/sml/RCS/sml_trans.c,v 1.9 91/11/26 12:07:27 bowe Exp $";
#endif

#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include "sml_def.h"
#include "sml_str.h"
#include "sml_glob.h"
#include "sml_proto.h"

	/*	Globals	*/

int	Status, LastStatus;
int	SymbNumb;
/*
/*int	NewDefin;		/* New definition found	*/
/*char	Msg[L_SIZE+1];
*/
char	Line[L_SIZE+1];
char	TranLine[TRANS_SIZE+1];	/* Line with translations	*/
char	OutLine[L_SIZE+1];
char	LineForParce[L_SIZE+1];	/* Necessary as strtok damage the pattern ! */ 
char	Word[L_SIZE+1];
char	Name[L_SIZE+1];
char	ForDouble[L_SIZE+1];
char	ArgList[(MACRO_NAME_SIZE+1)*MAX_MACRO_NUMB + 1];
char	List[(MACRO_NAME_SIZE+1)*MAX_MACRO_NUMB + L_SIZE + 1];
char	TempList[(MACRO_NAME_SIZE+1)*MAX_MACRO_NUMB + L_SIZE + 1];
char	NewMacros[MAX_MACRO_NUMB] [MACRO_NAME_SIZE+1];
char	NewNonMacros[MAX_MACRO_NUMB] [MACRO_NAME_SIZE+1];
char	VarBuffer[VAR_BUFFER_SIZE+1];
char	LineTail[L_SIZE+1];
char	LongName[L_SIZE+1];
char	TypeName[L_SIZE+1];
char	ListName[L_SIZE+1];
char	MacroName[L_SIZE+1];
char	CurMacName[L_SIZE+1];
int	MacroNumb,DefLineNumb;
int	NewMacrosNumb;
int	NewNonMacrosNumb;
int	OldMacroNumb;	/* Number of macros in old package ( mm - default)*/
int	ErMacNumb;
int	MacroRelNumb, ListNumb;
int	LineNumb;
int	ErNumb, WarNumb;
int	Force;		/* Force option - ovewrite existing file	*/
int	Debug, yydebug;
int	Verbose;
int	ErKey = 0;
char	DesFileName[P_LENGTH+1];
char	NewTextFileName[P_LENGTH+1];
char	TextFileName[P_LENGTH+1];
char	LogFileName[P_LENGTH+1];
char	InfoLogFileName[P_LENGTH+1];
char	SyntFileName[P_LENGTH+1];
FILE*	MdFile;			/* Macro desc. file			*/
/*
/*FILE*	OldMdFile;		/* Old (nonsemantic) macros desc. file	*/
/**/
FILE*	Out_file;		/* Output file				*/
FILE*	LogFile;		/* Log file				*/
FILE*	InfoLogFile;		/* Inf.log file - for print after log	*/
/*
FILE*	MacFile;
FILE*	RelFile;
*/
int	Stack, SerError;
int	CurMacroNumb;
int	W_mac_numb;
int	StackMacro[MAX_STACK];
int	StackLine[MAX_STACK];
char	StackLineText[MAX_STACK][L_SIZE+1];
char	*Work_name;	/* Name for a moment		*/
int	Work_int;	/* Integer for small tasks	*/

/*	Prototypes for trans only ( tempor. )	*/
void	ChangeStatus();
void	strunwraP();
int	block_enD();
int	CheckSingle();
int	LogOper(); 
char*	strplain();
void	EndSession();
char*	BulFun();
char*	strsub1();
char*	substitRef();
char*	substitFun();
int	realInd();
int	realBrk();
/*
void	simbEsc();
*/
char*	FindFont();
void	docLine();	/* To handle all work with document file	*/
void	outputLine();	/* To handle all work with output file		*/
void	strtraN();	/* Translations ( on one line )			*/
char*	strsublisT();	/* The first substring from the list		*/
void	PrepLine();	/* Prepare line while normalizing		*/
void	FontComp();	/* Compress fonts				*/

#define	INIT	0
#define GET	1
#define	UNGET	2
#define	PUT	3
#define	CLOSE	4

/*	Global for trans only ( tempor ? ) 		*/
char QuasiInput[TRANS_SIZE];
int	PutInInfo;	/* Flag - put line in info log?	*/
char	BulFunNames[][L_SIZE+1] = {"#plain","#warning","#add","#sub",
	"#substr","#in","#under","#strchr","#strlen","#tail","#head",
	"#head_out","#tail_out","#isupper","#islower","#set","#get","#unset",
	"#unget","#print",
	""};
char	troff_fonts[][L_SIZE+1] = {
	"\\fB","\\fI","\\fR","\\fP","\\f(CW","\\f\\(CW",
	"\\f1","\\f2","\\f3",
				""};
char	sml_quasi_fonts[][L_SIZE+1] = {
	"\\*L","\\*V","\\*O","\\*O","\\*C","\\*C",
	"\\*O","\\*V","\\*L",
				""};
char	mm_fonts[][L_SIZE+1] = {
	".B",".I",".R",".R",".ft CW",".ft CW",
	".R",".I",".B",
				""};

#ifdef ANSI
main(int argc, char* argv[])
#else
main(argc, argv)
int argc;
char* argv[];
#endif
{
int opt_numb;
char opt_name[L_SIZE+1], opt_value[L_SIZE+1];
int ok;		/* O'KEY	*/
int pid;
char	oldSyntFileName[P_LENGTH+1];
char	oldAccentFileName[P_LENGTH+1];
long	clock;	/* time in seconds	*/
char	char_time[27];	/* time in the form  Thu Jul  5 09:51:01 1990	*/
        clock = 0;
	time( &clock);
        strcpy(char_time,(char*)ctime(&clock));
	sprintf(ForDouble,"\n	sml_trans version 1.1	11.09.90 %s\n",
		&char_time[4]);
	Force=0;
	Debug =0;
	Verbose =0;
	ErMacNumb =0;
	OldMacroNumb = -1;
	strcpy(Trans_total_list,"");
	strcpy(Line,"");

	/* Initialization of files names	*/

	strcpy(LogFileName,"SML.log");
	pid = getpid();
	strcpy(InfoLogFileName,"SML.log");
	sprintf(InfoLogFileName,"/tmp/SML.inf.log%d",pid);
	strcpy(TextFileName,"");
	strcpy(SyntFileName,"sml.desc");
	strcpy(oldSyntFileName,"mm.desc");
	strcpy(oldAccentFileName,"");
	strcpy(NewTextFileName,"");
	strcpy(VarBuffer,"");

	for ( opt_numb =1;  opt_numb < argc; opt_numb++ ) {
		strcpy(opt_name,argv[opt_numb]);
		strcpy(opt_value,"");
		if ( opt_numb < argc -1 ) strcpy(opt_value,argv[opt_numb+1]);
		ok = 0;
		if ( ! strcmp(opt_name,"-synt") ) {
			ok =1;
			strcpy(SyntFileName,opt_value);
			opt_numb++;
		}
		if ( ! strcmp(opt_name,"-old1") ) {
			ok = 1;
			strcpy(oldAccentFileName,opt_value);
			opt_numb++;
		}
		if ( ! strcmp(opt_name,"-accent") ) {
			ok = 1;
			strcpy(oldAccentFileName,opt_value);
			opt_numb++;
		}
		if ( ! strcmp(opt_name,"-old") ) {
			ok = 1;
			strcpy(oldSyntFileName,opt_value);
			opt_numb++;
		}
		if ( ! strcmp(opt_name,"-out") ) {
			ok = 1;
			strcpy(NewTextFileName,opt_value);
			opt_numb++;
		}
		if ( strncmp(opt_name,"-",1) ) {
			ok = 1;
			strcpy(TextFileName,opt_name);
		}
		if ( ! strcmp(opt_name,"-f") ) {
			ok = 1;
			Force = 1;
		}
		if ( ! strcmp(opt_name,"-i") ) {
			ok = 1;
			Force = 0;
		}
		if ( ! strcmp(opt_name,"-d") ) {
			ok = 1;
			Debug = 1;
		}
		if ( ! strcmp(opt_name,"-v") ) {
			ok = 1;
			Verbose = 1;
		}
		if ( ( ! strcmp(opt_name,"-help"))  || ( !ok ) ) {
			if ( ! ok ) printf("Unknown option %s\n",opt_name);
			printf("Usage: sml_synt ['-synt' aaaa]\
 ['-old' bbbb] ['-out' cccc] ['-d'] ['-i'] ['-f'] ['-v'] ['-help'] ffff\n\
where:\n    aaaa - syntax description file name ( default sml.desc )\n\
    bbbb - old (nonsemantic) syntax description file name ( default mm.desc)\n\
    cccc - file name for semantic version of text\n\
    '-d' - debuging option\n\
    '-i' - interactive option, to ask permission to overwrite existing files\n\
    '-f' - force option, not to ask permission to overwrite existing files\n\
    '-v' - verbose option\n\
    '-help'  - help option ( to print this message )\n\
    ffff - text file name\n\
");
			exit(0);
		}
		if ( Debug ) printf("Option name %s, option value %s\n",
				opt_name,opt_value);
		if ( Debug ) printf("Text file - %s\n",TextFileName);
	}
/*
	MacFile = NULL;
	RelFile = NULL;
*/
	LogFile = NULL;
	InfoLogFile = NULL;
	MdFile  = NULL;
/*
	OldMdFile = NULL;
*/
	while ( LogFile == NULL ) {
		LogFile = fopen(LogFileName,"w");
		if ( LogFile == NULL ) {
			printf("Can not open log file - [%s]\n",LogFileName);
			printf(
			"New name for log file, please ( or 'q' to quit ) - ");
			gets(LogFileName);
			if ( !strcmp(LogFileName,"q") ) exit(1);
		}
	}
	fprintf(LogFile,ForDouble);	/*	Print version	*/
	while ( InfoLogFile == NULL ) {
		InfoLogFile = fopen(InfoLogFileName,"w");
		if ( InfoLogFile == NULL ) {
			printf("Can not open Infolog file - [%s]\n",
			InfoLogFileName);
			printf(
			"New name for log file, please ( or 'q' to quit ) - ");
			gets(InfoLogFileName);
			if ( !strcmp(InfoLogFileName,"q") ) exit(1);
		}
	}
	while ( MdFile == NULL ) {
		MdFile = fopen(SyntFileName,"r");
		if ( MdFile == NULL ) {
			printf("Can not open file - [%s]\n",SyntFileName);
			printf(
			"New name for SML syntax description file, please ( or 'q' to quit ) - ");
			gets(SyntFileName);
			if ( !strcmp(SyntFileName,"q") ) exit(1);
		}
	}
	strcpy(DesFileName,SyntFileName);
/*
	while ( OldMdFile == NULL ) {
		OldMdFile = fopen(OldSyntFileName,"r");
		if ( OldMdFile == NULL ) {
			printf("Can not open file - [%s]\n",OldSyntFileName);
			printf(
			"Name for translations description file, please ( or 'q' to skip ) - ");
			gets(OldSyntFileName);
			if ( !strcmp(OldSyntFileName,"q") ) break;
		}
	}
	ReadOld(OldMdFile);
*/
	ReadOld(oldAccentFileName);
	ReadOld(oldSyntFileName);
	MacroNumb =0;
	ListNumb =0;
	MacroRelNumb =0;
	LineNumb =0;
	ErNumb = 0; WarNumb = 0;	/* Errors and warnings	*/
	main1();
}
void Checker()
{
int i, l, end, end1;
char line1[L_SIZE+1];
	
	docLine(INIT,Line);

	outputLine(INIT,OutLine);

	LineNumb = 0;
	Status =0;
	Stack =0;
	strcpy(CurMacName,Macro_desc[0].macro_name);
	CurMacroNumb= 0;
	NewMacrosNumb =0;
	NewNonMacrosNumb =0;
	SerError =0;
	strcpy(OutLine,"");
	sprintf(ForDouble,"Translating file %s.\n",TextFileName);
	DoublePrint();

	/*	Scanning document	*/

	end = 0;
	strcpy(QuasiInput,"");
	while ( !end ) {
		PutInInfo = 0;
		end1=0;
		strcpy(Line,"");
		strcpy(line1,"");
		while ( !end1) { /* merge lines after \\ */
			end1 =1;
			docLine(GET,line1);
			strcat(Line,line1);
			strprS(Line);
			l=strlen(Line);
			if ( l > 2 ) {
				if ( strcmp(&Line[l-2],"\\\\") == 0 ) {
					end1=0;
					Line[l-2] = ' ';
					Line[l-1] = '\0';
					strcpy(line1,"no_fill"); /* !!!!! */
				}
			}
		}
		if ( strcmp(Line,"") == 0 ) {
			end = 1;
			EndSession();
		}
		else {
			i = Line[0];
			if ( ( ( i == '.' ) || ( i == '\'') )
	/* and not in pic file !!! and not .PE		*/
				&& ( ( !CheckStack("PS")) || ( strncmp(Line,".PE",3) == 0 )) ) {
				strprS(Line);
				strcpy(LineTail,"");
				if ( strlen(Line) > 3 ) 
				strcpy(LineTail,&Line[3]);
				strshF(LineTail);
				CheckCurMacro(); /*Output under Check!*/
			}
			else {
				strcat(Line,"\n");
				outputLine(PUT,Line);
			}
		}
	}
}
void CheckCurMacro()
{
int	i;
int	non_mac_numb;		/* nonsemantic macro numb.	*/
int	sem_mac_numb;		/* semantic macro numb.		*/
char	w_mac_name[MACRO_NAME_SIZE+1];
char	sem_mac_name[MACRO_NAME_SIZE+1];
char	long_sem_mac_name[TRANS_SIZE+1]; /* For escapes - \*XX:\*YY ...	*/
char	non_mac_name[MACRO_NAME_SIZE+1];
char*	temp_ptr;
int	end, printed;
/*char	out_line_rez[3*L_SIZE +1];
*/

	/* make non_mac_name	nonsemantic macro name	*/
	
	MakeName(non_mac_name,&Line[1]);

	/*	Search for translations line		*/

	non_mac_numb = -1;	/* Nonsement. macro numb.	*/
	strcpy(TranLine,"");	/* Translations line		*/
	for ( i=0; ( (i <= OldMacroNumb) && ( non_mac_numb == -1) ) ; i++ ) {
		MakeName(w_mac_name,Old_macro_desc[i].old_macro_name);
		if ( strcmp(non_mac_name,w_mac_name) == 0 ) {
			non_mac_numb = i;
			TakeTrans(TranLine,i);
			W_mac_numb = non_mac_numb;
		}
	}
	if ( non_mac_numb == -1 ) {	/* Name not found	*/
		OutUnknown();
		for ( i=0; i < NewNonMacrosNumb; i++ ) {
			if ( strcmp(non_mac_name,NewNonMacros[i]) == 0 )
			return;
		}
		if ( strcmp(non_mac_name,"") != 0 ) PrintEr(5,non_mac_name);
		strcpy(NewNonMacros[NewNonMacrosNumb],non_mac_name);
		NewNonMacrosNumb++;
		return;
	}

/*	if ( ChouseTrans(sem_mac_name,long_sem_mac_name) ) {
*/
	if ( ChouseTrans(long_sem_mac_name) ) {
	/* Error in conditional translations	*/
		return;
	}

	/*	End for conditions		*/

	MakeOutLine(long_sem_mac_name);	/* Make OutLine set of macros	*/
/**************************************** !!!!!	*************************/
/*		no more special meaning for ";"				*/
/*	10.17.90 Yakov							*/
					/* separated by ';' - no more !	*/
/*	strcpy(out_line_rez,OutLine);
/**/
	end = 0;
	while ( !end ) {

/*		ptr = strchr(OutLine,';');
/*		if ( ptr == NULL ) end = 1;
/*		else {
/*			strcpy(out_line_rez,ptr);
/*			strcpy(out_line_rez,&out_line_rez[1]);
/*			*ptr = '\0';
/*		}
/**/
		end = 1; /* !!!! 10.17.90	*/

		if ( OutLine[0] == '.' ) {	/* must change status	*/
						/* and check arguments	*/
						/* in semantic macro	*/

		MakeName(sem_mac_name,&OutLine[1]);
		sem_mac_numb = -1;
		for ( i = 0; ((i < MacroNumb) && ( sem_mac_numb == -1)); i++ ) {
			if (strcmp(sem_mac_name,Macro_desc[i].macro_name) == 0 )
			{
				sem_mac_numb = i;
			}
		}
		if ( sem_mac_numb == -1 ) {
			OutUnknown();
			printed =0;
			for ( i=0; ((i < NewMacrosNumb) && ( !printed)); i++ ) {
				if ( strcmp(sem_mac_name,NewMacros[i]) == 0 )
				printed =1;
			}
			if ( !printed ) {
				PrintEr(10,sem_mac_name);
				strcpy(NewMacros[NewMacrosNumb],sem_mac_name);
				NewMacrosNumb++;
			}
		}
		else	{
			W_mac_numb = sem_mac_numb;
	/*	Check arguments				*/
			temp_ptr = strpbrk(OutLine," \t");
			i = CheckCurMacArg(Macro_desc[sem_mac_numb].arg_list,
				temp_ptr);
	
			if ( i == 1 ) PrintEr(7,"");
			if ( i == 2 ) PrintEr(8,
				Macro_desc[sem_mac_numb].arg_list);
	
	/* Come to new status in translated ( semantic )  document */
	
			i = NextStatus(sem_mac_name);
			ChangeStatus(i,sem_mac_numb);
		}
		}	/* end for == '.'	*/
	/*	Output translated line		*/
		strcat(OutLine,"\n");
		outputLine(PUT,OutLine);
	}
}
#ifdef ANSI
void PrintEr(int reason, char* text) /* Print error messages	*/
#else
void PrintEr(reason,  text) 
int reason;
char* text;
#endif
{
char long_name[2*L_SIZE+1];
char w_long_name[2*L_SIZE+1];
char non_sem_long_name[2*L_SIZE+1];
char w_mac_name[MACRO_NAME_SIZE+1];
char* work_ptr;
int i, er_numb;
	strcpy(w_long_name,"");
	strcpy(non_sem_long_name,"");
	if ( ( reason != 12 ) && ( reason != 5 ) && ( reason != 10) )	{
		MakeName(w_mac_name,Macro_desc[W_mac_numb].macro_name);
		strcpy(w_long_name,Macro_desc[W_mac_numb].macro_long_name);
	}
	else	{
		MakeName(w_mac_name,text);
	}
	if ( reason == 12 ) {
		strcpy(long_name,Old_macro_desc[W_mac_numb].old_macro_name);
		MakeName(w_mac_name,long_name);
		work_ptr = strchr(long_name,'\t');
		if ( work_ptr != NULL ) strcpy(non_sem_long_name,work_ptr);
		strprS(non_sem_long_name);
		strshF(non_sem_long_name);
	}

	/*	Remember the macro name and reason	*/
	/*	to avoid repetition of the messages	*/
	er_numb = -1;
	for ( i=0; ( (i < ErMacNumb) && ( er_numb == -1) ) ; i++ ) {
		if (strcmp(w_mac_name,Er_desc[i].macro_name) == 0 ) 
		er_numb = i;
	}
/*
	if ( reason > MAX_REASONS ) {
		printf("Internal error: Unsufficient value for MAX_REASONS!\n");
		return;
	}
	else {
*/

	if ( er_numb != -1 ) {
		if (( Er_desc[er_numb].reasons[reason]=='1') && (!Verbose) )
		return;	   /* This error, for this macro already printed ! */
		else Er_desc[er_numb].reasons[reason] = '1';
	}
	else {
		strcpy(Er_desc[ErMacNumb].macro_name,w_mac_name);
/*****************	Limit 15 reasons for error !	****************/
		strcpy(Er_desc[ErMacNumb].reasons,"000000000000000");
		Er_desc[ErMacNumb].reasons[reason] = '1';
		ErMacNumb++;
	}
/*
	}
*/

	sprintf(ForDouble,"\nSML%2u: ",reason);
	if ( ForDouble[4] == ' ' ) ForDouble[4] = '0';
	DoublePrint();
	switch ( reason ) {
	case 5:
		sprintf(ForDouble,
		"Warning. Unknown nonsemantic macro %s\n",
		w_mac_name);
	break;
	case 6:
		sprintf(ForDouble,
		"Error. Macro %s [ %s ] used in wrong context\n",
		w_mac_name,w_long_name);
/*		DoublePrint();
		sprintf(ForDouble,"%s\t[line %d]\n",
		Line,LineNumb);
*/
	break;
	case 7:
	case 8:
		sprintf(ForDouble,
		"Error. Arguments will be incorrect in macro %s [%s].\n",
		w_mac_name,w_long_name);
		DoublePrint();
		sprintf(ForDouble,"In line\n%s\n",OutLine);
		DoublePrint();
		sprintf(ForDouble,
		"After translation line number %d\n%s\n",LineNumb,Line);
		if ( reason == 7 ) {
			DoublePrint();
			sprintf(ForDouble,
			"Macro %s cannot have arguments\n",
			w_mac_name);
		}
	break;
	case 9:
		sprintf(ForDouble,
		"Error. Tabs outside of arguments, in macro %s [ %s ] \n",
		w_mac_name,w_long_name);
	break;
	case 10:
		sprintf(ForDouble,"Error.In translation description\n\
%s\nthere is attempt to translate to unknown semantic macro [%s]\n",
		TranLine,text);
	break;
	case 11:
		sprintf(ForDouble,"Error in condition %s \n\
in translations description\n%s",text,TranLine);
	break;
	case 12:
		sprintf(ForDouble,
		"Caution. No semantic translations for macro %s [ %s ]\n",
		w_mac_name,non_sem_long_name);
		if ( strcmp(text,"") == 0 ) {
			DoublePrint();
			sprintf(ForDouble,
"in current context. Translation description is:\n%s",
			TranLine);
		}
	break;
	case 15:
		sprintf(ForDouble,
		"Error in translations description\n%sfor ",
		TranLine);
	break;
	}
	DoublePrint();
	if ( ( reason != 8 ) && ( reason != 7 ) && ( reason != 6 ) ) {
		sprintf(ForDouble,"%s\t[line %d]\n",
		Line,LineNumb);
		DoublePrint();
	}
	if ( reason == 8 ) {
		sprintf(ForDouble,"Synopsis: .%s ",w_mac_name);
		strcat(ForDouble,MakeSynopsis(text));
		strcat(ForDouble,"\n");
		DoublePrint();
	}

	/* not print information about block, where error was found	*/
	/* for reasons, which not depends, on this information		*/

	if ( reason == 6 ) {

	/* print information about block				*/

		strcpy(long_name,Macro_desc[CurMacroNumb].macro_long_name);
		strprS(long_name);
		if ( strcmp(long_name,"") == 0 ){
			sprintf(ForDouble,"%s [line %d] translated to %s\n . . .\n",
			StackLineText[Stack], StackLine[Stack], CurMacName);
		}
		else {
			sprintf(ForDouble,
			"%s [line %d] translated to %s [%s]\n . . .\n",
			StackLineText[Stack], StackLine[Stack], CurMacName,
			long_name);
		}
		if ( strcmp(CurMacName,"++") == 0 )
			sprintf(ForDouble,"Beginning of the document\n. . .\n");
		DoublePrint();
		sprintf(ForDouble,"%s\t[line %d]\n",Line,LineNumb);
		DoublePrint();
	}

	/*	Check the number of errors	*/

	if ( ( reason == 5 ) || ( reason == 12 ) ) WarNumb++;
	if ( ( reason != 5 ) && ( reason != 12 ) ) ErNumb++;
	if ( ErNumb == 50 ) {
		sprintf(ForDouble,"\nToo many errors !\nJust a warning!\n");
		DoublePrint();
/*		EndSession();
*/
	}
	return;
}
/*	Process unknown macro	*/
void	OutUnknown()
{
char w_line[L_SIZE+1];
	strcpy(w_line,".wH ");
	strcat(w_line,Line);
	strcpy(OutLine,w_line);
	strcat(OutLine,"\n");
	outputLine(PUT,OutLine);
/*
	fputs(OutLine,Out_file);
*/
}

/*	Make output line			*/
void	MakeOutLine(name) /* name - not only name, but translation's text */
char*	name;
{
char *ptr, *ptr1;
char name1[TRANS_SIZE+1];
int end, end1, i, i1;
	strcpy(OutLine,"");

	/* Add . if not \* construct	*/
	/* and not in '"'		*/

	if ( name[0] == '\\' ) strcpy(name1,"");
	else strcpy( name1,".");
	if ( name[0] == '\"' ) {
	/*	Delete "			*/
		strcpy(name1,"");
		strprS(name);
		i = strlen(name);
		if ( name[i-1] == '\"' ) 
		name[i-1] = '\0';
		strcpy(name1,&name[1]);
	}
	else strcat(name1,name);
	strcpy(name,name1);

	strcpy(OutLine,name);

/*	Separate QuisiInput, and UNGET it !!!	*/
	strcpy(QuasiInput,"");
	end1 = 0;
	i1 = realBrk(OutLine,";");
	if ( i1 == -1 ) end1 = 1;
	ptr1 = &OutLine[i1+1];
	while ( !end1) {
		ptr =ptr1;
		i = realBrk(ptr,";");
		end =0;
		if ( i == -1 ) {
			end1 = 1;
			end = 1;
		}
		while ( !end ) {
			i = realBrk(ptr,";");
			if ( i != -1 ) {
				ptr = &ptr[i+1];
			} else {
				end = 1;
			}
		}
		strcpy(QuasiInput,ptr);
/*	11.28.90	
/*		(void) substitRef(QuasiInput);
*/
		strcpy(QuasiInput,substitFun(QuasiInput));
		if ( strcmp(QuasiInput,"") != 0 ) {
			docLine(UNGET,QuasiInput);
			strcpy(QuasiInput,"");
		}
		ptr--;
		*ptr = '\0';
	}
/*	Print out information after ">>" into log file		*/
/*	(Maybe this is not needed, as #warning() is enought)	*/
	strcpy(QuasiInput,"");
	ptr = strsubenD(OutLine,">>");
	if ( ptr != NULL ) {
		ptr1 = ptr -2;
		*ptr1 ='\0';
		strcpy(ForDouble,ptr);
		ptr = strsubenD(ForDouble,"<<<");
		if ( ptr != NULL ) {
			ptr1 = ptr - 3;
			*ptr1 = '\0';
			ptr++;
			strcat(QuasiInput,ptr);
		}
		ptr = strsubenD(OutLine,"<<<");
		if ( ptr != NULL ) {
			ptr1 = ptr - 3;
			*ptr1 = '\0';
			ptr++;
			strcat(QuasiInput,ptr);
		}
/*		(void) substitRef(ForDouble);
*/
		strcpy(ForDouble,substitFun(ForDouble));
		DoublePrint();
	}

/*	Separate stuff for QuasiInput on "<<<" (What for ???)	*/
	ptr = strsubenD(OutLine,"<<<");
	if ( ptr != NULL ) {
		ptr1 = ptr - 3;
		*ptr1 = '\0';
		ptr++;
		strcat(QuasiInput,ptr);
	}

/*	Substitute "functions" and "references" in	*/
/*	translated lines				*/
/*	(void) substitRef(OutLine);
*/
	strcpy(OutLine,substitFun(OutLine));
/*	(void) substitRef(QuasiInput);
*/
	strcpy(QuasiInput,substitFun(QuasiInput));
	if ( strcmp(QuasiInput,"") != 0 ) {
		docLine(UNGET,QuasiInput);
		strcpy(QuasiInput,"");
	}
}
/*
int	ChouseTrans(sem_mac_name,long_sem_mac_name)
*/
int	ChouseTrans(long_sem_mac_name)
/*
char* sem_mac_name;
*/
char* long_sem_mac_name;
{
char temp_line[TRANS_SIZE+1];
char actions[TRANS_SIZE+1];
char tail[TRANS_SIZE+1];
char* ptr;
int end, i;

	if ( strcmp(TranLine,"") == 0 ) {
	/* Macro have no semantic translations	*/
		PrintEr(12,Line);
		OutUnknown();
		return(1);
	}
	end =0;
	strcpy(temp_line,TranLine);

	while  ( !end ) {
		strshF(temp_line);
		strprS(temp_line);
		if ( strcmp(temp_line,"") == 0 ) {
		/* No more translations				*/
			PrintEr(12,"");
			OutUnknown();
			return(1);
		}
		ptr = strchr(temp_line,'|');
		if ( ptr == NULL ) strcpy(tail,"");
		else {
			*ptr = '\0';
			strcpy(tail, ++ptr);
		}

		/* Delete the comments			*/
		ptr = strchr(temp_line,'\t');
		if ( ptr != NULL ) *ptr ='\0';

		if ( temp_line[0] != '(' ) {
		/* Unconditional translation	*/
			end = 1;
		}
		else {
		/* Conditional	translation	*/
			i = block_enD(temp_line,')');
			if ( i != 0 ) temp_line[i] ='\0';
			else	{
			/* Error in translation		*/
				PrintEr(15,"");
				OutUnknown();
				return(1);
			}
			strcpy(actions,&temp_line[i+1]);
			end = CheckCond(&temp_line[1]);
			if ( end == 2 ) {
			/* Error in translation		*/
				PrintEr(15,"Line");
				end =0;
			}
			strcpy(temp_line,actions);
		}
		if ( !end ) strcpy(temp_line,tail);
	}

	/*	Make semantic name and number		*/

	strshF(temp_line);
	strprS(temp_line);

/*	/* substitute references to command line	*/
/*	strcpy(temp_line,substitRef(temp_line));
/*	/* substit. functions				*/
/*	strcpy(temp_line,substitFun(temp_line));
/*
/*	MakeName(sem_mac_name,temp_line);
/**/
	strcpy(long_sem_mac_name,temp_line);
	ptr = strchr(long_sem_mac_name,'|');
	if ( ptr != NULL ) *ptr ='\0';

	return(0);
}
int CheckCond(condition)
char* condition;
{
char temp_line[TRANS_SIZE+1];
char oper[TRANS_SIZE+1];
char tail[TRANS_SIZE+1];
int i, ok;
int rezalt, rez1, rez2;
	ok = 0;
	strcpy(temp_line,condition);
	while ( !ok ) {
		strshF(temp_line);
		strprS(temp_line);
		if ( temp_line[0] != '(' ) return( CheckSingle(temp_line) );
		i = block_enD(temp_line,')');
		if ( i == 0 ) {
		/* Error in translation		*/
			PrintEr(15,"");
			OutUnknown();
			return(2);
		}
		temp_line[i] ='\0';
		strcpy(oper,&temp_line[i+1]);
		strshF(oper);
		if ( strcmp(oper,"") != 0 ) ok =1;
		else {
			temp_line[i] ='\0';
			strcpy(temp_line,&temp_line[1]);
		}
	}
	rezalt =0;
	if ( strlen(oper) < 3 ) {
	/* Error in translation		*/
		PrintEr(15,"");
		OutUnknown();
		return(2);
	}
	strcpy(tail,&oper[2]);
	strshF(tail);
	oper[2] = '\0';
	rez1 = CheckCond(&temp_line[1]);
	rez2 = CheckCond(tail);
	rezalt = LogOper(rez1,rez2,oper);
	return(rezalt);
}
int	LogOper(left, right, oper ) 
int left;
int right;
char* oper;
{
	if ( ( left == 2 ) || ( right == 2) ) return(2);
	if ( strcmp(oper,"&&") == 0 ) {
		if ( ( left ) && ( right ) ) return(1);
		else return(0);
	}
	if ( strcmp(oper,"||") == 0 ) {
		if ( ( left ) || ( right ) ) return(1);
		else return(0);
	}
	return(2);
}
int	CheckSingle(condition)
char* condition;
{
char temp_line[TRANS_SIZE+1];
char left[L_SIZE], right[L_SIZE], cond[L_SIZE];
int ok, i, cond_ok;
char *ptr;
	strcpy(temp_line,condition);
	if ( (temp_line[0] != '$' ) && ( temp_line[0] != '#' ) 
		&& ( temp_line[0] != '!' ) ) {
	/* Check the place in the document 		*/
		i =0;	/* Flag for !condition	*/
		if ( temp_line[0] == '!' ) {
			i = 1;
			strcpy(temp_line,&temp_line[1]);
		}
		ok = CheckStack1(temp_line);
		if ( i == 1 ) {
			ok = 1 - ok;
		}
	} 
	else {
	/* Check condition in the form "aaa [cc bbbb]"	*/
	/* where aaa and bbbb - regular words 		*/
	/* and cc - ==, !=, >, <, ...			*/

		strcpy(left,temp_line);
		strcpy(cond,"!=");
		strcpy(right,"");
		i = realBrk(left," \t><=!");
		ptr = NULL;
		if ( i != -1 ) ptr = &left[i];
		if ( ptr != NULL ) {
			strcpy(cond,ptr);
			*ptr = '\0';
			strshF(cond);
			i = strspn(cond,"=!><");
			if ( i == 0 ) {
				PrintEr(11,condition);
				return(2);
			}
			if ( i > 2 ) i = 2;
			strcpy(right,&cond[i]);
			strshF(right);
			strprS(right);
			cond[i] ='\0';
		}
	
	/* substitute references and functions		*/

/*		strcpy(left,substitRef(left));
/*		strcpy(right,substitRef(right));
*/
		strcpy(left,substitFun(left));
		strcpy(right,substitFun(right));

		cond_ok =0;
		ok = 0;
		if ( strcmp(cond,"==") == 0 ) {
			cond_ok =1;
			if ( strcmp(left,right) == 0 ) ok = 1;
		}
		if ( strcmp(cond,"!=") == 0 ) {
			cond_ok =1;
			if ( strcmp(left,right) != 0 ) ok = 1;
		}
		if ( strcmp(cond,">=") == 0 ) {
			cond_ok =1;
			if ( strcmp(left,right) >= 0 ) ok = 1;
		}
		if ( strcmp(cond,"<=") == 0 ) {
			cond_ok =1;
			if ( strcmp(left,right) <= 0 ) ok = 1;
		}
		if ( strcmp(cond,">") == 0 ) {
			cond_ok =1;
			if ( strcmp(left,right) > 0 ) ok = 1;
		}
		if ( strcmp(cond,"<") == 0 ) {
			cond_ok =1;
			if ( strcmp(left,right) < 0 ) ok = 1;
		}
		if ( !cond_ok ) PrintEr(11,condition);
	}
	return( ok );
}
int CheckStack(name)
char* name;
{
int found, i, j;
char temp_name[MACRO_NAME_SIZE+1];
	found =0;
	for ( i=0; i <= Stack; i++ ) {
		j = StackMacro[i];	
		strcpy(temp_name,
		Macro_desc[j].macro_name);
		if ( strcmp(temp_name,name) == 0 )
		found =1;
	}
	return ( found ) ;
}
int CheckStack1(name)
char* name;
{
int found, j;
char temp_name[MACRO_NAME_SIZE+1];
	found =0;
	j = StackMacro[Stack];	
	strcpy(temp_name,
	Macro_desc[j].macro_name);
	if ( strcmp(temp_name,name) == 0 )
	found =1;
	return ( found ) ;
}
void	ChangeStatus(status_change,mac_numb)
int status_change, mac_numb;
{
	if ( status_change != -2 ) SerError = 0;
	switch ( status_change ) {
	case -2	:
		PrintEr(6,"");
		Recovery();
		if ( SerError != 0 ) break;	/* Not atempt to recover */
	case -1 :
			/* pop up */
		if ( Stack > 0 ) Stack--;
		CurMacroNumb = StackMacro[Stack];	
		strcpy(CurMacName,Macro_desc[CurMacroNumb].macro_name);
	break;
	case 0 :
			/* the same	*/
	break;
	case 1:
			/*	push down	*/
		Stack++ ;
		if ( Stack > MAX_STACK ) {
			sprintf(ForDouble,"Stack overflow !!!\n");
			DoublePrint();
			Stack--;
		}
	case 2:
			/*	change to new	*/
		CurMacroNumb = mac_numb;
		StackMacro[Stack] = mac_numb;
		StackLine[Stack] = LineNumb;
		strcpy(StackLineText[Stack],Line);
		strcpy(CurMacName,Macro_desc[CurMacroNumb].macro_name);
	break;
	default:
		sprintf(ForDouble,"Unexpected status [%d]!!!\n",status_change);
		DoublePrint();
	break;
	}
}
void	strunwraP(string,simb)
char* string;
char simb;
{
int i;
char i1;
	if ( *string != simb ) return;
	i = strlen(string);
	if ( i == 0 ) return;
	i1 = *( string +i -1);
	if ( i1 != simb ) return;
	string[i-1] = '\0';
	strcpy(string,&string[1]);
	return;
}
int	block_enD(string,close_s)
char* string;
char close_s;
{
int level, esc, adress;
int i, c, end;
	end =0;
	esc =0;
	level =0;
	adress = 0;
	i = 0;
	while ( ( ( c = string[i]) != '\0' ) && ( !end ) ) {
		if ( esc == 1 ) esc = 0;
		else 	{
			if ( c == '\\' ) esc =1;
			if ( c == string[0] ) level++;
			if ( c == close_s ) {
				level--;
				if ( level <= 0 ) {
					adress = i;
					end =1;
				}
			}
		}
		i++;
	}
	return(adress);
}
char*	strplain(ext_string)
char* ext_string;
{
char string[TRANS_SIZE+1];
int end;
char* ptr;
	strcpy(string,ext_string);
	end = 0;
	while ( !end ) {
		end = 1;
		ptr = strchr(string,'\"');
		if ( ptr != NULL ) {
			end =0;
			*ptr='\0';
			strcat(string,++ptr);
		}
	}
	return(string);
}
void EndSession()
{
/*
	fclose(DocFile);
	fclose(Out_file);
*/
	docLine(CLOSE,Line);
	outputLine(CLOSE,OutLine);

	PrStat();

	sprintf(ForDouble,"\nThe following are how fonts were translated\
 by this conversion:\n\n");
	DoublePrint();

	fclose(LogFile);
	fclose(InfoLogFile);
	sprintf(Line,"cat %s >> %s\n",InfoLogFileName,
	LogFileName);	
	system(Line);
	sprintf(Line,"cat %s\n",InfoLogFileName);
	system(Line);
	sprintf(Line,"rm %s\n",InfoLogFileName);
	system(Line);
	exit(0);
}
char*	BulFun(fun_numb,string)
int fun_numb;
char* string;
{
char	temp_line[TRANS_SIZE+1];
int	i, j;
char*	ptr;
char	w_word[W_SIZE], w_word1[W_SIZE];
char	w_char;
	strcpy(temp_line,"");
	if ( strcmp(BulFunNames[fun_numb],"#set") == 0 ) {
		strcpy(temp_line,string);	/* var. name	*/
		strcpy(w_word,"");			/* var. value	*/
		ptr = strrchr(temp_line,',');
		if ( ptr != NULL ) {
			*ptr ='\0';
			ptr++;
			strcpy(w_word,ptr);
		}
		VarUnset(temp_line);		/*Clean up VarBuffer	*/
		sprintf(w_word1,"#%s:%s\n",temp_line,w_word);
		if ( ( strlen(VarBuffer) + strlen(w_word1) ) > VAR_BUFFER_SIZE ) {
			printf(ForDouble,"Not enough room in VarBuffer-%s",VarBuffer);
		} 
		else {
			strcat(VarBuffer,w_word1);
		}
		strcpy(temp_line,"");
	}
	if ( strcmp(BulFunNames[fun_numb],"#print") == 0 ) {
		printf("#print:%s\n",string);
	}
	if ( strcmp(BulFunNames[fun_numb],"#get") == 0 ) {
		sprintf(w_word,"#%s:",string);
		ptr = strsubenD(VarBuffer,w_word);
		if ( ptr != NULL ) {
			strncpy(temp_line,ptr,TRANS_SIZE);
			ptr = strchr(temp_line,'\n');
			if ( ptr != NULL ) *ptr = '\0';
		}
	}
	/* #unset - delete varible from the buffer of internal variables	*/
	if ( strcmp(BulFunNames[fun_numb],"#unset") == 0 ) {
		VarUnset(string);
	}
	/* #unget - to place string in the Quasi Input		*/
	if ( strcmp(BulFunNames[fun_numb],"#unget") == 0 ) {
		docLine(UNGET,string);
	}
	if ( strcmp(BulFunNames[fun_numb],"#plain") == 0 ) {
		strcpy(temp_line,strplain(string));
	}
	if ( strcmp(BulFunNames[fun_numb],"#warning") == 0 ) {
		PutInInfo = 1;
	}
	if ( strcmp(BulFunNames[fun_numb],"#substr") == 0 ) {
		strcpy(temp_line,strsub1(string));
	}
	if ( strcmp(BulFunNames[fun_numb],"#in") == 0 ) {
		if ( CheckStack1(string) ) strcpy(temp_line,"1");
		else strcpy(temp_line,"");
	}
	if ( strcmp(BulFunNames[fun_numb],"#under") == 0 ) {
		if ( CheckStack(string) ) strcpy(temp_line,"1");
		else strcpy(temp_line,"");
	}
	if ( strcmp(BulFunNames[fun_numb],"#isupper") == 0 ) {
		strcpy(temp_line,string);
		j = 1;
		i = 0;
		while ( ( j == 1 ) && ( temp_line[i] != '\0' ) ) {
			j = isupper(temp_line[i]);
			i++;
		}
		if ( j ) strcpy(temp_line,"1");
		else strcpy(temp_line,"");
	}
	if ( strcmp(BulFunNames[fun_numb],"#islower") == 0 ) {
		j = 1;
		i = 0;
		strcpy(temp_line,string);
		while ( ( j == 1 ) && ( temp_line[i] != '\0' ) ) {
			j = islower(temp_line[i]);
			i++;
		}
		if ( j ) strcpy(temp_line,"1");
	}
	if ( strcmp(BulFunNames[fun_numb],"#strchr") == 0 ) {
		strcpy(temp_line,string);
		if ( strlen(temp_line) > 0 ) {
			w_char = string[strlen(temp_line)-1];
			ptr = strrchr(temp_line,',');
			if ( ptr == NULL ) {
				strcpy(temp_line,"");
			}
			else {
				*ptr = '\0';
				if ( realInd(temp_line, w_char ) != -1 ) {
					strcpy(temp_line,"1");
				}
				else strcpy(temp_line,"");
			}
		}
	}
	if ( strcmp(BulFunNames[fun_numb],"#strlen") == 0 ) {
		sprintf(temp_line,"%s",string);
	}
	if ( strcmp(BulFunNames[fun_numb],"#isdigit") == 0 ) {
		if ( strisD(string) ) strcpy(temp_line,"1");
		else strcpy(temp_line,"");
	}
	if ( strcmp(BulFunNames[fun_numb],"#tail") == 0 ) {
		strcpy(temp_line,string);
		ptr = strrchr(temp_line,',');
		if ( ptr != NULL ) {
			*ptr ='\0';
			ptr++;
			i = atoi(ptr);
			j = strlen(temp_line);
			strcpy(temp_line,&temp_line[j-i]);
		}
	}
	if ( strcmp(BulFunNames[fun_numb],"#tail_out") == 0 ) {
		strcpy(temp_line,string);
		ptr = strrchr(temp_line,',');
		if ( ptr != NULL ) {
			*ptr ='\0';
			ptr++;
			i = atoi(ptr);
			if ( i <= strlen(temp_line) ) 
			temp_line[strlen(temp_line) - i] = '\0';
		}
	}
	if ( strcmp(BulFunNames[fun_numb],"#head") == 0 ) {
		strcpy(temp_line,string);
		ptr = strrchr(temp_line,',');
		if ( ptr != NULL ) {
			*ptr ='\0';
			ptr++;
			i = atoi(ptr);
			if ( i <= strlen(temp_line) )
			temp_line[i] = '\0';
		}
	}
	if ( strcmp(BulFunNames[fun_numb],"#head_out") == 0 ) {
		strcpy(temp_line,string);
		ptr = strrchr(temp_line,',');
		if ( ptr != NULL ) {
			*ptr ='\0';
			ptr++;
			i = atoi(ptr);
			if ( i <= strlen(temp_line) )
			strcpy(temp_line,&temp_line[i]);
		}
	}
	if ( strcmp(BulFunNames[fun_numb],"#add") == 0 ) {
		strcpy(temp_line,string);
		ptr = strrchr(temp_line,',');
		if ( ptr != NULL ) {
			*ptr ='\0';
			ptr++;
			i = atoi(ptr);
			j = atoi(temp_line);
			sprintf(temp_line,"%d",i+j);
		}
	}
	if ( strcmp(BulFunNames[fun_numb],"#sub") == 0 ) {
		strcpy(temp_line,string);
		ptr = strrchr(temp_line,',');
		if ( ptr != NULL ) {
			*ptr ='\0';
			ptr++;
			i = atoi(ptr);
			j = atoi(temp_line);
			sprintf(temp_line,"%d",j - i);
		}
	}
	return(temp_line);
}
/*	Unset variable in VarBuffer						*/
void	VarUnset(name)
char* name;
{
char word[W_SIZE];
char *ptr, *ptr1;
	sprintf(word,"#%s:",name);
	ptr = strsubbeG(VarBuffer,word);
	if ( ptr != NULL ) {
		*ptr='\0';
		ptr++;
		ptr1=strchr(ptr,'\n');
		if ( ptr1 == NULL ) ptr1 = ptr;
		ptr1++;
		strcat(VarBuffer,ptr1);
	}
}
char*	strsub1(string)
char* string;
{
char	temp_line[TRANS_SIZE];
char	rez_line[TRANS_SIZE];
int i, j;
char* ptr;
	strcpy(temp_line,string);
	strcpy(rez_line,"");
	ptr = strrchr(temp_line,',');
	if ( ptr == NULL ) {
		sprintf(ForDouble,"Error in 3-nd argument for bultin function\
#substr\n%s",string);
		DoublePrint(); 
		return(rez_line);
	}
	*ptr = '\0';
	ptr++;
	i = *ptr - '0';
	ptr = strrchr(temp_line,',');	
	if ( ptr == NULL ) {
		sprintf(ForDouble,"Error in 2-nd argument for bultin function\
#substr\n%s",string);
		DoublePrint(); 
		return(rez_line);
	}
	*ptr = '\0';
	ptr++;
	j = *ptr - '0';
	if ( ( i < 0 ) || ( i > 9) || ( j < 0 ) || ( j > 9 ) ){
		sprintf(ForDouble,"Error in arguments for bultin function\
#substr\n%s",string);
		DoublePrint(); 
		return(rez_line);
	}
	temp_line[i+j] = '\0';
	strcpy(rez_line,&temp_line[j]);
	return(rez_line);
}
/*	substitRef - substitute references on the command line	*/
char* substitRef(string)
char* string;
{
char temp_line[L_SIZE+1];
int end, i;
int pass, l;
char*	ptr;
char tail[L_SIZE], head[L_SIZE+1], middle[L_SIZE+1], ref[L_SIZE+1];
	strcpy(temp_line,string);
	end = 0;
	pass = 0;
	ptr = temp_line;
	while ( !end ) {
		if ( ( i = realInd(ptr,'$')) == -1 ) end = 1;
		else {
			strncpy(ref,&ptr[i],2);
			ref[2] = '\0';
			strcpy(tail,&ptr[i+2]);
			ptr[i] = '\0';
			strcpy(head,temp_line);
			strcpy(middle,SelLongWord(LineTail,ref));
			strcat(temp_line,middle);
			l = strlen(temp_line);
			ptr = &temp_line[l];
			strcat(temp_line,tail);
			pass++;
			if ( pass > 10 ) end = 1;
		}
	}
	strcpy(string,temp_line);
	return(string);
}
/************************************************************************/
/*	realBrk - real break: find the first simbol from delim. string	*/
/*	which is not escaped by '(' ')' or '\\'				*/
/************************************************************************/
int	realBrk(string,delim)
char*	string;
char*	delim;
{
int i, j, esc, esc1;
int c;
char simb;
int adr;
	adr = strlen(string) +10;
	for ( i=0; ( (simb = delim[i]) != '\0'); i++ ) {
		esc = 0; esc1=0;
		for ( j=0; ( (c = string[j]) != '\0'); j++ ) {
			if ( c == '\\' ) esc = 1 - esc;
			if ( !esc ) {
				if ( c == '(' ) esc1++;
				if ( c == ')' ) esc1--;
				if ( ( c == simb ) && ( !esc1 ) ) {
					if ( j < adr ) adr = j;
					break;
				}
			}
		}
	}
	if ( adr < strlen(string) ) return(adr);
	else return(-1);
}
/************************************************************************/
/*	realInd - real index: find in string the first simbol == simb	*/
/*	which is not escaped by  '\\'					*/
/************************************************************************/
int	realInd(string,simb)
char*	string;
char	simb;
{
int i, esc;
int c;
	esc = 0;
	for ( i=0; ( (c = string[i]) != '\0'); i++ ) {
		if ( ( c == simb ) && ( !esc ) ) return(i);
		if ( c == '\\' ) esc = 1 -esc;
		if ( c != '\\' ) esc = 0;
	}
	return(-1);
}
/*	Expand all the functions and references to the command	*/
/*  line in the string (complitely changed 11.28.90			*/
char*	substitFun(string)
char* string;
{
int fun_numb, first_fun_numb, first_arg_adr;
int i, l;
char*	ptr;
char*	ptr1;
/*char tail[TRANS_SIZE+1];
int end, i, l;
*/
char temp_line[TRANS_SIZE+1];
char left[TRANS_SIZE+1], right[TRANS_SIZE+1], argum[TRANS_SIZE+1];
	fun_numb = 0;
	/* Find the first function in the string			*/
	first_fun_numb= -1;
	first_arg_adr= -1;
	strcpy(temp_line,string);
	while(strcmp(BulFunNames[fun_numb],"") != 0 ) {
		ptr = strsubenD(temp_line,BulFunNames[fun_numb]);
		if ( ptr != NULL ) {
			if ( *ptr == '(' ) {
				i = block_enD(ptr,')');
				if ( i != 0 ) {
		/* Find a function call	*/
					*ptr='\0';
					l = strlen(temp_line);
					if ( ( first_arg_adr == -1 ) || ( l < first_arg_adr ) ) {
						first_arg_adr = l;
						first_fun_numb = fun_numb;
						strcpy(left,temp_line);
						ptr1 = strsubbeG(left,BulFunNames[fun_numb]);
						if ( ptr1 != NULL ) *ptr1 = '\0';
						strcpy(argum,&ptr[1]);
						argum[i-1] = '\0';
						strcpy(right,&argum[i]);
					}
					strcpy(temp_line,string);
				}
			}
		}
		fun_numb++;
	}	/* end for function search			*/

	/* Check the search rezults				*/
	
	if ( first_fun_numb == -1 ) {
		/* No functions		*/
		strcpy(string,substitRef(string)) ;
	}
	else {
		strcpy(left,substitRef(left));
		strcpy(argum,substitFun(argum));
		strcpy(argum,BulFun(first_fun_numb,argum));
		strcpy(right,substitFun(right));
		sprintf(string,"%s%s%s",left,argum,right);
	}
	return(string);
		
/*	below is old stuff (before 11.28.90)				*/
/*	while(strcmp(BulFunNames[fun_numb],"") != 0 ) {
/*		end =0;
/*		while ( !end ) {
/*			end = 1;
/*			ptr = strsubenD(string,BulFunNames[fun_numb]);
/*			if ( ptr != NULL ) {
/*				if ( *ptr == '(' ) {
/****************************************************************************/
/*				strcpy(tail,ptr);
/*				i = block_enD(tail,')');
/*				if ( i != 0 ) {
/*					end = 0;
/*					ptr1 = 
/*					strsubbeG(string,BulFunNames[fun_numb]);
/*					*ptr1 = '\0';
/*					tail[i] = '\0';
/*					strcpy(tail,tail+1);
/*		/* now: string - begin of line	*/
/*		/*      tail - string to work	*/
/*		/*	tail[i+1] - tail	*/
/*					strcpy(tail,substitFun(tail));
/*					strcpy(temp_line,BulFun(fun_numb,tail));
/*					strcat(string,temp_line);
/*					strcat(string,&tail[i+1]);
/*				}
/*****************************************************************************/
/*				} /* end if ')' after name	*/
/*			}
/*		}
/*		fun_numb++;
/*	}
/*	return(string);
*/
}
/*	Find troff font in line	*/
char*	FindFont(line)
char* line;
{
	return(strsublisT(line,troff_fonts));
}
void docLine(status,line)
int status;
char*	line;
{
static cur_numb;
static char lines[5][TRANS_SIZE+1];
static	FILE*	doc_file;		/* Input text (doc) file	*/
static	char	f_name[P_LENGTH+1];
static	int	ready_to_end;
char	*ptr, *ptr1;
int	no_fill;	/* Flag for no_fill mode			*/
int	i;
	switch ( status ) {
	case INIT:
		ready_to_end = 0;
		doc_file = NULL;
		strcpy(f_name,TextFileName);
		while ( doc_file == NULL ) {	/* Repeate if name uncorrect */
			if ( strcmp(f_name,"") == 0 ) {
				printf("\nText file name ( q to quit ) - ");
				gets(f_name);
				if ( strcmp(f_name,"q") == 0 ) exit(1);
			}	
			if ( strcmp(f_name,"") == 0 ) {
				printf("Directory list :\n");
				system("ls");
			}
			else {
				doc_file = fopen(f_name,"r");
				if ( doc_file == NULL ) {
					printf(
					"There is no file [%s]\n",f_name);
					printf("Directory list :\n");
					system("ls");
					strcpy(f_name,"");
				}
			}
		}
		cur_numb =0;
	break;
	case GET:
		no_fill = 0;
		if ( strcmp(line,"") != 0 ) no_fill = 1;	/* !!!! */
	/* Read line, if necessarly				*/
		if ( cur_numb == 0 ) {
			if ( ready_to_end ) {
                        	strcpy(line,"");
				break;
			} 
			if ( fgets(lines[0],L_SIZE,doc_file) == NULL ) {
/*
                        	strcpy(line,"");
				break;
*/
				ready_to_end = 1;
	/* .-+ macro for the end of file	*/
				strcpy(line,".-+");
				break;
			}
			LineNumb++;
			cur_numb = 1;
		}

	/* Prepare output line - normalization (substit. font changes	*/
	/* in the \f constructions with macros)		 		*/
	/* line - to process, lines[0] - for the next pass, if 		*/
	/* lines[0] == "" - then compess lines				*/

		strcpy(line,lines[0]);

	/* If line with a macro - pass as it is			*/
	/* (or we are in pic file)				*/

		if ( ( line[0] == '.' ) || ( line[0] == '\'' ) ||
				( CheckStack("PS") )  ) {
			strcpy(&lines[0][0],"");
		}
		else {
			ptr = FindFont(line); /* ptr to \ in \f	*/

	/* If no font changes - pass as it is			*/

			if ( ptr == NULL ) {
				strcpy(lines[0],"");
			}
			else {
	/* If under "TS" - table - change "troff fonts" to "sml fonts"	*/
	/* Not only "TS", but all "no_fill" regions !			*/
				if ( CheckStack("TS") ) no_fill = 1;
				if ( CheckStack("oS") ) no_fill = 1;
				if ( CheckStack("iS") ) no_fill = 1;
				if ( CheckStack("dS") ) no_fill = 1;
				if ( no_fill == 1 ) {
					strtraN(line,troff_fonts,sml_quasi_fonts);
					strcpy(lines[0],"");
				} 
				else {
					ptr1 = strsubbeG(line,ptr);
					if ( ptr1 != line ) {	
		/* if something before \f constr. then			*/
		/* pass the begining of the line			*/
						strcpy(lines[0],ptr1);
						*ptr1 = '\0';
		/* If under oS add \c at the end of line		*/
/*						if ( CheckStack("oS") ) 
Always	*/	
						strcat(line,"\\c");
	
						strcat(line,"\n");
					}
					else {
		/* the begining was passed, time to translate !		*/
						PrepLine(line,lines[0]);
					}
				}
			}
		}
	/*	Shift lines	*/
		if ((strcmp(lines[0],"")== 0) 
			|| (strcmp(lines[0],"\n") == 0 ) ) {
			for ( i=0; i < cur_numb; i++ ) {
				strcpy(lines[i],lines[i+1]);
			}
			strcpy(lines[cur_numb],"");
			cur_numb--;
		}
	break;
	case UNGET:
		if ( cur_numb > 3 ) printf("Stack for docLine too big!");
		else {
			for ( i=0; i < cur_numb; i++) {
				strcpy(lines[i+1],lines[i]);
			}
			strcpy(lines[0],line);
			cur_numb++;
		}
	break;
	case CLOSE:
		fclose(doc_file);
	break;
	default:
		printf("Wrong request for docLine - %d\n",status);
	break;
	}
}
/* archive line begins with \f, so make ext_line with macro (or \*C\c)	*/
/* and leave the rest of the line in archive				*/
void PrepLine(ext_line,arch_line)
char *ext_line;
char* arch_line;
{
char* ptr;
char* ptr1, *ptr2;
char	tail[L_SIZE+1];
char	text[L_SIZE+1];
	/* ptr1 - beg. of text, ptr2 - before next font change	*/
	/* lines[0] - from the next macro			*/
	ptr = FindFont(arch_line);	/* Adr. of font (must be not NULL)*/
	if ( ptr == NULL ) {
		printf("Error in PrepLine (can not find font) line is\n%s",arch_line);
		exit(1);
	}
	ptr1 = strsubenD(arch_line,ptr);
	if ( ptr1 == NULL ) {
		printf("Error #2 in PrepLine: font is [%s] line is\n%s",
		ptr1,arch_line);
		exit(1);
	}
	strprS(ptr1);
	ptr2 = FindFont(ptr1);	/* Next font			*/
	if ( ptr2 == NULL ) {
	/* The last font change on the line			*/
	/* reinforce font on the next line ! 			*/
		if ( ( strcmp(ptr1,"") == 0 ) || ( strcmp(ptr1,"\n") == 0 ) ) {
	/* only restore font						*/
			strtraN(arch_line,troff_fonts,mm_fonts);	
	/*		strtraN(arch_line,troff_fonts,sml_quasi_fonts); */
			strcpy(ext_line,arch_line);
			strcpy(arch_line,"");
		}
		else {
			strcpy(text,ptr1);
			*ptr1='\0';

		/* add \c at the end of text		*/
			if ( text[strlen(text)] == '\n' ) 
				text[strlen(text)] = '\0';	/* 01.30.91 */
			strcat(text,"\\c");
	
			sprintf(ext_line,"%s \"%s\"\n",arch_line,text);
			strtraN(ext_line,troff_fonts,mm_fonts);
		}
	}
	else {
		ptr2 = strsubbeG(ptr1,ptr2); /* next font begin	*/
		if ( ptr2 == NULL ) {
			printf("Error #3 in PrepLine: font is [%s] line is\n%s",
			ptr2,tail);
			exit(1);
		}
		strcpy(tail,ptr2);
		*ptr2='\0';
		strcpy(text,ptr1);
		*ptr1='\0';
	/* If under oS !!! add \c at the end of text		*/
/*		if ( CheckStack("oS") ) 
always !!!	*/
			strcat(text,"\\c");
		strtraN(arch_line,troff_fonts,mm_fonts);
		sprintf(ext_line,"%s \"%s\"\n",arch_line,text);
		strcpy(arch_line,tail);
	}
}
void outputLine(status,line)
int status;
char*	line;
{
#define OUT_BUF_SIZE	3
static cur_numb;
static char lines[OUT_BUF_SIZE][TRANS_SIZE+1];
static int pr_flag[OUT_BUF_SIZE];
static	char	out_f_name[P_LENGTH+1];
char	*ptr, *ptr1;
char	w_line[TRANS_SIZE+1];
char answer[L_SIZE];
int	i, press;
	switch ( status ) {
	case INIT:
	Out_file = NULL;
	strcpy(out_f_name,NewTextFileName);
	while ( Out_file == NULL ) {	/* Repeate if name uncorrect	*/
		if ( strcmp(out_f_name,"") == 0 ) {
			printf("\nOutput file name ( q to quit ) - ");
			gets(out_f_name);
			if ( strcmp(out_f_name,"q") == 0 ) exit(1);
		}	
		if ( strcmp(out_f_name,"") == 0 ) {
			printf("Directory list :\n");
			system("ls");
		}
		else {
			Out_file = fopen(out_f_name,"r");
			if ( Out_file == NULL ) {
				Out_file = fopen(out_f_name,"w");
				if ( Out_file == NULL ) {
					printf("Can not open for write %s\n",
					out_f_name);
				}
			}
			else {
				if ( !Force ) {	/* Force option	*/
					printf(
					"\nFile [%s] exist. Overwrite [y/n] ? ",
					out_f_name);
					gets(answer);
				}
				else {
					strcpy(answer,"y");
				}
				Out_file = NULL;
				if ( (answer[0] == 'y' ) || 
				     (answer[0] == 'Y' ) ) {
					Out_file = fopen(out_f_name,"w");
					if ( Out_file == NULL ) {
						printf(
						"Can not open for write %s\n",
						out_f_name);
					}
				}
			}
			if ( Out_file == NULL ) {
				printf(
				"New name for output file, please -");
				gets(out_f_name);
				if (strcmp(out_f_name,"q") == 0 ) 
				exit(1);
			}
		}
		cur_numb =0;
		for ( i=0; i < OUT_BUF_SIZE; i++) {
			strcpy(&lines[i][0],"");
			pr_flag[i] =0;
		}
	}
	break;
	case PUT:
		if ( cur_numb < 2 ) {
		/* Preprocess line and save in lines		*/
			FontComp(line);

		/* Ignore all after \c, if not in macro		*/
			ptr = strsubenD(line,"\\c");
			if ( ( ptr != NULL ) && ( line[0] != '.' ) ) {
				*ptr = '\0';
				strcat(line,"\n");
			}
			strcpy(lines[cur_numb],line);
			if ( PutInInfo ) pr_flag[cur_numb] = LineNumb;
			else pr_flag[cur_numb] = 0;
			cur_numb++;
		}
		press = 0; /*	Can compress lines ?		*/
		if ( cur_numb == 2 ) {
		/* time to output 				*/
			if ( (strlen(lines[0]) + strlen(lines[1])) < L_SIZE ) {
			/* 1: xxx\c\\n + yyyy\n = xxxyyyy\n	*/
			ptr = strsubenD(lines[cur_numb-2],"\\c\n");
			if ( ptr != NULL ) {
				if ( ( *ptr == '\0' ) && 
					(lines[cur_numb-1][0] != '.' ) &&
					(lines[cur_numb-1][0] != '\'' ) &&
					(lines[cur_numb-1][0] != '#' ) ) {
					ptr = ptr -3;
					*ptr = '\0';
					press = 1;
				}
			}
			else {
			/* 2: xxxxx + \*y = xxxxx\*y	*/
				if ( (strlen(lines[cur_numb-1]) == 4) &&
				( strncmp(lines[cur_numb-1],"\\*",2)==0) &&
				( lines[cur_numb-2][0] != '.' )  ) {
					strprS(lines[cur_numb-2]);
					press = 1;
				}
			}
			/* 3: xxxx\\n + yyyyy = xxxxyyyyy	*/
			if ( press == 0 ) {
				ptr = strsubenD(lines[cur_numb-2],"\\\n");
				if ( ptr != NULL ) {
					if ( *ptr == '\0' ) {
						ptr = ptr -2;
						*ptr = '\0';
						press = 1;
					}
				}
			}
			/* 4: xxxx\*O\\n + \*Oyyyyy = xxxx\*Oyyyyy	*/
			if ( press == 0 ) {
				ptr = strsubenD(lines[cur_numb-2],"\\*O\n");
				if ( ptr != NULL ) {
					if ( *ptr == '\0' ) {
						if ( strncmp(lines[cur_numb-1],
						"\\*O",3) == 0 ) {
							ptr = ptr -4;
							*ptr = '\0';
							press = 1;
						}
					}
				}
			}
			/* 5: xxx\*Oyyy + \*O = xxx\*Oyyy		*/
			if ( press == 0 ) {
				strcpy(w_line,lines[cur_numb-1]);
				strprS(w_line);
				if ( strcmp(w_line,"\\*O") == 0 ) {
					ptr = strsubenD(lines[cur_numb-2],"\\*O");
					if ( ptr != NULL ) {
						while ( ptr != NULL ) { /* the last \*O in line */
							ptr1 = ptr;
							ptr = strsubenD(ptr1,"\\*O");
						}
						ptr=strsublisT(ptr1,sml_quasi_fonts); /*Are there any*/
		/* other font after \*O	?		*/
						if ( ptr == NULL ) {
							press = 1;
							strcpy(lines[cur_numb-1],"");
						}
					}
				}
			}	/* end 5	*/

			}	/* end by L_SIZE			*/
		}
		if ( press ) {
			strcat(lines[cur_numb-2],lines[cur_numb-1]);
			strcpy(lines[cur_numb-1],"");
			if ( pr_flag[cur_numb-2] == 0 ) 
			pr_flag[cur_numb-2] = pr_flag[cur_numb-1];
			pr_flag[cur_numb-1] = 0;
			cur_numb--;
		}
		press = 0;
		if ( cur_numb == 2 ) {

		/* translate fonts in macro arguments	*/
			if ( lines[0][0] == '.' )
			strtraN(lines[0],troff_fonts,sml_quasi_fonts);

		/* in line fonts compression		*/
/*
			strtraN(lines[0],Tran_left,Tran_right);
*/
			FontComp(lines[0]);

/*	Add \n at the end					*/
/*			l = strlen(lines[0]);
/*			if ( lines[0][l-1] != '\n' ) {
/*					strcat(lines[0],"\n");
/*			}
*/
			fputs(lines[0],Out_file);
			if ( pr_flag[0] != 0 ) {
				sprintf(w_line,
				"[%d]	%s",pr_flag[0],lines[0]);
				fputs(w_line,InfoLogFile);
			}
			for ( i=0; i < cur_numb; i++ ) {
				strcpy(lines[i],lines[i+1]);
				pr_flag[i] = pr_flag[i+1];
			}
			cur_numb--;
			strcpy(lines[cur_numb],"");
			pr_flag[cur_numb] = 0;
		}
	break;
	case CLOSE:
		for ( i=0; i < cur_numb; i++ ) {
			FontComp(lines[0]);
			if ( ( i < cur_numb -1 ) || 
				( strcmp(lines[i],"\\c\n")) ) {	/* 01.30.91 */
				fputs(lines[i],Out_file);
				if ( pr_flag[i] != 0 ) {
					sprintf(w_line,
					"[%d]	%s",pr_flag[i],lines[i]);
					fputs(w_line,InfoLogFile);
				}
			}
		}
		fclose(Out_file);
	break;
	}
}
void	strtraN(text,left,right)
char*  text;
char	left[][L_SIZE+1];
char	right[][L_SIZE+1];
{
char bufer[1000];
char tail[1000];
char	*ptr, *ptr1;
int	i, end;
	i = 0;
	for ( i=0; strcmp(left[i],"") != 0; i++) {
		end = 0;
		while ( !end ) {
			if ( ( ptr = strsubenD(text,left[i]) ) == NULL ){
				end = 1;
			}
			else {
				ptr1 = strsubbeG(text,left[i]);
				if ( ptr1 == NULL ) {
					printf("Error in strtraN for\n%s",
					text);
					exit(1);
				}
				strcpy(tail, ptr);
				*ptr1 = '\0';
				sprintf(bufer,"%s%s%s",
				text,right[i],tail);
				strcpy(text,bufer);
				if ( strsubbeG(right[i],left[i]) != NULL ) {
					printf(
"Error in prog. in transl.table:\
\nleft  [%s]\nright [%s]\nFixe it !",left[i],right[i]);
					end = 1;
				}
			}
		}
	}
}
/*	Find the nearist substring from the list, return adres from the list!*/
char*	strsublisT(text,list)
char*  text;
char	list[][L_SIZE+1];
{
char	*ptr, *ptr1;
int	i;
char	*best_ptr;
char	*best_item;
	i = 0;
	best_ptr = NULL;
	best_item = NULL;
	for ( i=0; strcmp(list[i],"") != 0; i++) {
		ptr = strsubbeG(text,list[i]);
		if ( ptr != NULL ) {
			if ( best_ptr == NULL ) {
				best_item = list[i];
				best_ptr = ptr;
			}
			else {
				ptr1= strsubbeG(best_ptr,list[i]);
				if ( ptr1 != ptr ) {
					best_item = list[i];
					best_ptr = ptr;
				}
			}
		}
	}
	return(best_item);
}
/* Fonts compression ( if in line 2 seq. fonts is the same, then delete */
/* the second, if text bitween them == "", then delete first )		*/
void	FontComp(line)
char* line;
{
char *buffer_ptr;
char *buf_ptr1_beg, *buf_ptr1_end;
char *buf_ptr2_beg, *buf_ptr2_end;
char *font_ptr1, *font_ptr2;
char	buffer[L_SIZE+1];
int	end;
	strcpy(buffer,line);
	buffer_ptr = buffer;
	end = 0;
	while ( !end ) {
		font_ptr1 = strsublisT(buffer_ptr,sml_quasi_fonts);
		if ( font_ptr1 == NULL ) end = 1;
		else {
			buf_ptr1_beg = strsubbeG(buffer_ptr,font_ptr1);
			buf_ptr1_end = strsubenD(buffer_ptr,font_ptr1);
			if ( ( buf_ptr1_end == NULL ) || 
				( buf_ptr1_beg == NULL ) ) {
/************ ERROR in program **************************************/
				printf("ERROR:FontComp: line/n%s\nfont\n%s\n",
				buffer_ptr,font_ptr1);
				exit(1);
			}
			font_ptr2 = strsublisT(buf_ptr1_end,sml_quasi_fonts);
			if ( font_ptr2 == NULL ) end = 1;
			else {
				buf_ptr2_beg= strsubbeG(buf_ptr1_end,font_ptr2);
				buf_ptr2_end= strsubenD(buf_ptr1_end,font_ptr2);
				if ( ( buf_ptr2_end == NULL ) || 
				( buf_ptr2_beg == NULL ) ) 
				{
/************ ERROR in program **************************************/
				printf("ERROR:FontComp: line/n%s\nfont\n%s\n",
				buf_ptr1_end,font_ptr2);
				exit(1);
				}
	/* find 2 fonts							*/
				if ( buf_ptr1_end == buf_ptr2_beg ) {
	/* There is no text between fonts -> delete the first		*/
					*buf_ptr1_beg = '\0';
					strcat(buffer,buf_ptr2_beg);
				}
				else {
					if ( strcmp(font_ptr1,font_ptr2) == 0) {
	/* The same font -> delete the second				*/
						*buf_ptr2_beg='\0';
						strcat(buffer,buf_ptr2_end);
					}
					else {
	/* New font - shift buffer_ptr					*/
						buffer_ptr = buf_ptr2_beg;
					}
				}
			}
		}
	}
	strcpy(line,buffer);
}
