/*
 *  Copyright (c) 1990,1991, OPEN SOFTWARE FOUNDATION, INC.
 *  ALL RIGHTS RESERVED
 */
#ifndef lint
static char *RCSid =
 "$Header: /project/docsrc/src/sml/RCS/sml_check.c,v 1.3 91/11/26 12:07:17 bowe Exp $";
#endif

#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include "sml_def.h"
#include "sml_str.h"
#include "sml_proto.h"

	/*	Globals	*/

int	Status, LastStatus;
int	SymbNumb;
int	NewDefin;		/* New definition found	*/
char	Line[L_SIZE+1];
char    TranLine[TRANS_SIZE+1]; /* Line with translations       */
char	LineForParce[L_SIZE+1];	/* Necessary as strtok damage the pattern ! */ 
char	Word[L_SIZE+1];
char	Name[L_SIZE+1];
char	Msg[L_SIZE+1];
char	ForDouble[L_SIZE+1];
char	ArgList[(MACRO_NAME_SIZE+1)*MAX_MACRO_NUMB + 1];
char	List[(MACRO_NAME_SIZE+1)*MAX_MACRO_NUMB + L_SIZE + 1];
char	TempList[(MACRO_NAME_SIZE+1)*MAX_MACRO_NUMB + L_SIZE + 1];
char	NewMacros[MAX_MACRO_NUMB] [MACRO_NAME_SIZE+1];
char	NewNonMacros[MAX_MACRO_NUMB] [MACRO_NAME_SIZE+1];
char	LineTail[L_SIZE+1];
char	LongName[L_SIZE+1];
char	TypeName[L_SIZE+1];
char	ListName[L_SIZE+1];
char	MacroName[L_SIZE+1];
char	CurMacName[L_SIZE+1];
int	MacroNumb,DefLineNumb;
int	NewMacrosNumb;
int	NewNonMacrosNumb;
int	OldMacroNumb;	/* Number of macros in old package ( mm - default)*/
int	ErMacNumb;
int	MacroRelNumb, ListNumb;
int	LineNumb;
int	ErNumb, WarNumb;
int	Debug, yydebug;
int	Verbose;
int	ErKey = 0;
char	DesFileName[P_LENGTH+1];
char	TextFileName[P_LENGTH+1];
char	LogFileName[P_LENGTH+1];
char	SyntFileName[P_LENGTH+1];
FILE*	MdFile;
/*
FILE*	MacFile;
FILE*	RelFile;
*/
FILE*	LogFile;
int	Stack, SerError;
int	CurMacroNumb;
int	W_mac_numb;
int	StackMacro[MAX_STACK];
int	StackLine[MAX_STACK];
char	StackLineText[MAX_STACK][L_SIZE+1];
char	*Work_name;	/* Name for a moment		*/
int	Work_int;	/* Integer for small tasks	*/

#ifdef ANSI
main(int argc, char* argv[])
#else
main(argc, argv)
int argc;
char* argv[];
#endif
{
int opt_numb;
char opt_name[L_SIZE+1], opt_value[L_SIZE+1];
int ok;		/* O'KEY	*/
char    oldAccentFileName[P_LENGTH+1];
char	oldSyntFileName[P_LENGTH+1];
	Debug =0;
	Verbose =0;
	ErMacNumb =0;
	OldMacroNumb = -1;
	strcpy(Line,"");

	/* Initialization of files names	*/

	strcpy(LogFileName,"SML.log");
	strcpy(TextFileName,"");
	strcpy(SyntFileName,"sml.desc");
	strcpy(oldSyntFileName,"mm.desc");

	for ( opt_numb =1;  opt_numb < argc; opt_numb++ ) {
		strcpy(opt_name,argv[opt_numb]);
		strcpy(opt_value,"");
		if ( opt_numb < argc -1 ) strcpy(opt_value,argv[opt_numb+1]);
		ok = 0;
		if ( ! strcmp(opt_name,"-synt") ) {
			ok =1;
			strcpy(SyntFileName,opt_value);
			opt_numb++;
		}
        if ( ! strcmp(opt_name,"-old1") ) {
            ok = 1;
            strcpy(oldAccentFileName,opt_value);
            opt_numb++;
        }
        if ( ! strcmp(opt_name,"-accent") ) {
            ok = 1;
            strcpy(oldAccentFileName,opt_value);
            opt_numb++;
        }
		if ( ! strcmp(opt_name,"-old") ) {
			ok = 1;
			strcpy(oldSyntFileName,opt_value);
			opt_numb++;
		}
		if ( strncmp(opt_name,"-",1) ) {
			ok = 1;
			strcpy(TextFileName,opt_name);
		}
		if ( ! strcmp(opt_name,"-d") ) {
			ok = 1;
			Debug = 1;
		}
		if ( ! strcmp(opt_name,"-v") ) {
			ok = 1;
			Verbose = 1;
		}
		if ( ( ! strcmp(opt_name,"-help"))  || ( !ok ) ) {
			if ( ! ok ) printf("Unknown option %s\n",opt_name);
			printf("Usage: sml_synt ['-synt' aaaa]\
 ['-old' bbbb] ['-d'] ['-v'] ['-help'] ffff\n\
where:\n    aaaa - syntax description file name ( default sml.desc )\n\
    bbbb - old (nonsemantic) syntax description file name ( default mm.desc)\n\
    '-d' - debuging option\n\
    '-v' - verbose option\n\
    '-help'  - help option ( to print this message )\n\
    ffff - text file name\n\
");
			exit(0);
		}
		if ( Debug ) printf("Option name %s, option value %s\n",
				opt_name,opt_value);
		if ( Debug ) printf("Text file - %s\n",TextFileName);
	}
/*
	MacFile = NULL;
	RelFile = NULL;
*/
	LogFile = NULL;
	MdFile  = NULL;
	while ( LogFile == NULL ) {
		LogFile = fopen(LogFileName,"w");
		if ( LogFile == NULL ) {
			printf("Can not open log file - [%s]\n",LogFileName);
			printf(
			"New name for log file, please ( or 'q' to quit ) - ");
			gets(LogFileName);
			if ( !strcmp(LogFileName,"q") ) exit(1);
		}
	}
	while ( MdFile == NULL ) {
		MdFile = fopen(SyntFileName,"r");
		if ( MdFile == NULL ) {
			printf("Can not open file - [%s]\n",SyntFileName);
			printf(
			"New name for SML syntax description file, please ( or 'q' to quit ) - ");
			gets(SyntFileName);
			if ( !strcmp(SyntFileName,"q") ) exit(1);
		}
	}
	strcpy(DesFileName,SyntFileName);
/*
	while ( OldMdFile == NULL ) {
		OldMdFile = fopen(OldSyntFileName,"r");
		if ( OldMdFile == NULL ) {
			printf("Can not open file - [%s]\n",OldSyntFileName);
			printf(
			"Name for translations description file, please ( or 'q' to skip ) - ");
			gets(OldSyntFileName);
			if ( !strcmp(OldSyntFileName,"q") ) break;
		}
	}
	ReadOld(OldMdFile);
*/
	ReadOld(oldAccentFileName);
	ReadOld(oldSyntFileName);
	MacroNumb =0;
	ListNumb =0;
	MacroRelNumb =0;
	LineNumb =0;
	ErNumb = 0; WarNumb = 0;	/* Errors and warnings	*/
	main1();
}
void Checker()
{
int end;
FILE*	doc_file;
char f_name[P_LENGTH+1];
	
	doc_file = NULL;
	strcpy(f_name,TextFileName);
	while ( doc_file == NULL ) {	/* Repeate if name uncorrect	*/
		if ( strcmp(f_name,"") == 0 ) {
			printf("\nText file name ( q to quit ) - ");
			gets(f_name);
			if ( strcmp(f_name,"q") == 0 ) return;
		}	
		if ( strcmp(f_name,"") == 0 ) {
			printf("Directory list :\n");
			system("ls");
		}
		else {
			doc_file = fopen(f_name,"r");
			if ( doc_file == NULL ) {
				printf("There is no file [%s]\n",f_name);
				printf("Directory list :\n");
				system("ls");
				strcpy(f_name,"");
			}
		}
	}
	
	LineNumb = 0;
	Status =0;
	Stack =0;
	strcpy(CurMacName,Macro_desc[0].macro_name);
	CurMacroNumb= 0;
	NewMacrosNumb =0;
	NewNonMacrosNumb =0;
	SerError =0;

	/*	Scanning document	*/

	end = 0;
	while ( !end ) {
		if ( fgets(Line,L_SIZE,doc_file) == NULL ) {
			fclose(doc_file);
			PrStat();
			return;
		}
		else {
			LineNumb++;
			if ( Line[0]  == '.' ) {
				strcpy(LineTail,"");
				if ( strlen(Line) > 3 ) 
				strcpy(LineTail,&Line[3]);
				strshF(LineTail);
				CheckCurSemMacro();
			}
		}
	}
}
void CheckCurSemMacro()
{
int	i;
char	w_mac_name[MACRO_NAME_SIZE+1];

	/* make macro name	*/
	
	MakeName(w_mac_name,&Line[1]);

        W_mac_numb = -1;
        for ( i = 0; ((i < MacroNumb) && ( W_mac_numb == -1)); i++ ) {
                if ( strcmp(w_mac_name,Macro_desc[i].macro_name) == 0 ) {
                        W_mac_numb = i;
                }
        }
        if ( W_mac_numb == -1 ) {
                for ( i=0; i < NewMacrosNumb; i++ ) {
                        if ( strcmp(w_mac_name,NewMacros[i]) == 0 )
                        return;
                }
                PrintEr(2,w_mac_name);
                strcpy(NewMacros[NewMacrosNumb],w_mac_name);
                NewMacrosNumb++;
                return;
        }
        strcat(Line,"    ");
        i = CheckCurMacArg(Macro_desc[W_mac_numb].arg_list,&Line[3]);
	if ( i == 1 ) PrintEr(3,"");
	if ( i == 2 ) PrintEr(4,Macro_desc[W_mac_numb].arg_list);
        strcuT(Line);
        strcuT(Line);
        strcuT(Line);
        strcuT(Line);
        i = NextStatus(w_mac_name);
        if ( i != -2 ) SerError = 0;
        switch ( i ) {
        case -2 :
                PrintEr(1,"");
                Recovery();
        break;
        case -1 :
                        /* pop up */
                if ( Stack > 0 ) Stack--;
                CurMacroNumb = StackMacro[Stack];
                strcpy(CurMacName,Macro_desc[CurMacroNumb].macro_name);
        break;
        case 0 :
                        /* the same     */
        break;
        case 1:
                        /*      push down       */
                Stack++ ;
                if ( Stack > MAX_STACK ) {
                        sprintf(ForDouble,"Stack overflow !!!\n");
                        DoublePrint();
                        Stack--;
                }
        case 2:
                        /*      change to new   */
                CurMacroNumb = W_mac_numb;
                StackMacro[Stack] = W_mac_numb;
                StackLine[Stack] = LineNumb;
                strcpy(StackLineText[Stack],Line);
                strcpy(CurMacName,Macro_desc[CurMacroNumb].macro_name);
        break;
        default:
                sprintf(ForDouble,"Unexpected status !!!\n");
                DoublePrint();
        break;
        }
        return;
}
#ifdef ANSI
void PrintEr(int reason, char* text) /* Print error messages	*/
#else
void PrintEr(reason, text)
int reason;
char* text;
#endif
{
char long_name[2*L_SIZE+1];
char w_long_name[2*L_SIZE+1];
char w_mac_name[MACRO_NAME_SIZE+1];
char old_name[MACRO_NAME_SIZE+1];
int i, er_numb;
	if ( reason > MAX_REASONS ) {
		printf("Internal error: Unsufficient value for MAX_REASONS!\n");
		return;
	}
	if ( reason != 2 ) {
		MakeName(w_mac_name,Macro_desc[W_mac_numb].macro_name);
		strcpy(w_long_name,Macro_desc[W_mac_numb].macro_long_name);
	}
	else	{
		MakeName(w_mac_name,text);
	}

	/*	Remember the macro name and reason	*/
	/*	to avoid repetition of the messages	*/
	er_numb = -1;
	for ( i=0; ( (i < ErMacNumb) && ( er_numb == -1) ) ; i++ ) {
		if (strcmp(w_mac_name,Er_desc[i].macro_name) == 0 ) 
		er_numb = i;
	}
	if ( er_numb != -1 ) {
		if (( Er_desc[er_numb].reasons[reason]=='1') && (!Verbose) )
		return;	   /* This error, for this macro already printed ! */
		else Er_desc[er_numb].reasons[reason] = '1';
	}
	else {
		strcpy(Er_desc[ErMacNumb].macro_name,w_mac_name);
/*****************	Limit 15 reasons for error !	****************/
		strcpy(Er_desc[ErMacNumb].reasons,"000000000000000");
		Er_desc[ErMacNumb].reasons[reason] = '1';
		ErMacNumb++;
	}

	strprS(Line);
	sprintf(ForDouble,"\nSML%2u: ",reason);
        if ( ForDouble[4] == ' ' ) ForDouble[4] = '0';
        DoublePrint();

	switch ( reason ) {
	case 1:
		sprintf(ForDouble,
		"Error. Unexpected macro %s [ %s ]\n",
		w_mac_name,w_long_name);
	break;
	case 2:
		sprintf(ForDouble,
		"Warning. Unknown macro name %s, line number %d\n%s\n",
		w_mac_name,LineNumb,Line);
	break;
	case 3:
		sprintf(ForDouble,
		"Error. Macro %s [%s] cannot have arguments\n",
		w_mac_name,w_long_name);
	break;
	case 4:
		sprintf(ForDouble,
		"Error. Arguments are incorrect in macro %s [%s]\n",
		w_mac_name,w_long_name);
	break;
        case 9:
                sprintf(ForDouble,
                "Error. Tabs outside of arguments, in macro %s [ %s ] \n",
                w_mac_name,w_long_name);
        break;
	}
	DoublePrint();

	if ( reason == 2 ) {
		WarNumb++;
		for ( i=0; i < OldMacroNumb ; i++ ) {
			MakeName(old_name,Old_macro_desc[i].old_macro_name);
			if ( strcmp(w_mac_name,old_name) == 0 ) {
				sprintf(ForDouble,
				"This can be nonsemantic macro %s",
				Old_macro_desc[i].old_macro_name);
				DoublePrint();
				TakeTrans(TranLine,i);
				sprintf(ForDouble,
	"which should be translated to %ssemantic macro[s]\n",
				TranLine);
				DoublePrint();
				break;
			}
		}
		return;
	}

	sprintf(ForDouble,"in line number %d\n%s\n",
	LineNumb,Line);
	DoublePrint();
	if ( reason == 4 ) {
		sprintf(ForDouble,"Synopsis: .%s ",w_mac_name);
		strcat(ForDouble,MakeSynopsis(text));
		strcat(ForDouble,"\n");
		DoublePrint();
	}

	/* not print information about block, where error was found	*/
	/* for reasons, which not depends, on this information		*/

	if ( reason == 1 ) {

	/* print information about block				*/

		strcpy(long_name,Macro_desc[CurMacroNumb].macro_long_name);
		if ( strcmp(long_name,"") == 0 ){
			sprintf(ForDouble,"after macro %s found in line %d\n%s",
			CurMacName, StackLine[Stack],StackLineText[Stack]);
		}
		else {
			sprintf(ForDouble,
			"after macro %s [ %s ] found in line %d\n%s",
			CurMacName, long_name, 
			StackLine[Stack],StackLineText[Stack]);
		}
		if ( strcmp(CurMacName,"++") == 0 ) 
		sprintf(ForDouble,"after beginning of the document\n");
		DoublePrint();
	}

	/*	Check the number of errors	*/

	if ( reason != 2 )  ErNumb++;
	if ( ErNumb > 50 ) {
		sprintf(ForDouble,"\nToo many errors !\n");
		DoublePrint();
		PrStat();
		GentleExit();
	}
	return;
}
