#!/bin/sh
#
# Copyright (c) 1990,1991, OPEN SOFTWARE FOUNDATION, INC.
# ALL RIGHTS RESERVED
# 
#	synopsis: syncGen 
#
# assumes that the synchronizer macro outputs:
#
#	!SYNC: <page> <h1> <h2> <h3> <h4> <fig> <tab>
#
# generates nroff/troff command line register settings to set
#
#	@	page
#	!	H 1
#	#	H 2
#	$	H 3
#	^	H 4
#	_	current figure number
#	=	current table number
#

syncOpts=`tail -1 $1 |
	sed -n 's/^!SYNC: "\(.*\)" "\(.*\)" "\(.*\)" "\(.*\)" "\(.*\)" "\(.*\)" "\(.*\)"$/-r@\1 -r!\2 -r#\3 -r$\4 -r^\5 -r_\6 -r=\7/p'`

if [ "$syncOpts" = "" ]
	then echo "-r@99 -r!99 -r#99 -r$99 -r^99 -r_99 -r=99"
	else echo "$syncOpts"
fi
