/****************************************************************
* Copyright (c) 1990,1991, OPEN SOFTWARE FOUNDATION, INC.	*
* ALL RIGHTS RESERVED.						*
*****************************************************************/

#define const

/*
 * ------------------------------------------------------- Program:
 * indpostsort of:      Indexing Tools for DTE Usage:   indpostsort  Input:
 * stdin contains sorted index records. Format is: sortkey1, sortkey2,
 * sortkey3, sortkey4, pagetext, flags, textkey1, textkey2, textkey3,
 * textkey4. Each record is terminated with newline. Fields are terminated
 * with \x01. Sort keys consist of a flag character (unused) followed by text
 * used to sort the index entrys. We use the first character of the text of
 * sortkey1 to determine what letter the entry appears under, otherwise the
 * sortkeys are unsued. The textkeys contain the text passed to the index
 * generation macros. Textkey4 contains see or see also text. Output:  stdout
 * contains index macro calls: iL, iP, iS, iT, i#, i:, i;
 * ------------------------------------------------------- 
 */

const char      err_range_nest[] = "Page ranges improperly formed just prior to\n";

#include "stdio.h"
#include "string.h"
#include "ctype.h"

#define INPSZ 60
#define BUFSZ 1000
#define PAGESZ 20
#define FLAGSZ 20
#define NRKEYS 4
#define LVPAGE 3
#define LVSEE  4
#define LVSEA  5
#define EOFLD  1

typedef struct ST_entry *entry_ptr;
typedef struct ST_entry
{
    entry_ptr       next;
    int             level;
    int             nr_subord, preem;
    char           *text;
}
                entry;

entry          *head, *tail;
char            key[NRKEYS][INPSZ], prev_key[NRKEYS][INPSZ], inpbf[BUFSZ];
char            page[PAGESZ], range_start[PAGESZ], flags[FLAGSZ];
char            sort_letter, letter, prev_letter;
int             range_level, range_preem, diff[NRKEYS];

/*
 * char *read_input(char[][INPSZ]); void set_counts(entry*); void
 * output_list(entry*); entry *new_entry(int,char*); int  range_check(); void
 * double_quote(char*,char*); void error_entry (); char *page_format (char
 * *); 
 */

char           *read_input();
void            set_counts();
void            output_list();
entry          *new_entry();
int             range_check();
void            double_quote();
void            error_entry();
char           *page_format();


main()
{
    int             i, j;
    char           *cp;
    head = NULL;
    range_level = 0;
    strcpy(prev_key[0], "zzzzzz");
    prev_letter = 'z';
    while (read_input(key))
    {
	for (i = 0; i < NRKEYS; i++)
	{
	    if (strcmp(key[i], prev_key[i]))
		for (; i < NRKEYS; i++)
		{
		    diff[i] = 1;
		    strcpy(prev_key[i], key[i]);
		}
	    else
		diff[i] = 0;
	}
	if (diff[NRKEYS - 2])
	{
	    if (range_level)
	    {
		fprintf(stderr, err_range_nest);
		error_entry();
		range_level = 0;
	    }
	}
	if (diff[0])
	{
	    if (head)
	    {
		set_counts(head);
		output_list(head);
	    }
	    tail = head = new_entry(0, key[0]);
	    letter = sort_letter;
	}
	for (i = 1; i < NRKEYS - 1; i++)
	{
	    if (diff[i])
		tail = ((tail->next) = new_entry(i, key[i]));
	}
	cp = 0;
	if (strchr(flags, ':'))
	{
	    i = LVSEE;
	    cp = key[NRKEYS - 1];
	} else
	if (strchr(flags, ';'))
	{
	    i = LVSEA;
	    cp = key[NRKEYS - 1];
	} else
	{
	    i = LVPAGE;
	    cp = range_check() ? page : NULL;
	}
	if (cp)
	{
	    tail = ((tail->next) = new_entry(i, cp));
	    if (strchr(flags, '!'))
		tail->preem++;
	}
    }

    if (head)
    {
	set_counts(head);
	output_list(head);
    }
    exit(0);
}

char           *
read_input(key)
    char            key[][INPSZ];
{
    char           *cp, *ep;
    int             i;
    if (cp = fgets(inpbf, BUFSZ, stdin))
    {
	sort_letter = *++cp;
	if ((sort_letter < 'A' || sort_letter > 'Z')
	    && (sort_letter < 'a' || sort_letter > 'z'))
	    sort_letter = ' ';
	for (i = 0; i < NRKEYS; i++)
	    cp = strchr(cp, EOFLD) + 1;
	ep = strchr(cp, EOFLD);
	*ep++ = '\0';
	strcpy(page, cp);
	ep = strchr(cp = ep, EOFLD);
	*ep++ = '\0';
	strcpy(flags, ++cp);
	for (i = 0; i < NRKEYS; i++)
	{
	    ep = strchr(cp = ep, EOFLD);
	    *ep++ = '\0';
	    double_quote(key[i], cp);
	}
    }
    return cp;
}

void 
set_counts(pp)
    entry          *pp;
{
    entry          *sp, *tp, *qp;
    int             count[3];
    for (sp = pp->next, count[0] = 0; sp && sp->level > 0; sp = qp, count[0]++)
    {
	for (tp = sp->next, count[1] = 0; tp && tp->level > 1; tp = qp, count[1]++)
	{
	    for (qp = tp->next, count[2] = 0; qp && qp->level > 2;
		 qp = qp->next, count[2]++);
	    tp->nr_subord = count[2];
	}
	sp->nr_subord = count[1];
    }
    pp->nr_subord = count[0];
}

entry          *
new_entry(lv, sp)
    int             lv;
    char           *sp;
{
    entry          *ep;
    ep = (entry *) malloc(sizeof(entry));
    ep->next = NULL;
    ep->level = lv;
    ep->nr_subord = 0;
    ep->preem = 0;
    strcpy(ep->text = (char *) malloc(1 + strlen(sp)), sp);
    return ep;
}

const char      lit[] = "\\*L";
const char      ord[] = "\\*O";
const char      unused[] = "";

void 
output_list(pp)
    entry          *pp;
{
    entry          *ep, *dp;
    char           *leadem, *trailem;
    for (ep = pp; ep; ep = (dp = ep)->next, free(dp))
    {
	if (ep->preem)
	{
	    leadem = lit;
	    trailem = ord;
	} else
	{
	    leadem = unused;
	    trailem = unused;
	}
	switch (ep->level)
	{
	case 0:
	    if (letter != prev_letter)
	    {
		if (letter < 'A') printf(".iL \"Symbols\"\n");
		else printf(".iL \"%c\"\n", letter);
		prev_letter = letter;
	    }
	    printf(".iP \"%s\" %d\n", ep->text, ep->nr_subord);
	    break;
	case 1:
	    printf(".iS \"%s\" %d\n", ep->text, ep->nr_subord);
	    break;
	case 2:
	    printf(".iT \"%s\" %d\n", ep->text, ep->nr_subord);
	    break;
	case LVPAGE:
	    printf(".i# \"%s%s%s\"\n", leadem, page_format(ep->text), trailem);
	    break;
	case LVSEE:
	    printf(".i: \"%s\"\n", ep->text);
	    break;
	case LVSEA:
	    printf(".i; \"%s\"\n", ep->text);
	    break;
	}
	free(ep->text);
    }
}

int 
range_check()
{
    if (strchr(flags, '['))
	if (!range_level++)
	{
	    strcpy(range_start, page);
	    range_preem = strchr(flags, '!') ? 1 : 0;
	    return 0;
	} else;
    else
    if (strchr(flags, ']'))
	if (--range_level <= 0)
	    if (!range_level)
	    {
		if (strcmp(range_start, page))
		{
		    strcat(range_start, " to ");
		    strcat(range_start, page);
		    strcpy(page, range_start);
		}
		if (range_preem)
		    strcat(flags, "!");
	    } else
	    {
		fprintf(stderr, err_range_nest);
		error_entry();
		range_level = 0;
	    }
    return !range_level;
}

void 
error_entry()
{
    fprintf(stderr, "Entry: %s-%s-%s-%s-%s-%s\n",
	    key[0], key[1], key[2], key[3], page, flags);
}

void 
double_quote(dp, sp)
    char           *dp;
    char           *sp;
{
    for (; *sp; sp++)
    {
	*dp++ = *sp;
	if (*sp == '"')
	    *dp++ = '"';
    }
    *dp++ = '\0';
}

#define NEW

#ifdef NEW
char *
page_format(s)
char *s;
{
    static char buf[32];
    char *cp;
    int num=0;

    cp = buf;
    while (*s) {
	if (isdigit(*s)) {
	    if (num == 0 && *s == '0') {
		while (*s && *s == '0') s++;	/* eat leading zeros */
		if (!isdigit(*s)) s--;
	    }
	    num = 1;
	}
	else num = 0;
	if (*s == '-') *cp++ = '\\';
	*cp++ = *s;
	s++;
    }
    *cp++ = '\0';
    cp = buf;
    return cp;
}
#endif

#ifdef OLD
char           *
page_format(cp)
    char           *cp;
{
    char           *sp, *dp, *ep;
    int             zero_supp, nr_supp;
    zero_supp = 1;
    nr_supp = 0;
    for (sp = ep = dp = cp; *sp; sp++)
    {
	if (*sp == '0' && zero_supp)
	    nr_supp++;
	else
	{
	    if (isdigit(*sp) || isalpha(*sp))
		zero_supp = 0;
	    else
	    {
		if (dp == ep && nr_supp)
		    *dp++ = '0';
		ep = dp + 1;
		zero_supp = 1;
		nr_supp = 0;
	    }
	    *dp++ = *sp;
	}
    }
    if (dp == ep && nr_supp)
	*dp++ = '0';
    *dp = '\0';
    if (*cp == '-')
	strcpy(cp, cp + 1);
    return cp;
}
#endif
