/* This program was developed at Hitachi Computer Products (America), Inc., in
 * its Open Systems Division, which is responsible for porting and adapting OSF
 * offerings.  Hitachi Computer Products has given the program to OSF so it can
 * use and distribute it as part of its documentation build tools.  In addition,
 * OSF licensees can adapt the program to the needs of their sites.  The program
 * is offered as is, with no warranty attached, and so forth and so on.
 *
 * Before you make any changes to this file, read the "maintenance" file.
 */

#include "filter.h"

main(argc, argv)
     int argc;
     char **argv;
{
  int i_ua,			/* index into user arguments */
  i_f;				/* index into filter ARG_STRUCT array */
  STRING_LIST ifdefine_ptr;	/* new element in list of ifdef strings */
  FILE_LIST filename_ptr;
  extern ARG_STRUCT filter[];
  extern FILE *yyin;		/* a lex internal, used here for stacking files */
  extern FILE_LIST filename_list;
  extern STRING_LIST ifdefine_list;
  extern char *program_name;	/* this program, as pathname invoked by user */
  extern char file_name_buf[],	/* current file from which input is taken */
  *curr_file_name;
  extern unsigned int depth;	/* number of #ifdef directives without #endif */
  extern unsigned int line_number;
  extern unsigned int sizeof_buf;

  /* The following array tracks elements of the filter ARG_STRUCT array.
   * As the program loops through user input in a rather complicated manner,
   * this array preserves information on whether the argument has already
   * appeared in the user's input command, either with or without a "no" prefix.
   */
  BOOL filter_found[TOP_OF_FILTER_ARRAY];

  void usage();
  BOOL monitor_ifdef_stack();

  if ( (filename_list = (FILE_LIST) malloc(sizeof(struct file_list)) )
       == NULL )
    {
      perror(program_name);
      exit (1);
    }
  if ( (ifdefine_list = (STRING_LIST) malloc(sizeof(struct string_list)) )
       == NULL )
    {
      perror(program_name);
      exit (1);
    }

  filename_ptr = filename_list;
  ifdefine_ptr = ifdefine_list;

  /* The next opening in the list must always be null so we know when we've reached
     the end of the list. */

  filename_ptr->filen = NULL;
  ifdefine_ptr->string = NULL;

  /* Start with a clean array (all flags off). */

  for (i_f=0; i_f < TOP_OF_FILTER_ARRAY; i_f++ )
    {
      if (filter[i_f].available) /* skip altogether if permanently disabled */
	{
	  filter_found[i_f] = FALSE;
	  filter[i_f].actual_value = filter[i_f].on_by_default;
	}
    }

  program_name = argv[0];

  if (argc)
    {
      /* Man, who would think that VAX-style case-insensitive minimal-uniqueness argument parsing
	 would be this much work?  Mixing a UNIX-style option with it is half the trouble. */

      for ( i_ua=1; i_ua<argc; i_ua++ )
	{
	  BOOL this_arg_found=FALSE;

	  if ( ! strcmp (argv[i_ua], "-") ) /* The argument was a simple hyphen */
	    {
	      filename_ptr->filen = "-"; /* linked list */
	      if ( (filename_ptr->next = (FILE_LIST) malloc(sizeof(struct file_list)) )
		   == NULL )
		{
		  perror(program_name);
		  exit (1);
		}
	      filename_ptr = filename_ptr->next;
	      filename_ptr->filen = NULL; /* always keep the next opening null	*/
	    }
	  else if ( *argv[i_ua] == '-')
	    {

	      /* The big check for options!  This section finds two kinds of errors:  an unrecognized option
		 (one that isn't in the list) and an ambiguous option (one that could match two of the
		 elements in the filter[] array).  This loop does nothing to stop the user from specifying
		 the same option twice, or including contradictory options, like "-standard" and "-nostandard".
		 There's no harm in entering redundant arguments; in fact, it might be useful in case some
		 option is hard-coded in an alias or a makefile, and the user wants to override it. */

	      BOOL turnon_flag=TRUE; /* For deciding whether an option is enabled; TRUE is for first
					search through list; FALSE for second search with "-no" options. */
	      char *current_arg = argv[i_ua];
	      char *tmp_ptr;

	      current_arg++;

	      /* The -d option requires a lot of special handling,
	       * unfortunately, because it is the only one that follows
	       * conventions typically considered to  be in UNIX systems' style
	       * (that is, it consists of a single letter, and an optional
	       * value can follow with no intervening space).
	       */

	      /* Check whether a command-line option begins with -d or -D.
		 Get string that follows, if any, and store in ifdefine_list. */
	      if ( *current_arg == 'd' || *current_arg == 'D' )
		/* found a -d argument */
		{
		  filter[FILTER_DEFINE].actual_value = TRUE;
		  filter_found[FILTER_DEFINE] = TRUE;
		  this_arg_found = TRUE;
		  current_arg++; /* now pointing to the defined string */
		  if (*current_arg) /* store only if it's non-null */
		    {
		      ifdefine_ptr->string = current_arg; /* linked list */
		      if ( (ifdefine_ptr->next = (STRING_LIST) malloc(sizeof(struct string_list)) )
			   == NULL )
			{
			  perror(program_name);
			  exit (1);
			}
		      ifdefine_ptr = ifdefine_ptr->next;
		      ifdefine_ptr->string = NULL; /* always keep the next opening null	 */
		    }
		}		/* matches if ( *current_arg == 'd' || *current_arg == 'D' ) */
	      else
		{
		  /* In this else clause we check for all other options, including
		     those that begin with "-no". */

		  BOOL still_looking=TRUE; /* For reiterating the loop for a "-no" option; set this to
					      FALSE after checking for "-no" option */

		  while (still_looking) /* This loop runs at most twice: first for the option list as
					   defined in array, then for a -no option if current_arg begins
					   with "no". */
		    {
		      /* Convert current_arg to lowercase */
		      tmp_ptr=current_arg;
		      while (*tmp_ptr)
			{
			  if ( isupper(*tmp_ptr))
			    {
			      /* Use temporary character just in case macro definition of toupper
				 has side effects on the pointer that screws it up. */
			      char c;
			      c = tolower(*tmp_ptr);
			      *tmp_ptr = c;
			    }
			  tmp_ptr++ ;
			}
		      for (i_f=0; i_f < TOP_OF_FILTER_ARRAY; i_f++ )
			{
			  if (filter[i_f].available) /* skip altogether if permanently disabled */
			    {
			      if ( ! strncmp (filter[i_f].arg, current_arg, strlen(current_arg) ) )
				{
				  if (this_arg_found)
				    {
				      usage(program_name);
				      (void) fprintf(stderr,
				      "\n%s: ERROR ENDING THIS RUN -- Ambiguous argument %d matches two or more options: %s\n",
				      program_name, i_ua, argv[i_ua]);
				      exit (1);
				    }
				  else	    /* matches if (this_arg_found) */
				    {
				      this_arg_found = TRUE;
				      filter_found[i_f] = TRUE;
				      filter[i_f].actual_value = turnon_flag;
				    }
				} /* if ( ! strncmp (filter[i_f].arg, current_arg, strlen(current_arg) ) ) */
			    }	/* if (filter[i_f].available) */
			}	/* for (i_f=0; i_f < TOP_OF_FILTER_ARRAY; i_f++ ) */
		      /* We have passed through the array once.  Now, if the argument begins with
			 "-no", we must go through the whole array again. */
		      if ( (turnon_flag == TRUE) && ( ! strncmp ("no", current_arg, 2 ) ) )
			{
			  turnon_flag=FALSE;
			  current_arg += 2;
			}
		      else
			{
			  still_looking = FALSE;
			}
		    }		/* matches while (still_looking) */
		  if ( ! this_arg_found )
		    {
		      usage(program_name);
		      (void) fprintf(stderr,
		      "\n%s: ERROR ENDING THIS RUN -- Cannot recognize argument %d: %s\n",
		      program_name, i_ua, argv[i_ua]);
		      exit (1);
		    }
		}		/* matches else clause after if ( *current_arg == 'd' || *current_arg == 'D' ) */
	    }			/* matches else if ( *argv[i_ua] == '-') */
	  else
	    {
	      /* The argument must be a filename, if it does not begin with a hyphen. */
	      filename_ptr->filen=argv[i_ua];
	      if ( (filename_ptr->next = (FILE_LIST) malloc(sizeof(struct file_list)) )
		   == NULL )
		{
		  perror(program_name);
		  exit (1);
		}
	      filename_ptr = filename_ptr->next;
	      filename_ptr->filen = NULL; /* always keep the next opening null	*/
	    }
	}			/* matches for ( i_ua=1; i_ua<argc; i_ua++ ) */
    }				/* matches if (argc) */

  if ( filter[FILTER_HELP].actual_value )
    {
      usage(program_name);
      exit (0);
    }

  /* Turn on the arguments that are invoked by -standard.
   * The complicated logical expression causes the loop to skip arguments that the user
   * has already specified.  (So the command line always overrules the standard.)
   * Permanently disabled options (available member is FALSE) also are skipped.
   * The loop doesn't bother to check the on_by_default member, because we know what we
   * want to do with a standard argument -- turn it on, regardless of the default.
   */
  if ( filter[FILTER_STANDARD].actual_value )
    {
      for (i_f=0; i_f < TOP_OF_FILTER_ARRAY; i_f++)
	{
	  if ( filter[i_f].standard_turns_on && ! filter_found[i_f] && filter[i_f].available )
	    {
	      filter[i_f].actual_value = TRUE;
	    }
	}
    }

  /* Set up filenames, ready to go in order */

  filename_ptr = filename_list;

  if (filename_ptr->filen == NULL)
    {
      /* No filenames were passed, so take from standard input */
      filename_ptr->filen = "-"; /* linked list */
      if ( (filename_ptr->next = (FILE_LIST) malloc(sizeof(struct file_list)) )
	   == NULL )
	{
	  perror(program_name);
	  exit (1);
	}
      filename_ptr = filename_ptr->next;
      filename_ptr->filen = NULL; /* always keep the next opening null	*/
    }

  filename_ptr = filename_list;

  while (filename_ptr->filen)
    {
      if (! strcmp(filename_ptr->filen,"-") )
	{
	  yyin = stdin;
	  (void) strncpy (file_name_buf, "standard input", sizeof_buf);
	  line_number = 1;
	}
      else
	{
	  (void) strncpy (file_name_buf, filename_ptr->filen, sizeof_buf);
	  if ( (yyin = fopen( curr_file_name, "r") ) == NULL)
	    {
	      perror(program_name);
	      usage(program_name);
	      (void) fprintf(stderr, "%s: ERROR ENDING THIS RUN -- Tried to open file: %s\n",
			     program_name, curr_file_name);
	      exit (1);
	    }
	  line_number = 1;
	}			/* matches else clause after if (! strcmp(filename_ptr->filen,"-") ) */
      while (yylex() )		/* let lex-generated code process input */
	{}

      if (yyin != stdin )
	{
	  if ( (fclose(yyin) ) == EOF) /* Close old file */
	    {
	  perror(program_name);
	    }
	}

      /* At end of each input file, make one last check in case an #ifdef or
       * related directive is still open (that is, an #endif is missing).
       * This check enforces an unwritten rule that every #ifdef and its
       * corresponding #endif must be in the same file; see the maintenance file
       * for implications and justification.
       */
      if (depth != 0)
	{
	  (void) monitor_ifdef_stack(UNWIND, NULL);
	  exit (1);
	}

      filename_ptr = filename_ptr->next;
     }

  exit (0);
  /* NOTREACHED */
}

int yywrap()
{
  BOOL monitor_file_stack();

  if (monitor_file_stack(POP, NULL))	/* Returning from .so file; we're still in a source file */
    return (0);
  else				/* No more files on stack, go to next in list */
    return (1);
}

void usage(name)
     char *name;
{
  int i_f;
  extern ARG_STRUCT filter[];

  (void) fprintf(stderr, "The format for using this command is:\n\n", name);
  (void) fprintf(stderr, "    %s [ -ARG ] ... [FILE] ...\n\n", name);
  (void) fprintf(stderr, "or\n\n");
  (void) fprintf(stderr, "    cat FILE ... | %s [ -ARG ] ...\n\n", name);
  (void) fprintf(stderr, "where each -ARG can be one of the following, in any order.\n\n");

  for (i_f=0; i_f < TOP_OF_FILTER_ARRAY; i_f++ )
    {
      if (filter[i_f].available) /* skip altogether if permanently disabled */
	{
	  (void) fprintf(stderr, "  -%-15s	  (turn off through -no%s)\n	  %s.\n",
			 filter[i_f].arg, filter[i_f].arg, filter[i_f].doc);
	  (void) fprintf(stderr, "	Default is -%s%s, and the -standard option invokes -%s%s.\n\n",
			 filter[i_f].on_by_default ? "" : "no", filter[i_f].arg,
			 filter[i_f].standard_turns_on ? "" : "no", filter[i_f].arg);
	}
    }

  (void) fprintf(stderr, "For full documentation, see %s.\n", USER_DOC_FILE);
}
