%p 3000
%{
/* This program was developed at Hitachi Computer Products (America), Inc., in
 * its Open Systems Division, which is responsible for porting and adapting OSF
 * offerings.  Hitachi Computer Products has given the program to OSF so it can
 * use and distribute it as part of its documentation build tools.  In addition,
 * OSF licensees can adapt the program to the needs of their sites.  The program
 * is offered as is, with no warranty attached, and so forth and so on.
 *
 * Before you make any changes to this file, read the "maintenance" file.
 */

#include "filter.h"
extern ARG_STRUCT filter[];
extern char *program_name;
extern char *curr_file_name;
extern unsigned int line_number;
extern char *ifdef_directive;
extern void monitor_state_stack();
extern BOOL monitor_file_stack();
extern enum ifdef_op monitor_ifdef_stack();
extern BOOL find_ifdef_in_list();
extern BOOL monitor_token_stack();
%}

%Start TBL_HD IN_PIC IN_SO
%Start IN_IF ABSORB
%Start A_STRING A_LPAREN A_OP A_NEG
%Start PRINT IGNORE

%%
<ABSORB>.*\n	   {
	/* This state is set within an action that checks
	   for a string or takes some other action in the middle
	   of a line.  Trying to read characters from the input
	   file explicitly within that action has been found to
	   lead to strange errors; using this ABSORB action
	   is safer. */
	monitor_state_stack(POP);
	line_number++;
}

<IGNORE>^\.[ \t]*so.*\n	      ;

^\.[ \t]*so[ \t]*	{
	/* This entry finds .so lines and starts taking input
	   from the sourced-in file, using the yywrap() function
	   to make sure input continues properly in the old
	   file afterward. */
	if ( filter[FILTER_SOELIM].actual_value )
	  {
	    monitor_state_stack(PUSH);
	    BEGIN IN_SO;
	  }
	else
	  {
	    ECHO ;
	  }
}

<IN_SO>.*\n {
	/* Take the rest of the line after the .so request.   Most of
	   the work is done by the monitor_file_stack() function: finding
	   the file, preserving the previous file descriptor on a stack, taking
	   input from the new file. */
	unsigned char *yystptr=yytext;

	monitor_state_stack(POP);
	if (*yystptr == '\"')
	  {
	    unsigned char *yyenptr= ++yystptr; /* advance yystptr past quote */
	    while (*yyenptr)
	      {
		/* Our mission is now to find another quote character
		   and terminate the string there -- it will now be our
		   file name. */
		yyenptr++;
		if (*yyenptr=='\n')  /* We've found the end of the string */
		{
		  *yyenptr = '\0';
		  (void) fprintf(stderr,
		  "%s: ERROR in %s file, line %d -- filename \"%s must end with quotation mark\n",
		  program_name, curr_file_name, line_number, yystptr);
		  exit (1);
		}
		else if (*yyenptr == '\"')  /* Replace quote with null */
		{
		  *yyenptr = '\0';
		}
	      }
	    }
	else
	  {
	    unsigned char *yyenptr= yystptr;
	    /* Our mission is now to find either the end of the string
	       or a \" indicating the start of the comment. */
	    while ( (! isspace(*yyenptr) ) && strncmp(yyenptr, "\\\"", 2) )
	      {
		yyenptr++;
	      }
	      *yyenptr = '\0';
	  }
	if (monitor_file_stack(PUSH, yystptr) )
	  {
	    exit (1);		/* file not found */
	  }
}

^#[ \t]*ifdef[ \t]*	{
	if ( filter[FILTER_DEFINE].actual_value )
	  {
	    ifdef_directive="#ifdef";
	    monitor_state_stack(PUSH);
	    (void) monitor_token_stack(TOKEN_IFDEF);
	    BEGIN IN_IF ;
	  }
	else
	  {
	    ECHO ;
	  }
}

^#[ \t]*ifndef[ \t]*	{
	if ( filter[FILTER_DEFINE].actual_value )
	  {
	    ifdef_directive="#ifndef";
	    monitor_state_stack(PUSH);
	    (void) monitor_token_stack(TOKEN_IFNDEF);
	    BEGIN IN_IF ;
	  }
	else
	  {
	    ECHO ;
	  }
}

^#[ \t]*if[ \t]*	{
	/* For the sake of simplicity, I treat #if exactly
	   like #ifdef.  This means people can use constructs
	   that they perhaps should not use, but everything
	   that is used normally should be handled normally. */
	if ( filter[FILTER_DEFINE].actual_value )
	  {
	    ifdef_directive="#if";
	    monitor_state_stack(PUSH);
	    (void) monitor_token_stack(TOKEN_IFDEF);
	    BEGIN IN_IF ;
	  }
	else
	  {
	    ECHO ;
	  }
}

<IN_IF,A_STRING,A_LPAREN,A_OP,A_NEG>\/\*.*\*\/[ \t]*	    ;

<IN_IF,A_LPAREN,A_OP,A_NEG>defined[ \t]*	;

<IN_IF,A_LPAREN,A_OP,A_NEG>"("[ \t]*	{
	/* Opening of parenthesized expression in an #if directive
	   (although it could be used in #ifdef or #ifndef too, because these
	   are all represented by the same set of start states). */
	(void) monitor_token_stack(TOKEN_LPAREN);
	BEGIN A_LPAREN ;
}

<A_STRING>")"[ \t]* {
	/* Opening of parenthesized expression in an #if directive
	   (although it could be used in #ifdef or #ifndef too, because these
	   are all represented by the same set of start states). */
	(void) monitor_token_stack(TOKEN_RPAREN);
}

<IN_IF,A_LPAREN,A_OP,A_NEG>[a-zA-Z0-9_\-]+[ \t]*	{
	/* yytext is the string defined in the file.  Check to see if the
	   user passed it, then add appropriate value to the token stack. */
	if ( find_ifdef_in_list(yytext) )
	  {
	    (void) monitor_token_stack(TOKEN_STRING_DEFINED);
	  }
	else
	  {
	    (void) monitor_token_stack(TOKEN_STRING_UNDEFINED);
	  }
	BEGIN A_STRING ;
}

<IN_IF,A_LPAREN,A_OP,A_NEG>\![ \t]*	{
	/* unary negation operator before string of an #if directive. */
	(void) monitor_token_stack(TOKEN_NEGATE);
	BEGIN A_NEG ;
}

<A_STRING>\|[ \t]*  {
	/* OR operator between strings of an #if directive. */
	(void) monitor_token_stack(TOKEN_OR);
	BEGIN A_OP ;
}

<A_STRING>\|\|[ \t]*	    {
	/* doubled OR operator between strings of an #if directive. */
	(void) monitor_token_stack(TOKEN_OR);
	BEGIN A_OP ;
}

<A_STRING>\&[ \t]*  {
	/* AND operator between strings of an #if directive. */
	(void) monitor_token_stack(TOKEN_AND);
	BEGIN A_OP ;
}

<A_STRING>\&\&[ \t]*	    {
	/* doubled AND operator between strings of an #if directive. */
	(void) monitor_token_stack(TOKEN_AND);
	BEGIN A_OP ;
}

<A_STRING>\^[ \t]*  {
	/* Exclusive OR operator between strings of an #if directive. */
	(void) monitor_token_stack(TOKEN_XOR);
	BEGIN A_OP ;
}

<A_STRING>\n	    {
	/* Newline terminating an #if directive. */
	switch (monitor_ifdef_stack(PUSH, monitor_token_stack(TOKEN_NLINE))) {
	case IFDEFOP_ERROR:
	  exit (1);		/* shouldn't ever be reached */

	case IFDEFOP_PRINT:
	  BEGIN PRINT ;
	  break;

	case IFDEFOP_IGNORE:
	  BEGIN IGNORE ;
	  break;
	}
	line_number++;
}

<IN_IF>.     {
	/* This entry runs if the preceding ones did not.
	   If this entry is reached, it means that an #if, #ifdef,
	   or #ifndef line contained a parsing error -- no string,
	   an operator without a following string, two tokens in a row that
	   row that shouldn't appear, etc. */
	(void) fprintf(stderr,
	"%s: ERROR in %s file, line %d -- %s must be followed by left parenthesis, string, or exclamation point\n",
	program_name, curr_file_name, line_number, ifdef_directive);
	exit (1);
}

<A_STRING>. {
	/* This entry runs if the preceding ones did not.
	   If this entry is reached, it means that an #if, #ifdef,
	   or #ifndef line contained a parsing error -- no string,
	   an operator without a following string, two tokens in a row that
	   row that shouldn't appear, etc. */
	(void) fprintf(stderr,
	"%s: ERROR in %s file, line %d -- string must be followed by right parenthesis, operator, or end of line\n",
	program_name, curr_file_name, line_number);
	exit (1);
}

<A_LPAREN>. {
	/* This entry runs if the preceding ones did not.
	   If this entry is reached, it means that an #if, #ifdef,
	   or #ifndef line contained a parsing error -- no string,
	   an operator without a following string, two tokens in a row that
	   row that shouldn't appear, etc. */
	(void) fprintf(stderr,
	"%s: ERROR in %s file, line %d -- left parenthesis must be followed by string, exclamation point, or another left parenthesis\n",
	program_name, curr_file_name, line_number);
	exit (1);
}

<A_OP>.	{
	/* This entry runs if the preceding ones did not.
	   If this entry is reached, it means that an #if, #ifdef,
	   or #ifndef line contained a parsing error -- no string,
	   an operator without a following string, two tokens in a row that
	   row that shouldn't appear, etc. */
	(void) fprintf(stderr,
	"%s: ERROR in %s file, line %d -- operator must be followed by a string, exclamation point, or left parenthesis\n",
	program_name, curr_file_name, line_number);
	exit (1);
}

<A_NEG>. {
	/* This entry runs if the preceding ones did not.
	   If this entry is reached, it means that an #if, #ifdef,
	   or #ifndef line contained a parsing error -- no string,
	   an operator without a following string, two tokens in a row that
	   row that shouldn't appear, etc. */
	(void) fprintf(stderr,
	"%s: ERROR in %s file, line %d -- exclamation point must be followed by a string or left parenthesis\n",
	program_name, curr_file_name, line_number);
	exit (1);
}

<IN_IF>\n    {
	/* This entry runs if the preceding ones did not.
	   If this entry is reached, it means that an #if, #ifdef,
	   or #ifndef line contained a parsing error -- no string,
	   an operator without a following string, two tokens in a row that
	   row that shouldn't appear, etc. */
	(void) fprintf(stderr,
	"%s: ERROR in %s file, line %d -- %s must be followed by left parenthesis, string, or exclamation point\n",
	program_name, curr_file_name, line_number, ifdef_directive);
	exit (1);
}

<A_STRING>\n	    {
	/* This entry runs if the preceding ones did not.
	   If this entry is reached, it means that an #if, #ifdef,
	   or #ifndef line contained a parsing error -- no string,
	   an operator without a following string, two tokens in a row that
	   row that shouldn't appear, etc. */
	(void) fprintf(stderr,
	"%s: ERROR in %s file, line %d -- string must be followed by right parenthesis, operator, or end of line\n",
	program_name, curr_file_name, line_number);
	exit (1);
}

<A_LPAREN>\n	    {
	/* This entry runs if the preceding ones did not.
	   If this entry is reached, it means that an #if, #ifdef,
	   or #ifndef line contained a parsing error -- no string,
	   an operator without a following string, two tokens in a row that
	   row that shouldn't appear, etc. */
	(void) fprintf(stderr,
	"%s: ERROR in %s file, line %d -- left parenthesis must be followed by string, exclamation point, or another left parenthesis\n",
	program_name, curr_file_name, line_number);
	exit (1);
}

<A_OP>\n      {
	/* This entry runs if the preceding ones did not.
	   If this entry is reached, it means that an #if, #ifdef,
	   or #ifndef line contained a parsing error -- no string,
	   an operator without a following string, two tokens in a row that
	   row that shouldn't appear, etc. */
	(void) fprintf(stderr,
	"%s: ERROR in %s file, line %d -- operator must be followed by string, exclamation point, or left parenthesis\n",
	program_name, curr_file_name, line_number);
	exit (1);
}

<A_NEG>\n	 {
	/* This entry runs if the preceding ones did not.
	   If this entry is reached, it means that an #if, #ifdef,
	   or #ifndef line contained a parsing error -- no string,
	   an operator without a following string, two tokens in a row that
	   row that shouldn't appear, etc. */
	(void) fprintf(stderr,
	"%s: ERROR in %s file, line %d -- exclamation point must be followed by string or left parenthesis\n",
	program_name, curr_file_name, line_number);
	exit (1);
}

^#[ \t]*else	{
	if ( filter[FILTER_DEFINE].actual_value )
	  {
	    switch (monitor_ifdef_stack(CHECK, NULL)) {
	    case IFDEFOP_ERROR:
	      exit (1);		/* an earlier #else found, or not currently in #if  */

	    case IFDEFOP_PRINT:
	      BEGIN PRINT;
	      break;

	    case IFDEFOP_IGNORE:
	      BEGIN IGNORE ;
	      break;
	    }
	    monitor_state_stack(PUSH);
	    BEGIN ABSORB;
	  }
	else
	  {
	    ECHO ;
	  }
}

^#[ \t]*endif	{
	if ( filter[FILTER_DEFINE].actual_value )
	  {
	    switch (monitor_ifdef_stack(POP, NULL)) {
	    case IFDEFOP_ERROR:
	      exit (1);		/* not currently in #if	 */

	    case IFDEFOP_PRINT:
	    case IFDEFOP_IGNORE:
	      monitor_state_stack(POP);
	      break;
	    }
	    monitor_state_stack(PUSH);
	    BEGIN ABSORB;
	  }
	else
	  {
	    ECHO ;
	  }
}

<IGNORE>. ;

<IGNORE>\n	  {
	line_number++;
}

\n	  {
	ECHO ;
	line_number++;
}

<IGNORE>^\.T[S&]  ;

^\.T[S&]	{
	ECHO ;
	monitor_state_stack(PUSH);
	BEGIN TBL_HD ;
	}

<TBL_HD>^.*\.[ \t]*\n  {
	/* The period that marks the end of specifications means
	   we should stop substituting fonts.  The last line refers
	   to regular entries in the table, not headers, so this file
	   passes it through unchanged, and does not force helvetica fonts.
	   Unfortunately, this entry also overrides the one that removes
	   vertical bars for user rmboxes requests.  So a special check for
	   vertical bars must be inserted directly in the code here. */
       if ( filter[FILTER_RMBOXES].actual_value )
	 {
	   unsigned char *ptr_yytext=yytext;
	   while (*ptr_yytext)
	     {
	       if (*ptr_yytext == '|')
		 *ptr_yytext = ' ';
	       ptr_yytext++;
	     }
       }
       ECHO ;
       monitor_state_stack(POP);
       line_number++;
       }

<TBL_HD>doublebox" "*\,/.*[\\;][ \t]*\n |
<TBL_HD>allbox" "*\,/.*[\\;][ \t]*\n |
<TBL_HD>box" "*\,/.*[\\;][ \t]*\n |
<TBL_HD>\," "*doublebox/.*[\\;][ \t]*\n |
<TBL_HD>\," "*allbox/.*[\\;][ \t]*\n |
<TBL_HD>\," "*box/.*[\\;][ \t]*\n |
<TBL_HD>doublebox/.*[\\;][ \t]*\n |
<TBL_HD>allbox/.*[\\;][ \t]*\n |
<TBL_HD>box/.*[\\;][ \t]*\n    {
	/* These are global box specifications.  They are removed only if:
	      1.  We have encountered a .TS macro (thanks to <TBL_HD> mark)
	      2.  We have not yet finished the table header (thanks to
		  preceding entry that checks for terminating period)
	      3.  We are in a global specification (thanks to the stuff
		  in the current entries after the / character)
	      4.  The user has requested rmboxes (thanks to the if statement
		  in the code below)
	   Make sure to keep this entry after the period-checking entry and before
	   the ; and \ checking entry that passes these lines through unchanged. */
	if ( filter[FILTER_RMBOXES].actual_value )
	  (void) printf(" ") ;
	else
	  {
	    ECHO ;
	  }
	line_number++;
	}

<TBL_HD>"|"/.*[\\;][ \t]*\n {
	/* This entry is here just to override the following entry, in the rare
	   case that a vertical bar occurs in a global specification.  Global
	   specifications are lines ending with a ; or \ followed by optional
	   spaces or tabs. */
	ECHO ;
	line_number++;
	}

<TBL_HD>"|" {
	/* This regular expressions looks for a vertical bar that in
	   a table header.  It is not supposed to take effect in a global
	   specification, which is why the preceding entry is necessary.
	   If the user asked us to rmboxes, the vertical bar is removed. */
	if ( filter[FILTER_RMBOXES].actual_value )
	  (void) printf(" ") ;
	else
	    ECHO ;
}

<IGNORE>^\.PS.*\n {
	line_number++;
}

^\.PS.*\n	{
	/* Put analyzer in a state where it simply removes everything
	   until a .PE is encountered.  The rmPic entries must precede
	   normal ones so that they override them. */
	if ( filter[FILTER_RMPIC].actual_value )
	  {
	    monitor_state_stack(PUSH);
	    BEGIN IN_PIC ;
	  }
	else
	  {
	    ECHO ;
	  }
	line_number++;
}

<IN_PIC>^\.PE.*\n	{
	/* This entry finishes the rmPic activity and lets lines be passed
	   through again.  Make sure this entry stays before the one that
	   removes an entire line. */
	  (void) printf(".sp 1\n.ce 1\n***** PIC image removed here *****\n.sp 1\n");
	monitor_state_stack(POP);
	line_number++;
}

<IN_PIC>^.*\n	{
	/* Make sure that the .PE check stays before this one.
	   Otherwise, this entry will just keep removing lines
	   until the end of the file. */
	line_number++;
}

<IGNORE>OSF\/1	  ;

OSF\/1	{
	if ( filter[FILTER_OSF].actual_value )
	  (void) printf("%s", OP_SYS_NAME);
	else
	    ECHO ;
}
