/* This program was developed at Hitachi Computer Products (America), Inc., in
 * its Open Systems Division, which is responsible for porting and adapting OSF
 * offerings.  Hitachi Computer Products has given the program to OSF so it can
 * use and distribute it as part of its documentation build tools.  In addition,
 * OSF licensees can adapt the program to the needs of their sites.  The program
 * is offered as is, with no warranty attached, and so forth and so on.
 *
 * Before you make any changes to this file, read the "maintenance" file.
 */

#include <stdio.h>
#include "site_specific.h"	/* Isolates the definitions that each site wants to change */

#define TRUE 1			/* Used with variables and functions of type BOOL */
#define FALSE 0

#define MAX_FILENAME_LEN 80	/* Arbitrarily large, used just in error messages */

/* The following enumerated values are indices into the global "filter" table.
 * The flags determine whether this run of the program makes
 * each kind of change to the file.  If the user enters nothing, they
 * remain at default settings.  For each flag, 1 means the file should
 * change, 0 means it should be passed through unchanged.
 * Each flag corresponds to two command-line options (one turning it on and one
 * turning it off).
 *
 * This list must correspond to the filter ARG_STRUCT array in site_specific.c.
 * If you add or delete an enum definition here, change the filter array  to match.
 */
enum processing_type {
  FILTER_DEFINE,		/* Process #ifdef lines; optional string follows */
  FILTER_HELP,			/* Print usage() message (no corresponding -no option)	*/
  FILTER_OSF,			/* Change "OSF/1" to name of your favorite proprietary OS */
  FILTER_RMPIC,			/* Remove pic figures and insert warnings */
  FILTER_RMBOXES,		/* Remove "box" and vertical lines from tables */
  FILTER_SOELIM,		/* Read in files on .so requests */
  FILTER_STANDARD,		/* Tells main() to do whatever is currently standard */
  TOP_OF_FILTER_ARRAY		/* Do only the processing that is specified by other arguments, no defaults */
  };

/* Mnemonics for manipulating stacks maintained by functions in define_stack.c. */
enum stack_op { PUSH, POP, CHECK, UNWIND };

/* Effect of an #ifdef; the return value from monitor_ifdef_stack(). */
enum ifdef_op {
  IFDEFOP_ERROR,		/* Error, such two #else's in a row */
  IFDEFOP_PRINT,		/* Lines should be printed (string was defined) */
  IFDEFOP_IGNORE		/* Lines should be suppressed (string was not defined) */
  };

/* used in monitor_token_stack() function -- wish that yacc could do all this instead. */
enum ifdef_token {		/* valid parts of #if lines */
  TOKEN_AND,			/* binary & or && operator */
  TOKEN_OR,			/* binary | or || operator */
  TOKEN_XOR,			/* binary ^ operator */
  TOKEN_NEGATE,			/* unary ! operator */
  TOKEN_LPAREN,			/* opening parenthesis */
  TOKEN_RPAREN,			/* closing parenthesis */
  TOKEN_IFDEF,			/* #if or #ifdef directive */
  TOKEN_IFNDEF,			/* #ifndef directive */
  TOKEN_STRING_DEFINED,		/* a string that was passed by the user */
  TOKEN_STRING_UNDEFINED,	/* a string that was not passed by the user */
  TOKEN_NLINE			/* newline */
  };

/* used in various functions to parse the ifdef expressions by brute force. */
enum stacking_token {		/* tokens stored in op member of if_token_list */
  STACK_AND,			/* binary & or && operator */
  STACK_OR,			/* binary | or || operator */
  STACK_XOR,			/* binary ^ operator */
  STACK_PAREN,			/* opening parenthesis */
  STACK_IFDEF			/* #if, #ifdef, or #ifndef directive */
  };

typedef int BOOL;

/* Used to store strings defined on command line, in main() and find_ifdef_in_list(). */
struct string_list {
  char *string;
  struct string_list *next;
};

typedef struct string_list * STRING_LIST;

/* Used to store file names from command line, in main(). */
struct file_list {
  char *filen;
  struct file_list *next;
};

typedef struct file_list * FILE_LIST;

/* Used to evaluate #ifdef expressions token by token, in define_stack.c. */
struct if_token_list {
  enum stacking_token op;
  BOOL set, negate;
  struct if_token_list *prev;
};

typedef struct if_token_list * IF_TOKEN_LIST;

/* Everything the program has to know (outside of main() function) about
 * the arguments allowed in this program and whether or not to enable them.
 */
typedef struct {
  char *arg;			/* what user enters on command line */
  char *doc;			/* printed by help message  */
  BOOL available;		/* offered to users; set this to FALSE if option never used */
  BOOL on_by_default;		/* TRUE means enabled without having to be argument */
  BOOL standard_turns_on;	/* TRUE means enabled by -standard argument */
  BOOL actual_value;		/* value used during lexical analysis, set by main() */
} ARG_STRUCT;
