#!/bin/sh
#
#
# Copyright (c) 1990,1991, OPEN SOFTWARE FOUNDATION, INC.
# ALL RIGHTS RESERVED
# 
#   format-toc -- format a TOC from the info gleaned from book sync files
#
#   usage:  format-toc -n|-t|-x draft|publish [-Ttypesetter]
#
#   set -x

# set some defaults
whichFormatter=-t
outDir=publish
Form=pub
style=p
nopost=false
descFile=Description
verbose=false
doPrintOrder=false

while test $# != 0
do
    case $1 in
	-n)	whichFormatter=-n ;;
	-t)	whichFormatter=-t ;;
	-x)	whichFormatter=-x ;;
	-d)	outDir=draft
		Form=draft
		style=d
		;;
	-p)	outDir=publish
		Form=pub
		style=p
		;;
	-des*)	descFile=$2
		shift
		;;
	-out*)	OUTPUT=$2
		shift
		;;
	-libdir | -root)
		DTE_LIBDIR=$2
		shift
		;;
	-v)	verbose=true	;;
	-printorder)	doPrintOrder=true ;;

	-h*)	
		echo "usage: $0 [-n|-t|-x] [-d|-p] [-Ttypesetter] [-des DescriptFile] [-out OutputDir] [-libdir LibDir] [-help]"
		exit 0
		;;

	-T*)	TYPESETTER=`echo $1 | sed "s/-T//"`
		nopost=true
		;;

	-D*)	;;
    esac
    shift
done

if [ -z "$TROFF" ] ; then TROFF=troff ; fi
if [ -z "$NROFF" ] ; then NROFF=nroff ; fi
if [ -z "$TYPESETTER" ] ; then TYPESETTER=ps ; fi
if [ -z "$SYNC_DIR" ] ; then SYNC_DIR="Sync" ; fi

#if [ -r `which Where_DTE_Is` ]
#	then . `which Where_DTE_Is`
#		 Macros=$MACROBIN
#	else Macros=$DTE_LIBDIR/macros
#fi
Macros=$DTE_LIBDIR/macros

if [ "$style" = "d" ]; then
    Macs="-mm Headers/header.mm $Macros/draft-hdr.mm $Macros/draft-mmt+.mm \
		$Macros/headfoot.mm $Macros/draft.mac"
else
    Macs="$Macros/mmt $Macros/pub-hdr.mm Headers/header.mm $Macros/pub-mmt+.mm \
		$Macros/headfoot.mm"
fi

# must be last macro file loaded
if egrep '^##.*PARTS' $descFile >/dev/null ; then
    Macs="$Macs $Macros/parts.sml"
fi

# be tolerant of fonts loaded into the wrong place

if [ ! -d /usr/lib/font/dev$TYPESETTER -a -d /usr/local/lib/font ]; then
    LIB="-F/usr/local/lib/font"
else
    LIB=""
fi
if [ -z "$DTE_OUTFILTER" ] ; then DTE_OUTFILTER="eps $LIB" ; fi

if $doPrintOrder ; then
Pc=`sed -e '/^#/d' -e '/^$/d' $descFile | egrep FRONT | wc -l |
	awk '{printf "%03d.",$1+1}'`
fi

if [ "X$whichFormatter" = "X-n" ]; then
    formatter="$NROFF -Tlp -rN5 $nroffOptions $Macs -"
    outForm=ascii
    outFile=$OUTPUT/$outDir/$outForm/${Pc}toc
    outFilter="forward > $outFile"

elif [ "X$whichFormatter" = "X-t" ]; then
    formatter="$TROFF -T$TYPESETTER $LIB -rN5 $troffOptions -rO.625i $Macs -"
    outForm=$TYPESETTER
    outFile=$OUTPUT/$outDir/$outForm/${Pc}toc.$TYPESETTER
    if `$nopost` ; then
	outFilter="cat > $outFile"
    else
	outFilter="$DTE_OUTFILTER > $outFile"
    fi

elif [ "X$whichFormatter" = "X-x" ]; then
    formatter="$TROFF -Tps $LIB -rN5 $troffOptions -rO.625i $Macs -"
    outForm=dito
    outFile=$OUTPUT/$outDir/$outForm/${Pc}toc.x
    outFilter="cat > $outFile"
    whichFormatter=-t
fi

echo ""
echo "formatting table of contents ($outForm)"

syncFile=$style$whichFormatter
rm -f $SYNC_DIR/toc.$syncFile.not $SYNC_DIR/toc.$syncFile.tab $SYNC_DIR/toc.$syncFile.fig

FILES="$SYNC_DIR/$syncFile.???"

cat $FILES |
    sed -n 's/\!TOC: //p' |
	sed 's//\\ /g' |
	    grep -i '\.)T 1 1 "table' > $SYNC_DIR/toc.$syncFile.tab
		# NOTE: /bin/grep REQUIRES table with -i (NO caps allowed)

cat $FILES |
    sed -n 's/\!TOC: //p' |
	sed 's//\\ /g' |
	    grep -i '\.)T 1 1 "figure' > $SYNC_DIR/toc.$syncFile.fig

cat $FILES |
    sed -n 's/\!TOC: //p' |
	sed 's//\\ /g' |
	    grep -i -v '\.)T 1 1 "table' |
	    # table was TABLE
		grep -i -v '\.)T 1 1 "figure' > $SYNC_DIR/toc.$syncFile.not
		    # figure was Figure

rm -f $outFile
(cat $Macros/toc-pre.mm \
	$SYNC_DIR/toc.$syncFile.not $Macros/toc-middle.mm \
	$SYNC_DIR/toc.$syncFile.tab $SYNC_DIR/toc.$syncFile.fig \
	$Macros/toc-post1.mm
 
    # if not 0 change .nr for TABLES so don't get empty printed page
    if [ -s $SYNC_DIR/toc.$syncFile.tab ]
    then 
	echo '.nr !1 1' 
    fi 

    # if not 0 change .nr for FIGURES so don't get empty printed page
    if [ -s $SYNC_DIR/toc.$syncFile.fig ]
    then 
	echo '.nr !0 1'
    fi 

    cat $Macros/toc-post2.mm ) |
	eval "$formatter" | eval "$outFilter"

