...\" 
...\" @OSF_COPYRIGHT@
...\" 
...\" HISTORY
...\" $Log: dte_build.sml,v $
...\" Revision 1.1.2.8  1992/05/07  15:12:28  rcb
...\" 	new "Changes to the DTE" material from fred
...\" 	[1992/05/07  15:09:57  rcb]
...\"
...\" Revision 1.1.2.7  1992/04/30  19:48:38  rcb
...\" 	changes from John Bowe review
...\" 	[1992/04/30  19:48:09  rcb]
...\" 
...\" Revision 1.1.2.6  1992/04/29  18:10:56  rcb
...\" 	fixed something I did wrong
...\" 	[1992/04/29  18:10:38  rcb]
...\" 
...\" Revision 1.1.2.5  1992/04/29  17:17:51  rcb
...\" 	changes from John Bowe review
...\" 	[1992/04/29  17:17:32  rcb]
...\" 
...\" Revision 1.1.2.4  1992/04/27  12:46:49  rcb
...\" 	no change
...\" 	[1992/04/09  18:53:15  rcb]
...\" 
...\" 	first pass at Release 1.1 version
...\" 	[1992/04/09  17:07:53  rcb]
...\" 
...\" Revision 1.1.2.3  1991/09/19  09:21:37  rcb
...\" 	changed Documentors Workbench to uppercase, added TM
...\" 	[91/09/16  10:36:33  rcb]
...\" 
...\" Revision 1.1.2.2  91/09/11  09:16:43  rcb
...\" 	Additional changes from John Bowe, in paralell with ch4.sml of Release Notes
...\" 	[91/09/03  11:50:37  rcb]
...\" 
...\" 	Updated, coordinated with ch4.sml of release notes
...\" 	[91/08/29  13:37:39  rcb]
...\" 
...\" 	moved to this directory
...\" 	[91/08/29  11:53:15  rcb]
...\" 
...\" 	created from R1.1 S1 version; noted that prepend-so is now run automatically by install-refpages
...\" 	[91/08/29  10:44:59  rcb]
...\" 
...\" $EndLog$
...\" 
.if t .ds tM \(tm
.if n .ds tM (TM)
.if t .ds rG \(rg
.if n .ds rG (R)
...\"
...\"
.H 1 "Building the DTE"
.P
The Documentation Tools Environment package, or DTE, includes 
source code files from which the various tools are built, and source
files from which the DTE documentation is built.
The DTE can be used to build and rebuild all OSF the documentation.
This documents contains requirements and instructions for building the 
DTE so that it can be used on your system.
.P
Depending on the manner in which you obtained the DTE package, its
location on your system may vary.  
In the discussions that follow, \*Vdte-dir\*O represents the base pathname
at which the DTE tree has been loaded on your system.  (\*Vdte-dir\*O
can represent any number of actual directory levels.)  On a DTE distribution
tape, the highest-level directory is \*LDTE\*O; thus \*Vdte-dir\*L/DTE\*O 
would represent the pathname of the DTE package once it has been loaded onto 
your system, and this designation has been used throughout this
document.  If you have installed the DTE from some other source, however,
the pathname may be different; if you received the DTE as part of an OSF/1
release tape, for example, the highest directory level would be:
.iS
/\*Vosf-build-dir/\*Losf1/V1.1/doc
.iE
where \*L/\*Vosf-build-dir\*O is the directory at which the distribution
tape was loaded onto your system.  In the following pages, substitute the 
appropriate pathname on your system for \*Vdte-dir\*L/DTE\*O.
.P
The \*VDTE User's Guide\*O, located in \*Vdte-dir/\*LDTE/dte.gd\*O
in the DTE distribution tree (and elsewhere on the various OSF offering
distributions), is not built when the DTE is installed; however,
PostScript output versions of these documents are included in the tree.
You may rebuild these documents with the DTE tools after you have built
the tools.  For further information, see \*LBuilding the DTE User's
Guide\*O below.
.nS note
For a description of changes made to this version of the DTE which
are not documented in the \*VDTE User's Guide\*O, see the section 1.6, 
\*LLatest Changes in the DTE\*O.
.nE
.H 2 "Requirements for Building"
.P
To build the documentation, you must have unloaded 
the DTE tree from your tape.
Approximately 3.5 megabytes of free local storage are required to transfer the 
DTE source and output files from the tape and to build the DTE tools.
.P
The DTE requires the UNIX system commands provided by the
DOCUMENTOR'S WORKBENCH\(tm package (Version 2.0 or later), including
\*Leps\*O (the device-independent \*Ltroff\*O 
Postscript filter supplied with Elan's DWB
package) or equivalent (the name may be different).
You must also have available the \*Lmm\*O and \*Lman\*O maco packages,
which are used by the DTE in conjunction with OSF's own customized
macros, found in /\*Vosf-build-dir/\*Losf1/V1.1/doc/tools/src/macros\*O.
.P
.nS note
\*LIf you are installing a new version of the DTE over an 
older version, please read the section below entitled "Re-running 
make".\*O
.nE
.H 2 "Building the DTE"
.nS "note"
In order for you to build PostScript\*(tM versions of the documentation,
your system must have the appropriate PostScript\*(tM text-processing
utilities.
.nE
.P
In the discussions that follow, it is assumed that the DTE tree has
been loaded at the pathname \*Vdte-dir\*O on your system, and that the
highest level in the DTE tree is called \*LDTE\*O, as on the DTE distribution
tape.  However, this directory may be different on your system.
.AL
.LI
The following directory should have been loaded 
from the tape:
.iS
\*Vdte-dir/\*LDTE\*O
.iE
.P
and the \*LDTE\*O directory contains the following files and
directories:
.iS
...\" \*Vdte-dir/\*LDTE/dten.gpsml\*O (source file for this document)
...\" \*Vdte-dir/\*LDTE/dten.ps\*O (PostScript version)
...\" \*Vdte-dir/\*LDTE/dten.asc\*O (ASCII version)
\*Vdte-dir/\*LDTE/README\*O
...\" \*Vdte-dir/\*LDTE/FIXES\*O (List of fixes and changes to this version)
\*Vdte-dir/\*LDTE/tools\*O (The DTE tree)
\*Vdte-dir/\*LDTE/dte.gd\*O (\*VDTE User's Guide\*L)
.iE
.P
where \*Vdte-dir\*O is the directory where the DTE image 
has been loaded.
.LI
Before installing the DTE, please read the \*LPossible Problems\*O section
to see if you need to modify any files to accommodate your particular system.
.LI
To perform the actual installation, type the following
command lines:
.iS
\*Lcd\*V dte-dir/\*LDTE/tools/src\*O
\*Lmake TOP=\*Vdte-dir\*L/DTE/tools MACHINE=\(gamachine\(ga install\*O
.iE
.P
The rest of the line should be typed exactly as it appears above.
The output from \*Lmachine\*O, which is substituted into the command line
by the backquotes, enables \*Lmake\*O to find out what your
machine-dependent subdirectory in \*Vdte-dir/\*LDTE/tools/bin\*O 
is called; this is where the machine-dependent executable files 
will be installed.
.P
If your system does not have the \*Lmachine\*O command (you can test
this by simply typing \*Lmachine\*O in the shell), then
replace \*L\(gamachine\(ga\*O with a constant such as \*Lmbin\*O.
.P
There should be no errors reported by \*Lmake\*O as it does the install.
.LI
To use the tools, you must set the \*LDTE_LIBDIR\*O environment variable
to:
.iS
\*Vdte-dir\*L/DTE/tools/libdata
.iE
and add the following directory to your search path:
.P
The directory that must be added is:
.iS
\*Vdte-dir/\*LDTE/tools/bin/`machine`
.iE
Again, if you do not have the \*Lmachine\*O command on your system, use
the appropriate constant as described above.
.LI
To make sure that the directory has been added to your search
path, you can now type the following:
.iS
\*Lbook-format -help\*O
.iE
which should display a summary of \*Lbook-format\*O usage.
.P
To make sure that the \*LDTE_LIBDIR\*O environment variable has been correctly
set, type:
.iS
\*Lecho $DTE_LIBDIR\*O
.iE
.LI
You can now use the DTE tools.  For example, to try \*Lbook-format\*O,
just \*Lcd\*O to the directory containing the Description file for the book you 
want to process:
.iS
\*Lcd \*Vbook_directory\*O
.iE
.P
where \*Vbook_directory\*O is the name of the directory containing
the Description file of the book you want to build.  For example, you could try
building part of the \*VDTE User's Guide\*O which is included as part of the DTE
package at \*Vdte-dir/\*LDTE/dte.gd\*O.  For further information on how to
do this, see the \*LBuilding the DTE User's Guide\*O section below.
.LI
Then, to test \*Lbook-format\*O, type the following:
.iS
\*Lbook-format -t all\*O
.iE
You should get the following messages from \*Lbook-format:
.iS
\*CDoing draft formatting into PostScript

formatting body \*Vchapter_file\*C (mm) for ps;  part \*Vnnn\*C of \*Vmmm\*O
.iE
.P
If you get an error like the following:
.iS
\*CDoing draft formatting into PostScript

can't find file ./macros/sync-pre.mm\*O
.iE
.P
then you have not set the \*LDTE_LIBDIR\*O environment
variable correctly; refer to step 4 above.
...\" .P
...\" If you get an error like the following:
...\" .iS
...\" \*Cformatting body \*Vfile_or_directory\*C (man) for ps;  part 11 of 12
...\" Cannot open pattern-file: no
...\" \*Vdte-dir\*C/DTE/tools/bin/fix-man: 
...\" no fixTable.ex in .  \*Vdte-dir\*C/DTE/tools/bin \*O
...\" .iE
...\" then some of the files in \*Vdte-dir\*L/DTE/tools/bin\*O and
...\" \*Vdte-dir\*L/DTE/tools/\*Vmachine\*O probably do not have their execute
...\" permission on; see step 6 above.
...\"
.H 3 "Example"
...\"
.P
Suppose the unbuilt DTE (that is, the \*LDTE\*O tree) has been loaded onto
your system at the pathname:
.iS
\*Vdte-dir\*L/DTE\*O
.iE
.P
Now go to the \*Vdte-dir/\*LDTE/tools/src\*O directory and run \*Lmake\*O to
install the DTE by typing:
.iS
\*Lcd \*Vdte-dir\*L/DTE/tools/src\*O
\*Lmake TOP=\*Vdte-dir\*L/DTE/tools MACHINE=\(gamachine\(ga install\*O
.iE
.P
Note again that if your system does not have the \*Lmachine\*O
command, you should replace \*L\(gamachine\(ga\*O with a constant
such as \*Lmbin\*O; see step 3 above.
.P
After the installation, you should define the \*LDTE_LIBDIR\*O environment
variable and update your search path so that you can use the
newly-built tools:
.iS
\*Lsetenv DTE_LIBDIR \*Vdte-dir\*L/DTE/tools/libdata
set path=(\*Vdte-dir\*L/DTE/tools/bin/\(gamachine\(ga $path)\*O
.iE
.H 3 "Possible Problems"
.P
This section contains information to help you avoid
difficulties that may occur in installing the DTE.
.H 4 "Environment Variables"
...\"
...\".nS "Note"
...\"You should make these changes, if they are necessary, before 
...\"building the DTE.
...\".nE
.P
The DTE tools use a set of environment variables to refer to
various programs which they call to perform pre- and postprocessing
tasks.  These programs can have different names on different systems;
for example, \*Ltroff\*O might be called \*Lditroff\*O.
.P
If your system's versions of these programs have names different
from the ones that the DTE tools expect them to have, you will
have to change the value(s) of the environment variable(s).
.P
You should also add any changes that you make to these variables
to your appropriate startup shell profile
file, in order to make these directories a permanent part of your search path.
.P
Following is a list of the environment variables you may have to
change.
.VL 1.5i
.LI "\*LEQN\*O"
Refers to the \*Ltroff\*O version of the mathematical expression
preprocessor used on your system. 
.LI "\*LNEQN\*O"
Refers to the \*Lnroff\*O version of the mathematical expression
preprocessor used on your system.  
.LI "\*LTROFF\*O"
Refers to the \*Ltroff\*O used on your system.  
.LI "\*LDTE_OUTFILTER\*O"
Refers to the PostScript postprocessor used on your system.  
.LI "\*LTYPESETTER\*O"
Refers to the PostScript typesetter used on your system. 
.LE
.H 2 "Location of Makefiles"
The following list tells where to find the \*LMakefiles\*O 
and within the \*Vdte-dir\*L/DTE/tools\*O tree.
.ML
.LI
\*Vdte-dir\*L/DTE/tools/src\*O
.LI
\*Vdte-dir\*L/DTE/tools/src/dte\*O
.LI
\*Vdte-dir\*L/DTE/tools/src/glossary\*O
.LI
\*Vdte-dir\*L/DTE/tools/src/installref\*O
.LI
\*Vdte-dir\*L/DTE/tools/src/macros\*O
.LI
\*Vdte-dir\*L/DTE/tools/src/sml\*O
.LE
.H 2 "Building the DTE User's Guide"
.P
Printable PostScript versions of the \*VDTE User's Guide\*O chapters
can be found in \*Vdte-dir/\*LDTE/dte.gd/Output/draft/ps\*O; ASCII
versions of these files are in
\*Vdte-dir/\*LDTE/dte.gd/Output/draft/ascii\*O.
.P
Further information can be found in the \*VDTE User's Guide\*O itself, and in
the reference page for \*Lbook-format\*O, which is located in
\*Vdte-dir/\*LDTE/tools/man/man1\*O (once you have built the DTE).
.H 3 "To Rebuild the Entire Book in PostScript"
.P
To rebuild the book, follow these steps:
.iS
\*Lcd \*Vdte-dir/\*LDTE/dte.gd\*O
.iE
.P
and then:
.iS
\*Lbook-format -t all\*O
.iE
to rebuild the PostScript output version, or:
.iS
\*Lbook-format -n all\*O
.iE
to rebuild the ASCII version.
.H 3 "To Remove the Old Output Files"
.P
You should do this only if you want to replace the output (i.e.,
PostScript or ASCII) files with rebuilt versions.  The following
commands will remove \*Vall\*O the output files:
.iS
\*Lcd \*Vdte-dir/\*LDTE/dte.gd\*O
\*Lrm -r Output\*O
\*Lrm -r Sync\*O
.iE
.P
Note that the \*LSync\*O directory contains
intermediate information used by
\*Lbook-format\*O to track individual pieces of the book as they are
built separately, so you
should not delete \*LSync\*O unless you plan to replace it immediately
by invoking \*Lbook-format all\*O.
.H 3 "To Rebuild a Part of the Book"
.P
To rebuild only a part of the \*VDTE User's Guide\*O, follow these steps:
.iS
\*Lcd \*Vdte-dir/\*LDTE/dte.gd\*O
\*Lbook-format \*Vpart_of_book\*O
.iE
.P
where \*Vpart_of_book\*O is the part of the book you want to rebuild;
the names of the book's parts come from the left-hand column of the book's
Description file (they are \*Vnot\*O necessarily the names of the source files).
For further information, see the \*VDTE User's Guide\*O.
.P
If the \*LSync\*O directory or any of its contents have been removed since the
last \*Lbook-format -all\*O, a single book part may not format properly.
.H 2 "Continuous Width Font Specifier"
.P
Different versions of the Documenter's Workbench may require the constant width
(i.e., typewriter) font to be specified in different ways.  The Elan package used
at Open Software Foundation expects a \*L\\f(CW\*O specifier; other software has
been observed to expect \*L\\fC\*O.
.P
Things being as they are, constant width font is requested in source in
more than one way.  In books' front matter, which is coded in non-SML, the
primitive codes \*L\\f(CW\*O and \*L\\fC\*O occur.  The
SML versions of these, \*L\\*C\*O and \*L\\*(CW\*O, may also be present.  The
other parts of the books should use SML codes only.  These consist of the
primitives (again, \*L\\*C\*O or \*L\\*(CW\*O), as well as those SML macros
which implicitly request constant width font\(em the \*L.oS/.oE\*O pair,
for example.
.P
If your system expects a constant width specifier different from the one
used in a book's source, you will quickly find out: \*Lbook-format\*O will
display an error message when it encounters the specifier and, under some
circumstances, a core dump may occur.  If this happens with a book you
are trying to format, do the following:
.VL 2.5i
.LI "Change\ primitives\ in\ source"
Change all instances of the incorrect \*Ltroff\*O primitive to the form
that is correct for your Documenter's Workbench software.  As mentioned
above, these instances will probably all be in the book's front matter
source files.
.LI "Edit\ the\ \*Lheader.all\*O\ macro"
To correct places where constant width is requested by the SML macros,
you should edit the \*Lheader.all\*O macro file, as described below.
.LE
.P
The file \*Vdte-dir/\*LDTE/tools/macros/header.all\*O contains the following:
.oS
\&...\\"
\&...\\" Copyright (c) 1991, OPEN SOFTWARE FOUNDATION, INC.
\&...\\" ALL RIGHTS RESERVED
\&...\\"
\&...\\"
\&...\\" header.all  --  header information for ALL formatting
\&...\\"
\&...\\"
\&...\\" this file contains definitions of a very general nature.
\&...\\" The intention is to define items that might get redefined
\&...\\" under a different DWB, or provide global definitions.
\&...\\"
\&...\\"
\&...\\"
\&...\\" define the constant width font.  Instead of asking explicitly
\&...\\" for C or CW, everyone (in the macro packages) should use the
\&...\\" string !) instead.
\&...\\"
\&.ds !) CW\"  here, we use CW.  use this one in .ft \*(!) expressions
\&.ds !] (CW\" use this one in \f\*(!] expressions
.oE
.P
The two lines beginning \*L.ds\*O make \*L\\*(CW\*O the DTE's expected 
specifier 
for continuous-width font.  If you wish to change this to something else to
suit the font name on your system, substitute your specifier for the \*LCW\*O.
For example, to make \*L\\*C\*O the specifier, change the lines so that they
read:
.oS
\&.ds !) C\"  here, we use CW.  use this one in .ft \*(!) expressions
\&.ds !] C\" use this one in \f\*(!] expressions
.oE
.P
Note especially the change in the second definition: the open parenthesis
should be deleted if it is followed by a one-character specifier.
.H 2 "Latest Changes to the DTE"
.P
This section consists of brief descriptions of important changes in this
version of the DTE which were completed too late to be documented in the
\*VDTE User's Guide\*O.
...\" ========================= NEW MATERIAL FROM FRED 5/7/92
.ML
.LI
Changes to the Note Start and End macros (\*L.nS\*O and \*L.nE\*O)
.P
These macros are now available in RSML as well as in GPSML.
.P
The \*L.nS\*O macro continues to take a keyword that describes the kind of
note
(supported keywords are \*Lwarning\*O, \*Lcaution\*O, and \*Lreviewnote\*O).
If the argument to the .nS macro is
.eM not
one of the known keywords, then the argument will be used as a banner
for this note, allowing author creation of new note types.
.LI
Checks for termination of lists.
.P
The RSML macros now check whether lists have been terminated by the time a
new section (\*L.TH\*O, \*L.SH\*O, or \*L.SS\*O) begins.
If not, the lists are automatically terminated (as before) during formatting,
but a new warning message is printed.
.LI
Index grouping of symbol characters
.P
Index items that start with non-alphabetic characters are now
grouped together at the front of the index under a \*LSymbols\*O banner.
.LI
Page running header and footer styles
.P
All pages of a book, including the
glossary and index,
now get a consistent page header and footer style.
Left and right pages are now symmetrical,
providing a more balanced appearance,
particularly in books with parts (the \*L.pA\*O macro).
.LI
The table of contents
.P
The glossary and index now appear in the table of contents.
.LI
The \*Ldmm\*O and \*Ldman\*O commands
.P
These commands now produce an appearance that is more consistent with
formatting outside of a book context.
For example, page numbering style is not \*Vsection\*O-\*Vpage\*O,
but plain \*Vpage\*O.
.P
\*Ldman\*O is still suitable for use when doing production work
(ie, the page and line lengths, fonts, and point sizes are still consistent
with \*Lbook-format\*O).
.LI
Line spacing in RSML
.P
A bug was fixed in RSML that sometimes caused too little vertical white space
between different document elements
(eg, between a list and a paragraph).
.LI
Outdenting of output regions
.P
The \*L.oS\*O macro now takes an optional argument that,
if present
(any text at all \*(EM it doesn't look at the content of the
argument, just for its presence),
will cause the output region to be placed at the leftmost margin,
eliminating the need for an author to set the indent explicitly.
.LI
The constant width font
.P
The constant width font
(eg, used by the \*L.oS\*O macro)
has been made a little more compact by reducing the kerning.
This also allows a little more constant width text to fit between the
margins of a document
(viz, 72 characters from the standard indent to the right margin,
and 78 characters from the leftmost margin to the right margin).
...\" ===================== END NEW MATERIAL
.H 3 "Part Divisions for Formatted Books"
...\"
.P
Books can now be formatted into separate parts.  Parts can be realized in
either of two different ways, each of which is described below.
.H 4 "Parts With Chapters"
...\"
.P
You can specify part divisions (in addition to chapters) for any
DTE-formatted book.  The parts are shown in the Table of Contents for
the formatted book.  In addition, the part title is shown at the top
of every left-hand page; the book's title then appears at the bottom
of every right-hand page.  The book's chapters become subordinate to
the part in which they appear.
.P
There are two parts (as it were) to specifying this kind of formatting
for a book:
.ML
.LI
Source code markup
.P
At the spot in the book's source code where you want the part to begin,
the following line should appear:
.iS
\&.pA "\*Vpart number\*L" "\*VPart Title\*L"
.iE
.P
This line can be anywhere in the source files that precedes the first
chapter of the new part, and follows the last chapter of the last (if
any) part.  We recommend that a separate file be created to contain
only this line; this makes it easy to insert a new first chapter into
the part, if necessary.  Note that the \*L.pA\*O command does \*Vnot\*O
generate a part page.  If you want such a page, you must write the source
code for it yourself.  This code and the \*L.pA\*O line could then be
contained together in a separate part page source file.
.LI
Description file keyword
.P
Besides coding the \*L.pA\*O command in your book's source, you must also
put the following line somewhere in the book's Description file:
.oS
## PARTS
.oE
.P
This line can appear anywhere in the Description file; the convention
 at OSF is to place it (with other options lines) at the end.
.LE
.H 4 "Parts Instead of Chapters"
...\"
.P
For books such as reference manuals, where chapter division is not desired,
but parts are, an option is available to replace the chapters with parts
in the formatted book.  The result is that what would ordinarily appear as
chapters in the book's formatted Table of Contents are now called "Parts"
there. 
.P
To activate this option, you must put the following line somewhere in
the book's Description file:
.oS
## CHAPTERPARTS
.oE
.P
This line can appear anywhere in the Description file; the standard
practice at OSF is to place it (with other options lines) at the end.
.P
This option allows you to format a book \*Vwith\*O parts, but \*Vwithout\*O
separate part pages: in this case, the source files for the book can
be identical to the chapter files for an "ordinary"
book, and no special coding will be required.  However, if separate
part pages are used, then some special coding is required to make sure
that headers and footers do not appear on the formatted page and that
pagination is correct.  As always, separate part pages have to be explicitly
coded in the SML source.
.P
For example, suppose you want to divide a reference manual into parts,
with separate part pages to mark the divisions within the book.  The
Description file for such a manual, divided into four parts, would
look something like the following, where \*Lp1.gpsml\*O, \*Lp2.gpsml\*O,
etc., are the source files for the part pages:
.oS
title	gpsml	FRONT frontmatter/title.gpsml
copy	gpsml	FRONT frontmatter/copyright.gpsml
pref	gpsml	PREFACE frontmatter/preface.gpsml
part1	gpsml	FRONT p1.gpsml
p1.a	rsml	man1/a.rsml
p1.b	rsml	man1/b.rsml
part2	gpsml	FRONT p2.gpsml
p2.d	rsml	man2/d.rsml
p2.e	rsml	man2/e.rsml
part3	gpsml	FRONT p3.gpsml
p3.m	rsml	man3/m.rsml
p3.n	rsml	man3/n.rsml
part4	gpsml	FRONT p4.gpsml
p4.x	rsml	man4/x.rsml
p4.y	rsml	man4/y.rsml
## NO GLOSSARY
## CHAPTERPARTS
## OSFHEADS
.oE
.P
The important thing to note is the \*LFRONT\*O keyword in front of
each part page source file.  \*LFRONT\*O is necessary to prevent
headers and footers.  A typical part page (source, of course) might
look like the following:
.oS
\&...\\" Copyright 1991, Open Software Foundation, Inc.  ALL RIGHTS RESERVED.
\&...\\"*********************************************************************
\&.ad l	\\"*** Sets left justification
\&.PH ""	\\"*** Prevent page header
\&.PF ""	\\"*** Prevents page footer
\&...\\"*********************************************************************
\&...\\"          Enter the title of the book:
\&...\\"*********************************************************************
\&.S 20
\&.SP 1.5i
\&.H 1 "Some RPC Commands"
\&...\\"*********************************************************************
\&...\\"          Enter the book's revision number
\&.ad b	\\"*** Resets justification
.oE
.H 3 "OSF Manpage Headers"
.P
The DTE's default behavior in formatting reference manuals is to construct
the reference page header from the current chapter title.  
As an alternative, you
can specify that the header should \*Valways\*O be the string
\*LOpen Software Foundation\*O, or \*LOSF\*O if the reference page name is too
long to allow the full header string to be accommodated.  Use of this option is
recommended only if you have \*Vvery\*O long reference page names, or extremely
long chapter titles.
.P
To activate this option you must put the following line somewhere in
the book's Description file:
.oS
## OSFHEADS
.oE
.P
This line can appear anywhere in the Description file; the standard
practice at OSF is to place it (with other options lines) at the end.
.H 3 "Indenting of Notes"
.P
The \*L.nS/.nE\*O macro pair will now format the note text with both a
left and a right margin equal to the width of the note label.  The label
itself is flush with the current left margin.
.H 3 "Default Settings in Display Regions"
.P
The current default page widths (the, number of characters on a line 
in PostScript output) for \*L\&.oS/.oE\*O regions are:
.VL
.LI "Draft, text area:"
66 characters (from the scanning column indent)
.LI "Draft, live area:"
72 characters (from the left margin)
.LI "Publish, text area:"
56 characters
.LI "Publish, live area:"
66 characters
.LE
.P
Tab stops in \*L\&.oS/.oE\*O and \*L\&.iS/.iE\*O are now 8 columns apart.
.H 3 "Index Generation
Various changes have been made to Index generation:
.VL
.LI
\*VSee\*O and \*VSee Also\*O now appear in the italic font
.LI
Non-alphabetics now sort to the top of the index
.LI
Indent positions for wrapping (long) items have been changed
.LI
Non-hyphenating dashes are now used for page numbers (a change which has been
implemented throughout the macro packages)
.LE
.H 3 "Miscellaneous Changes"
.VL
.LI
The \*L\&.LE\*O macro now resets the indent to the proper place to allow
following text to line up with the previous indent.
.LI
The \*L\&.VL\*O macro in GPSML now has a default argument (\*L1i\*O), 
to match the \*L\&.VL\*O default in RSML.
.LI
The definition of the \*L\&.gL\*O macro has been removed
from the \*Lsml\*O macro file (because it is already defined elsewhere).
Other unneeded definitions have been removed from \*Lglossary.mm\*O (iX, etc).
.LI
UNNUMBERED sections now generate the "Chapter #" prefix in the TOC.
Indentations of sections in UNNUMBERED TOCs are now every 1/2 inch,
rather than the width of the maximum prefix.
.LE
.H 2 "The prepend-so Utility"
.nS note
If you have used the \*Linstallref\*O utility to install the OSF/1
reference pages on your system, you do not need to use \*Lprepend-so\*O
as described below.
.P
The presence of SML code, which requires the presence of OSF's RSML
macros in order to be formatted, will prevent reference page files being
usable with a standard \*Lman\*O command.
.P
However, a small utility called \*Lprepend-so\*O, which is included
as part of the DTE, will insert an \*L.so\*O request at the top
of specified reference page files, of the form:
.iS
\&.so /path/to/macro/files/rsml
.iE
.P
Whenever a reference page is formatted by \*Lman\*O, the macro definitions 
are read into the input stream, and all necessary macros are
present.  In the installed DTE, these macro definitions are found 
in the files:
.oS
\*Vdte-dir\*C/DTE/tools/libdata/macros/sml
.oE
.P
and
.oS
\*Vdte-dir\*C/DTE/tools/libdata/macros/rsml
.oE
.P
Once the reference page files have been processed in this
way, the macro directories themselves cannot be moved.  OSF
recommends putting a copy of the appropriate SML/RSML macros in a
place like
.oS
/usr/share/lib/macros
.oE
.P
or
.oS
/usr/lib/macros
.oE
.P
which will ensure that they are in the same filesystem as the
reference pages themselves (which should be in \*L/usr/share/man\*O or
\*L/usr/man\*O), and so will remain in the same location relative to 
them.  \*Lprepend-so\*O checks for the existence of pathnames specified
with \*L-so\*O; non-existence of a pathname is a fatal error.
.P
Note that the \*Lprepend-so\*O utility is \*Vautomatically executed by the
\*Linstall-ref\*V script, provided with OSF/1 snapshots and releases\*O.
(See Chapter 4 of the \*VOSF/1 Snapshot and Release Notes\*O for information
about \*Linstall-refpages\*O).  Use the following instructions only if you
have determined that \*Lprepend-so\*O has not already been run on your system
by \*Vinstall-refpages\*O.
.H 3 "Using `prepend-so'"
.P
The \*Lprepend-so\*O utility can be used, if the DTE is installed,
by simply typing its name followed by various flags and arguments.
The pathname of the RSML macros is one of the arguments you provide.
\*Lprepend-so\*O will process files whose names are given on the command
line, or it will process the input stream (\*Lstdin\*O), sending output to
\*Lstdout\*O.  Following is an explanation of the flags and arguments.
.P
.iS
prepend-so  [-so  \*Vmacfile\*L] ... [\*Vfile\*L] ...
.iE
.P
.VL 2i
.LI "\*L-so\*O\  <\*Vmacfile\*O>"
Pathname of file to \*L.so\*O at top of man files.  More than one 
\*L-so <\*Vmacfile\*L>\*O may be specified; multiple arguments should be
specified in the order you want them included.
.LI "[\*Vfile\*O]"
Man page file(s) to process.  Wildcards can be used; see \*LExamples\*O
below.
.LI "\*L-v\*O"
Verbose mode: show filenames of files as they are processed.
.LI "\*L-help\*O"
Display a help message.
.LE
.H 3 "Example"
.iS
prepend-so  -so  /local/macros/file1  -so  /local/macros/file2 < prog.man > prog.1
.iE
.P
Reads in the file \*Lprog.man\*O, inserts the following lines at its top:
.oS
\&.so /local/macros/file1
\&.so /local/macros/file2
.oE
and writes the resulting new file to \*Lprog.1\*O.
.H 3 "Example"
.iS
prepend-so  -so  /local/macros/file1  progA.1  progB.1
.iE
.P
Reads in the files \*LprogA.1\*O and \*LprogB.1\*O successively, and inserts the
following line at the top of each:
.oS
\&.so /local/macros/file1
.oE
