/* 
 * (c) Copyright 1989, 1990, 1991, 1992, 1993 OPEN SOFTWARE FOUNDATION, INC. 
 * ALL RIGHTS RESERVED 
*/ 
/* 
 * Motif Release 1.2.2
*/ 
#ifdef REV_INFO
#ifndef lint
static char rcsid[] = "$RCSfile: UniqueEvnt.c,v $ $Revision: 1.7.6.2 $ $Date: 92/11/09 22:36:53 $"
#endif
#endif
/*
*  (c) Copyright 1987, 1988, 1989, 1990, 1991, 1992 HEWLETT-PACKARD COMPANY */
#include <Xm/XmP.h>
#include <limits.h>

#define XmCHECK_UNIQUENESS 1
#define XmRECORD_EVENT     2


/********    Static Function Declarations    ********/
#ifdef _NO_PROTO

static Time ExtractTime() ;
static Boolean ManipulateEvent() ;

#else

static Time ExtractTime( 
                        XEvent *event) ;
static Boolean ManipulateEvent( 
                        XEvent *event,
                        int action) ;

#endif /* _NO_PROTO */
/********    End Static Function Declarations    ********/


/************************************************************************
 *
 *  _XwExtractTime
 *     Extract the time field from the event structure.
 *
 ************************************************************************/
static Time 
#ifdef _NO_PROTO
ExtractTime( event )
        XEvent *event ;
#else
ExtractTime(
        XEvent *event )
#endif /* _NO_PROTO */
{
   if ((event->type == ButtonPress) || (event->type == ButtonRelease))
      return (event->xbutton.time);

   if ((event->type == KeyPress) || (event->type == KeyRelease))
      return (event->xkey.time);

   return ((Time) 0);
}

static Boolean
#ifdef _NO_PROTO
Later(recorded, new_l)
     unsigned long recorded, new_l;
#else
Later(unsigned long recorded,
      unsigned long new_l)
#endif /* _NO_PROTO */
{
  long normalizedNew;

  /* The pathogenic cases for this calculation involve numbers
     very close to 0 or ULONG_MAX.  

     So the way we do it is by normalizing to 0 (signed).  That
     way the differences are +/- in the appropriate way.
     
     These numbers are defined as a unsigned long.  Please 
     remember that when changing this code.
     */

  normalizedNew = new_l - recorded;

  return (normalizedNew > 0);
}

static Boolean 
#ifdef _NO_PROTO
ManipulateEvent( event, action )
        XEvent *event ;
        int action ;
#else
ManipulateEvent(
        XEvent *event,
        int action )
#endif /* _NO_PROTO */
{
   static unsigned long serial = 0;
   static Time time = 0;
   static int type = 0;

   switch (action)
   {
      case XmCHECK_UNIQUENESS:
      {
	/*
	 * Ignore duplicate events, caused by an event being dispatched
	 * to both the focus widget and the spring-loaded widget, where
	 * these map to the same widget (menus).
	 * Also, ignore an event which has already been processed by
	 * another menu component.
	 * 
	 * Changed D.Rand 6/26/92 Discussion:
	 *
	 * This used to be done by making an exact comparison with
	 * a recorded event.  But there are many times when we can
	 * get an event,  but not the original event.  This cuts
	 * down on some distributed processing in the menu
	 * system.  
	 *
	 * So now we compare the serial number of the 
	 * examined event against the recorded event.  This needs
	 * to be done carefully to include the case where the
	 * serial number wraps
	 *
	 * 7/23/92 added discussion:
	 *
	 * The other case we must be careful of is when the serial
	 * number are the same.  This can only realistically occur
	 * if the user is very fast and therefore clicks while no
	 * protocol request occurs.  XSentEvent would cause an
	 * increment,  so we needn't worry over synthetic events
	 * causing problems.  
	 *
	 * So if the serial numbers match,  we use the timestamps
	 *
	 */

	if (Later(serial, event->xany.serial) 
	    || (serial == event->xany.serial &&
		Later(time, event->xbutton.time)))
	  return (TRUE);
	else
	  return (FALSE);
      }

      case XmRECORD_EVENT:
      {
         /* Save the fingerprints for the new event */
         type = event->type;
         serial = event->xany.serial;
         time = ExtractTime(event);

         return (TRUE);
      }

      default:
      {
         return (FALSE);
      }
   }
}


/*
 * Check to see if this event has already been processed.
 */
Boolean 
#ifdef _NO_PROTO
_XmIsEventUnique( event )
        XEvent *event ;
#else
_XmIsEventUnique(
        XEvent *event )
#endif /* _NO_PROTO */
{
   return (ManipulateEvent (event, XmCHECK_UNIQUENESS));
}



/*
 * Record the specified event, so that it will not be reprocessed.
 */
void 
#ifdef _NO_PROTO
_XmRecordEvent( event )
        XEvent *event ;
#else
_XmRecordEvent(
        XEvent *event )
#endif /* _NO_PROTO */
{
   ManipulateEvent (event, XmRECORD_EVENT);
}
