...\" **
...\" **
...\" **  (c) Copyright 1991, 1992 by Open Software Foundation, Inc.
...\" **      All Rights Reserved.
...\" **
...\" **  (c) Copyright 1987, 1988 by Digital Equipment Corporation,
...\" **      Maynard, MA.  All Rights Reserved.
...\" **
...\" **
.TH WML 5X
...\" ______________ start of SML macros ______________
.ds !) CW
.ds !] (CW
.cs \*(!) 20
.bd \*(!) 2
.ds |A Chapter
.nr |P 0
.nr |D 1
.deaS
..
.deaE
..
.deoS
.SP
.ps -1
.ft \\*(!)
.nf
.nr !x 8*\\w'0'
.ta \\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu
.if\\n(.$>0 .in 0
..
.deoE
.ps +1
.ft R
.fi
.SP
..
.deiS
.SP
.ps -1
.ft B
.nf
..
.deiE
.ps +1
.ft R
.fi
.SP
..
.decS
.ig cE
..
.decE
..
.dezA
.SP 1
.nr |Q (\\n(.lu-\\w\ \ \\$1\ (start)\ \ u-\\n(.i)/2
\&\\l\\n(|Qu\ \ \\$1\ (start)\ \ \\l\\n(|Qu
.br
..
.dezZ
.br
.nr |Q (\\n(.lu-\\w\ \ \\$1\ (end)\ \ u-\\n(.i)/2
\&\\l\\n(|Qu\ \ \\$1\ (end)\ \ \\l\\n(|Qu
.SP 1
..
.delS
..
.delE
..
.nr Nn 0 1
.denS
.P
.nr Nn +1
.ie\\$1warning .ds yy Warning:\ \
.el.ie\\$1caution .ds yy Caution:\ \
.el.ie\\$1note .ds yy Note:\ \
.el.ie\\$1reviewnote \{\
.	ds yy
.	ps +2
.	ft B
.	P
Review Note To Developers:
.	P
.	ft
.	ps -2 \}
.el.ds yy \\$1:\ \
.ft B
.ll -\w\\*(yyu
.in +\w\\*(yyu
.ti -\w\\*(yyu
\\*(yy\c
.ft
..
.denE
.nr Nn -1
.in -\w\\*(yyu
.ll +\w\\*(yyu
.P
..
.de |F
.ie\\$1table .nr |F 1
.el.nr |F 0
.ie\\n(|D=0&\\n(|F=1 \{\
.	ds L \&\\f(HB
.	ds V \&\\f(HI
.	ds A \&\\f\\*(!]
.	ds N \&\\f\\*(!]
.	ds O \&\\fH
.	ds C \&\\f\\*(!]
.	ds U \&\\f(HB
.	ds E \&\\f(HI
'	br \}
.el\{\
.	ds L \&\\fB
.	ds V \&\\fI
.	ds A \&\\f\\*(!]
.	ds N \&\\f\\*(!]
.	ds O \&\\fR
.	ds C \&\\f\\*(!]
.	ds U \&\\fB
.	ds E \&\\fI
'	br \}
..
.|F general
.am TS
.|F table
..
.am TE
.|F general
..
.desS
.SP
..
.desE
.SP
..
.defS
.br
\&\fB\\$1(\fP
.nr !+ 1
.nr !% 0
..
.defE
\fB);\fP
.br
.if\\n(!%=1 .in -5i
.nr !+ 0
.nr !% 0
..
.dedS
.if\\n(!+=1 \{\
.	ie \\n(!%=0 .in +.5i
.	el \fB,\fP
'	br \}
.br
\&\fB\\$1\fR
.nr !% 1
..
.dedE
.if\\n(!+=0 \fB;\fR
..
.dekY
.ft B
<\\$1>
.ft
..
.de K,
\fB<\\$1>\fP\\$2
..
.de ,K
\&\\$1\fB<\\$2>\fP
..
.deeM
.ft I
\&\\$1
.ft
..
.de E,
\&\fI\\$1\fP\^\\$2
..
.de ,E
\&\\$1\^\fI\\$2\fP
..
.dedI
.so \\$1
..
.deeI
.nf
.ft CW
.nr !x 8*\w'0'
.ta \\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu
.de !~
so\\$1
\\..
.wh \\n(nlu+\\n(.tu-1v e,
.e:
!~
e;
.ft
.fi
.ch e,
..
.de e:
.eo
.c2 
.cc 
..
.de e;
cc
.c2
.ec
..
.de e,
e;
'bp
.e:
..
.depI
.br
.fl
.rs
.sy includePS "\\$1" "\\$2" "\\$3" > /tmp/pI.tmp.
.so /tmp/pI.tmp.
.sy rm -f /tmp/pI.tmp.
..
.depM
..
.denP
.bp
..
.denL
.br
..
.dewH
..
.rn RS rS
.rn RE rE
.detH
..
.am TH
.|Y TH "\\$1"
..
.am SH
.|Y SH "\\$1"
..
.am SS
.|Y SS "\\$1"
..
.nr Ll 0 1
.nr $A 0 1
.nr $M 0 1
.nr $V 0 1
.de |Y
.if\\n(Ll>0 \{\
.	tm unterminated list (no .LE) -- noticed by the .\\$1 "\\$2"
.	nr Ll 0
'	br \}
..
.rn PP P#
.dePP
.ie(\\n(Ll>0):(\\n(Nn>0) .sp \\n(PDu
.el.P#
..
.deML
.SP
.nr $M +1
.if\\n(Ll>0 .rS \\n(%\\n(Llu
.nr Ll +1
.nr %\\n(Ll .5i
.ie\\n($M=1 .ds %\\n(Ll \(bu
.el\{\
.	ie t .ds %\\n(Ll \(em
.	el .ds %\\n(Ll --
'	br \}
.ien .ds %\\n(Ll "\ \ \\*(%\\n(Ll
.el.ds %\\n(Ll "\ \ \ \ \ \ \ \\*(%\\n(Ll
.nr #\\n(Ll 0 1
.ds #\\n(Ll M
..
.deVL
.SP
.nr $V +1
.if\\n(Ll>0 .rS \\n(%\\n(Llu
.nr Ll +1
.ie\\$1 .nr %\\n(Ll 1i
.el.nr %\\n(Ll \\$1n
.ds #\\n(Ll V
..
.deAL
.SP
.nr $A +1
.if\\n(Ll>0 .rS \\n(%\\n(Llu
.nr Ll +1
.nr %\\n(Ll .5i
.ie\\n($A=1 .af #\\n(Ll 1
.el.ie\\n($A=2 .af #\\n(Ll a
.el.af #\\n(Ll i
.nr #\\n(Ll 0 1
.ds %\\n(Ll \\\\\\\\\\\\\\\\n+(#\\n(Ll
.ien .ds %\\n(Ll "\ \\*(%\\n(Ll
.el.ds %\\n(Ll "\ \ \ \ \ \\*(%\\n(Ll
.ds #\\n(Ll A
..
.deLI
.SP .25
.ie\\*(#\\n(LlV \{\
.	IP "\\$1" \\n(%\\n(Llu
'	br \}
.el.ie\\*(#\\n(LlM \{\
.	IP \\*(%\\n(Ll \\n(%\\n(Llu
'	br \}
.el.IP \\*(%\\n(Ll. \\n(%\\n(Llu
..
.deLE
.ie\\*(#\\n(LlA \{\
.	nr $A -1
.	nr Ll -1
.	if \\n(Ll>0 .rE
'	in \\n(%\\n(Llu+\\n()Ru+\\n(INu
'	br \}
.el.ie\\*(#\\n(LlV \{\
.	nr $V -1
.	nr Ll -1
.	if \\n(Ll>0 .rE
'	in \\n(%\\n(Llu+\\n()Ru+\\n(INu
'	br \}
.el.if\\*(#\\n(LlM \{\
.	nr $M -1
.	nr Ll -1
.	if \\n(Ll>=0 .rE
'	in \\n(%\\n(Llu+\\n()Ru+\\n(INu
'	br \}
.SP
..
.deFG
.)F Figure 0 \\n+(Fg "\\$1"
..
.deTB
.)F Table 1 \\n+(Tb "\\$1"
..
.deEC
.)F Equation 2 \\n+(Ec "\\$1"
..
.deEX
.)F Exhibit 3 \\n+(Ex "\\$1"
..
.de )F
.sp \\n(PDu
.ce 1
\\$1\ \\n(H1\(mi\\$3.\ \ \\$4
.sp \\n(PDu
.if\\n(|Z=1 .tm !TOC: .if \\$2=\\\\\\\\$1 .)T 1 1 "\\$1\ \\n(H1\(mi\\$3.\ \ " "\\$4" \\nP \\n(H1
..
.deSP
.br
.nr |Q \\n(PDu
.if\\n(.$ .nr |Q \\$1v
.if!(\\n(nl=\\n(|B) .nr |A 0
.nr |Q -\\n(|Au
.if\\n(|Q \{\
.	sp \\n(|Qu
.	nr |A +\\n(|Qu
'	br \}
.nr |B \\n(nl
..
...\" ______________ end of SML macros ______________
.iX "WML"
.SH NAME
\*LWML\*O\(emThe widget meta-language file format for creating uil compilers
.iX "widget meta-language"
.SH DESCRIPTION
.PP
The widget meta-language facility (WML) is used to generate the
components of the user interface language (UIL) compiler that 
can change depending on the widget set.  Using WML you can add support
in UIL for
new widgets to the 1/Motif widget set or for a totally new widget set.
.SH FILE FORMAT
.PP
WML files are ASCII files that you can modify with any standard
text editor.  They are accessed in the
\*Ltools/wml\*O directory by WML.
By convention WML files have the suffix \*L\&.wml\*O.
The Motif widget set is described in the
\*Lmotif.wml\*O file.
This is also the default WML file when using the WML facility.
.PP
When adding new widgets or changing widget characteristics, you should
start with a copy of the
\*Lmotif.wml\*O file.
If you are creating a new widget set for use with UIL, you should
start from scratch.
In either case the
\*Lmotif.wml\*O
file is a good example of WML syntax, and you should familiarize
yourself with it before writing your own WML file.
.PP
WML files have a simple syntax, similar in structure to UIL.
It is made up of the following elements:
.ML
.LI
Comments
.LI
Data Type Definitions
.LI
Character Set Definitions
.LI
Enumeration Set Definitions
.LI
Control List Definitions
.LI
Class Definitions
.LI
Child Definitions
.LI
Resource Definitions
.LE
.PP
You can use space, tabs, or newlines anywhere in the syntax,
as long as you do not split up keywords or strings, except that
comments end at a newline.
The order of elements is not important to the syntax.
.PP
.ne 9
This description uses the following additional conventions
to describe the syntax of the widget meta-language:
.VL 7n
.LI "[\ \ ]"
Indicates optional elements.
.LI "\.\.\."
Indicates where an element of syntax can be repeated.
.LI "|"
Indicates a choice among multiple items.
.LE
.SS "Comments"
.PP
You can include comments in the WML file.
Comments have the following syntax:
.PP
.nf
[\*Vany.element\*O]\*L!\*O\*Vany.comment\*O
.fi
.PP
Comments begin with an exclamation point and extend to the
end of the line.  A comment can begin on a line by itself or
follow any part of another element.  A comment does not change
the meaning of any other element.
For example:
.oS
!This is a comment
!  that spans two lines.
DataType    !This is a comment following code.
.oE
.ne 10
.SS "Data Type Definitions"
.PP
Data type definitions register all the resource data
types used in the file.  You must register all the data types used
in your WML file.
Data type definitions have the following syntax:
.PP
.nf
\*LDataType\*O
.in +5n
\*Vany.datatype\*O [\*L{ InternalLiteral =\*O \*Vinternal.name\*O |
.in +5n
\*LDocName = "\*O\*Vstring\*O\*L";\*O [...]\*L}\*O]\*L;\*O
.in -5n
[...]
.in -5n
.fi
.PP
A data type definition begins with the keyword \*LDataType\*O.  Following
the
.B DataType
keyword is a list of data types that can be further modified with:
.VL 10n
.LI "\*LInternalLiteral\*O"
.nL
This forces the value of the internal symbol table literal definition
of the data type name.  This modifier is only used to get around
symbol table definitions hard coded into the UIL compiler.
It should rarely be used.
.LI "\*LDocName\*O"
which gives an arbitrary string for use in the documentation.
This string is meant to supply a different name for the data type for
use in the documentation, or a single name for the data type if the
data type has aliases.
.LE
.PP
For example:
.oS
DataType OddNumber {DocName="OddNumber";};
         NewString;
.oE
.nL
.ne 16
.SS "Character Set Definitions"
.PP
Character set definitions register the Motif Toolkit name and other
information for the character set names used in UIL.
Character set definitions have the following syntax:
.PP
.nf
\*LCharacterSet\*O
.in +5n
\*Vany.character.set\*O
.in +5n
\*L{\*O [ \*LFontListElementTag\*O | \*LXmStringCharsetName\*O ] \*L= "\*O\*Vstring\*O\*L" ;\*O
.in +5n
[ \*LAlias = "\*O\*Vstring\*O\*L"\*O ... \*L;\*O |
\*LDirection =\*O [ \*LLeftToRight\*O | \*LRightToLeft\*O ] \*L;\*O |
\*LParseDirection =\*O [ \*LLeftToRight\*O | \*LRightToLeft\*O ] \*L;\*O |
\*LCharacterSize =\*O [ \*LOneByte\*O | \*LTwoByte\*O ] \*L;\*O ]
[ ... ] \*L} ;\*O
.in -5n
.in -5n
[ ... ]
.in -5n
.fi
.PP
A character set definition begins with the keyword \*LCharacterSet\*O.
Following the \*LCharacterSet\*O keyword is a list of character sets
that can be further modified with:
.VL 1.5i
.LI "\*LFontListElementTag\*O\ |\ \*LXmStringCharsetName\*O"
.nL
Specifies the name of the character set, which will become the character
set component of a compound string segment created using this
character set.
This modifier is required.
.LI "\*LAlias\*O"
Specifies one or more aliases for the character set name.
Each alias can be used within UIL to refer to the same character set.
.nL
.ne 3
.LI "\*LDirection\*O"
Specifies the direction of a compound string segment created using
this character set.
The default is \*LLeftToRight\*O.
.nL
.ne 10
.LI "\*LParseDirection\*O"
Specifies the direction in which an input string is parsed when a
compound string segment is created using this character set.
The default is whatever \*LDirection\*O is specified.
.LI "\*LCharacterSize\*O"
Specifies the number of bytes in each character of a compound string
segment created using this character set.
The default is \*LOneByte\*O.
.LE
.PP
.ne 14
For example:
.oS
CharacterSet
  iso_latin1
    { XmStringCharsetName = "ISO8859-1";
      Alias = "ISOLatin1"; };
  iso_hebrew_lr
    { XmStringCharsetName = "ISO8859-8";
      Alias = "iso_latin8_lr";
      Direction = RightToLeft;
      ParseDirection = LeftToRight; };
  ksc_korean
    { XmStringCharsetName = "KSC5601.1987-0";
      CharacterSize = TwoByte; };
.oE
.SS "Enumeration Set Definitions"
Enumeration set definitions register the named constants used in the
Motif Toolkit to specify some resource values.
Enumeration set definitions have the following syntax:
.PP
.nf
\*LEnumerationSet\*O
.in +5n
\*Vresource.name\*O \*L:\*O \*Vresource.type\*O
.in +5n
\*L{\*O \*Venum.value.name\*O \*L;\*O [ ... ] \*L} ;\*O
.in -5n
.in -5n
.fi
.PP
An enumeration set definition begins with the keyword
\*LEnumerationSet\*O.
For each enumeration set defined, the name and type of the resource are
listed.
The resource name is the Motif Toolkit resource name, with the beginning
\*LXmN\*O removed and with the initial letter capitalized.
For example, the name of the Motif Toolkit resource
\*LXmNrowColumnType\*O is \*LRowColumnType\*O.
The resource type is the data type for the resource; for most resources,
this is \*Linteger\*O.
.ne 5
Following the resource name and type is a list of names of enumeration
values that can be used as settings for the resource.
These names are the same as those in the Motif Toolkit.
.PP
.ne 7
For example:
.oS
EnumerationSet
  RowColumnType: integer
    { XmWORK_AREA; XmMENU_BAR; XmMENU_POPUP;
      XmMENU_PULLDOWN; XmMENU_OPTION; };
.oE
.SS "Control List Definitions"
.PP
Control list definitions assign a name to groups of controls.
You can use these control lists later in class definitions to simplify
the structure of your WML file.
Control list definitions have the following syntax:
.PP
.nf
\*LControlList\*O
.in +5n
\*Vany.control.list\*O [\*L{\*O \*Vany.control\*O\*L;\*O [...]\*L}\*O]\*L;\*O
.in -5n
.fi
.PP
A control list definition starts with the
.B ControlList
keyword.
Following the
.B ControlList
keyword are any number of control list definitions.  Control list
definitions are made up of a control list name followed by the
set of controls it represents.  For example:
.oS
ControlList
        Buttons {PushButton;
                 RadioButton;
                 CascadeButton;
                 NewCascadebutton;};
.oE
.PP
Each control specified in the control list must be defined as
a class in the file.
.nL
.ne 15
.SS "Class Definitions"
.PP
Class definitions describe a particular widget class including
its position in the class hierarchy, toolkit convenience function,
resources, and controls.  There should be one class definition for
each widget or gadget in the widget set you want to support in UIL.
Class definitions have the following syntax:
.PP
.nf
\*LClass\*O \*Vclass.name\*O \*L: MetaClass\*O | \*LWidget\*O | \*LGadget\*O
.in +5n
[\*L{\*O[
\*LSuperClass =\*O \*Vclass.name\*O\*L;\*O |
\*LParentClass =\*O \*Vparent.class.name\*O\*L;\*O |
\*LInternalLiteral =\*O \*Vinternal.name\*O\*L;\*O |
\*LAlias =\*O \*Valias\*O\*L;\*O |
\*LConvenienceFunction =\*O \*Vconvenience.function\*O\*L;\*O |
\*LWidgetClass =\*O \*Vwidget.class\*O\*L;\*O |
\*LDocName = "\*O\*Vstring\*O\*L";\*O |
\*LDialogClass =\*O \*LTrue\*O | \*LFalse;\*O |
\*LResources {\*O \*Vany.resource.name\*O [\*L{\*O
.in +5n
.in +5n
\*LDefault =\*O \*Vnew.default.value\*O\*L;\*O |
\*LExclude = True\*O |
\*LFalse;\*O
[...]\*L}\*O ]\*L;\*O
.in -5n
[...]\*L};\*O |
.in -5n
\*LControls {\*O \*Vany.control.name\*O\*L;\*O [...]\*L};\*O
\*LChildren {\*O \*Vany.child.name\*O\*L;\*O [...] \*L};\*O
[...]
]\*L}\*O]\*L;\*O
.in -5n
.fi
.PP
Class definitions start with the
.B Class
keyword. 
For each class defined, the name of the class and whether the
class is a metaclass, widget, or gadget is listed.
Each class definition can be further modified with the following
keywords:
.VL 12n
.LI "\*LSuperClass\*O"
This indicates the name of the parent class.
Only the root of the hierarchy does not specify a SuperClass.
.LI "\*LParentClass\*O"
This indicates the name of the widgets automatically created
parent class if one exists.  This allows resources for that
automatically created class to be used in instances of this class.
For example, \*LXmBulletinBoardDialog\*O creates both an
\*LXmBulletinBoard\*O and an \*LXmDialogShell\*O.  To access the
resources of the \*LXmDialogShell\*O parent class it must be
specified here.
.LI "\*LInternalLiteral\*O"
.nL
which forces the value of the internal symbol table literal definition
of the class name.  This modifier is only used to get around
symbol table definitions hard coded into the UIL compiler.
It should rarely be used.
.LI "\*LAlias\*O"
This indicates alternate names for the class
for use in a UIL specification.
.LI "\*LConvenienceFunction\*O"
.nL
This indicates the name of the creation convenience function
for this class.  All widget and gadget classes must have a
.B ConvenienceFunction .
.LI "\*LWidgetClass\*O"
This indicates the associated widget class of gadget type classes.
Presently, nothing is done with this value.
.LI "\*LDocName\*O"
This defines an arbitrary string for use in the documentation.
Presently, nothing is done with this value.
.LI "\*LDialogClass\*O"
This indicates whether the class is a dialog class.
Presently, nothing is done with this value.
.LI "\*LResources\*O"
This lists the resources of the widget class.  This keyword
can be further modified with:
.VL 10n
.LI "\*LDefault\*O"
This specifies a new default value for this resource.  Resource
default values are usually set in the resource definition.  If
an inherited resource's default value is changed by the class,
the new default value should be noted here.
.LI "\*LExclude\*O"
This specifies whether an inherited resource should be excluded from the
resource list of the class.  Exclude is
.B False
by default.
.LE
.LI "\*LChildren\*O"
This lists the names of the automatically created children of this 
class, so that those children can be accessed in the UIL file.
.LI "\*LControls\*O"
This lists the controls that the widget class allows.  The controls can
be other classes or a control list from the control list definition.
.LE
.PP
.ne 16
The example below uses the examples from the data type definitions and
control list definitions above.
.oS
Class
     TopLevelWidget : MetaClass
          {
          Resources
               {
               XtbNfirstResource;
               XtbNsecondResource;
               };
          };
     NewWidget : Widget
          {
          SuperClass = TopLevelWidget;
          ConvenienceFunction =
              XtbCreateNewWidget;
          Resources
               {
               XtbNnewResource;
               XtbNfirstResource
                  {Default="XtbNEW_VALUE";};
               XtbNsecondResource
                  {Exclude=True;};
               };
          Controls
               {
               NewWidget;
               Buttons;
               };
          };
.oE
.nL
.ne 20
.SS "Child Definitions"
.PP
Child definitions register the classes of automatically created
children.  Automatically created children are referenced elsewhere in
a uil file using the \*LChildren\*O keyword within a class definition.
Child definitions have the following syntax:
.PP
.nf
\*LChild\*O
.in +5n
\*Vchild.name\*O \*L:\*O \*Vclass.name\*O\*L;\*O
[...]
.in -5n
.fi
.PP
Where \*Vchild.name\*O is the name of the automatically created child
and \*Vclass.name\*O is the name of the class of that child.
.nL
.ne 16
.SS "Resource Definitions"
.PP
Resource definitions describe a particular resource including
its type, and default value.
There should be a resource definition for
each new resource referenced in the class definitions.
Resource definitions have the following syntax:
.PP
.nf
\*LResource\*O
.in +5n
\*Vresource.name\*O \*L: Argument\*O | \*LReason\*O | \*LConstraint\*O | \*LSubResource\*O
.in +5n
[\*L{\*O[
\*LType =\*O \*Vtype\*O \*L;\*O |
\*LResourceLiteral =\*O \*Vresource.literal\*O \*L;\*O |
\*LInternalLiteral =\*O \*Vinternal.name\*O\*L;\*O |
\*LAlias =\*O \*Valias\*O \*L;\*O |
\*LRelated =\*O \*Vrelated\*O \*L;\*O |
\*LDefault =\*O \*Vdefault\*O \*L;\*O |
\*LDocName =\*O \*Vdoc.name\*O \*L;\*O ]
[...]\*L}\*O]
.in -5n
[...]
.in -5n
.fi
.PP
Resource definitions start with the
.B Resource
keyword. 
For each resource definition,
the name of the resource and whether the resource is an argument, reason,
constraint or subresource is listed.
.VL 15n
.LI "\*LArgument\*O"
Indicates a standard resource.
.LI "\*LReason\*O"
Indicates a callback resource.
.LI "\*LConstraint\*O"
Indicates a constraint resource.
.LI "\*LSubResource\*O"
Presently, nothing is done with this value.
.LE
.PP
The resource definition can be further modified with the following
keywords:
.VL 15n
.LI "\*LType\*O"
This indicates the data type of the resource.  It must be listed
in the data type definition.
.LI "\*LResourceLiteral\*O"
This indicates the keyword used in the UIL file to reference the
resource.  In Motif, the resource name is the same as the
.B ResourceLiteral .
.nL
.ne 7
.LI "\*LInternalLiteral\*O"
which forces the value of the internal symbol table literal definition
of the resource name.  This modifier is only used to get around
symbol table definitions hard coded into the UIL compiler.
It should rarely be used.
.LI "\*LAlias\*O"
This indicates alternate names for the resource
for use in a UIL specification.
.LI "\*LRelated\*O"
This is a special purpose field that allows resources that
act as a counter for the current resources to be related to the resource.
UIL automatically sets the value of this related resource to the number of items
in the compiled instance of type \*Vresource.name\*O.
.LI "\*LDefault\*O"
This indicates the default value of the resource.
.LI "\*LDocName\*O"
This defines an arbitrary string for use in the documentation.
Presently, nothing is done with this value.
.LE
.nL
.ne 20
.PP
The example below uses the examples from the data type definitions,
control list definitions and class definitions above.
.oS
Resource
     XtbNfirstResource : Argument
          { Type = OddNumber;
            Default = "XtbOLD_VALUE";};
     XtbNsecondResource : Argument
          { Type = NewString;
            Default = "XtbNEW_STRING"; };
     XtbNnewResource : Argument
          { Type = OddNumber;
            Default = "XtbODD_NUMBER"; };
.oE
