...\" **
...\" **
...\" **  (c) Copyright 1992 by Open Software Foundation, Inc.
...\" **      All Rights Reserved.
...\" **
...\" **  (c) Copyright 1987, 1988 by Digital Equipment Corporation,
...\" **      Maynard, MA.  All Rights Reserved.
...\" **
...\" **
.TH UIL 5X
...\" ______________ start of SML macros ______________
.ds !) CW
.ds !] (CW
.cs \*(!) 20
.bd \*(!) 2
.ds |A Chapter
.nr |P 0
.nr |D 1
.deaS
..
.deaE
..
.deoS
.SP
.ps -1
.ft \\*(!)
.nf
.nr !x 8*\\w'0'
.ta \\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu
.if\\n(.$>0 .in 0
..
.deoE
.ps +1
.ft R
.fi
.SP
..
.deiS
.SP
.ps -1
.ft B
.nf
..
.deiE
.ps +1
.ft R
.fi
.SP
..
.decS
.ig cE
..
.decE
..
.dezA
.SP 1
.nr |Q (\\n(.lu-\\w\ \ \\$1\ (start)\ \ u-\\n(.i)/2
\&\\l\\n(|Qu\ \ \\$1\ (start)\ \ \\l\\n(|Qu
.br
..
.dezZ
.br
.nr |Q (\\n(.lu-\\w\ \ \\$1\ (end)\ \ u-\\n(.i)/2
\&\\l\\n(|Qu\ \ \\$1\ (end)\ \ \\l\\n(|Qu
.SP 1
..
.delS
..
.delE
..
.nr Nn 0 1
.denS
.P
.nr Nn +1
.ie\\$1warning .ds yy Warning:\ \
.el.ie\\$1caution .ds yy Caution:\ \
.el.ie\\$1note .ds yy Note:\ \
.el.ie\\$1reviewnote \{\
.	ds yy
.	ps +2
.	ft B
.	P
Review Note To Developers:
.	P
.	ft
.	ps -2 \}
.el.ds yy \\$1:\ \
.ft B
.ll -\w\\*(yyu
.in +\w\\*(yyu
.ti -\w\\*(yyu
\\*(yy\c
.ft
..
.denE
.nr Nn -1
.in -\w\\*(yyu
.ll +\w\\*(yyu
.P
..
.de |F
.ie\\$1table .nr |F 1
.el.nr |F 0
.ie\\n(|D=0&\\n(|F=1 \{\
.	ds L \&\\f(HB
.	ds V \&\\f(HI
.	ds A \&\\f\\*(!]
.	ds N \&\\f\\*(!]
.	ds O \&\\fH
.	ds C \&\\f\\*(!]
.	ds U \&\\f(HB
.	ds E \&\\f(HI
'	br \}
.el\{\
.	ds L \&\\fB
.	ds V \&\\fI
.	ds A \&\\f\\*(!]
.	ds N \&\\f\\*(!]
.	ds O \&\\fR
.	ds C \&\\f\\*(!]
.	ds U \&\\fB
.	ds E \&\\fI
'	br \}
..
.|F general
.am TS
.|F table
..
.am TE
.|F general
..
.desS
.SP
..
.desE
.SP
..
.defS
.br
\&\fB\\$1(\fP
.nr !+ 1
.nr !% 0
..
.defE
\fB);\fP
.br
.if\\n(!%=1 .in -5i
.nr !+ 0
.nr !% 0
..
.dedS
.if\\n(!+=1 \{\
.	ie \\n(!%=0 .in +.5i
.	el \fB,\fP
'	br \}
.br
\&\fB\\$1\fR
.nr !% 1
..
.dedE
.if\\n(!+=0 \fB;\fR
..
.dekY
.ft B
<\\$1>
.ft
..
.de K,
\fB<\\$1>\fP\\$2
..
.de ,K
\&\\$1\fB<\\$2>\fP
..
.deeM
.ft I
\&\\$1
.ft
..
.de E,
\&\fI\\$1\fP\^\\$2
..
.de ,E
\&\\$1\^\fI\\$2\fP
..
.dedI
.so \\$1
..
.deeI
.nf
.ft CW
.nr !x 8*\w'0'
.ta \\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu +\\n(!xu
.de !~
so\\$1
\\..
.wh \\n(nlu+\\n(.tu-1v e,
.e:
!~
e;
.ft
.fi
.ch e,
..
.de e:
.eo
.c2 
.cc 
..
.de e;
cc
.c2
.ec
..
.de e,
e;
'bp
.e:
..
.depI
.br
.fl
.rs
.sy includePS "\\$1" "\\$2" "\\$3" > /tmp/pI.tmp.
.so /tmp/pI.tmp.
.sy rm -f /tmp/pI.tmp.
..
.depM
..
.denP
.bp
..
.denL
.br
..
.dewH
..
.rn RS rS
.rn RE rE
.detH
..
.am TH
.|Y TH "\\$1"
..
.am SH
.|Y SH "\\$1"
..
.am SS
.|Y SS "\\$1"
..
.nr Ll 0 1
.nr $A 0 1
.nr $M 0 1
.nr $V 0 1
.de |Y
.if\\n(Ll>0 \{\
.	tm unterminated list (no .LE) -- noticed by the .\\$1 "\\$2"
.	nr Ll 0
'	br \}
..
.rn PP P#
.dePP
.ie(\\n(Ll>0):(\\n(Nn>0) .sp \\n(PDu
.el.P#
..
.deML
.SP
.nr $M +1
.if\\n(Ll>0 .rS \\n(%\\n(Llu
.nr Ll +1
.nr %\\n(Ll .5i
.ie\\n($M=1 .ds %\\n(Ll \(bu
.el\{\
.	ie t .ds %\\n(Ll \(em
.	el .ds %\\n(Ll --
'	br \}
.ien .ds %\\n(Ll "\ \ \\*(%\\n(Ll
.el.ds %\\n(Ll "\ \ \ \ \ \ \ \\*(%\\n(Ll
.nr #\\n(Ll 0 1
.ds #\\n(Ll M
..
.deVL
.SP
.nr $V +1
.if\\n(Ll>0 .rS \\n(%\\n(Llu
.nr Ll +1
.ie\\$1 .nr %\\n(Ll 1i
.el.nr %\\n(Ll \\$1n
.ds #\\n(Ll V
..
.deAL
.SP
.nr $A +1
.if\\n(Ll>0 .rS \\n(%\\n(Llu
.nr Ll +1
.nr %\\n(Ll .5i
.ie\\n($A=1 .af #\\n(Ll 1
.el.ie\\n($A=2 .af #\\n(Ll a
.el.af #\\n(Ll i
.nr #\\n(Ll 0 1
.ds %\\n(Ll \\\\\\\\\\\\\\\\n+(#\\n(Ll
.ien .ds %\\n(Ll "\ \\*(%\\n(Ll
.el.ds %\\n(Ll "\ \ \ \ \ \\*(%\\n(Ll
.ds #\\n(Ll A
..
.deLI
.SP .25
.ie\\*(#\\n(LlV \{\
.	IP "\\$1" \\n(%\\n(Llu
'	br \}
.el.ie\\*(#\\n(LlM \{\
.	IP \\*(%\\n(Ll \\n(%\\n(Llu
'	br \}
.el.IP \\*(%\\n(Ll. \\n(%\\n(Llu
..
.deLE
.ie\\*(#\\n(LlA \{\
.	nr $A -1
.	nr Ll -1
.	if \\n(Ll>0 .rE
'	in \\n(%\\n(Llu+\\n()Ru+\\n(INu
'	br \}
.el.ie\\*(#\\n(LlV \{\
.	nr $V -1
.	nr Ll -1
.	if \\n(Ll>0 .rE
'	in \\n(%\\n(Llu+\\n()Ru+\\n(INu
'	br \}
.el.if\\*(#\\n(LlM \{\
.	nr $M -1
.	nr Ll -1
.	if \\n(Ll>=0 .rE
'	in \\n(%\\n(Llu+\\n()Ru+\\n(INu
'	br \}
.SP
..
.deFG
.)F Figure 0 \\n+(Fg "\\$1"
..
.deTB
.)F Table 1 \\n+(Tb "\\$1"
..
.deEC
.)F Equation 2 \\n+(Ec "\\$1"
..
.deEX
.)F Exhibit 3 \\n+(Ex "\\$1"
..
.de )F
.sp \\n(PDu
.ce 1
\\$1\ \\n(H1\(mi\\$3.\ \ \\$4
.sp \\n(PDu
.if\\n(|Z=1 .tm !TOC: .if \\$2=\\\\\\\\$1 .)T 1 1 "\\$1\ \\n(H1\(mi\\$3.\ \ " "\\$4" \\nP \\n(H1
..
.deSP
.br
.nr |Q \\n(PDu
.if\\n(.$ .nr |Q \\$1v
.if!(\\n(nl=\\n(|B) .nr |A 0
.nr |Q -\\n(|Au
.if\\n(|Q \{\
.	sp \\n(|Qu
.	nr |A +\\n(|Qu
'	br \}
.nr |B \\n(nl
..
...\" ______________ end of SML macros ______________
.iX "UIL"
.SH NAME
\*LUIL\*O\(emThe user interface language file format
.iX "user interface language"
.SH SYNOPSIS
.nf
\*LMODULE\*O \*Vmodule_name\*O
.in +5n
[ \*LNAMES = CASE_INSENSITIVE\*O | \*LCASE_SENSITIVE\*O ]
[ \*LCHARACTER_SET =\*O \*Vcharacter_set\*O ]
[ \*LOBJECTS = {\*O \*Vwidget_name\*O \*L= GADGET\*O | \*LWIDGET;\*O [...] \*L}\*O ]
\*L{\*O [
[ \*Vvalue_section\*O ] |
[ \*Vprocedure_section\*O ] |
[ \*Vlist_section\*O ] |
[ \*Vobject_section\*O ] |
[ \*Videntifier_section\*O ]
[ ... ]
] \*L}\*O
.in -5n
\*LEND MODULE;\*O
.fi
.SH DESCRIPTION
.PP
The UIL language is used for describing the initial state of
a user interface for a widget based application.  UIL describes
the widgets used in the interface, the resources of those widgets,
and the callbacks of those widgets.  The UIL file is compiled into
a UID file using the command \*Luil\*O or by the callable compiler
\*LUil()\*O.  The contents of the
compiled UID file can then by accessed by the various Motif Resource
Management (MRM) functions from within an application program.
.SH FILE FORMAT
.PP
UIL is a free-form language.  This means that high-level constructs
such as object and value declarations do not need to begin in any
particular column and can span any number of lines.  Low-level constructs
such as keywords and punctuation characters
can also begin in any column; however, except for string literals and comments,
they cannot span lines.
.PP
The UIL compiler accepts input lines up to 132 characters in length.  
.PP
.VL 10
.LI "\*LMODULE\*O \*Vmodule_name\*O"
The name by which the UIL module is known in the UID file.
This name is stored in the UID file for later
use in the retrieval of resources by the MRM.
This name is always stored in uppercase in the UID file. 
.LI "\*LNAMES\*O\ \*L=\*O\ \*LCASE_INSENSITIVE\*O\ |\ \*LCASE_SENSITIVE\*O"
.iX "UIL" "case sensitivity clause"
Indicates whether names should be treated as case sensitive or case
insensitive.  The default is case sensitive. 
The case-sensitivity clause should be the
first clause in the module header, and in any case must precede any statement
that contains a name.
If names are case sensitive in a UIL module, UIL keywords in that module
must be in lowercase.  Each name is stored in the UIL file in the same
case as it appears in the UIL module. 
If names are case insensitive, then keywords 
can be in uppercase, lowercase, or 
mixed case, and the uppercase equivalent of each
name is stored in the UID file.
.LI "\*LCHARACTER_SET\*O\ \*L=\*O\ \*Vcharacter_set\*O"
.iX "UIL" "default character set clause"
Specifies the default character set for string
literals in the module that do not explicitly set
their character set.
The default character set, in the absence of this clause
is the codeset component of the \*LLANG\*O environment variable,
or the value of \*LXmFALLBACK_CHARSET\*O if \*LLANG\*O
is not set or has no codeset component.
The value of
\*LXmFALLBACK_CHARSET\*O is defined by UIL supplier, but is
usually ISO8859-1 (equivalent to
ISO_LATIN1).
Use of this clause turns off all localized string literal processing
turned on by the compiler flag \*L-s\*O or the \*LUil_command_type\*L
data structure element \*Luse_setlocale_flag\*O.
.LI "\*LOBJECTS\ =\ {\*O\ \*Vwidget_name\*O = \*LGADGET\*O | \*LWIDGET;\ }\*O"
.iX "UIL" "objects clause"
Indicates whether the widget or gadget form of
the control specified by \*Vwidget_name\*O is used by default.
By default the widget form is used, so the gadget keyword is usually the
only one used.
The specified control should be one that has both a widget and gadget
version:  XmCascadeButton, XmLabel, XmPushButton, XmSeparator,
and XmToggleButton.
The form of more than one control can be specified by delimiting them
with semicolons.
The gadget or widget form of an instance of a control can be specified
with the \*LGADGET\*O and \*LWIDGET\*O keywords in a particular
object declaration.
.LI "\*Vvalue_section\*O"
Provides a way to name a value expression or literal.
The value name can then be referred to by declarations that occur
elsewhere in the UIL module in any context where a value can be used.
Values can be forward referenced.
Value sections
are described in more detail later in the reference page.
.LI "\*Vprocedure_section\*O"
Defines the callback routines used by a widget and the creation
routines for user-defined widgets.  These definitions are used
for error checking.
Procedure sections
are described in more detail later in the reference page.
.LI "\*Vlist_section\*O"
Provides a way to group together a set of arguments, controls (children),
callbacks, or procedures for later use in the UIL module.
Lists can contain other
lists, so that you can set up a hierarchy to clearly show which
arguments, controls, callbacks, and procedures are common to which widgets.
List sections
are described in more detail later in the reference page.
.LI "\*Vobject_section\*O"
Defines the objects that make up the user interface of the application.
You can reference the object names in declarations that
occur elsewhere in the UIL module in any context where an object name can 
be used (for example, in a controls list, as a symbolic reference
to a widget ID, or as the tag_value argument for a callback procedure). 
Objects can be forward referenced.
Object sections
are described in more detail later in the reference page.
.LI "\*Videntifier_section\*O"
Defines a run-time binding of data to names that appear in the UIL module.
Identifier sections
are described in more detail later in the reference page.
.LE
.PP
The UIL file can also contain comments and include directives, which are
described along with the main elements of the UIL file format in
the following sections.
.SS "Comments"
.PP
Comments can take one of two forms, as follows:  
.ML
.LI
The comment is introduced with the sequence \*L/*\*O
followed by the text of the comment and terminated with the sequence \*L*/\*O.
This form of comment can span multiple source lines.
.LI
The comment is introduced with an \*L!\*O (exclamation point),
followed by
the text of the comment and terminated by the end of the source line.
.LE
.PP
Neither form of comment can be nested.
.SS "Value sections"
.PP
.iX "UIL" "value section"
A value section consists of the keyword \*LVALUE\*O followed by a sequence of
value declarations.  It has the following syntax: 
.PP
.nf
\*LVALUE\*O \*Vvalue_name\*O \*L:\*O
.in +5n
[ \*LEXPORTED\*O | \*LPRIVATE\*O ] \*Vvalue_expression\*O |
\*LIMPORTED\*O \*Vvalue_type\*O \*L;\*O
.in -5n
.fi
.PP
Where \*Vvalue_expression\*O is assigned to \*Vvalue_name\*O or a
\*Vvalue_type\*O is assigned to an imported value name.
A value declaration provides a way to name a value expression or literal.
The value name can be referred to by declarations that occur
later in the UIL module in any context where a value can be used.
Values can be forward referenced.
.iX "IMPORTED"                                                  
.iX "EXPORTED"
.iX "PRIVATE"
.VL 10n
.LI "\*LEXPORTED\*O"
A value that you define as exported is stored in the
UID file as a named resource, and therefore can be referenced by
name in other UID files.  When you define a value as exported, 
MRM looks outside the module in which the exported value
is declared to get its value at run time.
.LI "\*LPRIVATE\*O"
A private value is a value that is not imported or exported.
A value that you define as private is
not stored as a distinct resource in the UID file.
You can reference a private value only in the UIL module containing 
the value declaration. The value or object is directly incorporated into
anything in the UIL module that references the declaration.
.LI "\*LIMPORTED\*O"
A value that you define as imported is one that is 
defined as a named resource in a UID file.  MRM resolves this 
declaration with the corresponding exported declaration at 
application run time.
.LE
.PP
By default, values and objects are private.
The following is a list of the supported value types in UIL.
.ML
.LI
\*LANY\*O
.LI
\*LARGUMENT\*O
.LI
\*LBOOLEAN\*O
.LI
\*LCOLOR\*O
.LI
\*LCOLOR_TABLE\*O
.LI
\*LCOMPOUND_STRING\*O
.LI
\*LFLOAT\*O
.LI
\*LFONT\*O
.LI
\*LFONT_TABLE\*O
.LI
\*LFONTSET\*O
.LI
\*LICON\*O
.LI
\*LINTEGER\*O
.LI
\*LINTEGER_TABLE\*O
.LI
\*LKEYSYM\*O
.LI
\*LREASON\*O
.LI
\*LSINGLE_FLOAT\*O
.LI
\*LSTRING\*O
.LI
\*LSTRING_TABLE\*O
.LI
\*LTRANSLATION_TABLE\*O
.LI
\*LWIDE_CHARACTER\*O
.LI
\*LWIDGET\*O
.LE
.SS "Procedure sections"
.PP
.iX "UIL" "procedure section"
A procedure section consists of the keyword \*LPROCEDURE\*O followed by a
sequence of procedure declarations.  It has the following syntax:
.PP
.nf
\*LPROCEDURE\*O
.in +5n
\*Vprocedure_name\*O [ \*L(\*O [ \*Vvalue_type\*O ] \*L)\*O ] \*L;\*O
.in -5n
.fi
.PP
.iX "UIL" "procedure declaration"
Use a procedure declaration to declare:
.ML
.LI
A routine that can be used as a
callback routine for a widget
.LI
The creation function for a user-defined widget
.LE
.PP
You can reference a procedure name in
declarations that occur later in the UIL module in any context 
where a procedure can be used.  Procedures can be forward referenced.
You cannot use a
name you used in another context as a procedure name.
.PP
In a procedure declaration, you have the option
of specifying that a parameter will be
passed to the corresponding callback routine at run time.  This parameter is
called the callback tag.  You can specify the data type of the callback tag by
putting the data type in parentheses following the procedure name.  When you
compile the module, the UIL compiler checks that the argument you specify in
references to the procedure is of this type.  Note that the data type of the
callback tag must be one of the valid UIL data types.
You can use a widget as a callback tag, as long as the widget is defined
in the same widget hierarchy as the callback, that is they have a common
ancestor that is in the same UIL hierarchy.
.PP
The following list summarizes how the UIL compiler checks
argument type and argument count, depending on the procedure declaration.
.VL 20n
.LI "No\ parameters"
No argument type or argument count checking occurs. 
You can supply either 0 or 1 aguments in the prcedure reference.
.LI "\*L(\ )\*O"
Checks that the argument count is 0.
.LI "\*L(ANY)\*O"
Checks that the argument count is 1.  Does
not check the argument type.  Use the \*LANY\*O type to prevent type 
checking on procedure tags.
.LI "\*L(\*O\*Vtype\*O\*L)\*O"
Checks for one argument of the specified type.
.LI "\*L(\*O\*Vclass_name\*O\*L)\*O"
Checks for one widget argument of the specified widget class.
.LE
.PP
While it is possible to use any UIL data type to specify the type of a tag in a
procedure declaration, you must be able to represent that data type in the
programming language you are using.  Some data types (such as integer, Boolean,
and string) are common data types recognized by most programming languages. 
Other UIL data types (such as string tables) are more complicated and may
require you to set up an appropriate corresponding data structure in the
application in order to pass a tag of that type to a callback routine.
.PP
You can also use a procedure declaration to specify the creation function
for a user-defined widget.  In this case, you specify no formal parameters.
The procedure is invoked with the standard three arguments passed to
all widget creation functions.
(See the Motif Toolkit documentation for more information 
about widget creation functions.)
.SS "List sections"
.PP
.iX "UIL" "list section"
A list section consists of the keyword \*LLIST\*O followed by a
sequence of list declarations.  It has the following syntax:
.PP
.nf
\*LLIST\*O
.in +5n
\*Vlist_name\*O \*L: {\*O \*Vlist_item\*O\*L;\*O [...] \*L}\*O
[...]
.in -5n
.fi
.PP
You can also use list sections to group together a set of arguments, controls
(children),
callbacks, or procedures for later use in the UIL module.  Lists can contain other
lists, so that you can set up a hierarchy to clearly show which
arguments, controls, callbacks, and procedures are common to which widgets.
You cannot mix the different types of lists; a list
of a particular type cannot contain entries of a different list type
or reference the name of a different list type.
A list name is always private to the UIL module in which you declare 
the list and
cannot be stored as a named resource in a UID file.
.PP
The additional list types are described in the following sections.
.PP
\*LArguments List Structure\*O
.PP
.iX "List types" "argument"
.iX "UIL" "arguments list"
An arguments list defines which arguments are to be specified
in the arguments-list parameter when the creation routine for a particular
object is called at run time.  
An arguments list also specifies
the values for those arguments.
Argument lists have the following syntax:
.PP
.nf
\*LLIST\*O
.in +5n
\*Vlist_name\*O \*L: ARGUMENTS {\*O
.in +5n
\*Vargument_name\*O \*L=\*O \*Vvalue_expression\*O\*L;\*O
[...] \*L}\*O
.in -5n
[...]
.in -5n
.fi
.PP
The argument name must be either a built-in argument name or a
user-defined argument name that is specified with the
\*LARGUMENT\*O function.
.PP
If you use a built-in argument name as an arguments list entry in an object 
definition, the UIL compiler checks the argument name to be sure that it
is supported by the type of object that you are defining.  If the same argument
name appears more than once in a given arguments list, the last entry
that uses that argument name supersedes all previous entries
with that name, and the compiler issues a message. 
.PP
Some arguments, such as \*LXmNitems\*O and \*LXmNitemCount\*O,
are coupled by the UIL compiler.  
When you specify one of the arguments, the compiler also sets the
other.  The coupled
argument is not available to you.
.iX "UIL" "coupled arguments"
.iX "Arguments" "coupled in UIL"
.PP
The Motif Toolkit and the X Toolkit (intrinsics) 
support constraint
arguments.
A constraint argument is one that is passed
to children of an object, beyond those 
arguments normally available.
For example, the Form widget grants a set of constraint arguments to its
children.
These arguments control the position of the children within the Form.
.PP
Unlike the arguments used to define the 
attributes of a particular
widget, constraint arguments are 
used exclusively to define additional attributes of the children of a
particular widget.
These attributes affect the behavior of the children
within their parent.
To supply constraint arguments to the children,
you include the arguments 
in the arguments list for the
child.
.PP
See \*EAppendix B\*O
for information about which arguments are supported by which widgets.  See 
\*EAppendix C\*O
for information about what the valid value type is for each built-in argument.
.PP
\*LCallbacks List Structure\*O
.iX "UIL" "callbacks list"
.iX "List types" "callback"
.PP
Use a callbacks list to define which callback reasons are to
be processed by a particular widget at run time.
Callback lists have the following syntax:
.PP
.nf
\*LLIST\*O
.in +5n
\*Vlist_name\*O \*L: CALLBACKS {\*O
.in +5n
\*Vreason_name\*O \*L= PROCEDURE\*O \*Vprocedure_name\*L [ \*L(\*O [ \*Vvalue_expression\*O ] \*L)\*O ]\*L;\*O |
\*Vreason_name\*O \*L=\*O \*Vprocedure_list\*O \*L;\*O
[...] \*L}\*O
.in -5n
[...]
.in -5n
.fi
.PP
For Motif Toolkit widgets, the reason name must be a built-in
reason name.  For a user-defined widget, you can use a reason name
that you previously specified using the \*LREASON\*O function.
If you use a built-in reason in an object definition, 
the UIL compiler ensures that reason is supported by the type of object
you are defining.  Appendix B shows which reasons
each object supports.
.PP
If the same reason appears more than once in a callbacks list, the last entry
referring to that name supersedes all previous entries using the same reason,
and the UIL compiler issues a diagnostic message.
.PP
If you specify a named value for the procedure argument (callback
tag), the data type of the value must match the type specified for the callback
tag in the corresponding procedure declaration.
When specifying a widget name as a procedure value expression you must also
specify the type of the widget and a space before the name of the widget.
.PP
Because the UIL compiler produces
a UID file rather than an object module (.o), the binding of the UIL name to
the address of the entry point to the procedure is not done by the loader, but
is established at run time with the MRM function
\*LMrmRegisterNames\*O.
You call this function
before fetching any objects,
giving it both the UIL names and the procedure addresses of each callback.  The
name you register with MRM in the application program must match the name you
specified for the procedure in the UIL module.
.PP
Each callback procedure receives three arguments.  The first two arguments
have the same form for each callback.  The form of the third argument varies
from object to object.  
.PP
The first argument is the address of the data structure maintained by the 
Motif Toolkit
for this object instance.  This address is called the widget ID for 
this object.
.PP
The second argument is the address of the value you specified in the callbacks
list for this procedure.  
If you do not specify an argument, the address is NULL.
.PP
The third argument is the
reason name you specified in the callbacks list.
.PP
\*LControls List Structure\*O
.PP
.iX "UIL" "controls list"
A controls list defines which objects are children of, or controlled by, 
a particular object.
Each entry in a controls list has the following syntax:
.PP
.nf
\*LLIST\*O
.in +5n
\*Vlist_name\*O \*L: CONTROLS {\*O
.in +5n
[\*Vchild_name\*O] [\*LMANAGED\*O | \*LUNMANAGED\*O] \*Vobject_definition\*O\*L;\*O
[...] \*L}\*O
.in -5n
[...]
.in -5n
.fi
.PP
If you specify the keyword \*LMANAGED\*O at run time, the object is created and 
managed; if you specify \*LUNMANAGED\*O at run time, the object is only created.
Objects are managed by default.
.PP
You can use \*Vchild_name\*O to specify resources for the automatically
created children of a particular control.  Names for automatically created
children are formed by appending \*LXm_\*O to the name of the child widget.
This name is specified in the documentation for the parent widget.
.PP
Unlike the arguments list and the callbacks list, a controls list entry that is
identical to a previous entry does not supersede the previous
entry.  At run time, 
each controls list entry causes a child to be created when 
the parent is created.  If the same
object definition is used for multiple children, multiple instances of the
child are created at run time. 
See \*EAppendix B\*O
for a list of which widget types can be
controlled by which other widget types.
.PP
\*LProcedures List Structure\*O
.PP
You can specify multiple procedures for a callback reason
in UIL by defining a procedures list.  Just as
with other list types, procedures lists can be defined in-line or in
a list section and referenced by name.
.PP
If you define a reason more than once (for example, when the reason is
defined both in a referenced procedures list and in the callbacks list for the
object), previous definitions are overridden by the latest definition.
The syntax for a procedures list is as follows:
.PP
.nf
\*LLIST\*O
.in +5n
\*Vlist_name\*O \*L: PROCEDURES {\*O
.in +5n
\*Vprocedure_name\*L [ \*L(\*O [ \*Vvalue_expression\*O ] \*L)\*O ]\*L;\*O
[...] \*L}\*O
.in -5n
[...]
.in -5n
.fi
.PP
When specifying a widget name as a procedure value expression you must also
specify the type of the widget and a space before the name of the widget.
.SS "Object Sections"
.PP
.iX "UIL" "object section" 
An object section consists of the keyword \*LOBJECT\*O followed by a
sequence of object declarations.  It has the following syntax:
.PP
.nf
\*LOBJECT\*O \*Vobject_name\*O \*L:\*O
.in +5n
[ \*LEXPORTED\*O | \*LPRIVATE\*O | \*LIMPORTED\*O ] \*Vobject_type\*O
.in +5n
[ \*LPROCEDURE\*O \*Vcreation_function\*L ]
[ \*Vobject_name\*O [ \*LWIDGET\*O | \*LGADGET\*O ] | \*L{\* \*Vlist_definitions\*O \*L}\*O ]
.in -5n
.in -5n
.fi
.PP
.iX "UIL" "object declaration"
Use an object declaration to define the objects that are to be stored in the
UID file.  You can reference the object name in declarations that
occur elsewhere in the UIL module in any context where an object name can 
be used (for example, in a controls list, as a symbolic reference
to a widget ID, or as the tag_value argument for a callback procedure). 
Objects can be forward referenced; that is, you can declare an object
name after you reference it.  All references to an object name must be
consistent with the type of the object, as specified in the object declaration. 
You can specify an object as exported, imported, or private. 
.PP
The object definition can contain a sequence of lists that define 
the arguments, hierarchy, and callbacks for the widget.  
You can specify only one list of each type for an object.
When you declare a user-defined widget, you must include a reference to the
widget creation function for the user-defined widget.
.PP
Use the \*LGADGET\*O or \*LWIDGET\*O
keyword to specify the object type or to override the default variant for this
object type.
You can use the Motif Toolkit name of an object type that has a gadget
variant (for example, \*LXmLabelGadget\*O) as an attribute of an object
declaration.
The \*Vobject_type\*O can be any object type, including gadgets.
You need to specify the \*LGADGET\*O or \*LWIDGET\*O keyword only in the
declaration of an object, not when you reference the object.  You cannot
specify the \*LGADGET\*O or \*LWIDGET\*O keyword for a
user-defined object; user-defined objects are always widgets.
.SS "Identifier sections"
.PP
.iX "UIL" "identifiers"
The identifier section allows you to define an identifier, a mechanism that
achieves run-time binding of data to names that appear in a UIL module. 
The identifier section consists of
the reserved keyword \*LIDENTIFIER\*O, followed by a list of names, each name followed
by a semicolon.
.PP
.nf
\*LIDENTIFIER\*L \*Videntifier_name\*O\*L;\*O [...\*L;\*O]
.fi
.PP
You can later use these names in the UIL module as
either the value of an argument to a widget or the tag value to a callback
procedure. At run time, you use the MRM functions
\*LMrmRegisterNames\*O and \*LMrmRegisterNamesInHierarchy\*O
to bind
the identifier name with the data (or, in the case of callbacks, with
the address of the data) associated with the identifier.
.PP
Each UIL module has a single name space; therefore, you cannot use a
name you used for a value, object, or procedure as an identifier name in
the same module.
.PP
The UIL compiler does not do any type checking on the use of identifiers in a
UIL module.  Unlike a UIL value, an identifier does not have a UIL type
associated with it.  Regardless of what particular type a widget argument or
callback procedure tag is defined to be, you can use an identifier in that
context instead of a value of the corresponding type.
.PP
To reference these identifier names in a UIL module, you use the name of
the identifier wherever you want its value to be used.
.SS "Include directives"
.PP
.iX "UIL" "include directive"
The include directive incorporates the contents of a specified
file into a UIL module.  This mechanism allows several UIL modules to share
common definitions.  The syntax for the include directive is as follows: 
.PP
.nf
\*LINCLUDE FILE\*O \*Vfile_name\*O ;
.fi
.PP
The UIL 
compiler replaces the include directive with the contents of the include file
and processes it as if these contents had appeared in the current
UIL source file.  
.PP
You can nest include files; that is, an include
file can contain include directives.
The UIL compiler can process up to 100 references (including the file
containing the UIL module).  Therefore, you can include up to 99 files
in a single UIL module, including nested files.  Each time a file is
opened counts as a reference, so including the same file twice counts
as two references.
.PP
The character expression is a file specification that identifies the
file to be included.  The rules for finding the specified file are
similar to the rules for finding header, or \*L.h\*O files using
the include directive, 
\*L#include\*O, 
with a quoted string in C.
The \*Luil\*O uses the \*L-I\*O option for specifying a search directory
for include files.
.ML
.LI
If you do
not supply a directory, the UIL compiler searches for the include file in the
directory of the main source file.
.LI
If the compiler does not find the include
file there, the compiler looks in the same directory as the source
file.
.LI
If you supply a directory, the UIL compiler searches
only that directory for the file. 
.LE
.SH "LANGUAGE SYNTAX"
.SS "Names and Strings"
.PP
Names can consist of any of the characters A to Z, a to z,
0 to 9, $ (dollar sign), and \^_\^ (underscore).  Names cannot begin
with a digit (0 to 9).  The maximum length of a name is 31 characters.
.PP
UIL gives you a choice of
either case-sensitive or case-insensitive names through a clause 
in the \*LMODULE\*O header.
For example, if names are case sensitive, the names "sample" and
"Sample" are distinct from each other.  If names are case insensitive,
these names are treated as the same name and can be used
interchangeably.  By default, UIL assumes names are case sensitive. 
.PP
In \*LCASE-INSENSITIVE\*O mode, the compiler outputs all names in the 
UID file in uppercase form.
In \*LCASE-SENSITIVE\*O mode, 
names appear in the UIL file 
exactly as they appear in the source.  
.PP
The following table list the reserved keywords, which are not
available for defining programmer defined names.
.iX "UIL" "keywords"
.iX "UIL module" "keywords"
.iX "UIL specification file" "keywords"
.iX "Keywords"
.PP
.TS
.if \n+(b.=1 .nr d. \n(.c-\n(c.-1
.de 35
.ps \n(.s
.vs \n(.vu
.in \n(.iu
.if \n(.u .fi
.if \n(.j .ad
.if \n(.j=0 .na
..
.nf
.nr #~ 0
.if \n(.T .if n .nr #~ 0.6n
.ds #d .d
.if \(ts\n(.z\(ts\(ts .ds #d nl
.fc
.nr 33 \n(.s
.rm 50 51 52 53
.nr 50 0
.nr 38 \w\f3ARGUMENTS\fP
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \w\f3EXPORTED\fP
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \w\f3INCLUDE\fP
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \w\f3ON\fP
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \w\f3PROCEDURES\fP
.if \n(50<\n(38 .nr 50 \n(38
.50
.rm 50
.nr 51 0
.nr 38 \w\f3CALLBACKS\fP
.if \n(51<\n(38 .nr 51 \n(38
.nr 38 \w\f3FALSE\fP
.if \n(51<\n(38 .nr 51 \n(38
.nr 38 \w\f3LIST\fP
.if \n(51<\n(38 .nr 51 \n(38
.nr 38 \w\f3OBJECT\fP
.if \n(51<\n(38 .nr 51 \n(38
.nr 38 \w\f3TRUE\fP
.if \n(51<\n(38 .nr 51 \n(38
.51
.rm 51
.nr 52 0
.nr 38 \w\f3CONTROLS\fP
.if \n(52<\n(38 .nr 52 \n(38
.nr 38 \w\f3GADGET\fP
.if \n(52<\n(38 .nr 52 \n(38
.nr 38 \w\f3MODULE\fP
.if \n(52<\n(38 .nr 52 \n(38
.nr 38 \w\f3PRIVATE\fP
.if \n(52<\n(38 .nr 52 \n(38
.nr 38 \w\f3VALUE\fP
.if \n(52<\n(38 .nr 52 \n(38
.52
.rm 52
.nr 53 0
.nr 38 \w\f3END\fP
.if \n(53<\n(38 .nr 53 \n(38
.nr 38 \w\f3IDENTIFIER\fP
.if \n(53<\n(38 .nr 53 \n(38
.nr 38 \w\f3OFF\fP
.if \n(53<\n(38 .nr 53 \n(38
.nr 38 \w\f3PROCEDURE\fP
.if \n(53<\n(38 .nr 53 \n(38
.nr 38 \w\f3WIDGET\fP
.if \n(53<\n(38 .nr 53 \n(38
.53
.rm 53
.nr 38 1n
.nr 49 0
.nr 40 \n(49+((0*\n(38)/2)
.nr 50 +\n(40
.nr 41 \n(50+((6*\n(38)/2)
.nr 51 +\n(41
.nr 42 \n(51+((6*\n(38)/2)
.nr 52 +\n(42
.nr 43 \n(52+((6*\n(38)/2)
.nr 53 +\n(43
.nr TW \n(53
.if t .if (\n(TW+\n(.o)>7.65i .tm Table at line 708 file Input is too wide - \n(TW units
.nr #I \n(.i
.in +(\n(.lu-\n(TWu-\n(.iu)/2u
.fc  
.nr #T 0-1
.nr #a 0-1
.eo
.de T#
.nr 35 1m
.ds #d .d
.if \(ts\n(.z\(ts\(ts .ds #d nl
.mk ##
.nr ## -1v
.ls 1
.ls
..
.ec
.ta \n(50u \n(51u \n(52u \n(53u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\f3ARGUMENTS\f\n(31\h'|\n(41u'\f3CALLBACKS\f\n(31\h'|\n(42u'\f3CONTROLS\f\n(31\h'|\n(43u'\f3END\f\n(31
.ta \n(50u \n(51u \n(52u \n(53u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\f3EXPORTED\f\n(31\h'|\n(41u'\f3FALSE\f\n(31\h'|\n(42u'\f3GADGET\f\n(31\h'|\n(43u'\f3IDENTIFIER\f\n(31
.ta \n(50u \n(51u \n(52u \n(53u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\f3INCLUDE\f\n(31\h'|\n(41u'\f3LIST\f\n(31\h'|\n(42u'\f3MODULE\f\n(31\h'|\n(43u'\f3OFF\f\n(31
.ta \n(50u \n(51u \n(52u \n(53u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\f3ON\f\n(31\h'|\n(41u'\f3OBJECT\f\n(31\h'|\n(42u'\f3PRIVATE\f\n(31\h'|\n(43u'\f3PROCEDURE\f\n(31
.ta \n(50u \n(51u \n(52u \n(53u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\f3PROCEDURES\f\n(31\h'|\n(41u'\f3TRUE\f\n(31\h'|\n(42u'\f3VALUE\f\n(31\h'|\n(43u'\f3WIDGET\f\n(31
.fc
.nr T. 1
.T# 1
.in \n(#Iu
.35
.TE
.if \n-(b.=0 .nr c. \n(.c-\n(d.-8
.PP
The following table list the UIL unreserved keywords.  These keywords
can be used as programmer defined names,
however, if you use any keyword as a name, you cannot use the UIL-supplied
usage of that keyword.
.PP
.TS
.if \n+(b.=1 .nr d. \n(.c-\n(c.-1
.de 35
.ps \n(.s
.vs \n(.vu
.in \n(.iu
.if \n(.u .fi
.if \n(.j .ad
.if \n(.j=0 .na
..
.nf
.nr #~ 0
.if \n(.T .if n .nr #~ 0.6n
.ds #d .d
.if \(ts\n(.z\(ts\(ts .ds #d nl
.fc
.nr 33 \n(.s
.rm 48 49 50
.nr 48 0
.nr 38 \w\f3ANY\fP
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\f3ASCIZ_TABLE\fP
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\f3CASE_INSENSITIVE\fP
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\f3COLOR\fP
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\f3COMPOUND_STRING_TABLE\fP
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\f3FONT\fP
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\f3FOREGROUND\fP
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\f3INTEGER\fP
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\f3MANAGED\fP
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\f3REASON\fP
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\f3SINGLE_FLOAT\fP
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\f3TRANSLATION_TABLE\fP
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\f3VERSION\fP
.if \n(48<\n(38 .nr 48 \n(38
.nr 38 \w\f3XBITMAPFILE\fP
.if \n(48<\n(38 .nr 48 \n(38
.48
.rm 48
.nr 49 0
.nr 38 \w\f3ARGUMENT\fP
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\f3BACKGROUND\fP
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\f3CASE_SENSITIVE\fP
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\f3COLOR_TABLE\fP
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\f3FILE\fP
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\f3FONT_TABLE\fP
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\f3ICON\fP
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\f3INTEGER_TABLE\fP
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\f3NAMES\fP
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\f3RGB\fP
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\f3STRING\fP
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\f3UNMANAGED\fP
.if \n(49<\n(38 .nr 49 \n(38
.nr 38 \w\f3WIDE_CHARACTER\fP
.if \n(49<\n(38 .nr 49 \n(38
.49
.rm 49
.nr 50 0
.nr 38 \w\f3ASCIZ_STRING_TABLE\fP
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \w\f3BOOLEAN\fP
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \w\f3CHARACTER_SET\fP
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \w\f3COMPOUND_STRING\fP
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \w\f3FLOAT\fP
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \w\f3FONTSET\fP
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \w\f3IMPORTED\fP
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \w\f3KEYSYM\fP
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \w\f3OBJECTS\fP
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \w\f3RIGHT_TO_LEFT\fP
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \w\f3STRING_TABLE\fP
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \w\f3USER_DEFINED\fP
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \w\f3WIDGET\fP
.if \n(50<\n(38 .nr 50 \n(38
.50
.rm 50
.nr 38 \wBuilt-in argument names (for example: \*LXmNx\*O, \*LXmNheight\*O)-\n(48-3n-\n(49-3n-\n(50
.if \n(38>0 .nr 38 \n(38/2
.if \n(38<0 .nr 38 0
.nr 49 +\n(38
.nr 50 +\n(38
.nr 38 \wBuilt-in reason names (for example: \*LXmNactivateCallback\*O, \*LXmNhelpCallback\*O)-\n(48-3n-\n(49-3n-\n(50
.if \n(38>0 .nr 38 \n(38/2
.if \n(38<0 .nr 38 0
.nr 49 +\n(38
.nr 50 +\n(38
.nr 38 \wCharacter set names (for example: \*LISO_LATIN1\*O, \*LISO_HEBREW_LR\*O)-\n(48-3n-\n(49-3n-\n(50
.if \n(38>0 .nr 38 \n(38/2
.if \n(38<0 .nr 38 0
.nr 49 +\n(38
.nr 50 +\n(38
.nr 38 \wConstant value names (for example: \*LXmMENU_OPTION\*O, \*LXmBROWSE_SELECT\*O)-\n(48-3n-\n(49-3n-\n(50
.if \n(38>0 .nr 38 \n(38/2
.if \n(38<0 .nr 38 0
.nr 49 +\n(38
.nr 50 +\n(38
.nr 38 \wObject types (for example: \*LXmPushButton\*O, \*LXmBulletinBoard\*O)-\n(48-3n-\n(49-3n-\n(50
.if \n(38>0 .nr 38 \n(38/2
.if \n(38<0 .nr 38 0
.nr 49 +\n(38
.nr 50 +\n(38
.nr 38 1n
.nr 47 0
.nr 40 \n(47+((0*\n(38)/2)
.nr 48 +\n(40
.nr 41 \n(48+((6*\n(38)/2)
.nr 49 +\n(41
.nr 42 \n(49+((6*\n(38)/2)
.nr 50 +\n(42
.nr TW \n(50
.if t .if (\n(TW+\n(.o)>7.65i .tm Table at line 742 file Input is too wide - \n(TW units
.nr #I \n(.i
.in +(\n(.lu-\n(TWu-\n(.iu)/2u
.fc  
.nr #T 0-1
.nr #a 0-1
.eo
.de T#
.nr 35 1m
.ds #d .d
.if \(ts\n(.z\(ts\(ts .ds #d nl
.mk ##
.nr ## -1v
.ls 1
.ls
..
.ec
.ta \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'Built-in argument names (for example: \*LXmNx\*O, \*LXmNheight\*O)
.ta \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'Built-in reason names (for example: \*LXmNactivateCallback\*O, \*LXmNhelpCallback\*O)
.ta \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'Character set names (for example: \*LISO_LATIN1\*O, \*LISO_HEBREW_LR\*O)
.ta \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'Constant value names (for example: \*LXmMENU_OPTION\*O, \*LXmBROWSE_SELECT\*O)
.ta \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'Object types (for example: \*LXmPushButton\*O, \*LXmBulletinBoard\*O)
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\f3ANY\f\n(31\h'|\n(41u'\f3ARGUMENT\f\n(31\h'|\n(42u'\f3ASCIZ_STRING_TABLE\f\n(31
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\f3ASCIZ_TABLE\f\n(31\h'|\n(41u'\f3BACKGROUND\f\n(31\h'|\n(42u'\f3BOOLEAN\f\n(31
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\f3CASE_INSENSITIVE\f\n(31\h'|\n(41u'\f3CASE_SENSITIVE\f\n(31\h'|\n(42u'\f3CHARACTER_SET\f\n(31
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\f3COLOR\f\n(31\h'|\n(41u'\f3COLOR_TABLE\f\n(31\h'|\n(42u'\f3COMPOUND_STRING\f\n(31
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\f3COMPOUND_STRING_TABLE\f\n(31\h'|\n(41u'\f3FILE\f\n(31\h'|\n(42u'\f3FLOAT\f\n(31
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\f3FONT\f\n(31\h'|\n(41u'\f3FONT_TABLE\f\n(31\h'|\n(42u'\f3FONTSET\f\n(31
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\f3FOREGROUND\f\n(31\h'|\n(41u'\f3ICON\f\n(31\h'|\n(42u'\f3IMPORTED\f\n(31
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\f3INTEGER\f\n(31\h'|\n(41u'\f3INTEGER_TABLE\f\n(31\h'|\n(42u'\f3KEYSYM\f\n(31
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\f3MANAGED\f\n(31\h'|\n(41u'\f3NAMES\f\n(31\h'|\n(42u'\f3OBJECTS\f\n(31
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\f3REASON\f\n(31\h'|\n(41u'\f3RGB\f\n(31\h'|\n(42u'\f3RIGHT_TO_LEFT\f\n(31
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\f3SINGLE_FLOAT\f\n(31\h'|\n(41u'\f3STRING\f\n(31\h'|\n(42u'\f3STRING_TABLE\f\n(31
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\f3TRANSLATION_TABLE\f\n(31\h'|\n(41u'\f3UNMANAGED\f\n(31\h'|\n(42u'\f3USER_DEFINED\f\n(31
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\f3VERSION\f\n(31\h'|\n(41u'\f3WIDE_CHARACTER\f\n(31\h'|\n(42u'\f3WIDGET\f\n(31
.ta \n(48u \n(49u \n(50u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\f3XBITMAPFILE\f\n(31\h'|\n(41u'\f3\f\n(31\h'|\n(42u'\f3\f\n(31
.fc
.nr T. 1
.T# 1
.in \n(#Iu
.35
.TE
.if \n-(b.=0 .nr c. \n(.c-\n(d.-27
.PP
String literals can be composed of the upper- and lower-case
letters, digits, and punctuation characters.
Spaces, tabs, and comments are special elements in the language.  They are
a means of delimiting other elements, such as two names.  One or more of
these elements can appear before or after any other element in the language.
However, spaces, tabs, and comments that appear in string literals are
treated as character sequences rather than delimiters.
.SS "Data Types"
.iX "UIL" "literals"
.iX "UIL module" "literals"
.iX "UIL specification file" "literals"
.iX "Values" "literals"
.PP
UIL provides literals for
several of the value types it supports.  Some of the value types are not
supported as literals (for example, pixmaps and string tables).  You can
specify values for these types 
by using functions described in the \*EFunctions\*O section.
UIL directly supports the following literal types:
.ML
.LI
String literal
.LI
Integer literal
.LI
Boolean literal
.LI
Floating-point literal
.LE
.PP
UIL also includes the data type \*LANY\*O, which is used to turn off compile
time checking of data types.
.SS "String Literals"
.iX "UIL" "string literals"
.iX "UIL module" "string literals"
.iX "UIL specification file" "string literals"
.iX "Values" "string literals"
.PP
A string literal is a sequence of zero or more 8-bit or 16-bit
characters or a combination 
delimited by \*L'\*O (single quotation marks) or \*L"\*O (double quotation marks).
String literals can also contain multibyte characters delimited with double
quotation marks.
String literals can be no more than 2000 characters long.
.PP
A single-quoted string literal can span multiple source lines.  To continue
a single-quoted string literal, terminate the continued line with a 
\*L\e\*O (backslash).  The literal continues with the first character
on the next line.
.PP
Double-quoted string literals cannot span multiple source lines.
(Because double-quoted strings can contain escape sequences and other special
characters, you cannot use the backslash character to designate
continuation of the string.)  To build a string value that must
span multiple source lines, use the concatenation operator described later
in this section.
.PP
The syntax of a string literal is one of the following:
.PP
.nf
\&\*L'\*O[\*Vcharacter_string\*O]\*L'\*O
[\*L#\*O\*Vchar_set\*O]\*L"\*O[\*Vcharacter_string\*O]\*L"\*O
.fi
.PP
Both string forms associate a character set with a string value.
UIL uses the following rules to determine the character set and
storage format for string literals:
.ML
.LI
A string declared as \*L'\*O\*Vstring\*O\*L'\*O is equivalent to
\*L#\*O\*Vcur_charset\*O\*L"\*O\*Vstring\*O\*L"\*O,
where \*Vcur_charset\*O will be the codeset
portion of the value of the \*LLANG\*O environment variable if it is set
or the value
of \*LXmFALLBACK_CHARSET\*O if \*LLANG\*O is not set or has no codeset
component.
By default \*LXmFALLBACK_CHARSET\*O is \*LISO8859-1\*O (equivalent to
\*LISO_LATIN1\*O), but vendors may define a different default.
.LI
A string declared as \*L"\*O\*Vstring\*O\*L"\*O is
equivalent to \*L#\*O\*Vchar_set\*O\*L"\*O\*Vstring\*O\*L"\*O if
you specified \*Vchar_set\*O as the default character set for the module.
If no default character set has been specified for the module, then
if the \*L-s\*O option is provided to the \*Luil\*O command or the
\*Luse_setlocale_flag\*O is set for the callable compiler, \*LUil()\*O, the
string will be interpreted to be a string in the current locale.  This means that
the string is parsed in the locale of the user by calling \*Lsetlocale\*O and its
charset is \*LXmFONTLIST_DEFAULT_TAG\*O, and that if the string is
converted to a compound string, it is stored as a locale encoded text segment.
Otherwise, \*L"\*O\*Vstring\*O\*L"\*O is equivalent
to \*L#\*O\*Vcur_charset\*O\*L"\*O\*Vstring\*O\*L"\*O, where
\*Vcur_charset\*O is interpreted as described for single quoted strings.
.LI
A string of the form \*L"\*O\*Vstring\*O\*L"\*O or
\*L#\*O\*Vchar_set\*O\*L"\*O\*Vstring\*O\*L"\*O is stored as a
null-terminated string.
.LE
.PP
The following table lists the character sets supported by the UIL compiler for
string literals.
Note that several UIL names map to the same character set.  In
some cases, the UIL name influences how string literals are read.  For example,
strings identified by a UIL character set name ending in _LR are read left-to-right.
Names that end in a different number reflect different fonts 
(for example, ISO_LATIN1 or ISO_LATIN6).
All character sets in this table are represented by 8 bits.
.PP
.TS
.if \n+(b.=1 .nr d. \n(.c-\n(c.-1
.de 35
.ps \n(.s
.vs \n(.vu
.in \n(.iu
.if \n(.u .fi
.if \n(.j .ad
.if \n(.j=0 .na
..
.nf
.nr #~ 0
.if \n(.T .if n .nr #~ 0.6n
.ds #d .d
.if \(ts\n(.z\(ts\(ts .ds #d nl
.fc
.nr 33 \n(.s
.rm 46 47
.nr 46 0
.nr 38 \w\f3UIL Name\fP
.if \n(46<\n(38 .nr 46 \n(38
.nr 38 \w\f3ISO_LATIN1\fP
.if \n(46<\n(38 .nr 46 \n(38
.nr 38 \w\f3ISO_LATIN2\fP
.if \n(46<\n(38 .nr 46 \n(38
.nr 38 \w\f3ISO_ARABIC\fP
.if \n(46<\n(38 .nr 46 \n(38
.nr 38 \w\f3ISO_LATIN6\fP
.if \n(46<\n(38 .nr 46 \n(38
.nr 38 \w\f3ISO_GREEK\fP
.if \n(46<\n(38 .nr 46 \n(38
.nr 38 \w\f3ISO_LATIN7\fP
.if \n(46<\n(38 .nr 46 \n(38
.nr 38 \w\f3ISO_HEBREW\fP
.if \n(46<\n(38 .nr 46 \n(38
.nr 38 \w\f3ISO_LATIN8\fP
.if \n(46<\n(38 .nr 46 \n(38
.nr 38 \w\f3ISO_HEBREW_LR\fP
.if \n(46<\n(38 .nr 46 \n(38
.nr 38 \w\f3ISO_LATIN8_LR\fP
.if \n(46<\n(38 .nr 46 \n(38
.nr 38 \w\f3JIS_KATAKANA\fP
.if \n(46<\n(38 .nr 46 \n(38
.46
.rm 46
.nr 47 0
.nr 38 \w\f3Description\fP
.if \n(47<\n(38 .nr 47 \n(38
.nr 38 \wGL: ASCII, GR: Latin-1 Supplement
.if \n(47<\n(38 .nr 47 \n(38
.nr 38 \wGL: ASCII, GR: Latin-2 Supplement
.if \n(47<\n(38 .nr 47 \n(38
.nr 38 \wGL: ASCII, GR: Latin-Arabic Supplement
.if \n(47<\n(38 .nr 47 \n(38
.nr 38 \wGL: ASCII, GR: Latin-Arabic Supplement
.if \n(47<\n(38 .nr 47 \n(38
.nr 38 \wGL: ASCII, GR: Latin-Greek Supplement
.if \n(47<\n(38 .nr 47 \n(38
.nr 38 \wGL: ASCII, GR: Latin-Greek Supplement
.if \n(47<\n(38 .nr 47 \n(38
.nr 38 \wGL: ASCII, GR: Latin-Hebrew Supplement
.if \n(47<\n(38 .nr 47 \n(38
.nr 38 \wGL: ASCII, GR: Latin-Hebrew Supplement
.if \n(47<\n(38 .nr 47 \n(38
.nr 38 \wGL: ASCII, GR: Latin-Hebrew Supplement
.if \n(47<\n(38 .nr 47 \n(38
.nr 38 \wGL: ASCII, GR: Latin-Hebrew Supplement
.if \n(47<\n(38 .nr 47 \n(38
.nr 38 \wGL: JIS Roman, GR: JIS Katakana
.if \n(47<\n(38 .nr 47 \n(38
.47
.rm 47
.nr 38 1n
.nr 45 0
.nr 40 \n(45+((0*\n(38)/2)
.nr 46 +\n(40
.nr 41 \n(46+((6*\n(38)/2)
.nr 47 +\n(41
.nr TW \n(47
.if t .if (\n(TW+\n(.o)>7.65i .tm Table at line 867 file Input is too wide - \n(TW units
.fc  
.nr #T 0-1
.nr #a 0-1
.eo
.de T#
.nr 35 1m
.ds #d .d
.if \(ts\n(.z\(ts\(ts .ds #d nl
.mk ##
.nr ## -1v
.ls 1
.ls
..
.ec
.ta \n(46u \n(47u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\f3UIL Name\f\n(31\h'|\n(41u'\f3Description\f\n(31
.ta \n(46u \n(47u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\f3ISO_LATIN1\f\n(31\h'|\n(41u'GL: ASCII, GR: Latin-1 Supplement
.ta \n(46u \n(47u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\f3ISO_LATIN2\f\n(31\h'|\n(41u'GL: ASCII, GR: Latin-2 Supplement
.ta \n(46u \n(47u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\f3ISO_ARABIC\f\n(31\h'|\n(41u'GL: ASCII, GR: Latin-Arabic Supplement
.ta \n(46u \n(47u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\f3ISO_LATIN6\f\n(31\h'|\n(41u'GL: ASCII, GR: Latin-Arabic Supplement
.ta \n(46u \n(47u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\f3ISO_GREEK\f\n(31\h'|\n(41u'GL: ASCII, GR: Latin-Greek Supplement
.ta \n(46u \n(47u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\f3ISO_LATIN7\f\n(31\h'|\n(41u'GL: ASCII, GR: Latin-Greek Supplement
.ta \n(46u \n(47u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\f3ISO_HEBREW\f\n(31\h'|\n(41u'GL: ASCII, GR: Latin-Hebrew Supplement
.ta \n(46u \n(47u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\f3ISO_LATIN8\f\n(31\h'|\n(41u'GL: ASCII, GR: Latin-Hebrew Supplement
.ta \n(46u \n(47u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\f3ISO_HEBREW_LR\f\n(31\h'|\n(41u'GL: ASCII, GR: Latin-Hebrew Supplement
.ta \n(46u \n(47u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\f3ISO_LATIN8_LR\f\n(31\h'|\n(41u'GL: ASCII, GR: Latin-Hebrew Supplement
.ta \n(46u \n(47u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\f3JIS_KATAKANA\f\n(31\h'|\n(41u'GL: JIS Roman, GR: JIS Katakana
.fc
.nr T. 1
.T# 1
.35
.TE
.if \n-(b.=0 .nr c. \n(.c-\n(d.-16
.PP
Following are the parsing rules for each
of the character sets:
.VL 5n
.LI "All\ character\ sets"
.nL
Character codes in the range 00...1F, 7F, and 80...9F are control characters 
including both bytes of 16-bit characters.  
The compiler flags these as illegal characters.
.LI "\*LISO_LATIN1\ ISO_LATIN2\ ISO_ARABIC\ ISO_LATIN3\ ISO_GREEK\ ISO_LATIN4\*O"
.nL
These sets are parsed from left to right.  
The escape sequences for null-terminated strings
are also supported by these character sets.
.LI "\*LISO_HEBREW\ ISO_LATIN8\*O"
.nL
These sets are parsed from right to left; for example,
the string \*L#ISO_HEBREW"012345"\*O generates a
primitive string "543210" with character set \*LISO_HEBREW\*O.  
A DDIS descriptor for such a string has this segment marked as 
being right_to_left.
The escape sequences for null-terminated
strings are also supported by these 
character sets, and the characters that compose the escape sequences are 
in left-to-right order.  For example, you type \en, not n\e.
.LI "\*LISO_HEBREW_LR\ ISO_LATIN8_LR\*O"
.nL
These sets are parsed from left to right; for example, 
the string \*L#ISO_HEBREW_LR"012345"\*O generates a primitive string "012345" 
with character set \*LISO_HEBREW\*O.
A DDIS descriptor for such a string marks this segment as being left_to_right.
The escape sequences for null-terminated strings
are also supported by these character sets.
.LI "\*LJIS_KATAKANA\*O"
.nL
This set is parsed from left to right.  The escape sequences
for null-terminated strings are also supported by this character
set.  Note that the \*L\e\*O (backslash) may be displayed as a yen symbol.
.LE
.PP
In addition to designating parsing rules for strings, character set
information remains an attribute of a compound string.  
If the string is included in a string consisting of
several concatenated segments, the character set information
is included with that string segment.
This gives the Motif Toolkit
the information it needs to decipher the 
compound string and choose a font to display the string.
.PP
For an application interface displayed only in English, 
UIL lets you ignore the distinctions between the two uses of strings.  
The compiler recognizes by context when a 
string must be passed as a null-terminated string or as a compound string.
.PP
The UIL compiler recognizes enough about the various character sets to
correctly parse string literals.  
The compiler also issues errors if you use a compound
string in a context that supports only null-terminated strings.
.PP
Since the character set names are keywords, you must
put them in lowercase if case-sensitive names are in force.
If names are case insensitive, character set names can be 
uppercase, lowercase, or mixed case.
.PP
In addition to the built-in character sets recognized by UIL, you can define
your own character sets with the \*LCHARACTER_SET\*O function.  You can use the
\*LCHARACTER_SET\*O function anywhere a character set can be specified.
.PP
String literals can contain characters with the eighth (high-order)
bit set.  You cannot type control characters (00..1F, 7F, and 80..9F)
directly in a single-quoted string literal.  However, you can represent these 
characters with escape sequences.  The following list shows the
escape sequences for special characters.
.VL 10n
.iX "UIL" "escape sequences"
.iX "Escape sequences"
.LI "\*L\eb\*O"
Backspace
.LI "\*L\ef\*O"
Form-feed
.LI "\*L\en\*O"
Newline
.LI "\*L\er\*O"
Carriage return
.LI "\*L\et\*O"
Horizontal tab
.LI "\*L\ev\*O"
Vertical tab
.LI "\*L\e'\*O"
Single quotation mark
.LI "\*L\e""""\*O"
Double quotation mark
.LI "\*L\e\e\*O"
Backslash
.LI "\*L\e\*O\*Vinteger\*O\^\*L\e\*O"
Character whose internal representation is given by
\*Vinteger\*O (in the range 0 to 255 decimal)
.LE
.PP
Note that escape sequences are processed literally in strings that are
parsed in the current locale (localized strings).
.PP
The UIL compiler does not process newline characters in compound
strings.
The effect of a newline character in a compound string depends only on
the character set of the string, and the result is not guaranteed to be
a multiline string.
.PP
\*LCompound String Literals\*O
.PP
A compound string consists of a string of 8-bit, 16-bit, or multibyte characters,
a named character set, and a writing direction.  Its UIL data type is 
\*Lcompound_string\*O.
.PP
The writing direction of a compound string is implied by the
character set specified for the string.  You can explicitly set the
writing direction for a compound string by using the \*LCOMPOUND_STRING\*O
function.  
.PP
A compound string can consist of a sequence of concatenated compound strings,
null-terminated strings, or a combination of both,
each of which can have a different character set property and writing
direction.  Use the
concatenation operator \*L&\*O (ampersand) to create a 
sequence of compound strings.
.PP
Each string in the sequence is stored, including
the character set and writing direction information.
.PP
Generally, a string literal is stored in the UID file as a compound
string when the literal consists of concatenated strings having
different character sets or writing directions, or when you 
use the string to specify a value for an argument that requires
a compound string value.  If you want to
guarantee that a string literal is stored as a compound string,
you must use the \*LCOMPOUND_STRING\*O function.
.PP
\*LData Storage Consumption for String Literals\*O
.PP
The way a string literal is stored in the UID file depends on 
how you declare and use the string.  The UIL compiler 
automatically converts a null-terminated string to 
a compound string if you use the string to specify the 
value of an argument that requires a compound string.
However, this conversion is costly in terms of storage
consumption.
.PP
\*LPRIVATE\*O, \*LEXPORTED\*O, and \*LIMPORTED\*O string literals require
storage for a single allocation when the literal is declared;
thereafter, storage is required for each reference to the 
literal.  Literals declared in-line require storage
for both an allocation and a reference.
.PP
The following table summarizes data storage consumption for
string literals.  The storage requirement for an 
allocation consists of a fixed portion and a variable 
portion.  The fixed portion of an allocation is roughly
the same as the storage requirement for a reference
(a few bytes).
The storage consumed by the variable portion
depends on the size of the literal value (that is, the 
length of the string).  To conserve storage space, avoid
making string literal declarations that result in an 
allocation per use.
.PP
.TS
.if \n+(b.=1 .nr d. \n(.c-\n(c.-1
.de 35
.ps \n(.s
.vs \n(.vu
.in \n(.iu
.if \n(.u .fi
.if \n(.j .ad
.if \n(.j=0 .na
..
.nf
.nr #~ 0
.if \n(.T .if n .nr #~ 0.6n
.ds #d .d
.if \(ts\n(.z\(ts\(ts .ds #d nl
.fc
.nr 33 \n(.s
.rm 50 51 52 53
.nr 34 \n(.lu
.eo
.am 53
.br
.di a+
.35
.ft \n(.f
.ll \n(34u*1u/5u
.if \n(.l<\n(53 .ll \n(53u
.in 0
An allocation and a reference (within the module)
.br
.di
.nr a| \n(dn
.nr a- \n(dl
..
.ec \
.eo
.am 53
.br
.di b+
.35
.ft \n(.f
.ll \n(34u*1u/5u
.if \n(.l<\n(53 .ll \n(53u
.in 0
A reference (within the module)
.br
.di
.nr b| \n(dn
.nr b- \n(dl
..
.ec \
.eo
.am 53
.br
.di c+
.35
.ft \n(.f
.ll \n(34u*1u/5u
.if \n(.l<\n(53 .ll \n(53u
.in 0
A reference (within the UID hierarchy)
.br
.di
.nr c| \n(dn
.nr c- \n(dl
..
.ec \
.eo
.am 53
.br
.di d+
.35
.ft \n(.f
.ll \n(34u*1u/5u
.if \n(.l<\n(53 .ll \n(53u
.in 0
A reference (within the UID hierarchy)
.br
.di
.nr d| \n(dn
.nr d- \n(dl
..
.ec \
.eo
.am 53
.br
.di e+
.35
.ft \n(.f
.ll \n(34u*1u/5u
.if \n(.l<\n(53 .ll \n(53u
.in 0
An allocation and a reference (within the module)
.br
.di
.nr e| \n(dn
.nr e- \n(dl
..
.ec \
.eo
.am 53
.br
.di f+
.35
.ft \n(.f
.ll \n(34u*1u/5u
.if \n(.l<\n(53 .ll \n(53u
.in 0
An allocation and a reference (within the module)
.br
.di
.nr f| \n(dn
.nr f- \n(dl
..
.ec \
.eo
.am 53
.br
.di g+
.35
.ft \n(.f
.ll \n(34u*1u/5u
.if \n(.l<\n(53 .ll \n(53u
.in 0
A reference (within the UID hierarchy)
.br
.di
.nr g| \n(dn
.nr g- \n(dl
..
.ec \
.eo
.am 53
.br
.di h+
.35
.ft \n(.f
.ll \n(34u*1u/5u
.if \n(.l<\n(53 .ll \n(53u
.in 0
A reference (within the UID hierarchy)
.br
.di
.nr h| \n(dn
.nr h- \n(dl
..
.ec \
.eo
.am 53
.br
.di i+
.35
.ft \n(.f
.ll \n(34u*1u/5u
.if \n(.l<\n(53 .ll \n(53u
.in 0
An allocation and a reference (within the module)
.br
.di
.nr i| \n(dn
.nr i- \n(dl
..
.ec \
.eo
.am 53
.br
.di j+
.35
.ft \n(.f
.ll \n(34u*1u/5u
.if \n(.l<\n(53 .ll \n(53u
.in 0
A reference (within the module)
.br
.di
.nr j| \n(dn
.nr j- \n(dl
..
.ec \
.eo
.am 53
.br
.di k+
.35
.ft \n(.f
.ll \n(34u*1u/5u
.if \n(.l<\n(53 .ll \n(53u
.in 0
A reference (within the UID hierarchy)
.br
.di
.nr k| \n(dn
.nr k- \n(dl
..
.ec \
.eo
.am 53
.br
.di l+
.35
.ft \n(.f
.ll \n(34u*1u/5u
.if \n(.l<\n(53 .ll \n(53u
.in 0
A reference (within the UID hierarchy)
.br
.di
.nr l| \n(dn
.nr l- \n(dl
..
.ec \
.35
.nf
.ll \n(34u
.nr 50 0
.nr 38 \w\f3Declaration\fP
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wIn-line
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wPrivate
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wExported
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wImported
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wIn-line
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wPrivate
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wExported
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wImported
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wIn-line
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wPrivate
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wExported
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \wImported
.if \n(50<\n(38 .nr 50 \n(38
.50
.rm 50
.nr 51 0
.nr 38 \w\f3Data Type\fP
.if \n(51<\n(38 .nr 51 \n(38
.nr 38 \wNull-terminated
.if \n(51<\n(38 .nr 51 \n(38
.nr 38 \wNull-terminated
.if \n(51<\n(38 .nr 51 \n(38
.nr 38 \wNull-terminated
.if \n(51<\n(38 .nr 51 \n(38
.nr 38 \wNull-terminated
.if \n(51<\n(38 .nr 51 \n(38
.nr 38 \wNull-terminated
.if \n(51<\n(38 .nr 51 \n(38
.nr 38 \wNull-terminated
.if \n(51<\n(38 .nr 51 \n(38
.nr 38 \wNull-terminated
.if \n(51<\n(38 .nr 51 \n(38
.nr 38 \wNull-terminated
.if \n(51<\n(38 .nr 51 \n(38
.nr 38 \wCompound
.if \n(51<\n(38 .nr 51 \n(38
.nr 38 \wCompound
.if \n(51<\n(38 .nr 51 \n(38
.nr 38 \wCompound
.if \n(51<\n(38 .nr 51 \n(38
.nr 38 \wCompound
.if \n(51<\n(38 .nr 51 \n(38
.51
.rm 51
.nr 52 0
.nr 38 \w\f3Used As\fP
.if \n(52<\n(38 .nr 52 \n(38
.nr 38 \wNull-terminated
.if \n(52<\n(38 .nr 52 \n(38
.nr 38 \wNull-terminated
.if \n(52<\n(38 .nr 52 \n(38
.nr 38 \wNull-terminated
.if \n(52<\n(38 .nr 52 \n(38
.nr 38 \wNull-terminated
.if \n(52<\n(38 .nr 52 \n(38
.nr 38 \wCompound
.if \n(52<\n(38 .nr 52 \n(38
.nr 38 \wCompound
.if \n(52<\n(38 .nr 52 \n(38
.nr 38 \wCompound
.if \n(52<\n(38 .nr 52 \n(38
.nr 38 \wCompound
.if \n(52<\n(38 .nr 52 \n(38
.nr 38 \wCompound
.if \n(52<\n(38 .nr 52 \n(38
.nr 38 \wCompound
.if \n(52<\n(38 .nr 52 \n(38
.nr 38 \wCompound
.if \n(52<\n(38 .nr 52 \n(38
.nr 38 \wCompound
.if \n(52<\n(38 .nr 52 \n(38
.52
.rm 52
.nr 53 0
.nr 38 \w\f3Storage Requirements\fP
.if \n(53<\n(38 .nr 53 \n(38
.nr 38 \w\f3Per Use\fP
.if \n(53<\n(38 .nr 53 \n(38
.53
.rm 53
.nr 38 \n(a-
.if \n(53<\n(38 .nr 53 \n(38
.nr 38 \n(b-
.if \n(53<\n(38 .nr 53 \n(38
.nr 38 \n(c-
.if \n(53<\n(38 .nr 53 \n(38
.nr 38 \n(d-
.if \n(53<\n(38 .nr 53 \n(38
.nr 38 \n(e-
.if \n(53<\n(38 .nr 53 \n(38
.nr 38 \n(f-
.if \n(53<\n(38 .nr 53 \n(38
.nr 38 \n(g-
.if \n(53<\n(38 .nr 53 \n(38
.nr 38 \n(h-
.if \n(53<\n(38 .nr 53 \n(38
.nr 38 \n(i-
.if \n(53<\n(38 .nr 53 \n(38
.nr 38 \n(j-
.if \n(53<\n(38 .nr 53 \n(38
.nr 38 \n(k-
.if \n(53<\n(38 .nr 53 \n(38
.nr 38 \n(l-
.if \n(53<\n(38 .nr 53 \n(38
.35
.nf
.ll \n(34u
.nr 38 1n
.nr 49 0
.nr 40 \n(49+((0*\n(38)/2)
.nr 50 +\n(40
.nr 41 \n(50+((6*\n(38)/2)
.nr 51 +\n(41
.nr 42 \n(51+((6*\n(38)/2)
.nr 52 +\n(42
.nr 43 \n(52+((6*\n(38)/2)
.nr 53 +\n(43
.nr TW \n(53
.if t .if (\n(TW+\n(.o)>7.65i .tm Table at line 1076 file Input is too wide - \n(TW units
.fc  
.nr #T 0-1
.nr #a 0-1
.eo
.de T#
.nr 35 1m
.ds #d .d
.if \(ts\n(.z\(ts\(ts .ds #d nl
.mk ##
.nr ## -1v
.ls 1
.ls
..
.ec
.nr #^ \n(\*(#du
.nr #- \n(#^
.ta \n(50u \n(51u \n(52u \n(53u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\h'|\n(41u'\h'|\n(42u'\h'|\n(43u'\f3Storage Requirements\f\n(31
.nr ^a \n(#^u
.nr ^b \n(#^u
.nr ^c \n(#^u
.nr #^ \n(\*(#du
.nr #- \n(#^
.ta \n(50u \n(51u \n(52u \n(53u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\v'-(\n(\*(#du-\n(^au-((\n(#-u-\n(^au)/2u)'\f3Declaration\f\n(31\v'(\n(\*(#du-\n(^au-((\n(#-u-\n(^au)/2u)'\h'|\n(41u'\v'-(\n(\*(#du-\n(^bu-((\n(#-u-\n(^bu)/2u)'\f3Data Type\f\n(31\v'(\n(\*(#du-\n(^bu-((\n(#-u-\n(^bu)/2u)'\h'|\n(42u'\v'-(\n(\*(#du-\n(^cu-((\n(#-u-\n(^cu)/2u)'\f3Used As\f\n(31\v'(\n(\*(#du-\n(^cu-((\n(#-u-\n(^cu)/2u)'\h'|\n(43u'\f3Per Use\f\n(31
.ne \n(a|u+\n(.Vu
.if (\n(a|+\n(#^-1v)>\n(#- .nr #- +(\n(a|+\n(#^-\n(#--1v)
.ta \n(50u \n(51u \n(52u \n(53u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'In-line\h'|\n(41u'Null-terminated\h'|\n(42u'Null-terminated\h'|\n(43u'
.mk ##
.nr 31 \n(##
.sp |\n(##u-1v
.nr 37 \n(43u
.in +\n(37u
.a+
.in -\n(37u
.mk 32
.if \n(32>\n(31 .nr 31 \n(32
.sp |\n(31u
.ne \n(b|u+\n(.Vu
.if (\n(b|+\n(#^-1v)>\n(#- .nr #- +(\n(b|+\n(#^-\n(#--1v)
.ta \n(50u \n(51u \n(52u \n(53u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'Private\h'|\n(41u'Null-terminated\h'|\n(42u'Null-terminated\h'|\n(43u'
.mk ##
.nr 31 \n(##
.sp |\n(##u-1v
.nr 37 \n(43u
.in +\n(37u
.b+
.in -\n(37u
.mk 32
.if \n(32>\n(31 .nr 31 \n(32
.sp |\n(31u
.ne \n(c|u+\n(.Vu
.if (\n(c|+\n(#^-1v)>\n(#- .nr #- +(\n(c|+\n(#^-\n(#--1v)
.ta \n(50u \n(51u \n(52u \n(53u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'Exported\h'|\n(41u'Null-terminated\h'|\n(42u'Null-terminated\h'|\n(43u'
.mk ##
.nr 31 \n(##
.sp |\n(##u-1v
.nr 37 \n(43u
.in +\n(37u
.c+
.in -\n(37u
.mk 32
.if \n(32>\n(31 .nr 31 \n(32
.sp |\n(31u
.ne \n(d|u+\n(.Vu
.if (\n(d|+\n(#^-1v)>\n(#- .nr #- +(\n(d|+\n(#^-\n(#--1v)
.ta \n(50u \n(51u \n(52u \n(53u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'Imported\h'|\n(41u'Null-terminated\h'|\n(42u'Null-terminated\h'|\n(43u'
.mk ##
.nr 31 \n(##
.sp |\n(##u-1v
.nr 37 \n(43u
.in +\n(37u
.d+
.in -\n(37u
.mk 32
.if \n(32>\n(31 .nr 31 \n(32
.sp |\n(31u
.ne \n(e|u+\n(.Vu
.if (\n(e|+\n(#^-1v)>\n(#- .nr #- +(\n(e|+\n(#^-\n(#--1v)
.ta \n(50u \n(51u \n(52u \n(53u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'In-line\h'|\n(41u'Null-terminated\h'|\n(42u'Compound\h'|\n(43u'
.mk ##
.nr 31 \n(##
.sp |\n(##u-1v
.nr 37 \n(43u
.in +\n(37u
.e+
.in -\n(37u
.mk 32
.if \n(32>\n(31 .nr 31 \n(32
.sp |\n(31u
.ne \n(f|u+\n(.Vu
.if (\n(f|+\n(#^-1v)>\n(#- .nr #- +(\n(f|+\n(#^-\n(#--1v)
.ta \n(50u \n(51u \n(52u \n(53u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'Private\h'|\n(41u'Null-terminated\h'|\n(42u'Compound\h'|\n(43u'
.mk ##
.nr 31 \n(##
.sp |\n(##u-1v
.nr 37 \n(43u
.in +\n(37u
.f+
.in -\n(37u
.mk 32
.if \n(32>\n(31 .nr 31 \n(32
.sp |\n(31u
.ne \n(g|u+\n(.Vu
.if (\n(g|+\n(#^-1v)>\n(#- .nr #- +(\n(g|+\n(#^-\n(#--1v)
.ta \n(50u \n(51u \n(52u \n(53u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'Exported\h'|\n(41u'Null-terminated\h'|\n(42u'Compound\h'|\n(43u'
.mk ##
.nr 31 \n(##
.sp |\n(##u-1v
.nr 37 \n(43u
.in +\n(37u
.g+
.in -\n(37u
.mk 32
.if \n(32>\n(31 .nr 31 \n(32
.sp |\n(31u
.ne \n(h|u+\n(.Vu
.if (\n(h|+\n(#^-1v)>\n(#- .nr #- +(\n(h|+\n(#^-\n(#--1v)
.ta \n(50u \n(51u \n(52u \n(53u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'Imported\h'|\n(41u'Null-terminated\h'|\n(42u'Compound\h'|\n(43u'
.mk ##
.nr 31 \n(##
.sp |\n(##u-1v
.nr 37 \n(43u
.in +\n(37u
.h+
.in -\n(37u
.mk 32
.if \n(32>\n(31 .nr 31 \n(32
.sp |\n(31u
.ne \n(i|u+\n(.Vu
.if (\n(i|+\n(#^-1v)>\n(#- .nr #- +(\n(i|+\n(#^-\n(#--1v)
.ta \n(50u \n(51u \n(52u \n(53u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'In-line\h'|\n(41u'Compound\h'|\n(42u'Compound\h'|\n(43u'
.mk ##
.nr 31 \n(##
.sp |\n(##u-1v
.nr 37 \n(43u
.in +\n(37u
.i+
.in -\n(37u
.mk 32
.if \n(32>\n(31 .nr 31 \n(32
.sp |\n(31u
.ne \n(j|u+\n(.Vu
.if (\n(j|+\n(#^-1v)>\n(#- .nr #- +(\n(j|+\n(#^-\n(#--1v)
.ta \n(50u \n(51u \n(52u \n(53u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'Private\h'|\n(41u'Compound\h'|\n(42u'Compound\h'|\n(43u'
.mk ##
.nr 31 \n(##
.sp |\n(##u-1v
.nr 37 \n(43u
.in +\n(37u
.j+
.in -\n(37u
.mk 32
.if \n(32>\n(31 .nr 31 \n(32
.sp |\n(31u
.ne \n(k|u+\n(.Vu
.if (\n(k|+\n(#^-1v)>\n(#- .nr #- +(\n(k|+\n(#^-\n(#--1v)
.ta \n(50u \n(51u \n(52u \n(53u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'Exported\h'|\n(41u'Compound\h'|\n(42u'Compound\h'|\n(43u'
.mk ##
.nr 31 \n(##
.sp |\n(##u-1v
.nr 37 \n(43u
.in +\n(37u
.k+
.in -\n(37u
.mk 32
.if \n(32>\n(31 .nr 31 \n(32
.sp |\n(31u
.ne \n(l|u+\n(.Vu
.if (\n(l|+\n(#^-1v)>\n(#- .nr #- +(\n(l|+\n(#^-\n(#--1v)
.ta \n(50u \n(51u \n(52u \n(53u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'Imported\h'|\n(41u'Compound\h'|\n(42u'Compound\h'|\n(43u'
.mk ##
.nr 31 \n(##
.sp |\n(##u-1v
.nr 37 \n(43u
.in +\n(37u
.l+
.in -\n(37u
.mk 32
.if \n(32>\n(31 .nr 31 \n(32
.sp |\n(31u
.fc
.nr T. 1
.T# 1
.35
.rm a+
.rm b+
.rm c+
.rm d+
.rm e+
.rm f+
.rm g+
.rm h+
.rm i+
.rm j+
.rm k+
.rm l+
.TE
.if \n-(b.=0 .nr c. \n(.c-\n(d.-43
.SS "Integer Literals"
.iX "UIL" "integer literals"
.iX "UIL module" "integer literals"
.iX "UIL specification file" "integer literals"
.iX "Values" "integer literals"
.PP
An integer literal represents the value of a whole number.
Integer literals have the form of 
an optional sign followed by one or more decimal digits.
An integer literal must not contain embedded spaces or commas.
.PP
Integer literals are stored in the UID file as long integers.
Exported and imported integer literals require a single allocation
when the literal is declared; thereafter, a few bytes of
storage are required for each reference to the literal.  Private
integer literals and those declared in-line require allocation
and reference storage per use.  To conserve storage
space, avoid making integer literal declarations that result
in an allocation per use.
.PP
The following table shows data storage consumption for integer
literals.
.PP
.TS
.if \n+(b.=1 .nr d. \n(.c-\n(c.-1
.de 35
.ps \n(.s
.vs \n(.vu
.in \n(.iu
.if \n(.u .fi
.if \n(.j .ad
.if \n(.j=0 .na
..
.nf
.nr #~ 0
.if \n(.T .if n .nr #~ 0.6n
.ds #d .d
.if \(ts\n(.z\(ts\(ts .ds #d nl
.fc
.nr 33 \n(.s
.rm 46 47
.nr 46 0
.nr 38 \w\f3Declaration\fP
.if \n(46<\n(38 .nr 46 \n(38
.nr 38 \wIn-line
.if \n(46<\n(38 .nr 46 \n(38
.nr 38 \wPrivate
.if \n(46<\n(38 .nr 46 \n(38
.nr 38 \wExported
.if \n(46<\n(38 .nr 46 \n(38
.nr 38 \wImported
.if \n(46<\n(38 .nr 46 \n(38
.46
.rm 46
.nr 47 0
.nr 38 \w\f3Storage Requirements Per Use\fP
.if \n(47<\n(38 .nr 47 \n(38
.nr 38 \wAn allocation and a reference (within the module)
.if \n(47<\n(38 .nr 47 \n(38
.nr 38 \wAn allocation and a reference (within the module)
.if \n(47<\n(38 .nr 47 \n(38
.nr 38 \wA reference (within the UID hierarchy)
.if \n(47<\n(38 .nr 47 \n(38
.nr 38 \wA reference (within the UID hierarchy)
.if \n(47<\n(38 .nr 47 \n(38
.47
.rm 47
.nr 38 1n
.nr 45 0
.nr 40 \n(45+((0*\n(38)/2)
.nr 46 +\n(40
.nr 41 \n(46+((6*\n(38)/2)
.nr 47 +\n(41
.nr TW \n(47
.if t .if (\n(TW+\n(.o)>7.65i .tm Table at line 1109 file Input is too wide - \n(TW units
.fc  
.nr #T 0-1
.nr #a 0-1
.eo
.de T#
.nr 35 1m
.ds #d .d
.if \(ts\n(.z\(ts\(ts .ds #d nl
.mk ##
.nr ## -1v
.ls 1
.ls
..
.ec
.ta \n(46u \n(47u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\f3Declaration\f\n(31\h'|\n(41u'\f3Storage Requirements Per Use\f\n(31
.ta \n(46u \n(47u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'In-line\h'|\n(41u'An allocation and a reference (within the module)
.ta \n(46u \n(47u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'Private\h'|\n(41u'An allocation and a reference (within the module)
.ta \n(46u \n(47u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'Exported\h'|\n(41u'A reference (within the UID hierarchy)
.ta \n(46u \n(47u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'Imported\h'|\n(41u'A reference (within the UID hierarchy)
.fc
.nr T. 1
.T# 1
.35
.TE
.if \n-(b.=0 .nr c. \n(.c-\n(d.-9
.SS "Boolean Literal"
.PP
.iX "UIL" "Boolean literals"
.iX "UIL module" "Boolean literals"
.iX "UIL specification file" "Boolean literals"
.iX "Values" "Boolean literals"
.iX "Boolean literals"
A Boolean literal represents the value True (reserved keyword \*LTRUE\*O
or \*LOn\*O) or False (reserved keyword \*LFALSE\*O or \*LOff\*O).
These keywords are subject to case-sensitivity rules.
.PP
In a UID file, \*LTRUE\*O is represented by the integer value 1 and
\*LFALSE\*O is represented by the integer value 0.
.PP
Data storage consumption for Boolean literals is the same
as that for integer literals.
.SS "Floating-Point Literal"
.iX "UIL" "floating-point literals"
.iX "UIL module" "floating-point literals"
.iX "UIL specification file" "floating-point literals"
.iX "Values" "floating-point literals"
.PP
A floating-point literal represents the value of a real (or float) number.
Floating-point literals have the following form:
.PP
.nf
[\*L+\*O|\*L-\*O][\*Vinteger\*O]\*L.\*O\*Vinteger\*O[\*LE\*O|\*Le\*O[\*L+\*O|\*L-\*O]\*Vexponent\*O]
.fi
.PP
For maximum portability a floating-point literal can represent values in
the range 1.0E-37 to 1.0E+37
with at least 6 significant digits.
On many machines this range will be wider, with more significant digits.
A floating-point literal must not contain embedded spaces or commas.
.PP
Floating-point literals are stored in the UID file as 
double-precision, floating-point numbers.
The following table
gives examples of valid and invalid floating-point 
notation for the UIL compiler.
.PP
.TS
.if \n+(b.=1 .nr d. \n(.c-\n(c.-1
.de 35
.ps \n(.s
.vs \n(.vu
.in \n(.iu
.if \n(.u .fi
.if \n(.j .ad
.if \n(.j=0 .na
..
.nf
.nr #~ 0
.if \n(.T .if n .nr #~ 0.6n
.ds #d .d
.if \(ts\n(.z\(ts\(ts .ds #d nl
.fc
.nr 33 \n(.s
.rm 46 47
.nr 46 0
.nr 38 \w\f3Valid Floating-Point Literals\fP
.if \n(46<\n(38 .nr 46 \n(38
.nr 38 \w1.0
.if \n(46<\n(38 .nr 46 \n(38
.nr 38 \w.1
.if \n(46<\n(38 .nr 46 \n(38
.nr 38 \w3.1415E\-2 (equals .031415)
.if \n(46<\n(38 .nr 46 \n(38
.nr 38 \w\-6.29e7 (equals \-62900000)
.if \n(46<\n(38 .nr 46 \n(38
.46
.rm 46
.nr 47 0
.nr 38 \w\f3Invalid Floating-Point Literals\fP
.if \n(47<\n(38 .nr 47 \n(38
.nr 38 \w1e1 (no decimal point)
.if \n(47<\n(38 .nr 47 \n(38
.nr 38 \wE\-1 (no decimal point or digits)
.if \n(47<\n(38 .nr 47 \n(38
.nr 38 \w2.87 e6 (embedded blanks)
.if \n(47<\n(38 .nr 47 \n(38
.nr 38 \w2.0e100 (out of range)
.if \n(47<\n(38 .nr 47 \n(38
.47
.rm 47
.nr 38 1n
.nr 45 0
.nr 40 \n(45+((0*\n(38)/2)
.nr 46 +\n(40
.nr 41 \n(46+((6*\n(38)/2)
.nr 47 +\n(41
.nr TW \n(47
.if t .if (\n(TW+\n(.o)>7.65i .tm Table at line 1160 file Input is too wide - \n(TW units
.nr #I \n(.i
.in +(\n(.lu-\n(TWu-\n(.iu)/2u
.fc  
.nr #T 0-1
.nr #a 0-1
.eo
.de T#
.nr 35 1m
.ds #d .d
.if \(ts\n(.z\(ts\(ts .ds #d nl
.mk ##
.nr ## -1v
.ls 1
.ls
..
.ec
.ta \n(46u \n(47u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\f3Valid Floating-Point Literals\f\n(31\h'|\n(41u'\f3Invalid Floating-Point Literals\f\n(31
.ta \n(46u \n(47u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'1.0\h'|\n(41u'1e1 (no decimal point)
.ta \n(46u \n(47u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'.1\h'|\n(41u'E\-1 (no decimal point or digits)
.ta \n(46u \n(47u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'3.1415E\-2 (equals .031415)\h'|\n(41u'2.87 e6 (embedded blanks)
.ta \n(46u \n(47u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\-6.29e7 (equals \-62900000)\h'|\n(41u'2.0e100 (out of range)
.fc
.nr T. 1
.T# 1
.in \n(#Iu
.35
.TE
.if \n-(b.=0 .nr c. \n(.c-\n(d.-9
.PP
Data storage consumption for floating-point literals is
the same as that for integer literals.
.SS "The ANY Data Type"
.PP
.iX "UIL" "ANY value"
.iX "UIL module" "ANY value"
.iX "UIL specification file" "ANY value"
.iX "Functions" "ANY value"
.iX "ANY value"
The purpose of the 
\*LANY\*O
data type is to shut off the data-type checking feature of the UIL compiler.
You can use the 
\*LANY\*O
data type for the following:
.ML
.LI
Specifying the type of a callback procedure tag
.LI
Specifying the type of a user-defined argument
.LE
.PP
You can use the 
\*LANY\*O
data type when you need to use a type not
supported by the UIL compiler or when you want the data-type
restrictions imposed by the compiler to be relaxed.
For example, you might want to define a widget having an argument that
can accept different types of values, depending on run-time
circumstances.
.PP
If you specify that an argument takes an 
\*LANY\*O
value, the compiler does not
check the type of the value specified for that argument; therefore, you
need to take care when specifying a value for an argument of type 
\*LANY\*O.
You could get unexpected results at run time if you pass a value having
a data type that the widget does not support for that argument.
.SS "Expressions"
.PP
.iX "UIL" "expressions"
.iX "expressions"
UIL includes compile-time value expressions.  These expressions
can contain references to other UIL values, but cannot be 
forward referenced.
.PP
The following table lists the set of operators in UIL that allow
you to create integer, real, and Boolean values based on other values
defined
with the UIL module.  In the table, a precedence of 1 is the highest.
.PP
.TS
.if \n+(b.=1 .nr d. \n(.c-\n(c.-1
.de 35
.ps \n(.s
.vs \n(.vu
.in \n(.iu
.if \n(.u .fi
.if \n(.j .ad
.if \n(.j=0 .na
..
.nf
.nr #~ 0
.if \n(.T .if n .nr #~ 0.6n
.ds #d .d
.if \(ts\n(.z\(ts\(ts .ds #d nl
.fc
.nr 33 \n(.s
.rm 50 51 52 53
.nr 50 0
.nr 38 \w\f3Operator\fP
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \w\f3~\fP
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \w\f3-\fP
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \w\f3+\fP
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \w\f3*\fP
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \w\f3/\fP
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \w\f3+\fP
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \w\f3\-\fP
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \w\f3>>\fP
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \w\f3<<\fP
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \w\f3&\fP
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \w\f3|\fP
.if \n(50<\n(38 .nr 50 \n(38
.nr 38 \w\f3^\fP
.if \n(50<\n(38 .nr 50 \n(38
.50
.rm 50
.nr 51 0
.nr 38 \w\f3Operand Types\fP
.if \n(51<\n(38 .nr 51 \n(38
.nr 38 \wBoolean
.if \n(51<\n(38 .nr 51 \n(38
.nr 38 \winteger
.if \n(51<\n(38 .nr 51 \n(38
.nr 38 \wfloat
.if \n(51<\n(38 .nr 51 \n(38
.nr 38 \winteger
.if \n(51<\n(38 .nr 51 \n(38
.nr 38 \wfloat
.if \n(51<\n(38 .nr 51 \n(38
.nr 38 \winteger
.if \n(51<\n(38 .nr 51 \n(38
.nr 38 \wfloat,float
.if \n(51<\n(38 .nr 51 \n(38
.nr 38 \winteger,integer
.if \n(51<\n(38 .nr 51 \n(38
.nr 38 \wfloat,float
.if \n(51<\n(38 .nr 51 \n(38
.nr 38 \winteger,integer
.if \n(51<\n(38 .nr 51 \n(38
.nr 38 \wfloat,float
.if \n(51<\n(38 .nr 51 \n(38
.nr 38 \winteger,integer
.if \n(51<\n(38 .nr 51 \n(38
.nr 38 \wfloat,float
.if \n(51<\n(38 .nr 51 \n(38
.nr 38 \winteger,integer
.if \n(51<\n(38 .nr 51 \n(38
.nr 38 \winteger,integer
.if \n(51<\n(38 .nr 51 \n(38
.nr 38 \winteger,integer
.if \n(51<\n(38 .nr 51 \n(38
.nr 38 \wBoolean,Boolean
.if \n(51<\n(38 .nr 51 \n(38
.nr 38 \winteger,integer
.if \n(51<\n(38 .nr 51 \n(38
.nr 38 \wstring,string
.if \n(51<\n(38 .nr 51 \n(38
.nr 38 \wBoolean,Boolean
.if \n(51<\n(38 .nr 51 \n(38
.nr 38 \winteger,integer
.if \n(51<\n(38 .nr 51 \n(38
.nr 38 \wBoolean,Boolean
.if \n(51<\n(38 .nr 51 \n(38
.nr 38 \winteger,integer
.if \n(51<\n(38 .nr 51 \n(38
.51
.rm 51
.nr 52 0
.nr 38 \w\f3Meaning\fP
.if \n(52<\n(38 .nr 52 \n(38
.nr 38 \wNOT
.if \n(52<\n(38 .nr 52 \n(38
.nr 38 \wOne's complement
.if \n(52<\n(38 .nr 52 \n(38
.nr 38 \wNegate
.if \n(52<\n(38 .nr 52 \n(38
.nr 38 \wNegate
.if \n(52<\n(38 .nr 52 \n(38
.nr 38 \wNOP
.if \n(52<\n(38 .nr 52 \n(38
.nr 38 \wNOP
.if \n(52<\n(38 .nr 52 \n(38
.nr 38 \wMultiply
.if \n(52<\n(38 .nr 52 \n(38
.nr 38 \wMultiply
.if \n(52<\n(38 .nr 52 \n(38
.nr 38 \wDivide
.if \n(52<\n(38 .nr 52 \n(38
.nr 38 \wDivide
.if \n(52<\n(38 .nr 52 \n(38
.nr 38 \wAdd
.if \n(52<\n(38 .nr 52 \n(38
.nr 38 \wAdd
.if \n(52<\n(38 .nr 52 \n(38
.nr 38 \wSubtract
.if \n(52<\n(38 .nr 52 \n(38
.nr 38 \wSubtract
.if \n(52<\n(38 .nr 52 \n(38
.nr 38 \wShift right
.if \n(52<\n(38 .nr 52 \n(38
.nr 38 \wShift left
.if \n(52<\n(38 .nr 52 \n(38
.nr 38 \wAND
.if \n(52<\n(38 .nr 52 \n(38
.nr 38 \wBitwise AND
.if \n(52<\n(38 .nr 52 \n(38
.nr 38 \wConcatenate
.if \n(52<\n(38 .nr 52 \n(38
.nr 38 \wOR
.if \n(52<\n(38 .nr 52 \n(38
.nr 38 \wBitwise OR
.if \n(52<\n(38 .nr 52 \n(38
.nr 38 \wXOR
.if \n(52<\n(38 .nr 52 \n(38
.nr 38 \wBitwise XOR
.if \n(52<\n(38 .nr 52 \n(38
.52
.rm 52
.nr 53 0
.nr 38 \w\f3Precedence\fP
.if \n(53<\n(38 .nr 53 \n(38
.nr 38 \w1
.if \n(53<\n(38 .nr 53 \n(38
.nr 38 \w1
.if \n(53<\n(38 .nr 53 \n(38
.nr 38 \w1
.if \n(53<\n(38 .nr 53 \n(38
.nr 38 \w2
.if \n(53<\n(38 .nr 53 \n(38
.nr 38 \w2
.if \n(53<\n(38 .nr 53 \n(38
.nr 38 \w3
.if \n(53<\n(38 .nr 53 \n(38
.nr 38 \w3
.if \n(53<\n(38 .nr 53 \n(38
.nr 38 \w4
.if \n(53<\n(38 .nr 53 \n(38
.nr 38 \w4
.if \n(53<\n(38 .nr 53 \n(38
.nr 38 \w5
.if \n(53<\n(38 .nr 53 \n(38
.nr 38 \w6
.if \n(53<\n(38 .nr 53 \n(38
.nr 38 \w6
.if \n(53<\n(38 .nr 53 \n(38
.53
.rm 53
.nr 38 1n
.nr 49 0
.nr 40 \n(49+((0*\n(38)/2)
.nr 50 +\n(40
.nr 41 \n(50+((6*\n(38)/2)
.nr 51 +\n(41
.nr 42 \n(51+((6*\n(38)/2)
.nr 52 +\n(42
.nr 43 \n(52+((6*\n(38)/2)
.nr 53 +\n(43
.nr TW \n(53
.if t .if (\n(TW+\n(.o)>7.65i .tm Table at line 1242 file Input is too wide - \n(TW units
.nr #I \n(.i
.in +(\n(.lu-\n(TWu-\n(.iu)/2u
.fc  
.nr #T 0-1
.nr #a 0-1
.eo
.de T#
.nr 35 1m
.ds #d .d
.if \(ts\n(.z\(ts\(ts .ds #d nl
.mk ##
.nr ## -1v
.ls 1
.ls
..
.ec
.ta \n(50u \n(51u \n(52u \n(53u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\f3Operator\f\n(31\h'|\n(41u'\f3Operand Types\f\n(31\h'|\n(42u'\f3Meaning\f\n(31\h'|\n(43u'\f3Precedence\f\n(31
.ta \n(50u \n(51u \n(52u \n(53u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\f3~\f\n(31\h'|\n(41u'Boolean\h'|\n(42u'NOT\h'|\n(43u'1
.ta \n(50u \n(51u \n(52u \n(53u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\f3\f\n(31\h'|\n(41u'integer\h'|\n(42u'One's complement\h'|\n(43u'
.ta \n(50u \n(51u \n(52u \n(53u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\f3-\f\n(31\h'|\n(41u'float\h'|\n(42u'Negate\h'|\n(43u'1
.ta \n(50u \n(51u \n(52u \n(53u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\f3\f\n(31\h'|\n(41u'integer\h'|\n(42u'Negate\h'|\n(43u'
.ta \n(50u \n(51u \n(52u \n(53u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\f3+\f\n(31\h'|\n(41u'float\h'|\n(42u'NOP\h'|\n(43u'1
.ta \n(50u \n(51u \n(52u \n(53u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\f3\f\n(31\h'|\n(41u'integer\h'|\n(42u'NOP\h'|\n(43u'
.ta \n(50u \n(51u \n(52u \n(53u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\f3*\f\n(31\h'|\n(41u'float,float\h'|\n(42u'Multiply\h'|\n(43u'2
.ta \n(50u \n(51u \n(52u \n(53u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\f3\f\n(31\h'|\n(41u'integer,integer\h'|\n(42u'Multiply\h'|\n(43u'
.ta \n(50u \n(51u \n(52u \n(53u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\f3/\f\n(31\h'|\n(41u'float,float\h'|\n(42u'Divide\h'|\n(43u'2
.ta \n(50u \n(51u \n(52u \n(53u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\f3\f\n(31\h'|\n(41u'integer,integer\h'|\n(42u'Divide\h'|\n(43u'
.ta \n(50u \n(51u \n(52u \n(53u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\f3+\f\n(31\h'|\n(41u'float,float\h'|\n(42u'Add\h'|\n(43u'3
.ta \n(50u \n(51u \n(52u \n(53u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\f3\f\n(31\h'|\n(41u'integer,integer\h'|\n(42u'Add\h'|\n(43u'
.ta \n(50u \n(51u \n(52u \n(53u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\f3\-\f\n(31\h'|\n(41u'float,float\h'|\n(42u'Subtract\h'|\n(43u'3
.ta \n(50u \n(51u \n(52u \n(53u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\f3\f\n(31\h'|\n(41u'integer,integer\h'|\n(42u'Subtract\h'|\n(43u'
.ta \n(50u \n(51u \n(52u \n(53u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\f3>>\f\n(31\h'|\n(41u'integer,integer\h'|\n(42u'Shift right\h'|\n(43u'4
.ta \n(50u \n(51u \n(52u \n(53u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\f3<<\f\n(31\h'|\n(41u'integer,integer\h'|\n(42u'Shift left\h'|\n(43u'4
.ta \n(50u \n(51u \n(52u \n(53u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\f3&\f\n(31\h'|\n(41u'Boolean,Boolean\h'|\n(42u'AND\h'|\n(43u'5
.ta \n(50u \n(51u \n(52u \n(53u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\f3\f\n(31\h'|\n(41u'integer,integer\h'|\n(42u'Bitwise AND\h'|\n(43u'
.ta \n(50u \n(51u \n(52u \n(53u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\f3\f\n(31\h'|\n(41u'string,string\h'|\n(42u'Concatenate\h'|\n(43u'
.ta \n(50u \n(51u \n(52u \n(53u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\f3|\f\n(31\h'|\n(41u'Boolean,Boolean\h'|\n(42u'OR\h'|\n(43u'6
.ta \n(50u \n(51u \n(52u \n(53u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\f3\f\n(31\h'|\n(41u'integer,integer\h'|\n(42u'Bitwise OR\h'|\n(43u'
.ta \n(50u \n(51u \n(52u \n(53u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\f3^\f\n(31\h'|\n(41u'Boolean,Boolean\h'|\n(42u'XOR\h'|\n(43u'6
.ta \n(50u \n(51u \n(52u \n(53u 
.nr 35 1m
.nr 31 \n(.f
\&\h'|\n(40u'\f3\f\n(31\h'|\n(41u'integer,integer\h'|\n(42u'Bitwise XOR\h'|\n(43u'
.fc
.nr T. 1
.T# 1
.in \n(#Iu
.35
.TE
.if \n-(b.=0 .nr c. \n(.c-\n(d.-28
.PP
A string can be either a single compound string or a sequence of
compound strings.  If the two
concatenated strings have different properties (such as writing
direction or character set), the result of the concatenation is a 
multisegment compound string.
.PP
The string resulting from the concatenation is a null-terminated string
unless one or more of the following conditions exists:
.ML
.LI
One of the operands is a compound string
.LI
The operands have different character set properties
.LI
The operands have different writing directions
.LE
.PP
Then the resulting string is a compound string.   
You cannot use imported or exported values as operands of the concatenation 
operator.
.PP
The result of each operator has the same type as its operands.
You cannot mix types in an expression without using conversion routines.
.PP
You can use parentheses to override the normal precedence of operators.
In a sequence of unary operators, the operations are performed in
right-to-left
order.  For example, \*L\- + \-A\*O is equivalent to \*L\-(+(\-A))\*O.
In a sequence of binary operators of the same precedence, the operations
are performed in left-to-right order.  For example, \*LA*B/C*D\*O is
equivalent to \*L((A*B)/C)*D\*O.
.PP
A value declaration gives a value a name.  You cannot redefine the value
of that name in a subsequent value declaration.
You can use a value containing operators and functions anywhere you can
use a value in a UIL module.
You cannot use imported values as operands in expressions.
.iX "UIL" "data type conversions"
.iX "Data type" "conversions"
.iX "Conversions" "data type"
.PP
Several of the binary operators are defined for multiple data types.
For example, the operator for multiplication (\*L*\*O) is defined for both
floating-point and integer operands.
.PP
For the UIL compiler to perform these binary operations, both
operands must be of the same type.
If you supply operands of different data types, the UIL compiler
automatically converts one of the operands to the type of the other
according to the following conversions rules.
.ML
.LI
If the operands are an integer and a boolean, the boolean is converted
to an integer.
.LI
If the operands are an integer and a floating-point, the integer is converted
to an floating-point.
.LI
If the operands are a floating-point and a boolean, the boolean is converted
to a floating-point.
.LE
.PP
You can also explicitly convert the data type of a value by using
one of the conversion functions \*LINTEGER\*O, \*LFLOAT\*O or
\*LSINGLE_FLOAT\*O.
.SS "Functions"
.PP
.iX "UIL Functions"
.iX "UIL module" "functions"
.iX "UIL specification file" "functions"
.iX "Functions"
UIL provides functions to generate the following types of values:
.ML
.LI
Character sets
.LI
Keysyms
.LI
Colors
.LI
Pixmaps
.LI
Single-precision, floating-point numbers
.LI
Double-precision, floating-point numbers
.LI
Fonts
.LI
Fontsets
.LI
Font tables
.LI
Compound strings
.LI
Compound string tables
.LI
ASCIZ (null-terminated) string tables
.LI
Wide character strings
.LI
Widget class names
.LI
Integer tables
.LI
Arguments
.LI
Reasons
.LI
Translation tables
.LE
.PP
Remember that all examples in the following sections assume case-insensitive 
mode.  Keywords are shown in uppercase letters to distinguish them
from user-specified names, which are shown in lowercase letters.
This use of uppercase letters is not required in case-insensitive
mode.  In case-sensitive mode, keywords 
must be in lowercase letters.
.VL 5n
.LI "\*LCHARACTER_SET(\*O\*Vstring_expression[\*L,\*O\ property[\*L,\*O\ ...]]\*L)\*O"
.nL
.iX "UIL" "user-defined character set"
.iX "UIL module" "user-defined character set"
.iX "UIL specification file" "user-defined character set"
.iX "UIL Functions" "CHARACTER_SET"
.iX "User-defined character set"
.iX "Character set" "user-defined"
.iX "CHARACTER_SET function"
You can define your own character sets with the \*LCHARACTER_SET\*O function.  You
can use the \*LCHARACTER_SET\*O function anywhere a character set can be specified. 
.PP
The result of the \*LCHARACTER_SET\*O function is a character set with the name
\*Vstring_expression\*O and the properties you specify. 
\*VString_expression\*O must be a
null-terminated string.  You can optionally include one or both of the following
clauses to specify properties for the resulting character set:
.PP
.nf
\*LRIGHT_TO_LEFT =\*O \*Vboolean_expression\*O
\*LSIXTEEN_BIT =\*O \*Vboolean_expression\*O
.fi
.PP
The \*LRIGHT_TO_LEFT\*O clause sets the default writing direction of the string from
right to left if \*Vboolean_expression\*O is True, and right to left otherwise.
.PP
The \*LSIXTEEN_BIT\*O clause allows the strings associated with this character set to
be interpreted as 16-bit characters if \*Vboolean_expression\*O is True, 
and 8-bit characters otherwise.
.LI "\*LKEYSYM(\*O\*Vstring_literal\*O\*L)\*O"
.nL
.iX "UIL" "keysyms"
.iX "UIL module" "keysyms"
.iX "UIL specification file" "keysyms"
.iX "UIL Functions" "KEYSYM"
.iX "Keysyms" "defining in UIL"
The \*LKEYSYM\*O function is used to specify a keysym for a mnemonic resource.
The \*Vstring_literal\*O must contain exactly one character.
.LI "\*LCOLOR(\*O\*Vstring_expression\*O[\*L,FOREGROUND\*O|\*LBACKGROUND\*O]\*L)\*O"
.nL
.iX "UIL" "color values"
.iX "UIL module" "color values"
.iX "UIL specification file" "color values"
.iX "UIL Functions" "COLOR"
.iX "Color values" "defining in UIL"
The \*LCOLOR\*O function supports the definition of colors.
Using the \*LCOLOR\*O function, you can designate a value to specify a color
and then use that value for arguments requiring a color value.
The string expression 
names the color you want to define;
the optional keywords \*LFOREGROUND\*O and \*LBACKGROUND\*O identify how the color is 
to be displayed on a monochrome device when the color is used in the
definition of a color table.
.PP
The UIL compiler does not 
have built-in color names.  Colors are a server-dependent attribute of
an
object.  Colors are defined on each server and may have different red-green-blue (RGB)
values on each server.  The string you specify as the
color argument must be recognized by the server on which
your application runs.
.PP
In a UID file, UIL represents a color as a character string.
MRM calls X translation routines
that convert a color string to the device-specific pixel value.  If you
are running on a monochrome server, all colors translate to black or
white.
If you are on a color server, the color names translate to their proper
colors if the following conditions are met:
.ML
.LI
The color is defined.
.LI
The color map is not yet full.
.LE
.PP
If the color map is full, even valid colors translate to black or white
(foreground or background).
.PP
Interfaces do not, in general, specify colors for widgets,
so that the selection of colors can be controlled by the
user through the \*L.Xdefaults\*O
file.
.PP
To write an application that runs on both monochrome and color devices, you
need to specify which colors in a color table (defined with the \*LCOLOR_TABLE\*O
function) 
map to the background and which colors map to the foreground. 
UIL lets you use the \*LCOLOR\*O function to designate this mapping in the definition of the color.
The following example
shows how to use the \*LCOLOR\*O function to map
the color red to the background color on a monochrome device:
.PP
.nf
.ft CW 0
VALUE c: COLOR ( 'red',BACKGROUND );
.fi
.ft R
.PP
The mapping comes into play only when the MRM is
given a color and the 
application is to be displayed on a monochrome device.  In this case,
each color is considered to be in one of the following three categories: 
.ML
.LI
The color is mapped to the background color on the monochrome device.
.LI
The color is mapped to the foreground color on the monochrome device.
.LI
Monochrome mapping is undefined for this color.
.LE
.PP
If the color is mapped to the
foreground or background color, MRM substitutes the
foreground or background color, respectively.  If you do not specify the
monochrome mapping for a color, MRM passes the color string
to the Motif Toolkit 
for mapping to the foreground or background color. 
.LI "\*LRGB(\*O\*Vred_integer\*O\*L,\*O\ \*Vgreen_integer\*O\*L,\*O \*Vblue_integer\*O\*L)\*O"
.nL
.iX "UIL" "color values"
.iX "UIL module" "color values"
.iX "UIL specification file" "color values"
.iX "UIL Functions" "RGB"
.iX "Color values" "defining in UIL"
The three integers define the values for the red, green, and blue
components of the color, in that order.
The values of these components can range from 0 to 65,535, inclusive.
.PP
In a UID file, UIL represents an \*LRGB\*O value as three integers.
MRM calls X translation routines that
convert the integers to the device-specific pixel value.
If you are running on a monochrome server, all colors translate to
black or white.
If you are on a color server, \*LRGB\*O values translate to their proper
colors if the colormap is not yet full.
If the colormap is full, values translate to black or white (foreground
or background).
.LI "\*LCOLOR_TABLE(\*O\*Vcolor_expression\*O\*L='\*O\*Vcharacter\*O\*L'\*O[\*L,\*O...]\*L)\*O"
.nL
.iX "COLOR_TABLE Function"
The color expression
is a previously defined color, a color defined in line
with the \*LCOLOR\*O function, or the phrase
\*LBACKGROUND COLOR\*O or \*LFOREGROUND COLOR\*O.  The character 
can be any valid UIL character.
.PP
The \*LCOLOR_TABLE\*O function provides a device-independent way to
specify a set of colors.  
The \*LCOLOR_TABLE\*O function accepts either 
previously defined UIL color names or in line
color definitions (using the \*LCOLOR\*O function).
A color table must be private because its
contents must be known by the UIL compiler to construct an icon.  The
colors within a color table, however, can be imported, exported, or
private.
.PP
The single letter associated with each color is the character you 
use to represent that color when creating an icon.
Each letter used to represent a color must be unique within the
color table.
.LI "\*LICON(\*O[\*LCOLOR_TABLE=\*O\*Vcolor_table_name\*O\*L,\*O]\ \*Vrow\*O[\*L,\*O...\*L)\*O"
.nL
The color table name must refer to a previously defined color table
and the row is a character expression giving one row of the icon.
.PP
The \*LICON\*O function describes a rectangular icon that is x pixels wide
and y pixels high.  
The strings surrounded by single quotation marks describe 
the icon.  
Each string represents a row in the icon;
each character in the string represents a pixel.  
.PP
The first row in an icon definition determines the width of the icon.
All rows
must have the same number of characters as the first row. 
The height of the icon is dictated by the number of rows.
.PP
The first argument of the \*LICON\*O function 
(the color table specification) is optional and identifies the colors that are
available in this icon.  
By using the single letter associated with
each color, you can specify the color of each pixel in the icon.  
The icon must be constructed of characters
defined
in the specified color table.
.PP
A default color table is used if you omit the argument specifying the color
table.  To make use of the default color table, the rows of your icon
must contain only spaces and asterisks.
The default color table is defined as follows:
.oS
COLOR_TABLE( BACKGROUND COLOR = ' ', FOREGROUND COLOR = '*' ) 
.oE
.PP
You can define other characters to represent the background color and
foreground color by replacing the space and asterisk in the \*LBACKGROUND COLOR\*O
and \*LFOREGROUND COLOR\*O clauses shown in the previous statement.
You can specify icons as private, imported, or exported.
Use the MRM function 
\*LMrmFetchIconLiteral\*O
to retrieve an exported icon at run
time.
.LI "\*LXBITMAPFILE(\*O\*Vstring_expression\*O\*L)\*O"
.nL
The \*LXBITMAPFILE\*O function is similar to the \*LICON\*O function in that both
describe a rectangular icon that is x pixels wide and y pixels high.
However, \*LXBITMAPFILE\*O allows you to specify an external file containing the
definition of an X bitmap, whereas all \*LICON\*O function definitions must be
coded directly within UIL.  X bitmap files can be generated by 
many different X applications.
UIL reads these files through the \*LXBITMAPFILE\*O function, but does
not support creation of these files.
The X bitmap file specified as the argument
to the \*LXBITMAPFILE\*O function is read at application run time by MRM.
.PP
The \*LXBITMAPFILE\*O function returns a value of type 
\*Lpixmap\*O 
and can be used
anywhere a pixmap data type is expected.
.LI "\*LSINGLE_FLOAT(\*O\*Vreal_number_literal\*O\*L)\*O"
.nL
.iX "UIL" "floating-point values"
.iX "UIL module" "floating-point values"
.iX "UIL specification file" "floating-point values"
.iX "UIL Functions" "SINGLE_FLOAT"
.iX "Floating-point values"
The \*LSINGLE_FLOAT\*O function lets you store floating-point literals in UIL
files as single-precision, floating-point numbers.
Single-precision floating-point numbers can often be stored using less
memory than double-precision, floating-point numbers.
The \*Vreal_number_literal\*O can be either an integer literal or a
floating-point literal.
A value defined using this function cannot be used in an arithmetic
expression.
.LI "\*LFLOAT(\*o\*Vreal_number_literal\*O\*L)\*O"
.nL
.iX "UIL" "floating-point values"
.iX "UIL module" "floating-point values"
.iX "UIL specification file" "floating-point values"
.iX "UIL Functions" "FLOAT"
.iX "Floating-point values"
The \*LFLOAT\*O function lets you store floating-point literals in UIL files
as double-precision, floating-point numbers.
The \*Vreal_number_literal\*O can be either an integer literal or a
floating-point literal.
.LI "\*LFONT(\*O\*Vstring_expression\*O[\*L,\ CHARACTER_SET=\*O\*Vchar_set\*O]\*L)\*O"
.nL
.iX "UIL" "font values"
.iX "UIL module" "font values"
.iX "UIL specification file" "font values"
.iX "UIL Functions" "FONT"
.iX "Font values"
You define fonts with the \*LFONT\*O function.
Using the \*LFONT\*O function,
you designate a value to specify a font
and then use that value for arguments that require a font value.
The UIL compiler has no built-in fonts.
.PP
Each font makes sense only in the context of a character set.  
The \*LFONT\*O function has an additional
parameter to let you specify the character set
for the font.  
This parameter is optional; if you omit it,
the default character set depends on the value of the \*LLANG\*O environment
variable if it is set of the value of \*LXmFALLBACK_CHARSET\*O if \*LLANG\*O
is not set.
.PP
The string expression specifies the name of the font
and the clause \*LCHARACTER_SET\*O = \*Vchar_set\*O
specifies the character set for the font.  
The string expression used in the \*LFONT\*O function cannot be a compound string.
.LI "\*LFONTSET(\*O\*Vstring_expression\*O[\*L,\*O...][\*L,\ CHARACTER_SET=\*O\*Vcharset\*O]\*L)\*O"
.nL
.iX "UIL" "fontset value"
.iX "UIL module" "fontset value"
.iX "UIL specification file" "fontset value"
.iX "Functions" "fontset value"
.iX "UIL Functions" "FONT_TABLE"
.iX "fontset value" "defining"
You define fontsets with the \*LFONTSET\*O function.
Using the \*LFONTSET\*O function,
you designate a set of values to specify fonts
and then use those values for arguments that require a fontset.
The UIL compiler has no built-in fonts.
.PP
Each font makes sense only in the context of a character set.  
The \*LFONTSET\*O function has an additional
parameter to let you specify the character set
for the font.
This parameter is optional; if you omit it,
the default character set depends on the value of the \*LLANG\*O environment
variable if it is set of the value of \*LXmFALLBACK_CHARSET\*O if \*LLANG\*O
is not set.
.PP
The string expression specifies the name of the font
and the clause \*LCHARACTER_SET\*O = \*Vchar_set\*O
specifies the character set for the font.  
The string expression used in the \*LFONTSET\*O function cannot be a compound string.
.LI "\*LFONT_TABLE(\*O\*Vfont_expression\*O[\*L,\*O...]\*L)\*O"
.nL
.iX "UIL" "font table value"
.iX "UIL module" "font table value"
.iX "UIL specification file" "font table value"
.iX "Functions" "font table value"
.iX "UIL Functions" "FONT_TABLE"
.iX "Font table value" "defining"
A font table is a sequence of pairs of fonts and character sets.  At run time
when an object needs to display a string, the object
scans the font table for the character set that
matches the character set of the string to be displayed.
UIL provides the \*LFONT_TABLE\*O function to let you supply such an argument.
The font expression is created with the \*LFONT\*O and \*LFONTSET\*O functions.
.PP
If you specify a single font value to specify an argument that requires
a font table, the UIL compiler automatically converts a font value to a font
table.
.LI "\*LCOMPOUND_STRING(\*O\*Vstring_expression\*O[\*L,\*O\*Vproperty\*O[\*L,\*O...]]\*L)\*O"
.nL
Use the \*LCOMPOUND_STRING\*O function to set properties of a null-terminated string
and to convert it into a compound string.  
The properties you can set are the character set, writing direction, and 
separator.
.PP
The result of the \*LCOMPOUND_STRING\*O function is a compound string with the
string expression as its value.
You can optionally include one or more of the following clauses to specify
properties for the resulting compound string: 
.PP
.nf
\*LCHARACTER_SET\*O = \*Vcharacter_set\*O
\*LRIGHT_TO_LEFT\*O = \*Vboolean_expression\*O
\*LSEPARATE\*O = \*Vboolean_expression\*O
.fi
.PP
The \*LCHARACTER_SET\*O clause specifies the character set for the
string.
If you omit the \*LCHARACTER_SET\*O clause, the resulting string has the
same character set as \*Lstring_expression\*O.
.PP
The \*LRIGHT_TO_LEFT\*O clause sets the writing direction of the
string from right to left if \*Vboolean_expression\*O 
is True, and left to right otherwise.  
Specifying this argument does not cause the value 
of the string expression to change.
If you omit the \*LRIGHT_TO_LEFT\*O argument, the resulting string has the same
writing direction as \*Vstring_expression\*O.
.PP
The \*LSEPARATE\*O clause appends a separator to the end of the compound string if
\*Vboolean_expression\*O is True.  If you omit the \*LSEPARATE\*O
clause, the resulting string does not have a separator.
.PP
You cannot use imported or exported values as the operands of the 
\*LCOMPOUND_STRING\*O function.  
.LI "\*LCOMPOUND_STRING_TABLE(\*O\*Vstring_expression\*O[\*L,\*O...]\*L)\*O"
.nL
A compound string table is an array
of compound strings.  Objects requiring a list of string values, such
as the \*LXmNitems\*O and \*LXmNselectedItems\*O
arguments for the list widget, use string table values.  The
\*LCOMPOUND_STRING_TABLE\*O function builds the values
for these two arguments of the list widget.  The \*LCOMPOUND_STRING_TABLE\*O
function generates a value of type \*Lstring_table\*O.
The name \*LSTRING_TABLE\*O is a synonym for \*LCOMPOUND_STRING_TABLE\*O.
.PP
The strings inside the string table can be simple strings, which the UIL
compiler automatically converts to compound strings.
.LI "\*LASCIZ_STRING_TABLE(\*O\*Vstring_expression\*O[\*L,\*O...]\*L)\*O"
.nL
An ASCIZ string table is an array of ASCIZ (null-terminated) string
values separated by commas. This function allows you to pass more than one
ASCIZ string as a callback tag value.  The \*LASCIZ_STRING_TABLE\*O function
generates a value
of type 
\*Lasciz_table\*O.
The name \*LASCIZ_TABLE\*O is a synonym for \*LASCIZ_STRING_TABLE\*O.
.LI "\*LWIDE_CHARACTER(\*O\*Vstring_expression\*O\*L)\*O"
.nL
.iX "UIL" "wide character strings"
.iX "UIL module" "wide character strings"
.iX "UIL specification file" "wide character strings"
.iX "UIL Functions" "WIDE_CHARACTER"
.iX "wide character strings" "defining in UIL"
Use the \*LWIDE_CHARACTER\*O function to generate a wide character
string from null-terminated string in the current locale.
.LI "\*LCLASS_REC_NAME(\*O\*Vstring_expression\*O\*L)\*O"
.nL
.iX "UIL" "widget class names"
.iX "UIL module" "widget class names"
.iX "UIL specification file" "widget class names"
.iX "UIL Functions" "CLASS_REC_NAME"
.iX "widget class names" "defining in UIL"
Use the \*LCLASS_REC_NAME\*O function to generate a widget class name.
For a widget class defined by the toolkit, the string argument is the
name of the class.
For a user-defined widget, the string argument is the name of the
creation routine for the widget.
.LI "\*LINTEGER_TABLE(\*O\*Vinteger_expression\*O[\*L,\*O...]\*L)\*O"
.nL
An integer table is an array of integer values separated by commas.
This function allows you to pass more than one integer per callback
tag value.
The \*LINTEGER_TABLE\*O function generates a value of type
\*Linteger_table\*O.
.LI "\*LARGUMENT(\*O\*Vstring_expression\*O[\*L,\*O\ \*Vargument_type\*O]\*L)\*O"
.nL
.iX "UIL" "argument values"
.iX "UIL module" "argument values"
.iX "UIL specification file" "argument values"
.iX "UIL Functions" "ARGUMENT"
.iX "Argument values" "defining in UIL"
The \*LARGUMENT\*O function defines the arguments to a user-defined widget.
Each of the objects that can be described by UIL permits a set of arguments,
listed in Appendix B.  For example,
\*LXmNheight\*O
is an argument to most objects and has integer data type.  To specify
height for a user-defined widget, you can use the built-in argument
name 
\*LXmNheight\*O,
and specify an integer value when you declare the user-defined widget.
You do not use the \*LARGUMENT\*O function to specify arguments that are 
built into the UIL compiler.
.PP
The \*Vstring_expression\*O name
is the
name the UIL compiler uses for the argument in the UID file.
the \*Vargument_type\*O
is the type of value that can be
associated with the argument.  If you omit the second argument, the default
type is 
\*LANY\*O
and no value type checking occurs.  Use one of the following keywords
to specify the argument type:
.ML
.LI
ANY
.LI
ASCIZ_TABLE
.LI
BOOLEAN
.LI
COLOR
.LI
COLOR_TABLE
.LI
COMPOUND_STRING
.LI
FLOAT
.LI
FONT
.LI
FONT_TABLE
.LI
FONTSET
.LI
ICON
.LI
INTEGER
.LI
INTEGER_TABLE
.LI
REASON
.LI
SINGLE_FLOAT
.LI
STRING
.LI
STRING_TABLE
.LI
TRANSLATION_TABLE
.LI
WIDE_CHARACTER
.LI
WIDGET
.LE
.PP
You can use the \*LARGUMENT\*O function to allow the UIL compiler to recognize
extensions to the Motif Toolkit.  For example, an existing widget
may accept a new argument.  Using the \*LARGUMENT\*O function, you can make
this new argument available to the UIL compiler before the updated
version of the compiler is released.  
.LI "\*LREASON(\*O\*Vstring_expression\*O\*L)\*O"
.nL
.iX "UIL" "reason value"
.iX "UIL Functions" "reason value"
.iX "UIL module" "reason value"
.iX "UIL specification file" "reason value"
.iX "Functions" "reason value"
.iX "Reason value"
The \*LREASON\*O function is useful for defining new reasons for user-defined
widgets.
.PP
Each of the objects in the
Motif Toolkit defines a set of conditions under which it calls a
user-defined function.  These conditions are known as callback reasons.
The user-defined functions are termed callback procedures.  In a UIL
module, you use a callbacks list to specify which user-defined
functions are to be called for which reasons.
.PP
Appendix B lists the callback reasons 
supported by the Motif Toolkit
objects.
.PP
When you declare a user-defined widget, you can define callback reasons
for that widget using the \*LREASON\*O function.
The string expression specifies the argument name stored in the UID
file for the reason.  This reason name is supplied to the widget
creation routine at run time.
.LI "\*LTRANSLATION_TABLE(\*O\*Vstring_expression\*O[\*L,\*O...]\*L)\*O"
.nL
.iX "UIL" "translation table value"
.iX "UIL module" "translation table value"
.iX "UIL specification file" "translation table value"
.iX "Functions" "translation table value"
.iX "Translation table value"
Each of the Motif Toolkit
widgets has a translation table that maps
X events (for example, mouse button 1 being pressed) to a sequence
of actions. Through widget arguments, such as the common translations argument,
you can specify an alternate set of events or actions for a particular widget. 
The \*LTRANSLATION_TABLE\*O function creates a translation table that can be used as
the value of a argument that is of the data type \*Ltranslation_table\*O.  
.PP
You can use one of the following translation table directives with the
\*LTRANSLATION_TABLE\*O function: \*L#override\*O, \*L#augment\*O, or \*L#replace\*O.
The default is \*L#replace\*O.
If you specify one of these directives, it must be the first entry in
the translation table.
.PP
The \*L#override\*O directive causes any duplicate translations to be ignored.
For example, if a translation for <\*LBtn1Down\*O> is already defined in the
current translations for a PushButton, the translation defined by
\*Vnew_translations\*O overrides the current definition.
If the \*L#augment\*O directive is specified, the current definition takes
precedence.
The \*L#replace\*O directive replaces all current translations with those
specified in the \*LXmNtranslations\*O resource.
.LE
.SH "RELATED INFORMATION"
.na
\*Luil(1X)\*O, \*LUil(3X)\*O
.ad
