...\" **
...\" **
...\" **  (c) Copyright 1989, 1990, 1992 by Open Software Foundation, Inc.
...\" **      All Rights Reserved.
...\" **
...\" **  (c) Copyright 1987, 1988, 1989, by Hewlett-Packard Company
...\" **
...\" **  (c) Copyright 1987, 1988 by Digital Equipment Corporation,
...\" **      Maynard, MA.  All Rights Reserved.
...\" **
...\" **
.TH XmStringCompare 3X "" "" "" ""
.SH NAME
\*LXmStringCompare\*O\(emA compound string function that compares two strings
.iX "XmStringCompare"
.iX "compound string functions" "XmStringCompare"
.SH SYNOPSIS
.sS
.iS
\&#include <Xm/Xm.h>
.sp \n(PDu
Boolean XmStringCompare (\*Vs1, s2\*L)
.ta .5i 1.5i
	XmString	\*Vs1\*L;
	XmString	\*Vs2\*L;
.wH .fi
.iE
.sE
.SH DESCRIPTION
\*LXmStringCompare\*O returns a Boolean value indicating the results of a
semantically equivalent comparison of two compound strings.
.PP 
Semantically equivalent means that the strings have the
same text components, font list element tags, directions,
and separators.  In general, if two compound strings are created
with the same (char *) string using \*LXmStringCreateLocalized\*O in
the same language environment, the compound strings compare as equal.
If two compound strings are created with the same (char *) string and
the same font list element tag other than \*LXmFONTLIST_DEFAULT_TAG\*O
using \*LXmStringCreate\*O, the strings compare as equal.
.VL .75i 
.LI "\*Vs1\*O"
Specifies a compound string to be compared with \*Vs2\*O
.LI "\*Vs2\*O"
Specifies a compound string to be compared with \*Vs1\*O
.LE 
.SH RETURN VALUE
Returns True if two compound strings are equivalent.
.SH RELATED INFORMATION
.na
\*LXmStringCreate(3X)\*O and
\*LXmStringCreateLocalized(3X)\*O.
.ad
