...\" **
...\" **
...\" **  (c) Copyright 1989, 1990, 1992 by Open Software Foundation, Inc.
...\" **      All Rights Reserved.
...\" **
...\" **  (c) Copyright 1987, 1988, 1989, by Hewlett-Packard Company
...\" **
...\" **  (c) Copyright 1987, 1988 by Digital Equipment Corporation,
...\" **      Maynard, MA.  All Rights Reserved.
...\" **
...\" **
.TH XmSetProtocolHooks 3X "" "" "" ""
.SH NAME
\*LXmSetProtocolHooks\*O\(emA VendorShell function that allows pre and post actions to be executed when a protocol message is received from MWM
.iX "XmSetProtocolHooks"
.iX "VendorShell functions" "XmSetProtocolHooks"
.iX "protocols"
.SH SYNOPSIS
.sS
.iS
\&#include <Xm/Xm.h>
\&#include <Xm/Protocols.h>
.sp \n(PDu
.ta 1i
void XmSetProtocolHooks (\*Vshell, property, protocol, prehook, pre_closure,
	posthook, post_closure\*L)
.ta .5i 2i
	Widget	\*Vshell\*L;
	Atom	\*Vproperty\*L;
	Atom	\*Vprotocol\*L;
	XtCallbackProc	\*Vprehook\*L;
	XtPointer	\*Vpre_closure\*L;
	XtCallbackProc	\*Vposthook\*L;
	XtPointer	\*Vpost_closure\*L;
.sp \n(PDu
.ta 1i
void XmSetWMProtocolHooks (\*Vshell, protocol, prehook, pre_closure,
	posthook, post_closure\*L)
.ta .5i 2i
	Widget	\*Vshell\*L;
	Atom	\*Vprotocol\*L;
	XtCallbackProc	\*Vprehook\*L;
	XtPointer	\*Vpre_closure\*L;
	XtCallbackProc	\*Vposthook\*L;
	XtPointer	\*Vpost_closure\*L;
.wH .fi
.iE
.sE
.SH DESCRIPTION
\*LXmSetProtocolHooks\*O is used by shells that want to have pre and post actions
executed when a protocol message is received from MWM.
Since there is no guaranteed ordering in execution of event handlers or
callback lists, this allows the shell to control the flow while leaving the
protocol manager structures opaque.
.PP 
\*LXmSetWMProtocolHooks\*O is a convenience interface.
It calls \*LXmSetProtocolHooks\*O
with the property value set to the atom returned by
interning \*LWM_PROTOCOLS\*O.
.VL 1i 
.LI "\*Vshell\*O"
Specifies the widget with which the protocol property is associated
.LI "\*Vproperty\*O"
Specifies the protocol property
.LI "\*Vprotocol\*O"
Specifies the protocol atom (or an int cast to Atom)
.LI "\*Vprehook\*O"
Specifies the procedure to call before calling entries on the client callback-list
.LI "\*Vpre_closure\*O"
Specifies the client data to be passed to the prehook when it is invoked
.LI "\*Vposthook\*O"
Specifies the procedure to call after calling entries on the client callback-list
.LI "\*Vpost_closure\*O"
Specifies the client data to be passed to the posthook when it is invoked
.LE 
.PP 
For a complete definition of VendorShell and its associated resources, see
\*LVendorShell(3X)\*O.
.SH RELATED INFORMATION
.na
\*LVendorShell(3X)\*O,
\*LXmInternAtom(3X)\*O, and \*LXmSetWMProtocolHooks(3X)\*O.
.ad
