...\" **
...\" **
...\" **  (c) Copyright 1989, 1990, 1992 by Open Software Foundation, Inc.
...\" **      All Rights Reserved.
...\" **
...\" **  (c) Copyright 1987, 1988, 1989, by Hewlett-Packard Company
...\" **
...\" **
.TH XmRepTypeRegister 3X "" "" "" ""
.SH NAME
\*LXmRepTypeRegister\*O\(emA representation type manager function
that registers a representation type resource
.iX "XmRepTypeRegister"
.iX "representation type manager functions" "XmRepTypeRegister"
.SH SYNOPSIS
.sS
.iS
\&#include <Xm/RepType.h>
.sp \n(PDu
XmRepTypeId XmRepTypeRegister (\*Vrep_type, value_names, values, num_values\*L)
.ta .5i 1.75i
	String	\*Vrep_type\*L;
	String	*\*Vvalue_names\*L;
	unsigned char	*\*Vvalues\*L;
	unsigned char	\*Vnum_values\*L;
.iE
.sE
.SH DESCRIPTION
\*LXmRepTypeRegister\*O registers a representation
type resource with the representation type manager.  All
features of the representation type management facility become
available for the specified representation type.  The function
installs a forward type converter to convert string values to
numerical representation type values.
.PP
When the \*Vvalues\*O argument is NULL, consecutive numerical
values are assumed.  The order of the strings in the \*Vvalue_names\*O
array determines the numerical values for the resource.  For example,
the first value name is 0; the second value name is 1; and so on.
.PP
If it is non-NULL, the \*Vvalues\*O argument can be used to assign values
to representation types that have nonconsecutive values or have
duplicate names for the same value.  Representation types registered
in this manner will consume additional storage and will be slightly
slower than representation types with consecutive values.
.PP
A representation type can only be registered once; if the
same representation type name is registered more than once, the
behavior is undefined.
.PP
The function \*LXmRepTypeAddReverse\*O installs a reverse converter
for a registered representation type.  The reverse converter takes
a representation type numerical value and returns the corresponding
string value. If the list of numerical values for a representation
type contains duplicate values, the reverse converter uses the first
name in the \*Vvalue_names\*O list that matches the specified numeric
value.  For example, if a \*Vvalue_names\*O array has \*Lcancel\*O,
\*Lproceed\*O, and \*Labort\*O, and the corresponding \*Vvalues\*O array
contains 0, 1, and 0, the reverse converter will return \*Lcancel\*O
instead of \*Labort\*O for an input value of 0.
.VL 1.25i 
.LI "\*Vrep_type\*O"
Specifies the representation type name.
.LI "\*Vvalue_names\*O"
Specifies a pointer to an array of value names associated with the
representation type.  A value name is specified in lowercase characters
without an "Xm" prefix.  Words within a name are separated with
underscores.
.LI "\*Vvalues\*O"
Specifies a pointer to an array of values associated with the
representation type.  A value in this array is associated with
the value name in the corresponding position of the \*Vvalue_names\*O
array.
.LI "\*Vnum_values\*O"
Specifies the number of entries in the \*Vvalue_names\*O and
\*Vvalues\*O arrays.
.LE 
.SH RETURN VALUE
Returns the identification number for the specified representation
type.
.SH RELATED INFORMATION
.na
\*LXmRepTypeAddReverse(3X)\*O,
\*LXmRepTypeGetId(3X)\*O,
\*LXmRepTypeGetNameList(3X)\*O,
\*LXmRepTypeGetRecord(3X)\*O,
\*LXmRepTypeGetRegistered(3X)\*O, and
\*LXmRepTypeValidValue(3X)\*O.
.ad
