...\" **
...\" **
...\" **  (c) Copyright 1989, 1990, 1992 by Open Software Foundation, Inc.
...\" **      All Rights Reserved.
...\" **
...\" **  (c) Copyright 1987, 1988, 1989, by Hewlett-Packard Company
...\" **
...\" **  (c) Copyright 1987, 1988 by Digital Equipment Corporation,
...\" **      Maynard, MA.  All Rights Reserved.
...\" **
...\" **
.TH XmProcessTraversal 3X "" "" "" ""
.SH NAME
\*LXmProcessTraversal\*O\(emA function that determines which component receives keyboard events when a widget has the focus
.iX "XmProcessTraversal"
.SH SYNOPSIS
.sS
.iS
\&#include <Xm/Xm.h>
.sp \n(PDu
Boolean XmProcessTraversal (\*Vwidget, direction\*L)
.ta .5i 2i
	Widget	\*Vwidget\*L;
	XmTraversalDirection	\*Vdirection\*L;
.wH .fi
.iE
.sE
.SH DESCRIPTION
\*LXmProcessTraversal\*O determines which component of a hierarchy
receives keyboard events when the hierarchy that contains the given
widget has keyboard focus.
Using \*LXmProcessTraversal\*O to traverse to MenuBars,
Pulldown MenuPanes, or Popup MenuPanes is not supported.
.VL 1.2i 
.LI "\*Vwidget\*O"
Specifies the widget ID of the widget whose hierarchy is to be traversed.
The hierarchy is only traversed up to the top of the shell.  If that shell
does not currently have the focus, any changes to the element with focus within
that shell will not occur until the next time the shell recieves focus.
.LI "\*Vdirection\*O"
Specifies the direction of traversal
.LE 
.PP 
.ne 5
The \*Vdirection\*O parameter can have the following values, which cause
the routine to take the corresponding actions:
.ML
.LI
\*LXmTRAVERSE_CURRENT\*O\(emFinds the hierarchy and the tab group that
contain \*Vwidget\*O.
If this tab group is not the active tab group, makes it the active tab
group.
If \*Vwidget\*O is an item in the active tab group, makes it the active
item.
If \*Vwidget\*O is the active tab group, makes the first traversable
item in the tab group the active item.
.LI
\*LXmTRAVERSE_DOWN\*O\(emFinds the hierarchy that contains \*Vwidget\*O.
Finds the active item in the active tab group and makes the item below
it the active item.
If there is no item below, wraps.
.LI
\*LXmTRAVERSE_HOME\*O\(emFinds the hierarchy that contains \*Vwidget\*O.
Finds the active item in the active tab group and makes the first
traversable item in the tab group the active item.
.LI
\*LXmTRAVERSE_LEFT\*O\(emFinds the hierarchy that contains \*Vwidget\*O.
Finds the active item in the active tab group and makes the item to the
left the active item.
If there is no item to the left, wraps.
.LI
\*LXmTRAVERSE_NEXT\*O\(emFinds the hierarchy that contains \*Vwidget\*O.
Finds the active item in the active tab group and makes the next item
in child order the active item.
.LI
\*LXmTRAVERSE_NEXT_TAB_GROUP\*O\(emFinds the hierarchy that contains
\*Vwidget\*O.
Finds the active tab group (if any) and makes the next tab group the
active tab group in the hierarchy.
.LI
\*LXmTRAVERSE_PREV\*O\(emFinds the hierarchy that contains \*Vwidget\*O.
Finds the active item in the active tab group and makes the previous
item in child order the active item.
.LI
\*LXmTRAVERSE_PREV_TAB_GROUP\*O\(emFinds the hierarchy that contains
\*Vwidget\*O.
Finds the active tab group (if any) and makes the previous tab group the
active tab group in the hierarchy.
.LI
\*LXmTRAVERSE_RIGHT\*O\(emFinds the hierarchy that contains
\*Vwidget\*O. 
Finds the active item in the active tab group and makes the item to the
right the active item.
If there is no item to the right, wraps.
.LI
\*LXmTRAVERSE_UP\*O\(emFinds the hierarchy that contains \*Vwidget\*O.
Finds the active item in the active tab group and makes the item above
it the active item.
If there is no item above, wraps.
.LE 
.SS CAUTIONS
.ML
.LI
\*LXmProcessTraversal\*O will not allow traversal to a
widget in a different shell.
.LI
\*LXmProcessTraversal\*O will only allow traversal to
widgets that are currently mapped.
.LI
You cannot call \*LXmProcessTraversal\*O from inside
a focusCallback routine (or you will get a segmentation fault).
.LE
.SH RETURN VALUE
Returns True if the setting succeeded.
Returns False if the keyboard focus policy is not \*LXmEXPLICIT\*O, if
there are no traversable items, or if the call to the routine has
invalid parameters.
.SH RELATED INFORMATION
.na
\*LXmGetVisibility(3X)\*O and
\*LXmIsTraversable(3X)\*O.
.ad
