...\" **
...\" **
...\" **  (c) Copyright 1989, 1990, 1992 by Open Software Foundation, Inc.
...\" **      All Rights Reserved.
...\" **
...\" **  (c) Copyright 1987, 1988, 1989, by Hewlett-Packard Company
...\" **
...\" **  (c) Copyright 1987, 1988 by Digital Equipment Corporation,
...\" **      Maynard, MA.  All Rights Reserved.
...\" **
...\" **
.TH XmInstallImage 3X "" "" "" ""
.SH NAME
\*LXmInstallImage\*O\(emA pixmap caching function that adds an image to the pixmap cache
.iX "XmInstallImage"
.iX "pixmaps"
.SH SYNOPSIS
.sS
.iS
\&#include <Xm/Xm.h>
.sp \n(PDu
Boolean XmInstallImage (\*Vimage, image_name\*L)
.ta .5i 1.5i
	XImage	\*V* image\*L;
	char	\*V* image_name\*L;
.wH .fi
.iE
.sE
.SH DESCRIPTION
\*LXmInstallImage\*O stores an image in an image cache
that can later be used to generate a pixmap.
Part of the installation process is to extend the
resource converter used to reference these images.  The resource converter
is given the image name so that the image can be
referenced in a .Xdefaults file.
Since an image can be referenced by a widget
through its pixmap resources, it is up to the application to ensure that the
image is installed before the widget is created.
.VL 1i 
.LI "\*Vimage\*O"
Points to the image structure to be installed.
The installation process does not make a local copy of the image.  Therefore,
the application should not destroy the image until it is uninstalled from
the caching functions.
.LI "\*Vimage_name\*O"
Specifies a string that the application uses to name the image.  After
installation, this name can be used in .Xdefaults for referencing
the image.  A local copy of the name is created by the image caching
functions.
.LE 
.PP 
The image caching functions provide a set of eight preinstalled images.
These names can be used within a \*L.Xdefaults\*O file for generating pixmaps
for the resource for which they are provided.
.PP 
.TS 
center allbox;
lB lB
ll.
Image Name	Description
_
background	A tile of solid background
25_foreground	A tile of 25% foreground, 75% background
50_foreground	A tile of 50% foreground, 50% background
75_foreground	A tile of 75% foreground, 25% background
horizontal	A tile of horizontal lines of the two colors
vertical	A tile of vertical lines of the two colors
slant_right	A tile of slanting lines of the two colors
slant_left	A tile of slanting lines of the two colors
.TE
.SH RETURN VALUE
Returns True when successful; returns False if NULL \*Vimage\*O, NULL
\*Vimage_name\*O, or duplicate \*Vimage_name\*O is used as a parameter
value.
.SH RELATED INFORMATION
.na
\*LXmUninstallImage(3X)\*O, \*LXmGetPixmap(3X)\*O, and
\*LXmDestroyPixmap(3X)\*O.
.ad
