...\" **
...\" **
...\" **  (c) Copyright 1989, 1990, 1992 by Open Software Foundation, Inc.
...\" **      All Rights Reserved.
...\" **
...\" **  (c) Copyright 1987, 1988, 1989, by Hewlett-Packard Company
...\" **
...\" **  (c) Copyright 1987, 1988 by Digital Equipment Corporation,
...\" **      Maynard, MA.  All Rights Reserved.
...\" **
...\" **
.TH XmCreateOptionMenu 3X "" "" "" ""
.SH NAME
\*LXmCreateOptionMenu\*O\(emA RowColumn widget convenience creation function
.iX "XmCreateOptionMenu"
.iX "creation functions" "XmCreateOptionMenu"
.SH SYNOPSIS
.sS
.iS
\&#include <Xm/RowColumn.h>
.sp \n(PDu
Widget XmCreateOptionMenu (\*Vparent, name, arglist, argcount\*L)
.ta .5i 1.5i
	Widget	\*Vparent\*L;
	String	\*Vname\*L;
	ArgList	\*Varglist\*L;
	Cardinal	\*Vargcount\*L;
.wH .fi
.iE
.sE
.SH DESCRIPTION
\*LXmCreateOptionMenu\*O creates an instance of a
RowColumn widget of type \*LXmMENU_OPTION\*O
and returns the associated widget ID.
.PP 
It is provided as a convenience function for creating a RowColumn
widget configured to operate as an OptionMenu and is not implemented as a
separate widget class.
.PP 
The OptionMenu widget is a specialized RowColumn manager composed of a
label, a selection area, and a
single Pulldown MenuPane.  When an application creates
an OptionMenu widget, it supplies the label string and the Pulldown MenuPane.
In order to succeed, there must be a valid \*LXmNsubMenuId\*O resource set
when calling this function.
When the OptionMenu is created, the Pulldown MenuPane must have been
created as a child of the OptionMenu's parent and must be
specified.
The LabelGadget and the selection area (a CascadeButtonGadget) are created
by the OptionMenu.
.PP 
The OptionMenu's Pulldown MenuPane must not contain any ToggleButtons or
ToggleButtonGadgets.
The results of including CascadeButtons or CascadeButtonGadgets in the
OptionMenu's Pulldown MenuPane are undefined.
.PP 
An OptionMenu is laid out with the label displayed on one side of
the widget and the selection area on the other side when 
\*LXmNorientation\*O is XmHORIZONTAL.  If the value is XmVERTICAL,
the label is above the selection area. 
The selection area has a dual purpose; it displays the label of the last
item selected from the associated Pulldown MenuPane, and it provides
the means for posting the Pulldown MenuPane.
.PP 
The OptionMenu typically does not display any 3-D visuals around
itself or the internal LabelGadget.  By default, the internal
CascadeButtonGadget has a visible 3-D shadow.
The application may change this
by getting the CascadeButtonGadget ID using \*LXmOptionButtonGadget\*O, and then
calling \*LXtSetValues\*O using the standard visual-related resources.
.PP 
The Pulldown MenuPane is posted by moving the mouse pointer over the
selection area and pressing a mouse button defined by OptionMenu's
RowColumn parent.
The Pulldown MenuPane is posted
and positioned so that the last selected item is directly over
the selection area.  The mouse is then used to arm the desired menu
item.  When the mouse button is released, the armed menu item is selected
and the label within the selection area is changed to match that of
the selected item.  By default, \*LBSelect\*O is used to interact with an
OptionMenu.
The default can be changed via the RowColumn resource
\*LXmNmenuPost\*O.
.PP 
The OptionMenu also operates by using the keyboard interface mechanism.
If the application has established a mnemonic with the OptionMenu,
typing Alt with the mnemonic causes the Pulldown MenuPane to be posted with
traversal enabled.
The standard traversal keys can then be used to
move within the MenuPane.  Selection can occur as the result of pressing
the Return key or typing a mnemonic or accelerator for one of the
menu items.
.PP 
An application may use the \*LXmNmenuHistory\*O resource to
indicate which item in the Pulldown MenuPane should be treated as the current
choice and have its label displayed in the selection area.  By default,
the first item in the Pulldown MenuPane is used.
.nL
.ne 4
.VL .75i 
.LI "\*Vparent\*O"
Specifies the parent widget ID
.LI "\*Vname\*O"
Specifies the name of the created widget
.LI "\*Varglist\*O"
Specifies the argument list
.LI "\*Vargcount\*O"
Specifies the number of attribute/value pairs in the argument list
(\*Varglist\*O)
.LE 
.PP
The user can specify resources in a resource file for the automatically
created widgets and gadgets of an OptionMenu.  The following list
identifies the names of these widgets (or gadgets) and the associated
OptionMenu areas.
.ML
.LI
.LI
Option Menu Label Gadget\(em"OptionLabel"
.LI
Option Menu Cascade Button\(em"OptionButton"
.LE
.PP 
For a complete definition of RowColumn and its associated resources, see
\*LXmRowColumn(3X)\*O.
.SH RETURN VALUE
Returns the RowColumn widget ID.
.SH RELATED INFORMATION
.na
\*LXmCascadeButtonGadget(3X)\*O,
\*LXmCreatePulldownMenu(3X)\*O,
\*LXmCreateSimpleOptionMenu(3X)\*O,
\*LXmLabelGadget(3X)\*O,
\*LXmOptionButtonGadget(3X)\*O,
\*LXmOptionLabelGadget(3X)\*O,
\*LXmRowColumn(3X)\*O, and
\*LXmVaCreateSimpleOptionMenu(3X)\*O.
.ad
