...\" **
...\" **
...\" **  (c) Copyright 1989, 1992 by Open Software Foundation, Inc.
...\" **      All Rights Reserved.
...\" **
...\" **  (c) Copyright 1987, 1988, 1989, by Hewlett-Packard Company
...\" **
...\" **  (c) Copyright 1987, 1988 by Digital Equipment Corporation,
...\" **      Maynard, MA.  All Rights Reserved.
...\" **
...\" **
.TH VirtualBindings 3X "" "" "" ""
.SH NAME
\*LVirtualBindings\*O\(emBindings for virtual mouse and key events
.iX "VirtualBindings"
.iX "default bindings" "VirtualBindings"
.SH DESCRIPTION
The 1/Motif manual pages describe translations in terms of
\*Vvirtual bindings\*O, based on those described in the \*VOSF/Motif
Style Guide\*O.
Mouse events are described in terms of \*Vvirtual buttons\*O, and key
events are described in terms of \*Vvirtual keys\*O.
The term \*Vvirtual\*O implies that the events as described do not
necessarily correspond to a fixed set of X Window System events.
Instead, virtual buttons and keys are linked to actual events by means
of virtual bindings.
.SS "Virtual Modifiers"
Both virtual buttons and virtual keys may contain \*Vvirtual
modifiers\*O.
Each virtual modifier corresponds to one or more actual modifiers.
The following table lists the bindings of virtual modifiers to actual
modifiers in 1/Motif:
.PP 
.TS 
center, allbox, tab(@);
cb s
lb lb.
Virtual Modifier Bindings
Virtual Modifier@Actual Modifiers
_
MAlt@Mod1
MCopy@Ctrl
MCtrl@Ctrl
MLink@Ctrl Shift
MMove@Shift
MShift@Shift
.TE
.PP 
\*LMod1\*O refers to the first modifier key.
1/Motif requires that it correspond to either \*LAlt\*O or \*LMeta\*O.
.PP 
The virtual modifier \*LMAny\*O indicates that any modifier can be used.
If \*LMAny\*O is not specified and the user presses an actual modifier
that is not explicitly included in a translation, that modifier may
prevent the translation from being matched.
.SS "Virtual Buttons"
Each virtual button corresponds to one or more actual button event
descriptions.
Each button event description contains a button name and possibly
modifiers.
These button event descriptions, appropriately ordered and possibly
further modified, are used in translation tables.
The following table lists the bindings of virtual buttons to actual
button event descriptions in 1/Motif:
.PP 
.TS 
center, allbox, tab(@);
cb s
lb lb.
Virtual Button Bindings
Virtual Button@Actual Button Events
_
BCustom@<Btn3>
BDrag@<Btn2>
BExtend@Shift<Btn1>
BMenu@<Btn3>
BSelect@<Btn1>
BToggle@Ctrl<Btn1>
.TE
.SS "Virtual Keys"
Each virtual key corresponds to one or more actual key event
descriptions.
Each key event description contains a keysym name and possibly
modifiers.
These key event descriptions, appropriately ordered and possibly further
modified,
.ne 15
are used in translation tables.
The following table lists the bindings of virtual keys to
actual key event descriptions in 1/Motif:
.PP 
.TS 
center, box, tab(@);
cb s
lb | lb.
Virtual Key Bindings
_
Virtual Key@Actual Key Events
=
KActivate@<Key>Return
@Ctrl<Key>Return
@<Key>osfActivate
_
KAddMode@<Key>osfAddMode
_
KBackSpace@<Key>osfBackSpace
_
KBackTab@Shift<Key>Tab
_
KBeginData@Ctrl<Key>osfBeginLine
_
KBeginLine@<Key>osfBeginLine
_
KCancel@<Key>osfCancel
_
KClear@<Key>osfClear
_
KCopy@<Key>osfCopy
@Ctrl<Key>osfInsert
_
KCut@<Key>osfCut
@Shift<Key>osfDelete
_
KDelete@<Key>osfDelete
_
KDeselectAll@Ctrl<Key>backslash
_
KDown@<Key>osfDown
_
KEndData@Ctrl<Key>osfEndLine
_
KEndLine@<Key>osfEndLine
_
KEnter@<Key>Return
_
KEscape@<Key>Escape
_
KExtend@Ctrl Shift<Key>space
@Shift<Key>osfSelect
_
KHelp@<Key>osfHelp
_
KInsert@<Key>osfInsert
_
.TE
.nL
.ne 40
.TS 
center, box, tab(@);
cb s
lb | lb.
Virtual Key Bindings (Continued)
_
Virtual Key@Actual Key Events
=
KLeft@<Key>osfLeft
_
KMenu@<Key>osfMenu
_
KMenuBar@<Key>osfMenuBar
_
KNextField@<Key>Tab
@Ctrl<Key>Tab
_
KNextMenu@Ctrl<Key>osfDown
@Ctrl<Key>osfRight
_
KPageDown@<Key>osfPageDown
_
KPageLeft@Ctrl<Key>osfPageUp
@<Key>osfPageLeft
_
KPageRight@Ctrl<Key>osfPageDown
@<Key>osfPageRight
_
KPageUp@<Key>osfPageUp
_
KPaste@<Key>osfPaste
@Shift<Key>osfInsert
_
KPrevField@Shift<Key>Tab
@Ctrl Shift<Key>Tab
_
KPrevMenu@Ctrl<Key>osfUp
@Ctrl<Key>osfLeft
_
KPrimaryCopy@Ctrl<Key>osfPrimaryPaste
@Mod1<Key>osfCopy
@Mod1 Ctrl<Key>osfInsert
_
KPrimaryCut@Mod1<Key>osfPrimaryPaste
@Mod1<Key>osfCut
@Mod1 Shift<Key>osfDelete
_
KPrimaryPaste@<Key>osfPrimaryPaste
_
KQuickCopy@Ctrl<Key>osfQuickPaste
_
KQuickCut@Mod1<Key>osfQuickPaste
_
KQuickExtend@Shift<Key>osfQuickPaste
_
.TE
.nL
.ne 20
.TS 
center, box, tab(@);
cb s
lb | lb.
Virtual Key Bindings (Continued)
_
Virtual Key@Actual Key Events
=
KQuickPaste@<Key>osfQuickPaste
_
KReselect@Ctrl Shift<Key>osfSelect
_
KRestore@Ctrl Shift<Key>osfInsert
_
KRight@<Key>osfRight
_
KSelect@<Key>space
@Ctrl<Key>space
@<Key>osfSelect
_
KSelectAll@Ctrl<Key>slash
_
KSpace@<Key>space
_
KTab@<Key>Tab
_
KUndo@<Key>osfUndo
@Mod1<Key>osfBackSpace
_
KUp@<Key>osfUp
_
KAny@<Key>
_
.TE
.SS "Bindings for osf Keysyms"
Keysym strings that begin with "osf" are not part of the X server's
keyboard mapping.
Instead, these keysyms are produced on the client side at run time.
They are interpreted by the routine \*LXmTranslateKey\*O, and
are used by the translation manager when the server delivers an actual
key event.
For each application, a mapping is maintained between "osf" keysyms and
keysyms that correspond to actual keys.
This mapping is based on information obtained at application startup
from one of the following sources, listed in order of precedence:
.ML
.LI
A \*LdefaultVirtualBindings\*O application resource in the resource
database.
.LI
A property on the root window, which can be set by \*Lmwm\*O on startup,
or by the \*Lxmbind\*O client, or on prior startup of a Motif
application.
.LI
The file \*L\&.motifbind\*O in the user's home directory.
.LI
A set of bindings based on the vendor string and optionally the vendor
release of the X server.
Motif searches for these bindings in the following steps:
.ML
.LI
If the file \*Lxmbind.alias\*O exists in the user's home directory,
Motif searches this file for a pathname associated with the vendor
string or with the vendor string and vendor release.
If it finds such a pathname and if that file exists, Motif loads the
bindings contained in that file.
.LI
If it has found no bindings, Motif next looks for the file
\*Lxmbind.alias\*O in the directory specified by the environment
variable \*LXMBINDDIR\*O, if \*LXMBINDDIR\*O is set, or in the directory
\*L/usr/lib/Xm/bindings\*O if \*LXMBINDDIR\*O is not set.
If this file exists Motif searches it for a pathname associated with the
vendor string or with the vendor string and vendor release.
If it finds such a pathname and if that file exists, Motif loads the
bindings contained in that file.
.LI
If it still has found no bindings, Motif loads a set of hard-coded
fallback bindings.
.LE
.LE
.PP
The \*Lxmbind.alias\*O file contains zero or more lines of the form:
.PP
.na
.wH .in +3n
.ta 1.75i
"\*Vvendor_string\*O[ \*Vvendor_release\*O]"	\*Vbindings_file\*O
.wH .in
.ad
.PP
where \*Vvendor_string\*O is the X server vendor name as returned by the
X client \*Lxdpyinfo\*O or the Xlib function \*LXServerVendor\*O, and
must appear in double quotes.
If \*Vvendor_release\*O is included, it is the X server vendor release
number as returned by the X client \*Lxdpyinfo\*O or the Xlib function
\*LXVendorRelease\*O, and must also be contained within the double
quotes separated by one space from \*Vvendor_string\*O.
\*Vvendor_release\*O is provided to allow support of changes in keyboard
hardware from a vendor, assuming that the vendor increments the release
number to flag such changes.
Alternatively, the vendor may simply use a unique vendor string for each
different keyboard.
.PP
\*Vbindings_file\*O is the pathname of the file containing the bindings
themselves.
It can be a relative or absolute pathname.
If it it is a relative pathname, it is relative to the location of the
\*Lxmbind.alias\*O file.
.PP
Comment lines in the \*Lxmbind.alias\*O file begin with \*L!\*O.
.PP
The bindings found in either the \*L\&.motifbind\*O file or the vendor
mapping are placed in a property on the root window.
This property is used to determine the bindings for subsequent Motif
applications.
.PP
On startup \*Lmwm\*O attempts to load the file \*L\&.motifbind\*O in the
user's home directory.
If this is unsuccessful, it loads the vendor bindings as described
above.
It places the bindings it loads in a property on the root window for use
by subsequent Motif applications.
.PP
\*Lxmbind\*O loads bindings from a file if that file is specified on the
command line.
If no file is specified on the command line, it attempts to load the
file \*L\&.motifbind\*O in the user's home directory.
If this fails, it loads the vendor bindings as described above.
It places the bindings it loads in a property on the root window for use
by subsequent Motif applications.
.PP 
The format of the specification for mapping "osf" keysyms to actual
keysyms is similar to that of a specification for an event translation.
The syntax is specified here in EBNF notation using the following
conventions:
.PP 
.wH .in +3n 
.na
.ta 1i
[\*Va\*O]	Means either nothing or \*Va\*O
.nL
{\*Va\*O}	Means zero or more occurrences of \*Va\*O
.ad
.wH .in  
.PP 
Terminals are enclosed in double quotation marks.
.PP 
The syntax of an "osf" keysym binding specification is as follows:
.PP 
.wH .in +3n 
.na
.ta 1.5i 1.75i
binding_spec	=	{line "\en"} [line]
.nL
line	=	virtual_keysym ":" key_event
.nL
key_event	=	{modifier_name} "<Key>" actual_keysym
.nL
virtual_keysym	=	keysym
.nL
actual_keysym	=	keysym
.nL
keysym	=	A valid X11 keysym name that is
.nL
		mapped by \*LXStringToKeysym\*O
.ad
.wH .in  
.PP 
As with event translations, more specific event descriptions must
precede less specific descriptions.
For example, an event description for a key with a modifier must precede
a description for the same key without the same modifier.
.PP 
Following is an example of a specification for the
\*LdefaultVirtualBindings\*O resource in a resource file:
.wH .in +3n 
.oS
.ta 0.5i 2i 2.5i 3.75i
*defaultVirtualBindings: \e
	osfBackSpace	:	<Key>BackSpace	\en\e
	osfInsert	:	<Key>InsertChar	\en\e
\&...
	osfDelete	:	<Key>DeleteChar
.oE
.wH .in  
.PP 
The format of a \*L\&.motifbind\*O file or of a file containing vendor
bindings is the same, except that the binding specification for each
keysym is placed on a separate line.
The example specification above appears as follows in a
\*L\&.motifbind\*O or vendor bindings file:
.wH .in +3n 
.oS
.ta 1.5i 2i
osfBackSpace	:	<Key>BackSpace
osfInsert	:	<Key>InsertChar
\&...
osfDelete	:	<Key>DeleteChar
.oE
.wH .in  
.PP 
The following table lists the fixed fallback default bindings for
"osf" keysyms:
.PP 
.ne 7
.TS 
center, allbox, tab(@);
cb s
lb lb.
Fallback Default Bindings for "osf" Keysyms
"osf" Keysym@Fallback Default Binding
_
osfActivate@<unbound>
osfAddMode@Shift F8
osfBackSpace@Backspace
osfBeginLine@Home
osfClear@Clear
osfCopy@<unbound>
osfCut@<unbound>
osfDelete@Delete
osfDown@Down
osfEndLine@End
osfCancel@Escape
osfHelp@F1
osfInsert@Insert
osfLeft@Left
osfMenu@F4
osfMenuBar@F10
osfPageDown@Next
osfPageLeft@<unbound>
osfPageRight@<unbound>
osfPageUp@Prior
osfPaste@<unbound>
osfPrimaryPaste@<unbound>
osfQuickPaste@<unbound>
osfRight@Right
osfSelect@Select
osfUndo@Undo
osfUp@Up
.TE
.SH RELATED INFORMATION
\*Lxmbind(1X)\*O
