...\" **
...\" **
...\" **  (c) Copyright 1989, 1990, 1992 by Open Software Foundation, Inc.
...\" **      All Rights Reserved.
...\" **
...\" **  (c) Copyright 1987, 1988, 1989, by Hewlett-Packard Company
...\" **
...\" **  (c) Copyright 1987, 1988 by Digital Equipment Corporation,
...\" **      Maynard, MA.  All Rights Reserved.
...\" **
...\" **
.TH MrmFetchSetValues 3X
.SH NAME
\*LMrmFetchSetValues\*O\(emFetches the values to be set from literals stored in UID files
.iX "MrmFetchSetValues"
.iX "uil functions" "MrmFetchSetValues"
.SH SYNOPSIS
.sS
.iS
\&#include <Mrm/MrmPublic.h>
.sp \n(PDu
.iX "MRM function" "MrmFetchSetValues"
.iX "MrmFetchSetValues" "definition"
Cardinal MrmFetchSetValues(\*Vhierarchy_id, widget, args, num_args\*L)
.ta .5i 1.5i
	MrmHierarchy	\*Vhierarchy_id\*L;
	Widget	\*Vwidget\*L;
	ArgList	\*Vargs\*L;
	Cardinal	\*Vnum_args\*L;
.iE
.sE
.SH DESCRIPTION
The
\*LMrmFetchSetValues\*O
function
is similar to
\*LXtSetValues\*O,
except that the values to be set are defined by the UIL named
values that are stored in the UID hierarchy.
.iX "MrmFetchSetValues" "description"
\*LMrmFetchSetValues\*O
fetches the values to be set from literals stored in UID files.
.VL 1.25i 
.LI "\*Vhierarchy_id\*O"
Specifies the ID of the UID hierarchy that contains the
specified literal. 
The \*Vhierarchy_id\*O
was returned in a previous call to \*LMrmOpenHierarchyPerDisplay\*O.
.LI "\*Vwidget\*O"
Specifies the widget that is modified.
.LI "\*Vargs\*O"
Specifies an argument list that identifies the widget arguments to be
modified as well as the index (UIL name) of the literal that
defines the value for that argument.
The name part of each argument (args[n].name) must begin with the string
\*LXmN\*O followed by the name that uniquely identifies this attribute tag.
For example, \*LXmNwidth\*O
is the attribute name associated with the core argument \*Vwidth\*O.
The value part (args[n].value) must be a string
that gives the index (UIL name) of the literal.
You must define all literals in UIL as exported values.
.LI "\*Vnum_args\*O"
Specifies the number of entries in \*Vargs\*O.
.nL
.ne 7
.LE 
.PP 
This function
sets the values
on a widget, evaluating the
values as public literal resource references resolvable from
a UID hierarchy.
Each literal is fetched from the hierarchy, and
its value is modified and converted as required.
This value is
then placed in the argument list and used as the actual value for an
\*LXtSetValues\*O
call.
\*LMrmFetchSetValues\*O
allows a widget to be modified
after creation using UID file values exactly as is done for
creation
values in
\*LMrmFetchWidget\*O.
.PP 
As in
\*LMrmFetchWidget\*O,
each argument whose value can be evaluated
from
the UID hierarchy is set in the widget.
Values that are not
found
or values in which conversion errors occur are not modified.
.PP 
Each entry in the argument list identifies an argument to be modified
in the widget.
The name part identifies the tag, which begins with
\*LXmN\*O.
The value part must be a string
whose value is the index of
the literal.
Thus, the following code would modify the label resource of the widget
to have the value of the literal accessed by the index
OK_button_label in the hierarchy:
.oS
args[n].name = XmNlabel;
args[n].value = "OK_button_label";
.oE
.SH "RETURN VALUE"
.iX "MrmSUCCESS"
.iX "MrmPARTIAL_SUCCESS"
.iX "MrmBAD_HIERARCHY"
.iX "MrmFAILURE"
This function returns one of these status return constants:
.VL 1.5i 
.LI "\*LMrmSUCCESS\*O"
The function executed successfully.
.LI "\*LMrmPARTIAL_SUCCESS\*O"
At least one literal was successfully fetched.
.LI "\*LMrmBAD_HIERARCHY\*O"
The hierarchy ID was invalid.
.LI "\*LMrmFAILURE\*O"
The function failed.
.nL
.ne 10
.LE 
.SH RELATED INFORMATION
.na
\*LMrmOpenHierarchyPerDisplay(3X)\*O,
\*LXtSetValues(3X)\*O.
.ad
