...\" **
...\" **
...\" **  (c) Copyright 1989, 1990, 1992 by Open Software Foundation, Inc.
...\" **      All Rights Reserved.
...\" **
...\" **  (c) Copyright 1987, 1988, 1989, by Hewlett-Packard Company
...\" **
...\" **  (c) Copyright 1987, 1988 by Digital Equipment Corporation,
...\" **      Maynard, MA.  All Rights Reserved.
...\" **
...\" **
.TH MrmFetchLiteral 3X
.SH NAME
\*LMrmFetchLiteral\*O\(emFetches a literal from a UID file
.iX "MrmFetchLiteral"
.iX "uil functions" "MrmFetchLiteral"
.SH SYNOPSIS
.sS
.iS
\&#include <Mrm/MrmPublic.h>
.sp \n(PDu
.iX "MRM function" "MrmFetchLiteral"
.iX "MrmFetchLiteral" "definition"
int MrmFetchLiteral(\*Vhierarchy_id, index, display, value, type\*L)
.ta .5i 1.5i
	MrmHierarchy	\*Vhierarchy_id\*L;
	String	\*Vindex\*L;
	Display	*\*Vdisplay\*L;
	XtPointer	*\*Vvalue\*L;
	MrmCode	*\*Vtype\*L;
.iE
.sE
.SH DESCRIPTION
The
\*LMrmFetchLiteral\*O
function
.iX "MrmFetchLiteral" "description"
reads and returns the value and type of a literal (named value)
that is stored as
a public resource in a single UID file.
This function returns a pointer to the value of the literal.
For example, an integer is always returned as a pointer to an integer,
and a string is always returned as a pointer to a string.
.PP 
Applications should not use
\*LMrmFetchLiteral\*O
for fetching icon or color literals.
If this is attempted,
\*LMrmFetchLiteral\*O
returns an error.
.VL 1.25i 
.LI "\*Vhierarchy_id\*O"
Specifies the ID of the UID hierarchy that contains the
specified literal.
The \*Vhierarchy_id\*O was returned in a previous call to
\*LMrmOpenHierarchyPerDisplay\*O.
.LI "\*Vindex\*O"
Specifies the UIL name of the literal (pixmap) to fetch.
You must define this name in UIL as an exported value.
.LI "\*Vdisplay\*O"
Specifies the display used for the pixmap.
The
\*Vdisplay\*O
argument specifies the connection to the X server.
For more information on the
\*LDisplay\*O structure see the Xlib function
\*LXOpenDisplay\*O.
.LI "\*Vvalue\*O"
Returns the ID of the named literal's value.
.LI "\*Vtype\*O"
Returns the named literal's data type.
Types are defined in the include file \*L<Mrm/MrmPublic.h>\*O.
.LE 
.SH RETURN VALUE
.iX "MrmSUCCESS"
.iX "MrmBAD_HIERARCHY"
.iX "MrmNOT_FOUND"
.iX "MrmFAILURE"
This function returns one of these status return constants:
.VL 2.0i 
.LI "\*LMrmSUCCESS\*O"
The function executed successfully.
.LI "\*LMrmBAD_HIERARCHY\*O"
The hierarchy ID was invalid.
.LI "\*LMrmNOT_FOUND\*O"
The literal was not found in the UIL file.
.LI "\*LMrmWRONG_TYPE\*O"
The caller tried to fetch a literal of a type not supported by this
function.
.LI "\*LMrmFAILURE\*O"
The function failed.
.LE 
.SH RELATED INFORMATION
.na
\*LMrmFetchBitmapLiteral(3X)\*O,
\*LMrmOpenHierarchyPerDisplay(3X)\*O,
\*LMrmFetchIconLiteral(3X)\*O,
\*LMrmFetchColorLiteral(3X)\*O, and
\*LXOpenDisplay(3X)\*O.
.ad
