...\" **
...\" **
...\" **  (c) Copyright 1989, 1990, 1992 by Open Software Foundation, Inc.
...\" **      All Rights Reserved.
...\" **
...\" **  (c) Copyright 1987, 1988, 1989, by Hewlett-Packard Company
...\" **
...\" **  (c) Copyright 1987, 1988 by Digital Equipment Corporation,
...\" **      Maynard, MA.  All Rights Reserved.
...\" **
...\" **
.TH MrmFetchIconLiteral 3X
.SH NAME
\*LMrmFetchIconLiteral\*O\(emFetches an icon literal from a hierarchy
.iX "MrmFetchIconLiteral"
.iX "uil functions" "MrmFetchIconLiteral"
.SH SYNOPSIS
.sS
.iS
\&#include <Mrm/MrmPublic.h>
.sp \n(PDu
.iX "MRM function" "MrmFetchIconLiteral"
.iX "MrmFetchIconLiteral" "definition"
int MrmFetchIconLiteral(\*Vhierarchy_id, index, screen, display, fgpix, bgpix, pixmap\*L)
.ta .5i 1.5i
	MrmHierarchy	\*Vhierarchy_id\*L;
	String	\*Vindex\*L;
	Screen	*\*Vscreen\*L;
	Display	*\*Vdisplay\*L;
	Pixel	\*Vfgpix\*L;
	Pixel	\*Vbgpix\*L;
	Pixmap	*\*Vpixmap\*L;
.iE
.sE
.SH DESCRIPTION
The
\*LMrmFetchIconLiteral\*O
function
.iX "MrmFetchIconLiteral" "description"
fetches an icon literal from an MRM hierarchy, and converts the
icon literal to an X pixmap.
.VL 1.25i 
.LI "\*Vhierarchy_id\*O"
Specifies the ID of the UID hierarchy that contains the
specified icon literal.
The \*Vhierarchy_id\*O was returned in a previous call to
\*LMrmOpenHierarchyPerDisplay\*O.
.LI "\*Vindex\*O"
Specifies the UIL name of the icon literal to fetch.
.LI "\*Vscreen\*O"
Specifies the screen used for the pixmap.
The
\*Vscreen\*O
argument specifies a pointer to the
Xlib structure
\*LScreen\*O
which contains the information about that screen and is linked to the
\*LDisplay\*O
structure.
.ne 8
For more information on the
\*LDisplay\*O
and
\*LScreen\*O
structures, see the Xlib function
\*LXOpenDisplay\*O
and the associated screen information macros.
.LI "\*Vdisplay\*O"
Specifies the display used for the pixmap.
The
\*Vdisplay\*O
argument specifies the connection to the X server.
For more information on the
\*LDisplay\*O structure, see the Xlib function
\*LXOpenDisplay\*O.
.LI "\*Vfgpix\*O"
Specifies the foreground color for the pixmap.
.LI "\*Vbgpix\*O"
Specifies the background color for the pixmap.
.LI "\*Vpixmap\*O"
Returns the resulting X pixmap value.
.LE 
.SH RETURN VALUE
.iX "MrmSUCCESS"
.iX "MrmBAD_HIERARCHY"
.iX "MrmNOT_FOUND"
.iX "MrmFAILURE"
This function returns one of these status return constants:
.VL 2.0i 
.LI "\*LMrmSUCCESS\*O"
The function executed successfully.
.LI "\*LMrmBAD_HIERARCHY\*O"
The hierarchy ID was invalid.
.LI "\*LMrmNOT_FOUND\*O"
The icon literal was not found in the hierarchy.
.LI "\*LMrmWRONG_TYPE\*O"
The caller tried to fetch a literal of a type not supported by this
function.
.LI "\*LMrmFAILURE\*O"
The function failed.
.LE 
.SH RELATED INFORMATION
.na
\*LMrmFetchBitmapLiteral(3X)\*O,
\*LMrmOpenHierarchyPerDisplay(3X)\*O,
\*LMrmFetchLiteral(3X)\*O,
\*LMrmFetchColorLiteral(3X)\*O, and
\*LXOpenDisplay(3X)\*O.
.ad
