/* 
 * (c) Copyright 1989, 1990, 1991, 1992 OPEN SOFTWARE FOUNDATION, INC. 
 * ALL RIGHTS RESERVED 
*/ 
/* 
 * Motif Release 1.2
*/ 
#ifdef REV_INFO
#ifndef lint
static char rcsid[] = "$RCSfile: MOptionMenu1.c,v $ $Revision: 1.4 $ $Date: 92/03/13 17:52:17 $"
#endif
#endif

#include <stdio.h>
#include <signal.h>
#include <errno.h>
#include "Mmemory.h"
#include <testlib.h>

#define TEAMLEN	17		/* maximum length of a team string */
#define ERROR 	(-1)
#define OK 	1

#define MAX_GAMES 5		/* maximum games per week */
#define NUM_PUSH  3		/* # of push per games */

static Widget MainWindowHandle = NULL;
static Widget rc_outside = NULL, bb_outside = NULL;
static Widget label_header = NULL, radio_games[MAX_GAMES] ={NULL};
static Widget push_games[MAX_GAMES][NUM_PUSH] = { 0 };
static Widget label_mnf = NULL, scale_monday = NULL;
static Widget rc_options = NULL, pushb_send = NULL;
static Widget pushb_quit = NULL, pushb_print = NULL;

static char MNFheader[] = "Monday Night Football Total Score";
static char *ButtonLabels[] = { "Send picks",
                              "Print picks",
                              "Quit"
                            };
/**
 ** notify functions 
 **/

void PrintProc();
int pool_Index = 0;

#ifdef _NO_PROTO
void main(argc, argv)
int argc;
char **argv;
#else
void main(int argc, char **argv)
#endif
{
  int n=0, i=0,  j=0;
  Arg args[MAX_ARGS];
  Widget tmp_widget;
  XmString tcs;
  char temp[25];

  CommonTestInit(argc,argv);
  n = 0;
  tcs = XmStringCreateLtoR("Football Players", XmSTRING_DEFAULT_CHARSET); 
  XtSetArg(args[n], XmNlabelString, tcs); n++;
  label_header = XmCreateLabel(Shell1, "LabelHead", args, n);
  XmStringFree(tcs);
  XtManageChild(label_header);

  bb_outside = XmCreateBulletinBoardDialog(Shell1, "BB", NULL, 0);
  XtManageChild(bb_outside);

  n = 0;
  XtSetArg(args[n], XmNpacking, XmPACK_COLUMN); n++;
  rc_outside = XmCreateRowColumn(bb_outside, "RowC", args, n);
  XtManageChild(rc_outside);

  for(i=0; i< MAX_GAMES; i++)
    {
      sprintf(temp, "Pulldown%d", i);
      tmp_widget = XmCreatePulldownMenu(rc_outside, temp, NULL, 0);
      n = 0;
      XtSetArg(args[n], XmNsubMenuId, tmp_widget); n++;
      XtSetArg(args[n], XmNpacking, XmPACK_NONE); n++;
      sprintf(temp, "Game%d", i);
      radio_games[i] = XmCreateOptionMenu(rc_outside, temp, args, n);
      XtManageChild(radio_games[i]);

      for(j=1; j<=2; j++)
	{
	  n = 0;
	  tcs = XmStringCreateLtoR("Text", XmSTRING_DEFAULT_CHARSET);
	  XtSetArg(args[n], XmNlabelString, tcs); n++;
	  sprintf(temp, "PB%d%d", i, j);
	  push_games[i][j-1] = XmCreatePushButton(tmp_widget, temp, args, n);
	  XtManageChild(push_games[i][j-1]);
	  XmStringFree(tcs);

	  n = 0;
	  XtSetArg(args[n], XmNwidth, 110); n++;
	  XtSetArg(args[n], XmNx, (j-1)*112); n++;
	  XtSetValues(push_games[i][j-1], args, n);
	}
      n = 0; j = 3;
      XtSetArg(args[n], XmNx, (2)*112); n++;
      XtSetArg(args[n], XmNtraversalOn, FALSE); n++;
      XtSetArg(args[n], XmNindicatorOn, FALSE); n++;
      tcs = XmStringCreateLtoR("Spread", XmSTRING_DEFAULT_CHARSET);
      XtSetArg(args[n], XmNlabelString, tcs); n++;
      sprintf(temp, "PB%d%d", i, j);
      push_games[i][j-1] = XmCreatePushButton(tmp_widget, temp, args, n);
      XtManageChild(push_games[i][j-1]);
    }

  n = 0;
  tcs = XmStringCreateLtoR(MNFheader, XmSTRING_DEFAULT_CHARSET);
  XtSetArg(args[n], XmNlabelString, tcs); n++;
  label_mnf = XmCreateLabel(rc_outside, "MNF header", args,n);
  XtManageChild(label_mnf);
  XmStringFree(tcs);

  n = 0;
  XtSetArg(args[n], XmNorientation, XmHORIZONTAL); n++;
  XtSetArg(args[n], XmNshowValue, TRUE); n++;
  XtSetArg(args[n], XmNminimum, 0); n++;
  XtSetArg(args[n], XmNmaximum, 100); n++;
  scale_monday = XmCreateScale(rc_outside, "Scale", args, n);
  XtManageChild(scale_monday);

  n = 0;
  XtSetArg(args[n], XmNorientation, XmHORIZONTAL); n++;
  XtSetArg(args[n], XmNpacking, XmPACK_COLUMN); n++;
  XtSetArg(args[n], XmNentryAlignment, XmALIGNMENT_CENTER); n++;
  rc_options = XmCreateRowColumn(rc_outside, "Options", args, n);
  XtManageChild(rc_options);

  for(i=0; i<3; i++)
    {
      n = 0;
      tmp_widget = XmCreatePushButton(rc_options, ButtonLabels[i], args, n);
      XtManageChild(tmp_widget);
      XtAddCallback(tmp_widget, XmNactivateCallback, PrintProc, NULL);
    }

  XtRealizeWidget(Shell1);

  CommonPause();
  CommonPause();

} /* main */

/**
 ** Invoked when ANY button is pressed.
 **/

#ifdef _NO_PROTO
void PrintProc(w, clientData, callbackData)
Widget w;
caddr_t clientData;
caddr_t callbackData;
#else
void PrintProc(Widget w, caddr_t clientData, caddr_t callbackData)
#endif
{
  XtDestroyWidget(bb_outside);
  fprintf(stderr,"Clear the deck, she's gonna blow!\n");
}

