/* 
 * (c) Copyright 1989, 1990, 1991, 1992 OPEN SOFTWARE FOUNDATION, INC. 
 * ALL RIGHTS RESERVED 
*/ 
/* 
 * Motif Release 1.2
*/ 
#ifdef REV_INFO
#ifndef lint
static char rcsid[] = "$RCSfile: StringWidth.c,v $ $Revision: 1.3.2.4 $ $Date: 1992/04/29 20:29:13 $"
#endif
#endif
#include        <stdio.h>
#include        <testlib.h>
 
char *test_strings[] = {"", "", "a", "a", "aaaaaa" };
Dimension expected[] = {0, 0, 9, 54, 54, 0, 0 };

#define XmSTRING_DIRECTION_REVERT 2
#define NUM_TESTS 7 

main(argc, argv)
int argc;
char **argv;
{
    XmString	cs, cs1, cs2, cs3;
    XmFontList	fl;
    XFontStruct *font;
    register	i;
    Dimension received[NUM_TESTS];
    int test_num = 0;
 
    CommonTestInit (argc, argv);

    fl = CommonGetFontList
	      ("-adobe-courier-medium-r-normal--14-140-75-75-m-90-iso8859-1");

/*  Test 1 */ 
    cs = XmStringCreate ( test_strings[test_num], XmSTRING_DEFAULT_CHARSET );
    received[test_num++] = XmStringWidth(fl , cs );

/*  Test 2 */ 
    cs1 = XmStringCreate ( test_strings[test_num], XmSTRING_DEFAULT_CHARSET );
    for (i = 0; i < 5; i++) {
	cs1 = XmStringConcat( cs, cs1);
    }
    received[test_num++] = XmStringWidth(fl , cs1 );

/*  Test 3 */
    cs = XmStringSegmentCreate ( test_strings[test_num], 
		XmSTRING_DEFAULT_CHARSET,
                XmSTRING_DIRECTION_L_TO_R,
                FALSE);
    received[test_num++] = XmStringWidth(fl , cs );

/*  Test 4 */ 
    cs1 = XmStringSegmentCreate ( test_strings[test_num], 
                XmSTRING_DEFAULT_CHARSET,
                XmSTRING_DIRECTION_L_TO_R,
                FALSE);
    for (i = 0; i < 5; i++) {
	cs1 = XmStringConcat( cs, cs1);
    }
    received[test_num++] = XmStringWidth(fl , cs1 );

/*  Test 5 */
    cs = XmStringCreate ( test_strings[test_num], XmSTRING_DEFAULT_CHARSET );
    received[test_num++] = XmStringWidth(fl , cs );

/*  Test 6 */
    cs1 = XmStringDirectionCreate( XmSTRING_DIRECTION_L_TO_R );
    received[test_num++] = XmStringWidth(fl , cs1 );

/*  Test 7 */ 
    cs2 = XmStringDirectionCreate( XmSTRING_DIRECTION_REVERT );
    received[test_num++] = XmStringWidth(fl , cs2 );

    printf ("Summary of test results\n");
    printf ("Test #\tExpected\tReceived\tStatus\n\n");
    for (i = 0; i < test_num; i++) {
      printf ("%6d\t%8d\t%8d\t%s\n",     i + 1,
	                              (int) expected[i],
	                              (int) received[i],
	                              ((expected[i] == received[i]) 
				                   ? "PASSED\n" : "FAILED\n"));
    }

    fflush (stdout);

}

