/* 
 * (c) Copyright 1989, 1990, 1991, 1992 OPEN SOFTWARE FOUNDATION, INC. 
 * ALL RIGHTS RESERVED 
*/ 
/* 
 * Motif Release 1.2
*/ 
#ifdef REV_INFO
#ifndef lint
static char rcsid[] = "$RCSfile: Text5.c,v $ $Revision: 1.4.2.2 $ $Date: 1992/04/06 14:20:43 $"
#endif
#endif
/*
*  (c) Copyright 1987, 1988, 1989 HEWLETT-PACKARD COMPANY */

#include <testlib.h>

Widget BBoard1 = NULL;
Arg args[MAX_ARGS];

#ifdef _NO_PROTO
static void ModifyVerifyCB (w, client_data, call_data)
	Widget w;
	XtPointer client_data;
	XtPointer call_data;
#else   /* _NO_PROTO */
static void ModifyVerifyCB (Widget w, XtPointer client_data,
	XtPointer call_data)
#endif  /* _NO_PROTO */

{
	XmTextVerifyCallbackStruct  *modify_verify;
	static char c = 'A';
	static int position = 12;

	modify_verify = (XmTextVerifyCallbackStruct *)call_data;

	if (modify_verify->event == NULL)
		printf("Null event in ModifyVerifycallback\n");

	if (modify_verify->text->ptr != NULL)
	{
		/* Make sure that it is not a BS */
		modify_verify->startPos = position++;
		modify_verify->endPos = modify_verify->startPos;
		modify_verify->text->ptr[0] = c;
		modify_verify->text->length = 1;
	}

	c += 1;
	if (c > 'Z')
		c = 'A';
}

#ifdef _NO_PROTO
static void ModifyVerifyCB2 (w, client_data, call_data)
	Widget w;
	XtPointer client_data;
	XtPointer call_data;
#else   /* _NO_PROTO */
static void ModifyVerifyCB2 (Widget w, XtPointer client_data,
	XtPointer call_data)
#endif  /* _NO_PROTO */
{
    XmTextVerifyCallbackStruct  *modify_verify;
    static char c[] =
    "A234567890 234567890 234567890 234567890 234567890 234567890 234567890\n";
    static int position = 15;
    char *ptr;
    int	c_length;

    modify_verify = (XmTextVerifyCallbackStruct *)call_data;

    if (modify_verify->text->ptr != NULL)
    {
	    /* Make sure that it is not a BS */
	    c_length = strlen(c);
	    modify_verify->startPos = position;
	    position += c_length;
	    modify_verify->endPos = modify_verify->startPos;
	    XtFree(modify_verify->text->ptr);
	    ptr=XtMalloc(c_length+1);
	    strcpy(ptr, c);
	    modify_verify->text->ptr = ptr;
	    modify_verify->text->length = c_length;
    }

    *c += 1;
    if (*c > 'Z')
	    *c = 'A';
}

#ifdef _NO_PROTO
static void ChangeString (w, client_data, call_data)
	Widget w;
	XtPointer client_data;
	XtPointer call_data;
#else   /* _NO_PROTO */
static void ChangeString (Widget w, XtPointer client_data,
	XtPointer call_data)
#endif  /* _NO_PROTO */
{
	int n = 0;
	char *value;

	value = XmTextGetString(w);
	XmTextSetCursorPosition(w, strlen(value));
	XtFree(value);

	XtSetArg(args[n], XmNfontList, CommonGetFontList("8x13bold"));  n++;
	XtSetArg(args[n], XmNmarginWidth, 10);  n++;
	XtSetArg(args[n], XmNmarginHeight, 10);  n++;
	XtSetArg(args[n], XmNwordWrap, False); n++;
	XtSetArg(args[n], XmNrows, 5);  n++;
	XtSetArg(args[n], XmNeditMode, XmMULTI_LINE_EDIT); n++;
	XtSetArg(args[n], XmNforeground, CommonGetColor("navy"));  n++;
	XtSetArg(args[n], XmNvalue, "Welcome to OSF/Motif"); n++;
	XtSetValues(w, args, n);
}

void main (argc, argv)
int argc;
char **argv;
{
	Widget Text1 = NULL;
	int n = 0;

	/*  initialize toolkit  */
	 CommonTestInit(argc, argv);

	/* create bulletin board child to make allowresize work okay */

	n = 0;
	XtSetArg (args[n], XmNmarginHeight, 0); n++;
	XtSetArg (args[n], XmNmarginWidth, 0); n++;
	BBoard1 = XmCreateBulletinBoard(Shell1, "BBoard1", args, n);
	XtManageChild(BBoard1);

	XtRealizeWidget(Shell1);

	/* Test case for PIR 2757 */
	n = 0;
	XtSetArg(args[n], XmNrows, 1); n++;
	XtSetArg(args[n], XmNcolumns, 1); n++;
	XtSetArg(args[n], XmNeditMode, XmMULTI_LINE_EDIT); n++;
	XtSetArg(args[n], XmNwordWrap, False); n++;
	XtSetArg(args[n], XmNresizeHeight, True); n++;
	XtSetArg(args[n], XmNresizeWidth, True); n++;
	XtSetArg(args[n], XmNvalue, "Sample Text"); n++;
	Text1 = XmCreateText(BBoard1, "Text1", args, n);
	XtManageChild(Text1);

	CommonPause();

	XtDestroyWidget(Text1);

	n = 0;
	XtSetArg(args[n], XmNfontList, CommonGetFontList("fixed"));  n++;
	XtSetArg(args[n], XmNresizeWidth, True);  n++;
	XtSetArg(args[n], XmNresizeHeight, True);  n++;
	XtSetArg(args[n], XmNcolumns, 40);  n++;
	XtSetArg(args[n], XmNrows, 1);  n++;
	XtSetArg(args[n], XmNeditMode, XmSINGLE_LINE_EDIT); n++;
	XtSetArg(args[n], XmNcursorPosition, 12);  n++;
	XtSetArg(args[n], XmNvalue, "Sample Text ");  n++;
	XtSetArg(args[n], XmNforeground, CommonGetColor("Red"));  n++;
	XtSetArg(args[n], XmNbackground, CommonGetColor("White"));  n++;
	Text1 = XmCreateText(BBoard1, "Text1", args, n);

	XtManageChild(Text1);

	CommonPause();

	XtAddCallback(Text1, XmNmodifyVerifyCallback, ModifyVerifyCB, NULL);

	CommonPause();

	XtRemoveAllCallbacks (Text1, XmNmodifyVerifyCallback);
	XtAddCallback(Text1, XmNactivateCallback, ChangeString, NULL);

	CommonPause();

	/* test case for PIR 2230 */
	XtRemoveAllCallbacks (Text1, XmNactivateCallback);
	XtAddCallback(Text1, XmNmodifyVerifyCallback, ModifyVerifyCB2, NULL);

	CommonPause();
	/* end of test case for PIR 2230 */

	XtAppMainLoop(app_context);
}
