/* 
 * (c) Copyright 1989, 1990, 1991, 1992 OPEN SOFTWARE FOUNDATION, INC. 
 * ALL RIGHTS RESERVED 
*/ 
/* 
 * Motif Release 1.2
*/ 
#ifdef REV_INFO
#ifndef lint
static char rcsid[] = "$RCSfile: Scrollbar6.c,v $ $Revision: 1.3.2.2 $ $Date: 1992/04/03 15:43:03 $"
#endif
#endif
/*
*  (c) Copyright 1987, 1988, 1989 HEWLETT-PACKARD COMPANY */
/************************************************************************
 *
 *  Create a horizontal scrollbar with reverse processing direction
 *
 ************************************************************************/

#include <X11/StringDefs.h>
#include <testlib.h>

extern void ScrollCallback();

void main(argc, argv)
unsigned int argc;
char **argv;
{
  Widget frame;
  Widget scrollbar;
  Arg args[10];
  int n;

  CommonTestInit(argc, argv);
    
  frame = XmCreateFrame(Shell1, "frame", NULL, 0);
  XtManageChild(frame);

  n = 0;
  XtSetArg(args[n], XmNorientation, XmHORIZONTAL); n++;
  XtSetArg(args[n], XmNprocessingDirection, XmMAX_ON_LEFT); n++;
  XtSetArg(args[n], XmNheight, 50); n++;
  XtSetArg(args[n], XmNwidth, 250); n++;
  scrollbar = XmCreateScrollBar(frame, "scrollbar", args, n);
  XtManageChild(scrollbar);

  n = 0;
  XtSetArg(args[n], XmNvalue, 20);          n++;
  XtSetValues(scrollbar, args, n);

  XtAddCallback(scrollbar, XmNvalueChangedCallback,  ScrollCallback, NULL);
  XtAddCallback(scrollbar, XmNhelpCallback,          ScrollCallback, NULL);
  XtAddCallback(scrollbar, XmNpageIncrementCallback, ScrollCallback, NULL);
  XtAddCallback(scrollbar, XmNpageDecrementCallback, ScrollCallback, NULL); 
  
  XtRealizeWidget(Shell1);

  CommonPause();
  CommonPause();

  /* Change orientation to Vertical and re-do testing */

  n = 0;
  XtSetArg(args[n], XmNorientation, XmVERTICAL);	n++;
  XtSetArg(args[n], XmNprocessingDirection, XmMAX_ON_TOP);	n++;
  XtSetArg(args[n], XmNheight, 250);			n++;
  XtSetArg(args[n], XmNwidth, 50);			n++;
  XtSetValues(scrollbar, args, n);

  CommonPause();
  CommonPause();	

  XtDestroyWidget(scrollbar);
  XtDestroyWidget(frame);
  CommonPause();
  XtAppMainLoop(app_context);
}


void ScrollCallback(sbw, closure, call_data)
XmScrollBarWidget sbw;
XtPointer closure;
XtPointer call_data;
{
   int value;
   int reason;
   int pixel;
   Arg args[10];
   int n;

   XmScrollBarCallbackStruct * call_value = 
     (XmScrollBarCallbackStruct *) call_data;

   reason = call_value -> reason;
   value = call_value -> value;
   pixel = call_value -> pixel;

   switch(reason)
   {
      case XmCR_VALUE_CHANGED:
         printf("Reason = XmCR_VALUE_CHANGED,	Value = %d", value);
      break;

      case XmCR_PAGE_INCREMENT:
         printf("Reason = XmCR_PAGE_INCREMENT,	Value = %d", value);
      break;

      case XmCR_PAGE_DECREMENT:
         printf("Reason = XmCR_PAGE_DECREMENT,	Value = %d", value);
      break;

      case XmCR_HELP:
         printf("Reason = XmCR_HELP,	Value = %d\n", value);
      break;

      default:
         printf("Hit the default, incorrect reason sent!!\n");
      break;

   }

   n = 0;
   XtSetArg(args[n], XmNvalue, NULL);	n++;
   XtGetValues((Widget) sbw, args, n);
   printf(",   GetValues value = %d\n", args[0].value);
}
