/* 
 * (c) Copyright 1989, 1990, 1991, 1992 OPEN SOFTWARE FOUNDATION, INC. 
 * ALL RIGHTS RESERVED 
*/ 
/* 
 * Motif Release 1.2
*/ 
#ifdef REV_INFO
#ifndef lint
static char rcsid[] = "$RCSfile: Scrollbar5.c,v $ $Revision: 1.3 $ $Date: 92/03/13 17:46:29 $"
#endif
#endif
/*
*  (c) Copyright 1989, HEWLETT-PACKARD COMPANY */
/************************************************************************
 *
 *  Create a scrollbar with a full set of callbacks.
 *
 ************************************************************************/

#include <X11/StringDefs.h>
#include <testlib.h>

extern void ScrollCallback();

void main(argc, argv)
unsigned int argc;
char **argv;
{
   Widget frame;
   Widget scrollbar;
   Arg args[10];
   int n;

   CommonTestInit(argc, argv);
    
   frame = 
      XmCreateFrame(Shell1, "frame", NULL, 0);
   XtManageChild(frame);
   n = 0;

   XtSetArg(args[n], XmNwidth, 50); n++;
   XtSetArg(args[n], XmNheight, 250); n++;
   scrollbar = XmCreateScrollBar(frame, "scrollbar", args, n);
   XtManageChild(scrollbar);

   XtAddCallback(scrollbar, XmNvalueChangedCallback,  ScrollCallback, NULL);
   XtAddCallback(scrollbar, XmNincrementCallback,     ScrollCallback, NULL);
   XtAddCallback(scrollbar, XmNdecrementCallback,     ScrollCallback, NULL);
   XtAddCallback(scrollbar, XmNpageIncrementCallback, ScrollCallback, NULL);
   XtAddCallback(scrollbar, XmNpageDecrementCallback, ScrollCallback, NULL);
   XtAddCallback(scrollbar, XmNtoTopCallback,         ScrollCallback, NULL);
   XtAddCallback(scrollbar, XmNtoBottomCallback,      ScrollCallback, NULL);
   XtAddCallback(scrollbar, XmNdragCallback,          ScrollCallback, NULL);
   XtAddCallback(scrollbar, XmNhelpCallback,          ScrollCallback, NULL);

   XtRealizeWidget(Shell1);

   CommonPause();
   CommonPause();

   /* Change Orientation to Horizontal and resume testing */

   n = 0;
   XtSetArg(args[n], XmNorientation, XmHORIZONTAL); n++;
   XtSetArg(args[n], XmNwidth, 250); n++;
   XtSetArg(args[n], XmNheight, 50); n++;
   XtSetArg(args[n] , XmNvalue, 0); n++;
   XtSetValues(scrollbar, args, n);

   CommonPause();
   CommonPause();

   XtDestroyWidget(scrollbar);
   XtDestroyWidget(frame);
   CommonPause();
   XtAppMainLoop(app_context);
}

void ScrollCallback(sbw, closure, call_data)
XmScrollBarWidget sbw;
caddr_t closure;
caddr_t call_data;
{
  int value;
  int reason;
  int pixel;

  XmScrollBarCallbackStruct * call_value = 
    (XmScrollBarCallbackStruct *) call_data;

  reason = call_value -> reason;
  value = call_value -> value;
  pixel = call_value -> pixel;

  switch(reason)
   {
      case XmCR_VALUE_CHANGED:
         printf("Reason = XmCR_VALUE_CHANGED,	Value = %d\n", value);
      break;

      case XmCR_INCREMENT:
         printf("Reason = XmCR_INCREMENT,	Value = %d\n", value);
      break;

      case XmCR_DECREMENT:
         printf("Reason = XmCR_DECREMENT,	Value = %d\n", value);
      break;

      case XmCR_PAGE_INCREMENT:
         printf("Reason = XmCR_PAGE_INCREMENT,	Value = %d\n", value);
      break;

      case XmCR_PAGE_DECREMENT:
         printf("Reason = XmCR_PAGE_DECREMENT,	Value = %d\n", value);
      break;

      case XmCR_TO_TOP:
         printf("Reason = XmCR_TO_TOP,	Value = %d,	Pixel = %d\n",
                 value, pixel);
      break;

      case XmCR_TO_BOTTOM:
         printf("Reason = XmCR_TO_BOTTOM,	Value = %d,	Pixel = %d\n",
                 value, pixel);
      break;

      case XmCR_DRAG:
            printf("Reason = XmCR_DRAG,	Value = %d\n", value);
      break;

      case XmCR_HELP:
         printf("Reason = XmCR_HELP,	Value = %d\n", value);
      break;

      default:
         printf("Hit the default, incorrect reason sent!!\n");
      break;

   }
}












