/* 
 * (c) Copyright 1989, 1990, 1991, 1992 OPEN SOFTWARE FOUNDATION, INC. 
 * ALL RIGHTS RESERVED 
*/ 
/* 
 * Motif Release 1.2
*/ 
#ifdef REV_INFO
#ifndef lint
static char rcsid[] = "$RCSfile: PopupMenu2.c,v $ $Revision: 1.5.2.2 $ $Date: 1992/04/02 22:35:15 $"
#endif
#endif
/*
*  (c) Copyright 1989, HEWLETT-PACKARD COMPANY */

#include <X11/Xlib.h>
#include <X11/StringDefs.h>
#include <X11/IntrinsicP.h>

#include <testlib.h>

Widget popup = NULL, submenu2 = NULL, red = NULL, blue = NULL,
  violet = NULL, brown = NULL, orange = NULL, submenu4 = NULL,
  child1 = NULL, child2 = NULL, submenu3 = NULL, to_submenu = NULL,
  children = NULL, no_submenu = NULL,
  yellow = NULL, green = NULL, label = NULL, title = NULL;

#ifdef _NO_PROTO
static void PostIt(w, p, event, c)
Widget w;
XtPointer p;
XEvent *event;
Boolean *c;
#else
static void PostIt(Widget w, XtPointer p, XEvent *event, Boolean *c)
#endif
{
  Widget popup = (Widget) p;
  if(event->xbutton.button != Button2)
    {return; }
  XmMenuPosition(popup, (XButtonPressedEvent *)event);
  XtManageChild(popup);
}

#ifdef _NO_PROTO
static void TranslationPost(w, event, params, num_params)
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
#else
static void TranslationPost(Widget w, XEvent *event, String *params,
			    Cardinal *num_params)
#endif
{
  XmMenuPosition(popup, (XButtonPressedEvent *)event);
  XtManageChild (popup);
}

#ifdef _NO_PROTO
static void cascading_msg(w, client_data, call_data)
Widget w;
XtPointer	client_data;
XtPointer call_data;
#else
static void cascading_msg(Widget w, XtPointer client_data, 
			  XtPointer call_data)
#endif
{
  fprintf(stdout, "cascading callback - %s\n",
	  XrmQuarkToString(w->core.xrm_name));
}

#ifdef _NO_PROTO
static void ArmCallback(w, client_data, call_data)
Widget w;
XtPointer	client_data;
XtPointer call_data;
#else
static void ArmCallback(Widget w, XtPointer client_data, 
		    XtPointer call_data)
#endif
{
  fprintf(stdout, "arm callback - %s\n",
	  XrmQuarkToString(w->core.xrm_name));
}

#ifdef _NO_PROTO
static void disArmCallback(w, client_data, call_data)
Widget w;
XtPointer	client_data;
XtPointer call_data;
#else
static void disArmCallback(Widget w, XtPointer client_data, 
		       XtPointer call_data)
#endif
{
  fprintf(stdout, "disarm callback - %s\n",
	  XrmQuarkToString(w->core.xrm_name));
}

#ifdef _NO_PROTO
static void activate_msg(w, client_data, call_data)
Widget w;
XtPointer	client_data;
XtPointer call_data;
#else
static void activate_msg(Widget w, XtPointer client_data, 
					XtPointer call_data)
#endif
{
  fprintf(stdout, "activate callback - destroy %s\n",
	  XrmQuarkToString(w->core.xrm_name));
    
  XtDestroyWidget(w);
}

#ifdef _NO_PROTO
void PrintName_2(rc, client_data, rc_data)
Widget rc;
XtPointer	client_data;
XtPointer rc_data;
#else
void PrintName_2(Widget rc, XtPointer client_data, 
		 XtPointer rc_data)
#endif
{
  XmRowColumnCallbackStruct * rc_struct = (XmRowColumnCallbackStruct *)rc_data;
  fprintf(stdout, "Widget %s was activated\n", 
	  XrmQuarkToString(rc_struct->widget->core.xrm_name));
}

static XtCallbackRec PrintName_CB[] =
{
  {PrintName_2, NULL},
  {NULL, NULL}
};

#ifdef _NO_PROTO
int main(argc, argv)
int argc;
char *argv[];
#else
int main(int argc, char *argv[])
#endif
{
  Arg args[20];
  int n;
  XmString tcs;

  XmStringCharSet CharSet = (XmStringCharSet) XmSTRING_DEFAULT_CHARSET;

  /* for use in the later test of P1791 */
  static XtActionsRec actionTable[] = {{"PostPopupMenu", TranslationPost}};
  static char menuTranslations[] = "<Btn1Down>: PostPopupMenu()";

  CommonTestInit(argc, argv);
    
  XtAppAddActions(app_context, actionTable, 1);

  n = 0;
  XtSetArg(args[n], XtNwidth, 200); n++;
  XtSetArg(args[n], XtNheight, 40); n++;
  XtSetArg(args[n], XtNallowShellResize, True); n++;
  XtSetValues(Shell1, args, n);

  n = 0; 
  tcs = XmStringLtoRCreate("Popup Menu on MB2", CharSet);
  XtSetArg(args[n], XmNlabelString, tcs); n++;
  label = XmCreateLabel(Shell1, "top_label", args, n);
  XtManageChild(label);
  XmStringFree(tcs);
  XtRealizeWidget(Shell1);

  n = 0;
  XtSetArg(args[n], XmNorientation, XmVERTICAL); n++;
  XtSetArg(args[n], XmNwhichButton, 2); n++;
  popup = XmCreatePopupMenu(label, "popup", args, n);
  XtAddEventHandler(label, ButtonPressMask, False, PostIt, (XtPointer) popup);

  n = 0; 
  tcs = XmStringLtoRCreate("PopupMenu", CharSet);
  XtSetArg(args[n], XmNlabelString, tcs); n++;
  title = XmCreateLabel(popup, "Title", args, n);
  XtManageChild(title);
  XmStringFree(tcs);

  n = 0; 
  tcs = XmStringLtoRCreate("Red (W)", CharSet);
  XtSetArg(args[n], XmNlabelString, tcs); n++;
  red = XmCreatePushButton(popup, "red", args, n);
  XtAddCallback(red, XmNarmCallback, ArmCallback, NULL);
  XtAddCallback(red, XmNactivateCallback, activate_msg, NULL);
  XtAddCallback(red, XmNdisarmCallback, disArmCallback, NULL);
  XtManageChild(red);
  XmStringFree(tcs);

  n = 0; 
  tcs = XmStringLtoRCreate("Blue (G)", CharSet);
  XtSetArg(args[n], XmNlabelString, tcs); n++;
  blue = XmCreatePushButtonGadget(popup, "blue", args, n);
  XtAddCallback(blue, XmNarmCallback, ArmCallback, NULL);
  XtAddCallback(blue, XmNactivateCallback, activate_msg, NULL);
  XtAddCallback(blue, XmNdisarmCallback, disArmCallback, NULL);
  XtManageChild(blue);
  XmStringFree(tcs);
    
  n = 0; 
  tcs = XmStringLtoRCreate ("Yellow (W)", CharSet);
  XtSetArg(args[n], XmNlabelString, tcs); n++;
  yellow = XmCreatePushButton(popup, "yellow", args, n);
  XtAddCallback(yellow, XmNarmCallback, ArmCallback, NULL);
  XtAddCallback(yellow, XmNactivateCallback, activate_msg, NULL);
  XtAddCallback(yellow, XmNdisarmCallback, disArmCallback, NULL);
  XtManageChild(yellow);
  XmStringFree(tcs);

  n = 0; 
  XtSetArg(args[n], XmNentryCallback, (XtArgVal)PrintName_CB); n++;
  submenu2 = (Widget)XmCreatePulldownMenu(popup, "submenu2", args, n);

  n = 0; 
  tcs = XmStringLtoRCreate("Green (W)", CharSet);
  XtSetArg(args[n], XmNlabelString, tcs); n++;
  green = XmCreatePushButton(submenu2, "green", args, n);
  XtAddCallback(green, XmNarmCallback, ArmCallback, NULL);
  XtAddCallback(green, XmNactivateCallback, activate_msg, NULL);
  XtAddCallback(green, XmNdisarmCallback, disArmCallback, NULL);
  XtManageChild(green);
  XmStringFree(tcs);

  n = 0;
  tcs = XmStringLtoRCreate("Violet (G)", CharSet);
  XtSetArg(args[n], XmNlabelString, tcs); n++;
  violet = XmCreatePushButtonGadget(submenu2, "violet", args, n);
  XtAddCallback(violet, XmNarmCallback, ArmCallback, NULL);
  XtAddCallback(violet, XmNactivateCallback, activate_msg, NULL);
  XtAddCallback(violet, XmNdisarmCallback, disArmCallback, NULL);
  XtManageChild(violet);
  XmStringFree(tcs);

  n = 0;
  tcs = XmStringLtoRCreate("Brown (G)", CharSet);
  XtSetArg(args[n], XmNlabelString, tcs); n++;
  brown = XmCreatePushButtonGadget(submenu2, "brown", args, n);
  XtAddCallback(brown, XmNarmCallback, ArmCallback, NULL);
  XtAddCallback(brown, XmNactivateCallback, activate_msg, NULL);
  XtAddCallback(brown, XmNdisarmCallback, disArmCallback, NULL);
  XtManageChild(brown);
  XmStringFree(tcs);

  n = 0;
  tcs = XmStringLtoRCreate("Orange (W)", CharSet);
  XtSetArg(args[n], XmNlabelString, tcs); n++;
  orange = XmCreatePushButton(submenu2, "orange", args, n);
  XtAddCallback(orange, XmNarmCallback, ArmCallback, NULL);
  XtAddCallback(orange, XmNactivateCallback, activate_msg, NULL);
  XtAddCallback(orange, XmNdisarmCallback, disArmCallback, NULL);
  XtManageChild(orange);
  XmStringFree(tcs);

  n = 0;
  submenu4 = (Widget)XmCreatePulldownMenu(popup, "submenu4", args, n);

  n = 0;
  tcs = XmStringLtoRCreate("Child1 (G)", CharSet); 
  XtSetArg(args[n], XmNlabelString, tcs); n++;
  child1 = XmCreatePushButtonGadget(submenu4, "child1", args, n);
  XtAddCallback(child1, XmNarmCallback, ArmCallback, NULL);
  XtAddCallback(child1, XmNactivateCallback, activate_msg, NULL);
  XtAddCallback(child1, XmNdisarmCallback, disArmCallback, NULL);
  XtManageChild(child1);
  XmStringFree(tcs);

  n = 0;
  tcs = XmStringLtoRCreate("Child2 (W)", CharSet);
  XtSetArg(args[n], XmNlabelString, tcs); n++;
  child2 = XmCreatePushButton(submenu4, "child2", args, n);
  XtAddCallback(child2, XmNarmCallback, ArmCallback, NULL);
  XtAddCallback(child2, XmNactivateCallback, activate_msg, NULL);
  XtAddCallback(child2, XmNdisarmCallback, disArmCallback, NULL);
  XtManageChild(child2);
  XmStringFree(tcs);

  n = 0;
  submenu3 = (Widget)XmCreatePulldownMenu(popup, "submenu3", args, n);

  n = 0;
  tcs = XmStringLtoRCreate("To Submenu", CharSet);
  XtSetArg(args[n], XmNlabelString, tcs); n++;
  XtSetArg(args[n], XmNsubMenuId, submenu2); n++;
  to_submenu = XmCreateCascadeButton(popup, "to_submenu", args, n);
  XtAddCallback(to_submenu, XmNactivateCallback, activate_msg, NULL);
  XtAddCallback(to_submenu, XmNcascadingCallback, cascading_msg, NULL);
  XtManageChild(to_submenu);
  XmStringFree(tcs);

  n = 0;
  tcs = XmStringLtoRCreate("Children", CharSet); n++;
  XtSetArg(args[n], XmNlabelString, tcs); n++;
  XtSetArg(args[n], XmNsubMenuId, submenu4); n++;
  children = XmCreateCascadeButton(popup, "children", args, n);
  XtAddCallback(children, XmNactivateCallback, activate_msg, NULL);
  XtAddCallback(children, XmNcascadingCallback, cascading_msg, NULL);
  XtManageChild(children);
  XmStringFree(tcs);

  n = 0;
  tcs = XmStringLtoRCreate("No Submenu", CharSet);
  XtSetArg(args[n], XmNlabelString, tcs); n++;
  XtSetArg(args[n], XmNsubMenuId, submenu3); n++;
  no_submenu = XmCreateCascadeButton(popup, "no_submenu", args, n);
  XtAddCallback(no_submenu, XmNactivateCallback, activate_msg, NULL);
  XtAddCallback(no_submenu, XmNcascadingCallback, cascading_msg, NULL);
  XtManageChild(no_submenu);
  XmStringFree(tcs);

  CommonPause();

  XtRemoveEventHandler(label, ButtonPressMask, False, PostIt, popup);

  /* instead, install a translation that will pop it up */

  n = 0;
  tcs = XmStringCreateSimple ("Popup Menu on MB1");
  XtSetArg (args[n], XmNlabelString, tcs); n++;
  XtSetValues (label, args, n);

  n = 0;
  XtSetArg (args[n], XmNwhichButton, 1); n++;
  XtSetValues (popup, args, n);

  XtOverrideTranslations (label, XtParseTranslationTable(menuTranslations));
  CommonPause();

  XtAppMainLoop(app_context);
  return(1);
}
