/* 
 * (c) Copyright 1989, 1990, 1991, 1992 OPEN SOFTWARE FOUNDATION, INC. 
 * ALL RIGHTS RESERVED 
*/ 
/* 
 * Motif Release 1.2
*/ 
#ifdef REV_INFO
#ifndef lint
static char rcsid[] = "$RCSfile: PopupMenu1.c,v $ $Revision: 1.6.2.2 $ $Date: 1992/04/02 22:35:07 $"
#endif
#endif
/*
*  (c) Copyright 1987, 1988, 1989 HEWLETT-PACKARD COMPANY */


#include <testlib.h>

#define PUSHBUTTON 1
#define TOGGLEBUTTON 2
#define CASCADEBUTTON 3

Widget Label, PopupMenu1, Label1, Separator1, PushBtn1;
Widget ToggleBtn1, PullDown2, CascadeBtn1, Label2, Separator3;
Widget Separator2, ToggleBtn2, PullDown3, CascadeBtn2, Separator4;
Widget PushBtn2, Label3, PullDown4, CascadeBtn3;
Widget PushBtn3, ToggleBtn3, Label4;

#ifdef _NO_PROTO
void CBHandler(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
#else
void CBHandler(Widget w, XtPointer client_data, XtPointer call_data)
#endif
{
  char *myname;
  CoreWidget  *tmpwidget;

  switch ( ((XmAnyCallbackStruct *)call_data)->reason)
    {    
    case XmCR_ARM:    
      printf ("Arm ");
      break;
    case XmCR_ACTIVATE:   
      printf ("Activate ");
      break;
    case XmCR_DISARM:
      printf ("Disarm ");
      break;
    case XmCR_VALUE_CHANGED:
      printf ("ValueChanged ");
      break;
    case XmCR_CASCADING:
      printf ("Cascading ");
      break;
    default:
      printf ("Other Callback ");
    }

  printf ("%s\n", XtName(w));
  XFlush(display);
  fflush(stdout);
}

#ifdef _NO_PROTO
static Widget CreateLabel(label, parent)
char *label;
Widget parent;
#else
static Widget CreateLabel(char *label, Widget parent)
#endif
{
    Widget widget;
    register int n;
    Arg args[MAX_ARGS];
    XmString tcs;

    n = 0;
    tcs = XmStringLtoRCreate(label, XmSTRING_DEFAULT_CHARSET);
    XtSetArg(args[n], XmNlabelString, tcs);  n++;
    widget = XmCreateLabel(parent, label, args, n);
    XtManageChild(widget);
    XmStringFree(tcs);
    return(widget);
}

#ifdef _NO_PROTO
static Widget CreatePushButton(label, parent)
char *label;
Widget parent;
#else
static Widget CreatePushButton(char *label, Widget parent)
#endif
{
    Widget widget;
    register int n;
    Arg args[MAX_ARGS];
    XmString tcs;

    n = 0;
    tcs = XmStringLtoRCreate(label, XmSTRING_DEFAULT_CHARSET);
    XtSetArg(args[n], XmNlabelString, tcs);  n++;
    widget = XmCreatePushButton(parent, label, args, n);
    XtManageChild(widget);
    XtAddCallback (widget, XmNactivateCallback, CBHandler, (XtPointer) PUSHBUTTON);
    XtAddCallback (widget, XmNdisarmCallback, CBHandler, (XtPointer) PUSHBUTTON);
    XtAddCallback (widget, XmNarmCallback, CBHandler, (XtPointer) PUSHBUTTON);
    XmStringFree(tcs);
    return(widget);
}

#ifdef _NO_PROTO
static Widget CreateToggle(label, parent)
char *label;
Widget parent;
#else
static Widget CreateToggle(char *label, Widget parent)
#endif
{
    Widget widget;
    register int n;
    Arg args[MAX_ARGS];
    XmString tcs;

    n = 0;
    tcs = XmStringLtoRCreate(label, XmSTRING_DEFAULT_CHARSET);
    XtSetArg(args[n], XmNlabelString, tcs);  n++;
    widget = XmCreateToggleButton(parent, label, args, n);
    XtManageChild(widget);
    XtAddCallback (widget, XmNvalueChangedCallback, CBHandler, (XtPointer) TOGGLEBUTTON);
    XtAddCallback (widget, XmNdisarmCallback, CBHandler, (XtPointer) TOGGLEBUTTON);
    XtAddCallback (widget, XmNarmCallback, CBHandler, (XtPointer) TOGGLEBUTTON);
    XmStringFree(tcs);
    return(widget);
}

#ifdef _NO_PROTO
static Widget CreateSeparator(parent, name)
Widget parent;
char *name;
#else
static Widget CreateSeparator(Widget parent, char *name)
#endif
{
    Widget widget;
    widget = XmCreateSeparator(parent, name, NULL, 0);
    XtManageChild(widget);
    return(widget);
}

#ifdef _NO_PROTO
static Widget CreatePullDown(parent, name)
Widget parent;
char *name;
#else
static Widget CreatePullDown(Widget parent, char *name)
#endif
{
    Widget widget;
    widget = XmCreatePulldownMenu (parent, name, NULL, 0);
    return(widget);
}

#ifdef _NO_PROTO
static Widget CreateCascade(label, submenu, parent)
char *label;
Widget submenu;
Widget parent;
#else
static Widget CreateCascade(char *label, Widget submenu, Widget parent)
#endif
{
    Widget widget;
    register int n;
    Arg args[MAX_ARGS];
    XmString tcs;

    n = 0;
    tcs = XmStringLtoRCreate(label, XmSTRING_DEFAULT_CHARSET);
    XtSetArg(args[n], XmNlabelString, tcs);  n++;
    XtSetArg(args[n], XmNsubMenuId, submenu); n++;
    widget = XmCreateCascadeButton(parent, label, args,n);
    XtManageChild(widget);
    XtAddCallback(widget, XmNactivateCallback, CBHandler, (XtPointer) CASCADEBUTTON);
    XtAddCallback(widget, XmNcascadingCallback, CBHandler, (XtPointer) CASCADEBUTTON);
    XmStringFree(tcs);
    return(widget);
}

#ifdef _NO_PROTO
void PostMenu(w, popup, event, c)
Widget w;
XtPointer popup;
XEvent *event;
Boolean *c;
#else
void PostMenu(Widget w, XtPointer popup, XEvent *event, Boolean *c)
#endif
{
  if (event->xbutton.button != Button3)
    return;

  XmMenuPosition((Widget) popup, (XButtonEvent *) event);
  XtManageChild((Widget) popup);
}

#ifdef _NO_PROTO
int main(argc, argv)
int argc;
char **argv;
#else
int main(int argc, char **argv)
#endif
{
  register int  n;
  Arg args[MAX_ARGS];
  XmString tcs;
  XrmDatabase new_db, sav_db;

  CommonTestInit(argc, argv);
    
  /* Code for Pir2716 */

  XrmInitialize();

  new_db = XrmGetFileDatabase("PopupMenu1.db");
  
#ifdef MOTIF1_1
  XrmMergeDatabases(new_db, &(display->db));
#else
  sav_db = XtDatabase(display);
  XrmCombineDatabase(new_db, &sav_db, True);
#endif

  /* End code for Pir2716 */

  n = 0;
  XtSetArg(args[n], XmNwidth,  200);  n++;
  XtSetArg(args[n], XmNheight, 40);   n++;
  XtSetValues(Shell1, args, n);
  
  XtRealizeWidget(Shell1);

  Label = CreateLabel("SelectMe", Shell1);

  /*
   **  PopupMenu1
   */

  n = 0;
  PopupMenu1 = XmCreatePopupMenu(Label, "popMenu", args, n);
  XtAddEventHandler(Label, ButtonPressMask, False, PostMenu, (XtPointer) PopupMenu1);

  /*
   **  Menu1
   */

  Label1       = CreateLabel("Menu1", PopupMenu1);
  Separator1   = CreateSeparator(PopupMenu1, "Separator1");
  PushBtn1     = CreatePushButton("PushButton1", PopupMenu1);
  ToggleBtn1   = CreateToggle("Toggle1", PopupMenu1);
  PullDown2    = CreatePullDown(PopupMenu1, "Pulldown2");
  CascadeBtn1  = CreateCascade("Cascade1", PullDown2, PopupMenu1);

  /*
   **  Menu2
   */

  Label2       = CreateLabel("Menu2", PullDown2);
  Separator2   = CreateSeparator(PullDown2, "Separator2");
  ToggleBtn2   = CreateToggle("Toggle2", PullDown2);
  Separator3   = CreateSeparator(PullDown2, "Separator3");
  PullDown3    = CreatePullDown(PullDown2, "PullDown3");
  CascadeBtn2  = CreateCascade("Cascade2", PullDown3, PullDown2);
  Separator4   = CreateSeparator(PullDown2, "Separator4");
  PushBtn2     = CreatePushButton("PushButton2", PullDown2);

  /*
   **  Menu3
   */

  Label3       = CreateLabel("Menu3", PullDown3);
  PullDown4    = CreatePullDown(PullDown3, "PullDown4");
  CascadeBtn3  = CreateCascade("Cascade3", PullDown4, PullDown3);
  PushBtn3     = CreatePushButton("PushButton3", PullDown3);
  ToggleBtn3   = CreateToggle("Toggle3", PullDown3);

  /*
   **  Menu4
   */

  Label4       = CreateLabel("Menu4", PullDown4);

  CommonPause();
  CommonPause();
  CommonPause();
  CommonPause();

  XtAppMainLoop(app_context);
}














