/* 
 * (c) Copyright 1989, 1990, 1991, 1992 OPEN SOFTWARE FOUNDATION, INC. 
 * ALL RIGHTS RESERVED 
*/ 
/* 
 * Motif Release 1.2
*/ 
#ifdef REV_INFO
#ifndef lint
static char rcsid[] = "$RCSfile: PanedWin7.c,v $ $Revision: 1.4 $ $Date: 92/03/13 17:24:02 $"
#endif
#endif
/*
*  (c) Copyright 1989, HEWLETT-PACKARD COMPANY */

#include <testlib.h>

/* Tests what happens when children's intial sizes are larger than */
/* paned windows initial size. */

#define	BUTTONS		3
#define B_WIDTH		100
#define B_HEIGHT	100
#define W_MARGIN	-25

/* Internal functions. */
static void DoTheButtons();
static void DoTheWindows(); 
static void ReportSize(); 

void  main(argc, argv)
int     argc;
char  **argv;
{
    Boolean       	trace = False;
    register int  	n, i;
    Arg			args[MAX_ARGS], PWargs[MAX_ARGS];
    int			PWn;

    CommonTestInit(argc, argv);

    n = 0;
    XtSetArg(args[n], XmNgeometry, "150x150+0+0");  n++;
    XtSetValues(Shell1, args, n);
    XtRealizeWidget(Shell1);
    
    /* Do all cases for 1 to BUTTONS. */
    for (i = 0; i < BUTTONS; i++) 
      {
	/* Paned window with nothing set. */
	PWn = 0;
	DoTheButtons(i, PWargs, PWn);

	/* Paned window with width set. */
	PWn = 0;
	XtSetArg(PWargs[PWn], XmNwidth, B_WIDTH + W_MARGIN); PWn++;
	DoTheButtons(i, PWargs, PWn);

	/* Paned window with height set. */
	PWn = 0;
	XtSetArg(PWargs[PWn], XmNheight, (B_HEIGHT + W_MARGIN) * i ); PWn++;
	DoTheButtons(i, PWargs, PWn);

	/* Paned window with both set. */
	PWn = 0;
	XtSetArg(PWargs[PWn], XmNwidth, B_WIDTH + W_MARGIN); PWn++;
	XtSetArg(PWargs[PWn], XmNheight, (B_HEIGHT + W_MARGIN) * i ); PWn++;
	DoTheButtons(i, PWargs, PWn);

      }
    
    CommonPause();
    XtAppMainLoop(app_context);
}

static void DoTheButtons(num, PWargs, PWn)
     int 	num;
     Arg	PWargs[];
     int	PWn;
{
  Arg          	PBargs[MAX_ARGS];
  int		PBn;
  
  /* Nothing set. */
  PBn = 0;
  
  DoTheWindows(num, PWargs, PWn, PBargs, PBn);
  
  /* Width set. */
  PBn = 0;
  XtSetArg(PBargs[PBn], XmNwidth, B_WIDTH); PBn++;
  DoTheWindows(num, PWargs, PWn, PBargs, PBn);

  /* Height set. */
  PBn = 0;
  XtSetArg(PBargs[PBn], XmNheight, B_HEIGHT); PBn++;
  DoTheWindows(num, PWargs, PWn, PBargs, PBn);

  /* Both set. */
  PBn = 0;
  XtSetArg(PBargs[PBn], XmNwidth, B_WIDTH); PBn++;
  XtSetArg(PBargs[PBn], XmNheight, B_HEIGHT); PBn++;
  DoTheWindows(num, PWargs, PWn, PBargs, PBn);

}

static void DoTheWindows(num, PWargs, PWn, PBargs, PBn)
     int	num;
     Arg	PWargs[];
     int	PWn;
     Arg	PBargs[];
     int	PBn;
{
  register int	i;
  Widget	PW, PB;
  
  PW = XmCreatePanedWindow(Shell1, "PW", PWargs, PWn);
  for (i = 0; i <= num; i++)
    {
      PB = XmCreatePushButton(PW, "PB", PBargs, PBn);
      XtManageChild(PB);
    }
  XtManageChild(PW);
  ReportSize(PW);
  CommonPause();
  XtDestroyWidget(PW);
  
}

static void ReportSize (w)
     Widget w;
{
  register int	n;
  Arg		args[2];
  Dimension	width, height;
    
  n = 0;
  XtSetArg(args[n], XmNwidth, &width); n++;
  XtSetArg(args[n], XmNheight, &height); n++;
  XtGetValues(w, args, n);
  
  printf("%dX%d\n", (int)width, (int)height);
}

