/* 
 * (c) Copyright 1989, 1990, 1991, 1992 OPEN SOFTWARE FOUNDATION, INC. 
 * ALL RIGHTS RESERVED 
*/ 
/* 
 * Motif Release 1.2
*/ 
#ifdef REV_INFO
#ifndef lint
static char rcsid[] = "$RCSfile: ArrowBGad3.c,v $ $Revision: 1.4 $ $Date: 92/03/13 16:55:49 $"
#endif
#endif
/*
*  (c) Copyright 1987, 1988, 1989 HEWLETT-PACKARD COMPANY */
/*
 *  Create a drawing area with a set of arrow gadgets within it.
 *  Turn the highlight_thickness and highlight_on_enter resources on.
 *  Change the foreground of the manager to see if it gets reflected
 *  in the gadgets.  This tests the VisualChange communication path
 *  from managers SetValues to the gadgets.
 */

#include <signal.h>
#include <X11/StringDefs.h>
#include <testlib.h>

static void flushEvents();

void main (argc, argv)
unsigned int argc;
char **argv;

{
  Widget drawarea;
  Widget arrow;
  Arg args[10];
  Arg args2[10];
  int n;
  int x, y;

  CommonTestInit(argc, argv);
    
  /*  The drawing area creation.  Contained in an outer frame.  */

  n = 0;
  XtSetArg (args[n], XmNwidth, 400);	n++;
  XtSetArg (args[n], XmNheight, 400);	n++;
  drawarea = XmCreateDrawingArea (Shell1, "drawarea", args, n);
  XtManageChild (drawarea);

  XtRealizeWidget (Shell1);

  /*  Create a matrix of arrows  */

  for (y = 10; y <= 175; y += 50)
    {
      for (x = 10; x <= 175; x += 50)
	{
	  n = 0;
	  XtSetArg (args[n], XmNx, x);			n++;
	  XtSetArg (args[n], XmNy, y);			n++;
	  XtSetArg (args[n], XmNhighlightThickness, 4);	n++;
	  XtSetArg (args[n], XmNhighlightOnEnter, True);	n++;
	  arrow = XmCreateArrowButtonGadget(drawarea, "arrow", args, n);
	  XtManageChild(arrow);
	}
    }
  flushEvents (XtDisplay(Shell1), 3);

  n = 0;
  XtSetArg (args[n], XmNtopShadowColor, NULL);	n++;
  XtGetValues (drawarea, args, n);

  n = 0;
  XtSetArg (args2[n], XmNforeground, args[0].value); n++;
  XtSetValues (drawarea, args2, n);

  CommonPause();

  XtAppMainLoop(app_context);
  XtDestroyWidget(drawarea);
  XtDestroyWidget(arrow);
}

static void flushEvents(display, delay)
Display * display;
int delay;
{
   XEvent event;
   while (XPending(display)) {
      XNextEvent(display, &event);
      XtDispatchEvent(&event);
   }
   sleep(delay);
}

