/* 
 * (c) Copyright 1989, 1990, 1991, 1992 OPEN SOFTWARE FOUNDATION, INC. 
 * ALL RIGHTS RESERVED 
*/ 
/* 
 * Motif Release 1.2
*/ 
#ifdef REV_INFO
#ifndef lint
static char rcsid[] = "$RCSfile: TextData2.c,v $ $Revision: 1.4 $ $Date: 92/03/13 18:33:31 $"
#endif
#endif

/*
 *	file: TextData2.c
 *
 *	Has a Multi line Scrolled Text widget under Form. The XmNcolumns resource 
 *	is being set to 80 at creation time, and XmNrows to 24. By default, 
 *	wordWrap is off. Text is constructed with different no. of lines and
 *	different no. of chars per line, and memory measured in each case.
 *
 *	To run this under Motif 1.2 under multibytes/char locales, compile the
 *	test with the -DMOTIF1.2 option, and while executing the test run it
 *	with '-b bytes_per_char' option.
 */

/*  Standard C headers  */
#include <stdio.h>
#include <math.h>
#include <sys/types.h>
#include <sys/stat.h>

#ifdef MOTIF1_2
#include <locale.h>
#endif

/*  X headers  */
#include <X11/Xlib.h>
#include <X11/StringDefs.h>
#include <X11/Xatom.h>

#include <testlib.h>

#define	NUM_COLUMNS	80
#define	NUM_ROWS	24

#define	TEXT1_X		10
#define	TEXT1_Y		10

#define	MAX_TRIALS	40

#define	C_CHAR	'A'

#define	FIRST_BYTE	'\243'
#define	SECOND_BYTE	'\261'

int	cases[] = {10, 20, 50, 100, -1};
int	sub_cases[] = {100, 250, 550, 1200, 2500, 5200, 10500, 22000, 45000, 50000, -1};

static void	quitCB();
static void	startCB();
static void measure_memory();
static void CreateTextWidget();
static void fill_text_buf();
static void save_data();
static void collect_data();

/*  Global Variables  */

char *text_string;
#ifdef MOTIF1_2
char	*locale;
#endif

Widget Form1;
Widget Text1;
Widget start;
XmFontList	newfontlist;

Arg args[20];
int n;
int		memory_measured[MAX_TRIALS];
FILE	*out_fp;
int		num_trials = 0;
int		start_memory, total_memory, memory_in_use;
int		bytes_per_char;
Boolean	mappedWhenManaged, display_text;

main (argc, argv)
int argc;
char **argv;
{
	XFontStruct	*newfont;
	Widget	quit;
	char	c;
	int		i = 0;

	start_memory = 0;
	bytes_per_char = 1;
	display_text = False;

#ifdef MOTIF1_2
	setlocale(LC_ALL, "");
#endif
	if (argc > 1)
		while (--argc > 0) {

			i++;
			c = argv[i][0];
			if (c != '-')
				continue;
			c = argv[i][1];

			switch(c) {

				case 'b':
					bytes_per_char = atoi(argv[++i]);
					break;
				case 'd':
					display_text = True;
					break;
				case 'h':
					print_usage();
					exit(0);
				default:
					break;

			}
			if (c != 'd')
				argc--;
		}

	if ((out_fp = fopen("TextData2.out", "w+")) == NULL) {

		fprintf(stderr, "Can not open Output file\n");
		exit(0);

	}
	mappedWhenManaged = display_text;

	/*  initialize toolkit  */
    CommonTestInit(argc, argv);
    
	if (display_text == True) {

    	n = 0;
		XtSetArg(args[n], XtNwidth, 800);  n++;
		XtSetArg(args[n], XtNheight, 500);  n++;
    	XtSetValues(Shell1, args, n);

	}

	/* create main form */
	n = 0;
	XtSetArg(args[n], XmNmappedWhenManaged, mappedWhenManaged); n++;
	Form1 = XmCreateForm (Shell1, "Form1", args, n);
	XtManageChild (Form1);

	if (bytes_per_char == 1) {
		newfont = XLoadQueryFont(XtDisplay(Shell1),"9x15");
		if (newfont != NULL)
			newfontlist = XmFontListCreate(newfont, XmSTRING_DEFAULT_CHARSET);
	}
	else if (bytes_per_char == 2) {
		newfont = XLoadQueryFont(XtDisplay(Shell1),
			"-k14-screen-medium-r-normal--14-140-75-75-m-140-jisx0208.1983-1");
		if (newfont != NULL)
			newfontlist = XmFontListCreate(newfont, "jisx0208.1983-1");
	}

	CreateTextWidget();
	n = 0;
	XtSetArg(args[n], XmNx, 10); n++;
	XtSetArg(args[n], XmNy, TEXT1_Y + 450); n++;
	XtSetArg(args[n], XmNmappedWhenManaged, mappedWhenManaged); n++;
	start = XmCreatePushButtonGadget(Form1, "start", args, n);
	XtManageChild(start);
	XtAddCallback(start, XmNactivateCallback, startCB, NULL);

	n = 0;
	XtSetArg(args[n], XmNx, 150); n++;
	XtSetArg(args[n], XmNy, TEXT1_Y + 450); n++;
	XtSetArg(args[n], XmNmappedWhenManaged, mappedWhenManaged); n++;
	quit = XmCreatePushButtonGadget(Form1, "quit", args, n);
	XtManageChild(quit);
	XtAddCallback(quit, XmNactivateCallback, quitCB, NULL);

	XtRealizeWidget(Shell1);

	if (display_text == False) {

		MallocDisable();
		collect_data();
		XtDestroyWidget(Shell1);
		exit(0);

	}

	XtAppMainLoop(app_context);

}


static void  quitCB(w, client_data, call_data)
Widget	w;
caddr_t  client_data;
caddr_t  call_data;
{

	int	i;

	save_data();
	XtFree(text_string);
	XtDestroyWidget(Shell1);
#ifdef DEBUG
	printf("\nMemory Measurement Data: \n");
	for (i = 0; i < num_trials; i++)
		printf("\tCase %d:\t\tMeasured memory: %d\n", i, memory_measured[i]);
#endif
	fflush(stdout);
	exit(0);

}


static void  startCB(w, client_data, call_data)
Widget	w;
caddr_t  client_data;
caddr_t  call_data;
{

	int	i, j;
	Arg	args[1];
	int	n;

	n = 0;
	XtSetArg(args[n], XmNsensitive, False); n++;
	XtSetValues(w, args, n);

	MallocDisable();
	measure_memory(False);
	collect_data();

}


static void	collect_data()
{

	int	i, j;

	for (i = 0; cases[i] != -1; i++) {

		for (j = 0; sub_cases[j] != -1; j++) {
			fill_text_buf(cases[i], sub_cases[j]);
			MallocEnable();
			XmTextSetString(Text1, text_string);
			measure_memory(True);
			MallocDisable();
			XtDestroyWidget(Text1);
			CreateTextWidget();
		}

	}
	if (display_text == False) {
		save_data();
		exit(0);
	}

}


static void CreateTextWidget()
{

	Arg	args[15];
	int	n;

	/* create multi line text widget */
	n = 0;
	XtSetArg(args[n], XmNx, TEXT1_X); n++;
	XtSetArg(args[n], XmNfontList, newfontlist);  n++;
	XtSetArg(args[n], XmNcolumns, NUM_COLUMNS);  n++;
	XtSetArg(args[n], XmNrows, NUM_ROWS);  n++;
	XtSetArg(args[n], XmNeditMode, XmMULTI_LINE_EDIT); n++;
	XtSetArg(args[n], XmNscrollHorizontal, False); n++;
	XtSetArg(args[n], XmNeditable, False); n++;
	XtSetArg(args[n], XmNmappedWhenManaged, mappedWhenManaged); n++;
	Text1 = XmCreateScrolledText(Form1, "Text1", args, n);
	if (display_text == True)
		XtManageChild(Text1);

	return;

}


static void	fill_text_buf(chars_per_line, num_lines)
{
	
	int	i, j;
	char	*temp_string;

	if (text_string != NULL) {
		XtFree(text_string);
		text_string = NULL;
	}

	text_string = XtMalloc((chars_per_line * num_lines * bytes_per_char) + 1);
	temp_string = text_string;

	for (i = 0; i < num_lines; i++) {
		for (j = 0; j < chars_per_line - 1; j++) {

			if (bytes_per_char == 1)
				*temp_string++ = C_CHAR;
			else if (bytes_per_char == 2) {
				*temp_string++ = FIRST_BYTE;
				*temp_string++ = SECOND_BYTE;
			}
		}
		*temp_string++ = '\n';
	}
	*temp_string = '\0';

}


static void measure_memory(store)
Boolean	store;
{

	MallocLeakInfo(&total_memory, &memory_in_use);
	if (store == False) {
		start_memory = memory_in_use;
		return;
	}

	memory_measured[num_trials] = memory_in_use - start_memory;
	num_trials++;

	return;

}


print_usage()
{

	printf("Usage: TextData2 [-b num_bytes][-d]\n");

}


static void	save_data()
{

	int	i;

	for (i = 0; i < num_trials; i++)
		fprintf(out_fp, "\t%d", memory_measured[i]);
	fprintf(out_fp, "\n");
	fclose(out_fp);

	return;

}
