/* 
 * (c) Copyright 1989, 1990, 1991, 1992 OPEN SOFTWARE FOUNDATION, INC. 
 * ALL RIGHTS RESERVED 
*/ 
/* 
 * Motif Release 1.2
*/ 
#ifdef REV_INFO
#ifndef lint
static char rcsid[] = "$RCSfile: FetchWO.c,v $ $Revision: 1.5.2.3 $ $Date: 1992/04/29 14:13:13 $"
#endif
#endif

#include <MrmTest.h> 

/* 
 * Data for summary
 */

#include <Xm/XmP.h>			/* needed to get definition of XtName() */

#define NUM_TESTS		8
#define TEST_DESCRIP_LENGTH	60
#define	TEST_WIDTH		200

struct TestInfo FetchWidgetOverrideInfo[NUM_TESTS] = 
{
    {"Fetch valid parent widget, override width                 ",
				MrmSUCCESS,	NULL},
    {"Fetch valid widget, override pixmap                       ",
				MrmSUCCESS,	NULL},
    {"Check override of parent widget width inherited by child  ",
				False,	NULL},
    {"Fetch nonexistent widget, override name, pixmap           ",
				MrmNOT_FOUND,	NULL},
    {"Fetch previously fetched widget, override pixmap          ",
				MrmSUCCESS,	NULL},
    {"Fetch valid widget, override name but no args             ",
				MrmSUCCESS,	NULL},
	{"Check override of name on valid widget fetch              ",
				True,	NULL},
    {"Fetch widget, override shadow thickness not set already   ",
				MrmSUCCESS,	NULL},
};
int		FWO_info_cnt = 0;

/*
 * External declarations
 */

extern MrmHierarchy	s_MrmHierarchy;
extern MrmType		class;

extern Widget		toplevel,
			widgetmain;

extern String		summary();

/*
 * Local declarations
 */

#define VALID_TEST1	1
#define VALID_TEST2	2
#define FINISH		3

Widget		test_top,
		test_box,
		buttons[4],
		badwidget1,
		badwidget2;

Display		*dsp;

int		iteration = 1;

void continue_proc(w, tag, reason)
     Widget		w;
     int		*tag;
     unsigned long	*reason;
{ 	

    String	msg_valid_tst1 = "There should now be two buttons in the second window.\nThe buttons' labels should read\n    TEST                   TEST\n      1         and          1 \n    BTN1                   BTN2.\nThe colors should be: background - yellow, foreground - red.\nThe window itself should be 200 pixels wide with a space \nof about forty pixels to the right of the right button.\n\nPress the continue button to continue the test.";

    String	msg_valid_tst2 = "There should now be two additional buttons in the window.\nThe new buttons' labels should read\n    BTN1                   BTN2\n    TEST        and        TEST\n      2                      2 .\nThe colors should be: background - red, foreground - yellow.\nThe second new button should have a wider shadow (6 pixels) around it.\n\nPress the continue button to continue the test.";

    Arg		args[2];
    int		nargs;

    XmString	message;

    String	summary_msg;
	Pixel	fg, bg;
	Pixmap	button_icon[2];
	int		widgetwidth = 0;

    if(iteration == VALID_TEST1)
    {
	iteration++;

/*
 * Create top level shell widget as parent for test_box widget
 */

	nargs = 0;
	XtSetArg(args[nargs], XtNallowShellResize, TRUE); nargs++;

	test_top =
	XtAppCreateShell("test_top",			/* application class */
			 "TEST_TOP",			/* application name  */
			 topLevelShellWidgetClass,	/* widget class	     */
			 XtDisplay(widgetmain),		/* display	     */
			 args, nargs);			/* arguments	     */

/*
 * Fetch valid test_box widget, set the width to see if the children
 * inherit it later on.
 * Fetch valid parent widget, override width
 */
	nargs = 0;
	XtSetArg(args[nargs], XmNwidth, TEST_WIDTH); nargs++;

	test_box = NULL;
	FetchWidgetOverrideInfo[FWO_info_cnt].actual_return =
		MrmFetchWidgetOverride(
						s_MrmHierarchy,
						"test_box",
						test_top,
						NULL,
						args,
						nargs,
						&test_box,
						&class);
	FWO_info_cnt++;

	XtManageChild(test_box);

/*
 * Fetch the button widgets, and override the pixmaps - good conditions,
 * should be no errors
 * Fetch valid widget, override pixmap
 */
	/* get some default for the bg and fg */
	nargs = 0;
    XtSetArg(args[nargs], XmNforeground, &fg); nargs++;
    XtSetArg(args[nargs], XmNbackground, &bg); nargs++;
    XtGetValues(test_top, args, nargs);

	/* get the right pixmap for button2 */
    MrmFetchIconLiteral(s_MrmHierarchy,
                        "test1_btn2_icon",
                        XtScreen(widgetmain),
						XtDisplay(widgetmain),
                        fg, bg,
                        &button_icon[1]);

    nargs = 0;
    XtSetArg(args[nargs], XmNlabelPixmap, button_icon[1]); nargs++;

	buttons[1] = NULL;
	FetchWidgetOverrideInfo[FWO_info_cnt].actual_return =
		MrmFetchWidgetOverride(
						s_MrmHierarchy,
						"button2",
						test_box,
						NULL,
						args,
						nargs,
						&buttons[1],
						&class);
	FWO_info_cnt++;

	nargs = 0;
	XtSetArg(args[nargs], XmNwidth, &widgetwidth); nargs++;
	XtGetValues(buttons[1], args, nargs);

/*
 * Check override of parent widget width inherited by child
 */
	FetchWidgetOverrideInfo[FWO_info_cnt].actual_return =
		(widgetwidth == TEST_WIDTH);
	FWO_info_cnt++;


	XtManageChildren(&buttons[1], 1);
	XtRealizeWidget(test_top);

/*
 * Replace instruction message with "valid test 1" message
 */

	message = XmStringCreateLtoR(msg_valid_tst1, XmSTRING_DEFAULT_CHARSET);

	nargs = 0;
	XtSetArg(args[nargs], XmNmessageString, message); nargs++;
	XtSetValues(widgetmain, args, nargs);
	XmStringFree(message);
			       
/*
 * Fetch nonexistent widget, override name, pixmap
 */
    nargs = 0;
    XtSetArg(args[nargs], XmNlabelPixmap, button_icon[1]); nargs++;

	badwidget1 = NULL;
	FetchWidgetOverrideInfo[FWO_info_cnt].actual_return =
		MrmFetchWidgetOverride(
						s_MrmHierarchy,
						"badwidget1",
						test_top,
						"BAD_WIDGET",
						args,
						nargs,
						&badwidget1,
						&class);
	FWO_info_cnt++;
	
/*
 * Try to fetch a widget which has already been fetched, and override
 * it's pixmap
 * Fetch previously fetched widget, override pixmap
 */
	badwidget1 = NULL;
	badwidget1 = XtNameToWidget(test_box, "button1");
	
	FetchWidgetOverrideInfo[FWO_info_cnt].actual_return =
		MrmFetchWidgetOverride(
						s_MrmHierarchy,
						"button1",
						test_box,
						NULL,
						args, 
						nargs,
						&badwidget1,
						&class);
	FWO_info_cnt++;
    }
    else if(iteration == VALID_TEST2)
    {
	iteration++;

/*
 * Fetch second two button widgets
 */

/*
 * Override the name and then check to see if it actually worked.
 * Fetch valid widget, override name but no args
 */
	buttons[2] = NULL;
	FetchWidgetOverrideInfo[FWO_info_cnt].actual_return =
		MrmFetchWidgetOverride(
						s_MrmHierarchy,
						"button3",
						test_box,
						"button3new",
						NULL,
						NULL,
						&buttons[2],
						&class);
	FWO_info_cnt++;

/*
 * Check override of name on valid widget fetch
 */
	FetchWidgetOverrideInfo[FWO_info_cnt].actual_return =
		!strcmp("button3new", XtName(buttons[2]));
	FWO_info_cnt++;

/*
 * Override the shadow thickness which is a value that was not previously set.
 * Fetch widget, override shadow thickness not set already
 */
	nargs = 0;
    XtSetArg(args[nargs], XmNshadowThickness, 6); nargs++;
	buttons[3] = NULL;
	FetchWidgetOverrideInfo[FWO_info_cnt].actual_return =
		MrmFetchWidgetOverride(
						s_MrmHierarchy,
						"button4",
						test_box,
						NULL,
						args,
						nargs,
						&buttons[3],
						&class);
	FWO_info_cnt++;


	XtManageChildren(&buttons[2], 2);
	
/*
 * Replace the instruction message with "valid test 2" message
 */

	message = XmStringCreateLtoR(msg_valid_tst2, XmSTRING_DEFAULT_CHARSET);

	nargs = 0;
	XtSetArg(args[nargs], XmNmessageString, message); nargs++;
	XtSetValues(widgetmain, args, nargs);
	XmStringFree(message);
    }
    else if(iteration == FINISH)
    {
	iteration++;

/*
 * Replace the instruction message with test end message
 */

	summary_msg = summary(NUM_TESTS,
			      TEST_DESCRIP_LENGTH,
			      FetchWidgetOverrideInfo);

	fprintf (stdout, summary_msg);

	message = XmStringCreateLtoR(summary_msg, XmSTRING_DEFAULT_CHARSET);
	XtFree(summary_msg);

	nargs = 0;
	XtSetArg(args[nargs], XmNmessageString, message); nargs++;
	XtSetValues(widgetmain, args, nargs);
	XmStringFree(message);
    }
}
