/* 
 * (c) Copyright 1989, 1990, 1991, 1992 OPEN SOFTWARE FOUNDATION, INC. 
 * ALL RIGHTS RESERVED 
*/ 
/* 
 * Motif Release 1.2
*/ 
#ifdef REV_INFO
#ifndef lint
static char rcsid[] = "$RCSfile: FetchW.c,v $ $Revision: 1.5.2.3 $ $Date: 1992/04/29 14:13:11 $"
#endif
#endif

#include <MrmTest.h>

/*
 * Data for summary
 */

#define NUM_TESTS		5
#define TEST_DESCRIP_LENGTH	41

struct TestInfo FetchWidgetInfo[NUM_TESTS] = 
{
    {"Fetch valid widget                       ", MrmSUCCESS,	NULL},
    {"Fetch nonexistent widget                 ", MrmNOT_FOUND,	NULL},
    {"Fetch previously fetched widget          ", MrmSUCCESS,	NULL},
    {"Fetch valid widget                       ", MrmSUCCESS,	NULL},
    {"Fetch valid widget                       ", MrmSUCCESS,	NULL},
};

/*
 * External declarations
 */

extern MrmHierarchy	s_MrmHierarchy;
extern MrmType		class;

extern Widget		toplevel,
			widgetmain;

extern String		summary();

/*
 * Local declarations
 */

#define VALID_TEST1	1
#define VALID_TEST2	2
#define FINISH		3

Widget		test_top = NULL,
		test_box = NULL,
		button1 = NULL,
		button2 = NULL,
		badwidget1 = NULL,
		badwidget2 = NULL;

Display		*dsp;

int		iteration = 1;

void continue_proc(w, tag, reason)
     Widget		w;
     int		*tag;
     unsigned long	*reason;
{ 	

    String	msg_valid_tst1 = "There should now be two buttons in the second window.\nThe buttons' labels should read\n    TEST                   TEST\n      1         and          1 \n    BTN1                   BTN2.\nThe colors should be: background - yellow, foreground - red.\nPress the continue button to continue the test.";

    String	msg_valid_tst2 = "There should now be two additional buttons in the window.\nThe new buttons' labels should read\n    BTN1                   BTN2\n    TEST        and        TEST\n      2                      2 .\nThe colors should be: background - red, foreground - yellow.\nPress the continue button to continue the test.";

    Arg		args[2];
    int		nargs;

    XmString	message;

    String	summary_msg;

    if(iteration == VALID_TEST1)
    {
	iteration++;

/*
 * Create top level shell widget as parent for test_box widget
 */

	nargs = 0;
	XtSetArg(args[nargs], XtNallowShellResize, TRUE); nargs++;

	test_top =
	XtAppCreateShell("test_top",			/* application class */
			 "TEST_TOP",			/* application name  */
			 topLevelShellWidgetClass,	/* widget class	     */
			 XtDisplay(widgetmain),		/* display	     */
			 args, nargs);			/* arguments	     */

/*
 * Fetch vaild test_box widget
 */
	FetchWidgetInfo[0].actual_return = MrmFetchWidget(s_MrmHierarchy,
							  "test_box",
							  test_top,
							  &test_box,
							  &class);

/*
 * Manage button widgets
 */

	XtManageChild(test_box);
    
/*
 * Realize top level shell widget
 */

	XtRealizeWidget(test_top);

/*
 * Replace instruction message with "valid test 1" message
 */

	message = XmStringCreateLtoR(msg_valid_tst1, XmSTRING_DEFAULT_CHARSET);

	nargs = 0;
	XtSetArg(args[nargs], XmNmessageString, message); nargs++;
	XtSetValues(widgetmain, args, nargs);
			       
/*
 * Try to fetch a nonexistent widget
 */

	FetchWidgetInfo[1].actual_return = MrmFetchWidget(s_MrmHierarchy,
							  "badwidget1",
							  test_top,
							  &badwidget1,
							  &class);



/*
 * Fetch second two button widgets
 */

	FetchWidgetInfo[3].actual_return = MrmFetchWidget(s_MrmHierarchy,
							  "button3",
							  test_box,
							  &button1,
							  &class);

	FetchWidgetInfo[4].actual_return = MrmFetchWidget(s_MrmHierarchy,
							  "button4",
							  test_box,
							  &button2,
							  &class);
/*
 * Try to fetch a widget which has already been fetched
 */

	badwidget1 = NULL;
	badwidget1 = XtNameToWidget(test_box, "button1");
	
	FetchWidgetInfo[2].actual_return = MrmFetchWidget(s_MrmHierarchy,
							  "button1",
							  test_top,
							  &badwidget1,
							  &class);
    }
    else if(iteration == VALID_TEST2)
    {
	iteration++;


/*
 * Manage button widgets
 */

	XtManageChild(button1);
	XtManageChild(button2);
	
/*
 * Replace the instruction message with "valid test 2" message
 */

	message = XmStringCreateLtoR(msg_valid_tst2, XmSTRING_DEFAULT_CHARSET);

	nargs = 0;
	XtSetArg(args[nargs], XmNmessageString, message); nargs++;
	XtSetValues(widgetmain, args, nargs);
    }
    else if(iteration == FINISH)
    {
	iteration++;

/*
 * Replace the instruction message with test end message
 */

	summary_msg = summary(NUM_TESTS,
			      TEST_DESCRIP_LENGTH,
			      FetchWidgetInfo);

	fprintf (stdout, summary_msg);

	message = XmStringCreateLtoR(summary_msg, XmSTRING_DEFAULT_CHARSET);

	nargs = 0;
	XtSetArg(args[nargs], XmNmessageString, message); nargs++;
	XtSetValues(widgetmain, args, nargs);
    }
}
